/*
 * Decompiled with CFR 0.152.
 */
package mpi.metadata.search.client.model;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import mpi.metadata.search.client.applet.model.MDAppletResult;
import mpi.metadata.search.client.applet.model.MDAppletResultContentHandler;
import mpi.metadata.search.client.applet.model.MDAppletTranslateAtStartupResult;
import mpi.metadata.search.client.applet.model.MDAppletTranslateAtStartupResultContentHandler;
import mpi.metadata.search.model.MDQuery;
import mpi.metadata.search.model.MDResult;
import mpi.metadata.search.model.MDSearchDomain;
import mpi.search.result.model.ResultEvent;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MDClient2Server {
    public static MDAppletTranslateAtStartupResult getTranslateAtStartupResult(URL servletUrl, MDAppletTranslateAtStartupResult result) throws MalformedURLException, IOException, SAXException {
        StringBuffer sb = new StringBuffer();
        sb.append("?action=getTranslateAtStartup");
        if (result.getNodeIdString() != null) {
            sb.append("&nodes=");
            sb.append(result.getNodeIdString());
        }
        URL url = new URL(servletUrl.toString() + sb.toString());
        URLConnection servletConnection = MDClient2Server.getServletConnection(url);
        InputStream instr = servletConnection.getInputStream();
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            MDAppletTranslateAtStartupResultContentHandler resultContentHandler = new MDAppletTranslateAtStartupResultContentHandler(result);
            parser.parse(instr, (DefaultHandler)resultContentHandler);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static URLConnection getServletConnection(URL servletUrl, MDQuery query) throws MalformedURLException, IOException {
        StringBuffer sb = new StringBuffer();
        sb.append("?action=getMatches&num=50");
        sb.append("&query=" + URLEncoder.encode(query.getSearchExpression(), "UTF-8"));
        sb.append("&type=" + (query.isFulltext() ? "simple" : "advanced"));
        MDSearchDomain[] sds = query.getSearchDomains();
        for (int i = 0; i < sds.length; ++i) {
            List nodes = sds[i].getNodes();
            if (nodes == null) continue;
            for (int j = 0; j < nodes.size(); ++j) {
                sb.append("&nodeid=" + URLEncoder.encode((String)nodes.get(j), "UTF-8"));
            }
        }
        sb.append("&returnType=xml");
        sb.append("&sessionAndCatalogCount=");
        sb.append(query.getSessionAndCatalogCount());
        return MDClient2Server.getServletConnection(new URL(servletUrl.toString() + sb.toString()));
    }

    public static URLConnection getServletConnection(URL urlServlet) throws MalformedURLException, IOException {
        System.out.println("Opening connection to URL: " + urlServlet);
        URLConnection servletConnection = urlServlet.openConnection();
        servletConnection.setDoInput(true);
        servletConnection.setDoOutput(false);
        servletConnection.setUseCaches(false);
        servletConnection.setRequestProperty("Content-Type", "text/xml");
        return servletConnection;
    }

    public static void receiveMatches(MDSearchDomain searchDomain, URLConnection servletConnection, MDResult result, boolean firstTime) throws IOException, SAXException {
        InputStream instr = servletConnection.getInputStream();
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            MDAppletResultContentHandler resultContentHandler = new MDAppletResultContentHandler(searchDomain, result, firstTime);
            parser.parse(instr, (DefaultHandler)resultContentHandler);
            if (result instanceof MDAppletResult) {
                result.fireResultChanged(new ResultEvent(result, 3));
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        instr.close();
    }
}

