/*
 * Decompiled with CFR 0.152.
 */
package mpi.metadata.search.client.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import mpi.metadata.search.client.model.MDPathItem;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class MDProfileContentHandler
extends DefaultHandler {
    private final List rootPathItems;
    private String _elementTextContent = "";
    MDPathItem _lastItem = null;
    MDPathItem _currentItem = null;
    List _subItems = new ArrayList(20);
    Stack _itemStack = new Stack();
    Stack _visibilityStack = new Stack();
    String qpath = "";

    MDProfileContentHandler(List rootPathItems) {
        this.rootPathItems = rootPathItems;
    }

    public void characters(char[] ch, int start, int end) {
        this._elementTextContent = this._elementTextContent + new String(ch, start, end);
    }

    protected String getTextContent() {
        return new String(this._elementTextContent.trim());
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this._elementTextContent = "";
        if (localName.equals("METATRANSCRIPT")) {
            String _type = this.getValue(atts, "Type");
            if (!"SESSION.Profile".equals(_type) && !"CATALOGUE.Profile".equals(_type)) {
                System.err.println("MDSearchConfig: configuration file  is of unsupported type " + _type);
                throw new SAXException("configuration file not of supported type");
            }
        } else if (!localName.equals("Description")) {
            String name = "";
            String multiple_attr = "";
            String visible_attr = "";
            String xxx_tag = "";
            String type = "";
            String xxx_type = "";
            String link = "";
            String followupdep = "";
            boolean visible = true;
            boolean multiple = false;
            boolean listType = false;
            link = this.getValue(atts, "Link");
            xxx_tag = this.getValue(atts, "XXX-Tag");
            name = this.getValue(atts, "Name");
            type = this.getValue(atts, "Type");
            xxx_type = this.getValue(atts, "XXX-Type");
            followupdep = this.getValue(atts, "XXX-FollowUpDepend");
            visible_attr = this.getValue(atts, "XXX-Visible");
            multiple_attr = this.getValue(atts, "XXX-Multiple");
            visible = visible_attr == null || visible_attr.equals("") || visible_attr.equalsIgnoreCase("true");
            multiple = multiple_attr != null && !multiple_attr.equals("") && !multiple_attr.equalsIgnoreCase("false");
            if (!visible) {
                this.qpath = this.qpath + "." + localName;
                this._visibilityStack.push(new Boolean(false));
            } else {
                String path = this._visibilityStack.size() > 0 && (Boolean)this._visibilityStack.peek() == false ? this.qpath + "." + localName : "." + localName;
                if (xxx_type == null || xxx_type.equals("")) {
                    xxx_type = "String";
                }
                if (xxx_tag == null || xxx_tag.equals("")) {
                    xxx_tag = localName;
                }
                if (localName.equals("Key")) {
                    if (name != null && !name.equals("")) {
                        xxx_tag = "Key:" + name;
                        xxx_type = "FixedKeyValuePair:" + xxx_type;
                        if (type != null && type.endsWith("List")) {
                            listType = true;
                        }
                    } else {
                        xxx_type = "FreeKeyValuePair";
                        xxx_tag = "Key";
                        if (xxx_type.startsWith("CV:")) {
                            xxx_type = "FreeKeyValuePair:" + xxx_type;
                        }
                        name = localName;
                    }
                } else if (type != null && link != null && !link.equals("") && (type.startsWith("OpenVocabulary") || type.startsWith("ClosedVocabulary"))) {
                    xxx_type = "CV:" + link;
                    name = localName;
                    if (type.endsWith("List")) {
                        listType = true;
                    }
                } else if (xxx_type != null && xxx_type.equals("Boolean")) {
                    xxx_type = "Boolean";
                    name = localName;
                } else if (xxx_type != null && xxx_type.equals("Numeric")) {
                    xxx_type = "Numeric";
                    name = localName;
                } else if (xxx_type != null && xxx_type.equals("Date")) {
                    xxx_type = "Date";
                    name = localName;
                } else if (xxx_type != null && xxx_type.equals("Age")) {
                    xxx_type = "Age";
                    name = localName;
                } else if (link != null && !link.equals("")) {
                    xxx_type = "CV:" + link;
                    name = localName;
                } else {
                    xxx_type = "String";
                    name = localName;
                }
                if (followupdep != null && !followupdep.equals("")) {
                    xxx_type = "DependCV:" + followupdep;
                }
                this._currentItem = new MDPathItem(name, link, path, multiple, xxx_type, listType);
                if (this._itemStack.size() == 0) {
                    this.rootPathItems.add(this._currentItem);
                } else {
                    ((MDPathItem)this._itemStack.peek()).addSubItem(this._currentItem);
                }
                this._itemStack.push(this._currentItem);
                this._visibilityStack.push(new Boolean(true));
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        if (!localName.equals("METATRANSCRIPT")) {
            if (localName.equals("Item")) {
                if (!this.getTextContent().equals("")) {
                    // empty if block
                }
                this._itemStack.pop();
            } else if (!localName.equals("Description")) {
                if (((Boolean)this._visibilityStack.pop()).booleanValue()) {
                    this._itemStack.pop();
                } else {
                    this.qpath = this.qpath.substring(0, this.qpath.lastIndexOf(46));
                }
            }
        }
    }

    protected String getValue(Attributes atts, String str) {
        for (int i = 0; i < atts.getLength(); ++i) {
            if (!atts.getLocalName(i).equals(str)) continue;
            return atts.getValue(i);
        }
        return null;
    }
}

