/*
 * Decompiled with CFR 0.152.
 */
package mpi.metadata.search.client.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import mpi.metadata.search.model.MDMatch;
import mpi.search.result.model.Result;
import nl.mpi.util.XMLUtil;

public class MDResult2Corpus {
    public static boolean corexMode = false;

    public static String createSearchResultCorpus(String name, Result searchResults, String searchService, String text) {
        File outputFile = new File(name);
        try {
            OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(outputFile));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date curdate = new Date();
            String datestr = sdf.format(curdate);
            Hashtable scHash = new Hashtable();
            Hashtable ssHash = new Hashtable();
            for (int i = 0; i < searchResults.getRealSize(); ++i) {
            }
            StringBuffer sb = new StringBuffer("");
            Enumeration ke = scHash.keys();
            while (ke.hasMoreElements()) {
                sb.append((String)ke.nextElement());
                if (!ke.hasMoreElements()) continue;
                sb.append(";");
            }
            sb = new StringBuffer("");
            ke = ssHash.keys();
            while (ke.hasMoreElements()) {
                sb.append((String)ke.nextElement());
                if (!ke.hasMoreElements()) continue;
                sb.append(";");
            }
            String searchServicesString = sb.toString();
            out.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            out.write("<!DOCTYPE METATRANSCRIPT []>");
            out.write("<METATRANSCRIPT\n");
            out.write("  xmlns=\"http://www.mpi.nl/IMDI/Schema/IMDI\" \n");
            out.write("  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n");
            out.write("  xsi:schemaLocation=\"http://www.mpi.nl/IMDI/Schema/IMDI ./IMDI_3.0.xsd\"\n");
            out.write("  Date=\"" + datestr + "\" Version=\"1\" FormatId=\"IMDI 3.0\" Type=\"CORPUS\">\n");
            out.write("<Corpus SearchService=\"" + searchServicesString + "\" " + ">\n");
            out.write("<Name>" + name + "</Name>\n");
            out.write("<Title> Search result </Title>\n");
            out.write("<Description LanguageId=\"ISO639:eng\" Link=\"\">\n");
            out.write("Search results from Search Service: " + XMLUtil.toStdEnt((String)(searchService + '\n' + "query:\n" + text)));
            out.write("</Description>\n");
            out.write("<Description LanguageId=\"ISO639:eng\" Link=\"\">\n");
            out.write("#Hits folowed by participant codes:\n");
            for (int i = 1; i <= searchResults.getRealSize(); ++i) {
                if (((MDMatch)searchResults.getMatch(i)).getActorCode() == null) continue;
                out.write("#SF \"" + ((MDMatch)searchResults.getMatch(i)).getURL() + "\"\t" + ((MDMatch)searchResults.getMatch(i)).getActorCode() + "\n");
            }
            out.write("</Description>\n");
            String old = "null";
            for (int i = 1; i <= searchResults.getRealSize(); ++i) {
                String oname = ((MDMatch)searchResults.getMatch(i)).getName();
                String url = ((MDMatch)searchResults.getMatch(i)).getURL();
                if (old != null && old.equals(url)) continue;
                out.write("<CorpusLink Name=\"" + oname + "\"" + ">");
                if (url != null && !url.startsWith("file:") && !url.startsWith("http:")) {
                    out.write("file:");
                }
                out.write(url + "</CorpusLink>\n");
                old = url;
            }
            out.write("</Corpus>\n");
            out.write("</METATRANSCRIPT>\n");
            out.close();
        }
        catch (IOException ioe) {
            System.err.println("Error writing to file " + outputFile.getPath());
            ioe.printStackTrace();
        }
        return "file:" + outputFile.getPath();
    }
}

