/*
 * Decompiled with CFR 0.152.
 */
package mpi.metadata.search.client.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JOptionPane;
import mpi.metadata.search.client.model.MDSearchStructure;
import nl.mpi.util.OurURL;

public class MDSearchConfig {
    private static final String CATALOGUE_SEARCH_PROFILE_NAME = "CATALOGUE.Profile.xml";
    public static final String SESSION_SEARCH_PROFILE_NAME = "SESSION.Profile.xml";
    public static final String PROFILES_IN_JAR_PATH = "/mpi/metadata/profiles/";
    private static final Hashtable SEARCH_CONFIG_HASH = new Hashtable();

    public static MDSearchStructure getDefaultSearchStructure() {
        ArrayList<OurURL> profiles = new ArrayList<OurURL>();
        OurURL sessionProfile = MDSearchConfig.getProfileURL(SESSION_SEARCH_PROFILE_NAME);
        profiles.add(sessionProfile);
        OurURL catalogueProfile = MDSearchConfig.getProfileURL(CATALOGUE_SEARCH_PROFILE_NAME);
        profiles.add(catalogueProfile);
        return MDSearchConfig.getSearchStructure("DEFAULT_PROFILE", profiles);
    }

    public static MDSearchStructure getSearchStructure(String profile) {
        OurURL profileURL = MDSearchConfig.getProfileURL(profile);
        return MDSearchConfig.getSearchStructure(profile, Collections.singletonList(profileURL));
    }

    private static MDSearchStructure getSearchStructure(String profile, List profiles) {
        if (SEARCH_CONFIG_HASH.containsKey(profile)) {
            return (MDSearchStructure)SEARCH_CONFIG_HASH.get(profiles);
        }
        MDSearchStructure ss = new MDSearchStructure(profiles);
        SEARCH_CONFIG_HASH.put(profiles, ss);
        return ss;
    }

    public static File getSearchResultsDir() {
        return new File(System.getProperty("user.home"));
    }

    private static OurURL getProfileURL(String profile) {
        OurURL profileURL = null;
        try {
            profileURL = new OurURL(MDSearchConfig.class.getResource(PROFILES_IN_JAR_PATH + profile));
        }
        catch (Exception e) {
            System.err.println("MDSearchConfig:setConfiguration; Cannot get default " + profile + " from classpath: " + PROFILES_IN_JAR_PATH + profile + " Exception= " + e);
            JOptionPane.showMessageDialog(null, "Cannot get " + profile + " from classpath: " + PROFILES_IN_JAR_PATH + profile);
        }
        return profileURL;
    }
}

