/*
 * Decompiled with CFR 0.152.
 */
package mpi.metadata.search.client.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import mpi.metadata.search.client.model.MDProfileContentHandler;
import nl.mpi.util.OurURL;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class MDSearchStructure {
    private final List rootPathItems = new ArrayList(10);
    private boolean status = false;
    private final List profileURLs;

    public MDSearchStructure(OurURL profileURL) {
        this(Collections.singletonList(profileURL));
    }

    public MDSearchStructure(List profileURLs) {
        this.profileURLs = profileURLs;
        this.status = this.parseProfiles();
    }

    private boolean parseProfiles() {
        boolean result = true;
        Iterator iter = this.profileURLs.iterator();
        while (iter.hasNext()) {
            OurURL profileURL = (OurURL)iter.next();
            boolean status = MDSearchStructure.parseProfile(profileURL, this.rootPathItems);
            result = result || status;
        }
        return result;
    }

    public List getPathItems() {
        return this.rootPathItems;
    }

    public OurURL getProfile() {
        return (OurURL)this.profileURLs.iterator().next();
    }

    public boolean getStatus() {
        return this.status;
    }

    private static boolean parseProfile(OurURL url, List rootPathItems) {
        XMLReader xmlReader = null;
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            SAXParser saxParser = saxParserFactory.newSAXParser();
            xmlReader = saxParser.getXMLReader();
            xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
        }
        catch (Exception e) {
            System.err.println("error in setting up parser " + e);
            return false;
        }
        try {
            xmlReader.setContentHandler(new MDProfileContentHandler(rootPathItems));
            xmlReader.parse(url.toString());
        }
        catch (SAXException se) {
            System.err.println("SAX error parsing file : " + url + '\n' + se + '\n' + se.getMessage());
            JOptionPane.showMessageDialog(null, "Error parsing: " + url + "\n" + se.getMessage());
            return false;
        }
        catch (IOException ioe) {
            System.err.println("io error parsing file : " + url + '\n' + ioe);
            return false;
        }
        catch (Exception e) {
            System.err.println("error parsing file : " + url + '\n' + e);
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

