/*
 * Decompiled with CFR 0.152.
 */
package mpi.metadata.search.client.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import mpi.metadata.search.client.model.MDResult2Corpus;
import mpi.metadata.search.client.model.MDSearchConfig;
import mpi.metadata.search.client.model.MDSearchStructure;
import mpi.metadata.search.client.viewer.MDAdvancedQueryPanel;
import mpi.metadata.search.client.viewer.MDMatchCounter;
import mpi.metadata.search.client.viewer.MDQuerySpecPanel;
import mpi.metadata.search.client.viewer.MDQueryViewer;
import mpi.metadata.search.client.viewer.MDResultPrinter;
import mpi.metadata.search.client.viewer.MDResultViewer;
import mpi.metadata.search.client.viewer.MDSimpleQueryPanel;
import mpi.metadata.search.model.MDQuery;
import mpi.metadata.search.model.MDResult;
import mpi.metadata.search.model.MDSearchDomain;
import mpi.search.SearchLocale;
import mpi.search.query.model.Query;
import mpi.search.query.model.QueryManager;
import mpi.search.query.viewer.AbstractSimpleSearchPanel;
import mpi.search.query.viewer.StartStopPanel;
import mpi.search.result.model.Match;
import mpi.search.result.model.Result;
import mpi.search.result.model.ResultHandler;
import mpi.search.result.viewer.ResultViewer;
import nl.mpi.util.gui.TriptychLayout;

public abstract class MDAbstractSearchPanel
extends AbstractSimpleSearchPanel
implements ResultHandler {
    public static final Font DEFAULT_FONT = new Font("Dialog", 0, 11);
    protected static String version;
    protected static String build;
    protected static String[] actionNames;
    protected static final String advancedSearch = "Advanced search";
    protected static final String keywordSearch = "Keyword search";
    protected final JCheckBox showOccurrencesCheckBox = new JCheckBox("Show occurrences", false);
    protected Action[] userActions;
    protected final JLabel selectedNodesInfoLabel = new JLabel();
    protected final JPanel corpusStructureServicePanel = new JPanel();
    protected final JTextField corpusStructureServiceTextField = new JTextField("");
    protected MDSimpleQueryPanel simpleQueryPanel;
    protected final QueryManager queryManager = new QueryManager();
    protected MDSearchStructure mdSearchStructure;
    protected MDAdvancedQueryPanel advancedQueryPanel;
    protected int displayContext = -1;
    protected Action helpAction;
    protected final Action printAction;
    private final JButton keywordQueryPanelButton = new JButton();
    private final JButton advancedQueryPanelButton = new JButton();
    private final JLabel queryLabel = new JLabel();
    private JPanel searchStateViewer;
    private MDQuerySpecPanel mdQuerySpecPanel;
    private final String INITIAL_MODE = "Default search";

    public MDAbstractSearchPanel(MDSearchStructure searchStructure) {
        this.mdSearchStructure = searchStructure;
        this.exportAction.putValue("Name", "Save");
        this.exportAction.putValue("ShortDescription", SearchLocale.getString("Action.Tooltip.SaveAsCorpus"));
        this.printAction = new AbstractAction("Print"){

            public void actionPerformed(ActionEvent e) {
                MDAbstractSearchPanel.this.print();
            }
        };
        this.printAction.putValue("ShortDescription", "Print result");
        KeyStroke ks = KeyStroke.getKeyStroke(80, 2);
        this.printAction.putValue("AcceleratorKey", ks);
        ActionListener a = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MDAbstractSearchPanel.this.setQueryPanel(e.getActionCommand());
            }
        };
        this.keywordQueryPanelButton.addActionListener(a);
        this.keywordQueryPanelButton.setText(keywordSearch);
        this.advancedQueryPanelButton.addActionListener(a);
        this.advancedQueryPanelButton.setText(advancedSearch);
        this.matchCounter = new MDMatchCounter();
        this.setQueryPanel("Default search");
    }

    public String getCorpusStructureService() {
        return this.corpusStructureServiceTextField.getText();
    }

    public abstract void handleMatch(Match var1, String var2);

    public void setResultViewer(ResultViewer resultViewer) {
        this.resultViewer = resultViewer;
        this.searchStateViewer.add("Center", ((MDResultViewer)resultViewer).getControlPanel());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.insets = new Insets(5, 5, 5, 5);
        c.ipady = 5;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 1;
        this.add((Component)((JPanel)((Object)resultViewer)), c);
        if (actionNames != null && resultViewer instanceof MDResultViewer) {
            ((MDResultViewer)resultViewer).setPopupChoices(actionNames);
        }
    }

    public MDSearchStructure getSearchStructure() {
        return this.mdSearchStructure;
    }

    public void setTextViewerVisible(boolean b) {
        int componentNr;
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.ipadx = 5;
        c.ipady = 5;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 1;
        for (componentNr = 0; componentNr < this.getComponents().length && !(this.getComponent(componentNr) instanceof MDResultViewer) && !(this.getComponent(componentNr) instanceof JSplitPane); ++componentNr) {
        }
        this.remove(componentNr);
        if (b) {
            JSplitPane _split_pane_inner = new JSplitPane(0, new JScrollPane(this.mdQuerySpecPanel), (MDResultViewer)this.resultViewer);
            this.add(_split_pane_inner, c, componentNr);
        } else {
            this.add((MDResultViewer)this.resultViewer, c, componentNr);
        }
        this.validate();
    }

    public void changeSearchStructure(MDSearchStructure scfg) {
        this.mdSearchStructure = scfg;
        this.advancedQueryPanel.setMDSearchStructure(scfg);
    }

    public void print() {
        MDResultPrinter printer = new MDResultPrinter();
        try {
            printer.print((MDQuery)this.queryManager.getCurrentQuery());
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected abstract MDResult createResult();

    protected Query getQuery() {
        if (this.searchEngine != null) {
            this.searchEngine.stopExecution();
        }
        MDQuery query = new MDQuery(this.getSearchDomains(), this.getQuerySpec(), (Result)this.createResult(), this.getQueryViewer() == this.simpleQueryPanel, this.displayContext);
        this.queryManager.addQuery(query);
        return query;
    }

    protected String getQuerySpec() {
        return this.getQueryViewer().getQuerySpec();
    }

    protected MDQueryViewer getQueryViewer() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!(this.getComponent(i) instanceof MDQueryViewer)) continue;
            return (MDQueryViewer)((Object)this.getComponent(i));
        }
        return null;
    }

    protected abstract MDSearchDomain[] getSearchDomains();

    protected void export() {
        File dbdir = MDSearchConfig.getSearchResultsDir();
        File dbfile = new File(MDSearchConfig.getSearchResultsDir(), "Result.imdi");
        if (!MDSearchConfig.getSearchResultsDir().exists()) {
            MDSearchConfig.getSearchResultsDir().mkdirs();
        }
        JFileChooser chooser = new JFileChooser(dbdir);
        chooser.setSelectedFile(dbfile);
        chooser.setDialogType(1);
        chooser.setDialogTitle("Choose file name for result corpus");
        int rv = chooser.showSaveDialog(this);
        if (rv == 0) {
            String filename = chooser.getSelectedFile().getPath();
            if (filename.indexOf(".") < 1) {
                filename = filename + ".imdi";
            }
            MDResult2Corpus.createSearchResultCorpus(filename, this.queryManager.getCurrentQuery().getResult(), this.getCorpusStructureService(), this.advancedQueryPanel.getQuerySpec());
        }
    }

    protected void updateActions() {
        super.updateActions();
        this.printAction.setEnabled(this.exportAction.isEnabled());
    }

    protected void makeLayout() {
        this.setLayout(new GridBagLayout());
        JPanel leftUpperCornerPanel = new JPanel(new BorderLayout());
        this.queryLabel.setFont(this.queryLabel.getFont().deriveFont(16.0f));
        leftUpperCornerPanel.add((Component)this.queryLabel, "Center");
        this.showOccurrencesCheckBox.setFont(this.showOccurrencesCheckBox.getFont().deriveFont(10.0f));
        this.showOccurrencesCheckBox.setBorder(new EmptyBorder(0, 20, 0, 20));
        this.showOccurrencesCheckBox.setToolTipText("Show actual occurrences of controlled vocabulary entries");
        leftUpperCornerPanel.add((Component)this.showOccurrencesCheckBox, "East");
        JPanel rightUpperCornerPanel = new JPanel();
        if (this.helpAction != null) {
            JButton helpButton = new JButton(this.helpAction);
            rightUpperCornerPanel.add(helpButton);
        }
        rightUpperCornerPanel.add(this.keywordQueryPanelButton);
        rightUpperCornerPanel.add(this.advancedQueryPanelButton);
        JPanel queryTogglePanel = new JPanel(new BorderLayout());
        queryTogglePanel.add("West", leftUpperCornerPanel);
        queryTogglePanel.add("East", rightUpperCornerPanel);
        ActionListener querySpecListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MDAbstractSearchPanel.this.mdQuerySpecPanel.setQuerySpec(MDAbstractSearchPanel.this.getQuerySpec());
            }
        };
        this.mdQuerySpecPanel = new MDQuerySpecPanel();
        this.advancedQueryPanel = new MDAdvancedQueryPanel(this.mdSearchStructure, querySpecListener, this.startAction);
        this.simpleQueryPanel = new MDSimpleQueryPanel();
        this.corpusStructureServicePanel.setLayout(new GridBagLayout());
        JLabel corpusStructureServiceLabel = new JLabel("Data base: ");
        JPanel buttonPanel = new JPanel();
        this.startStopPanel = new StartStopPanel(this.startAction, this.stopAction, this.userActions);
        buttonPanel.add(this.startStopPanel);
        this.searchStateViewer = new JPanel((LayoutManager)new TriptychLayout());
        this.searchStateViewer.add("Left", this.matchCounter);
        this.searchStateViewer.add("Right", this.progressViewer);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 0.0;
        this.corpusStructureServicePanel.add((Component)corpusStructureServiceLabel, c);
        c.weightx = 1.0;
        this.corpusStructureServicePanel.add((Component)this.corpusStructureServiceTextField, c);
        c.gridx = 0;
        c.weightx = 1.0;
        c.ipadx = 5;
        c.ipady = 5;
        c.insets = new Insets(5, 5, 5, 5);
        this.add((Component)queryTogglePanel, c);
        c.insets = new Insets(0, 0, 0, 0);
        c.ipady = 0;
        this.add((Component)this.selectedNodesInfoLabel, c);
        c.ipady = 5;
        c.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.simpleQueryPanel, c);
        c.weighty = 0.0;
        c.fill = 2;
        this.add((Component)this.corpusStructureServicePanel, c);
        this.add((Component)buttonPanel, c);
        c.ipady = 0;
        c.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.searchStateViewer, c);
        this.simpleQueryPanel.setActionListener(this.startAction);
        this.showOccurrencesCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                MDAbstractSearchPanel.this.advancedQueryPanel.showOccurrences(e.getStateChange() == 1);
            }
        });
        this.showOccurrencesCheckBox.setVisible(false);
        this.updateActions();
    }

    protected void setQueryPanel(String queryPanelType) {
        JPanel queryP = (JPanel)((Object)this.getQueryViewer());
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (this.getComponent(i) != queryP) continue;
            this.remove(i);
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.gridx = 0;
            c.weightx = 1.0;
            c.ipadx = 5;
            c.ipady = 5;
            c.insets = new Insets(5, 5, 0, 5);
            JPanel selectedPanel = queryPanelType.equals(advancedSearch) ? this.advancedQueryPanel : this.simpleQueryPanel;
            this.add(selectedPanel, c, i);
            this.showOccurrencesCheckBox.setVisible(!queryPanelType.equals(keywordSearch));
            this.queryLabel.setText(queryPanelType);
            this.revalidate();
            return;
        }
    }
}

