/*
 * Decompiled with CFR 0.152.
 */
package mpi.metadata.search.client.viewer;

import java.awt.Color;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import mpi.metadata.search.client.model.MDPathItem;
import mpi.metadata.search.client.model.MDSearchStructure;
import mpi.metadata.search.client.viewer.MDAbstractComplexQueryPanel;
import mpi.metadata.search.client.viewer.MDConstraintPanel;
import mpi.metadata.search.client.viewer.MDQueryViewer;

public class MDAdvancedQueryPanel
extends MDAbstractComplexQueryPanel
implements MDQueryViewer {
    private RootPathItemListener listener = null;

    public MDAdvancedQueryPanel(MDSearchStructure mdSearchStructure, ActionListener querySpecListener, ActionListener startListener) {
        super(mdSearchStructure, querySpecListener, startListener);
        this.getConstraintGridPanel().setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.setOpaque(false);
        this.getConstraintGridPanel().setOpaque(false);
        this.addConstraint();
    }

    public JPanel createConstraintPanel() {
        if (this.listener == null) {
            List pathItems = this.mdSearchStructure.getPathItems();
            this.listener = new RootPathItemListener();
            this.listener.selectedRootItem = (MDPathItem)pathItems.get(0);
            return new MDConstraintPanel(pathItems, this, this.querySpecListener, this.startListener, this.listener);
        }
        return new MDConstraintPanel(Collections.singletonList(this.listener.selectedRootItem), this, this.querySpecListener, this.startListener);
    }

    public void reset() {
        this.listener = null;
        super.reset();
    }

    class RootPathItemListener
    implements ItemListener {
        private MDPathItem selectedRootItem = null;

        RootPathItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                this.selectedRootItem = (MDPathItem)e.getItem();
                MDAdvancedQueryPanel.this.deleteConstraints(MDAdvancedQueryPanel.this.getNrOfConstraints() - 1);
            }
        }
    }
}

