/*
 * Decompiled with CFR 0.152.
 */
package mpi.metadata.search.client.viewer;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import mpi.metadata.search.client.model.MDPathItem;
import mpi.metadata.search.client.viewer.MDAbstractConstraintPanel;
import mpi.metadata.search.client.viewer.MDAdvancedQueryPanel;
import mpi.metadata.search.client.viewer.MDPathItemComponent;
import mpi.metadata.search.client.viewer.valuefield.ValueField;
import mpi.metadata.search.client.viewer.valuefield.ValueFieldFactory;

public class MDConstraintPanel
extends MDAbstractConstraintPanel
implements ItemListener {
    private final List pathItemComponents;

    public MDConstraintPanel(List rootPathItems, MDAdvancedQueryPanel queryPanel, ActionListener querySpecListener, ActionListener startListener, ItemListener rootPathItemlistener) {
        super(queryPanel, querySpecListener, startListener);
        MDPathItemComponent rootComboBoxPanel = new MDPathItemComponent(false, rootPathItems);
        if (rootPathItemlistener != null) {
            rootComboBoxPanel.addItemListener(rootPathItemlistener);
        }
        rootComboBoxPanel.addItemListener(this);
        this.pathItemComponents = new ArrayList();
        this.pathItemComponents.add(rootComboBoxPanel);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        this.c.anchor = 17;
        this.add((Component)((Object)rootComboBoxPanel), this.c);
        MDPathItem defaultSelectedItem = (MDPathItem)rootPathItems.get(0);
        this.makePathItemComponents(defaultSelectedItem);
        this.setValueField(this.getValueField());
    }

    public MDConstraintPanel(List rootPathItems, MDAdvancedQueryPanel queryPanel, ActionListener querySpecListener, ActionListener startListener) {
        this(rootPathItems, queryPanel, querySpecListener, startListener, null);
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (e.getItem() instanceof MDPathItem) {
                int pathItemNr = this.pathItemComponents.indexOf(((JComponent)e.getSource()).getParent());
                this.removePathItemComponents(pathItemNr + 1);
                this.makePathItemComponents((MDPathItem)e.getItem());
                this.setValueField(this.getValueField());
            }
            this.queryPanel.updateLayout();
            if (this.querySpecListener != null) {
                this.querySpecListener.actionPerformed(new ActionEvent(e.getSource(), 0, e.paramString()));
            }
        }
    }

    MDPathItem getLeafItem() {
        int lastItemIndex = this.pathItemComponents.size() - 1;
        return (MDPathItem)((MDPathItemComponent)((Object)this.pathItemComponents.get(lastItemIndex))).getSelectedItem();
    }

    String getTotalPath() {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < this.pathItemComponents.size(); ++i) {
            sb.append(((MDPathItemComponent)((Object)this.pathItemComponents.get(i))).getPath());
        }
        sb.replace(0, 1, "");
        return sb.toString();
    }

    private void makePathItemComponents(MDPathItem item) {
        if (item.getSubItems() != null && item.getSubItems().size() != 0) {
            MDPathItemComponent pathItemComponent = new MDPathItemComponent(item.isMultiple(), item.getSubItems());
            pathItemComponent.addItemListener(this);
            this.pathItemComponents.add(pathItemComponent);
            this.c.anchor = 17;
            this.c.insets = new Insets(0, 0, 0, 0);
            pathItemComponent.setOpaque(false);
            this.add((Component)((Object)pathItemComponent), this.c);
            this.makePathItemComponents((MDPathItem)item.getSubItems().get(0));
        }
    }

    protected ValueField getValueField() {
        return ValueFieldFactory.createValueField(this.getLeafItem(), this.getTotalPath(), this, false, this.queryPanel.isShowOuccurrences() ? this.queryPanel.getCVUtil() : null);
    }

    private void removePathItemComponents(int pathItemNr) {
        for (int i = this.pathItemComponents.size() - 1; i >= pathItemNr; --i) {
            this.remove((JPanel)this.pathItemComponents.get(i));
            this.pathItemComponents.remove(i);
        }
        if (this.valueField != null) {
            this.valueField.remove();
            this.remove(this.gluePanel);
            this.remove((JPanel)((Object)this.valueField));
            this.setValueField(null);
        }
    }

    void setValueField(ValueField valueField) {
        super.setValueField(valueField);
        if (valueField != null) {
            valueField.setQueryStructureListener(this);
        }
    }
}

