/*
 * Decompiled with CFR 0.152.
 */
package mpi.metadata.search.client.viewer;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.LineMetrics;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.SimpleDateFormat;
import java.util.StringTokenizer;
import mpi.metadata.search.model.MDQuery;
import mpi.search.result.model.Result;

public class MDResultPrinter
implements Pageable,
Printable {
    private static final String FONTFAMILY = "Monospaced";
    private static final int FONTSIZE = 7;
    private static final int HEADERFONTSIZE = 8;
    private static final int FOOTERFONTSIZE = 8;
    private static final int FONTSTYLE = 0;
    private static final float LINESPACEFACTOR = 1.2f;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat();
    private Font font;
    private Font footerFont;
    private Font headerFont;
    private MDQuery query;
    private PageFormat pageFormat;
    private String[] constraintStrings;
    private String[] matchStrings;
    private int baseline = -1;
    private int footerHeight;
    private int headerHeight;
    private int linesPerPage;
    private int linespacing;
    private int numPages;

    public MDResultPrinter() {
        this.init();
    }

    public int getNumberOfPages() {
        return this.numPages;
    }

    public PageFormat getPageFormat(int i) {
        return this.pageFormat;
    }

    public Printable getPrintable(int i) {
        return this;
    }

    public static void main(String[] args) {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPageable(new MDResultPrinter());
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException exception) {
                System.err.println("Printing error: " + exception);
            }
        }
    }

    public int print(Graphics g, PageFormat format, int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.numPages) {
            return 1;
        }
        g.setFont(this.headerFont);
        String headerText = "Metadata search performed on " + dateFormat.format(this.query.getCreationDate()) + " (" + this.matchStrings.length + " matches) with constraint" + (this.constraintStrings.length > 1 ? "s" : "") + ":";
        LineMetrics metrics = this.headerFont.getLineMetrics(headerText, ((Graphics2D)g).getFontRenderContext());
        float y = (float)(format.getImageableY() + (double)metrics.getAscent());
        g.drawString(headerText, (int)format.getImageableX(), (int)y);
        for (int i = 0; i < this.constraintStrings.length; ++i) {
            g.drawString(this.constraintStrings[i], (int)format.getImageableX(), (int)y + (i + 1) * 8);
        }
        if (this.baseline == -1) {
            FontMetrics fm = g.getFontMetrics(this.font);
            this.baseline = fm.getAscent();
        }
        g.setColor(Color.black);
        g.setFont(this.font);
        int startLine = pageIndex * this.linesPerPage;
        int endLine = startLine + this.linesPerPage - 1;
        if (endLine >= this.matchStrings.length) {
            endLine = this.matchStrings.length - 1;
        }
        int x0 = (int)format.getImageableX();
        int y0 = (int)format.getImageableY() + this.baseline + this.headerHeight;
        for (int i = startLine; i <= endLine; ++i) {
            if (this.matchStrings[i].length() > 0) {
                g.drawString(this.matchStrings[i], x0, y0);
            }
            y0 += this.linespacing;
        }
        g.setFont(this.footerFont);
        String footerText = "Page " + (pageIndex + 1) + " of " + this.numPages;
        metrics = this.footerFont.getLineMetrics(footerText, ((Graphics2D)g).getFontRenderContext());
        y = (float)(format.getImageableY() + format.getImageableHeight() - (double)metrics.getDescent() - (double)metrics.getLeading());
        g.drawString(footerText, (int)format.getImageableX(), (int)y);
        return 0;
    }

    public void print(MDQuery query) throws PrinterException {
        Result result = query.getResult();
        if (result.getRealSize() > 0) {
            this.query = query;
            this.matchStrings = new String[result.getRealSize()];
            for (int i = 1; i <= result.getRealSize(); ++i) {
                this.matchStrings[i - 1] = result.getMatch(i).getValue();
            }
            StringTokenizer st = new StringTokenizer(query.getSearchExpression(), "\n");
            this.constraintStrings = new String[st.countTokens()];
            for (int i = 0; i < this.constraintStrings.length; ++i) {
                this.constraintStrings[i] = st.nextToken();
            }
            if (query.isFulltext()) {
                this.constraintStrings[0] = "Search in all fields: " + this.constraintStrings[0];
            }
            this.headerHeight = (this.constraintStrings.length + 2) * 8;
            this.footerHeight = 16;
            this.linesPerPage = (int)Math.floor((this.pageFormat.getImageableHeight() - (double)this.footerHeight - (double)this.headerHeight) / (double)this.linespacing);
            this.numPages = (this.matchStrings.length - 1) / this.linesPerPage + 1;
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            printerJob.setPageable(this);
            if (printerJob.printDialog()) {
                printerJob.print();
            }
        }
    }

    private void init() {
        this.font = new Font(FONTFAMILY, 0, 7);
        this.headerFont = new Font(FONTFAMILY, 0, 8);
        this.footerFont = new Font(FONTFAMILY, 0, 8);
        this.linespacing = 8;
        this.pageFormat = PrinterJob.getPrinterJob().defaultPage();
        this.pageFormat.setOrientation(0);
    }
}

