/*
 * Decompiled with CFR 0.152.
 */
package mpi.metadata.search.client.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import mpi.search.result.model.Result;
import mpi.search.result.model.ResultEvent;
import mpi.search.result.model.ResultHandler;
import mpi.search.result.viewer.AbstractResultViewer;
import mpi.search.result.viewer.ResultList;

public class MDResultViewer
extends AbstractResultViewer {
    protected final ResultList list = new ResultList();

    public MDResultViewer() {
        this((ResultHandler)null);
    }

    public MDResultViewer(ResultHandler resultHandler) {
        this.list.setFont(this.list.getFont().deriveFont(0));
        if (resultHandler != null) {
            this.setResultHandler(resultHandler);
        }
        this.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().setView(this.list);
        this.add((Component)scrollPane, "Center");
        this.makeControlPanel();
        this.reset();
    }

    public void setPopupChoices(String[] choices) {
        this.list.setPopupChoices(choices);
    }

    public void setResultHandler(ResultHandler resultHandler) {
        this.list.setResultHandler(resultHandler);
    }

    public void resultChanged(ResultEvent e) {
        super.resultChanged(e);
        if (e.getType() == 1 && this.result.getStatus() == 0) {
            this.list.setModel(this.result);
        } else if (e.getType() == 2) {
            this.controlPanel.setVisible(true);
        }
    }

    public void showResult(Result result) {
    }

    protected void makeControlPanel() {
        JButton nextButton = new JButton(this.nextAction);
        JButton previousButton = new JButton(this.previousAction);
        this.controlPanel.add(previousButton);
        this.controlPanel.add(this.currentLabel);
        this.controlPanel.add(nextButton);
    }
}

