/*
 * Decompiled with CFR 0.152.
 */
package mpi.metadata.search.client.viewer.valuefield;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import nl.mpi.util.MetadataCVEntry;

public class CVListCellRenderer
implements ListCellRenderer {
    private static final int maxStringLength = 30;

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel entryLabel = new JLabel();
        String entry = "";
        int occurrences = -1;
        if (value != null) {
            if (value instanceof MetadataCVEntry) {
                entry = ((MetadataCVEntry)value).getValue();
                occurrences = ((MetadataCVEntry)value).getNumberOfOccurrences();
            } else if (value instanceof String) {
                entry = (String)value;
            }
            if (entry.length() == 0) {
                entry = "[No value specified]";
            } else if (entry.length() > 30) {
                entryLabel.setToolTipText(entry);
                entry = entry.substring(0, 30) + "...";
            }
            if (occurrences > -1) {
                entry = entry + " (" + occurrences + ")";
            }
        }
        entryLabel.setFont(list.getFont());
        entryLabel.setText(entry);
        return entryLabel;
    }
}

