/*
 * Decompiled with CFR 0.152.
 */
package mpi.metadata.search.client.viewer.valuefield;

import java.awt.Component;
import javax.swing.JComboBox;
import mpi.metadata.search.client.viewer.MDAbstractSearchPanel;
import mpi.metadata.search.client.viewer.valuefield.AbstractCVValueField;
import mpi.metadata.search.client.viewer.valuefield.CVListCellRenderer;
import mpi.metadata.search.model.AbstractCVUtil;
import mpi.vocabs.IMDIVocab;
import nl.mpi.util.MetadataCVEntry;
import nl.mpi.util.gui.DescriptedObjectListCellRenderer;

class CVValueField
extends AbstractCVValueField {
    CVValueField(String name, boolean editable, String cvLink, boolean listType, String path, boolean addEmptyFirstEntry, AbstractCVUtil cvUtil, Object cbobj) {
        super(name, listType, path, cvUtil, cbobj);
        if (this.entries != null) {
            this.cvEntryComboBox = new JComboBox<Object>(this.entries.toArray());
            this.cvEntryComboBox.setRenderer(new CVListCellRenderer());
        } else {
            if (cvLink != null && cvLink.length() > 0) {
                IMDIVocab vocab = null;
                try {
                    vocab = IMDIVocab.get(cvLink);
                }
                catch (Exception e) {
                    System.out.println("ERROR: " + e.getMessage());
                }
                if (vocab != null && vocab.getStatus()) {
                    this.cvEntryComboBox = new JComboBox(vocab.getCVentries());
                    this.cvEntryComboBox.setRenderer(new DescriptedObjectListCellRenderer());
                } else {
                    System.err.println("Error getting CV " + cvLink);
                    this.cvEntryComboBox = new JComboBox(emptyVector);
                }
            } else {
                System.err.println("Error getting CV " + cvLink);
                this.cvEntryComboBox = new JComboBox(emptyVector);
            }
            this.cvEntryComboBox.setEditable(editable);
        }
        if (addEmptyFirstEntry && this.cvEntryComboBox.getItemCount() > 1) {
            this.cvEntryComboBox.insertItemAt(cvUtil != null ? allEntry : "", 0);
            this.cvEntryComboBox.setSelectedIndex(0);
        }
        this.cvEntryComboBox.setFont(MDAbstractSearchPanel.DEFAULT_FONT);
        this.cvEntryComboBox.addItemListener(this.myItemListener);
        this.add((Component)this.cvEntryComboBox, this.c);
    }

    String getFollowUpLink() {
        System.out.println("IMDICVValueField.getFollowUpLink(): " + this.id + " selected Item has class: " + this.cvEntryComboBox.getSelectedItem().getClass().getName());
        System.out.println("IMDICVValueField.getFollowUpLink(): " + this.id + " selected Item has followup: " + ((MetadataCVEntry)this.cvEntryComboBox.getSelectedItem()).getFollowUp());
        return ((MetadataCVEntry)this.cvEntryComboBox.getSelectedItem()).getFollowUp();
    }
}

