/*
 * Decompiled with CFR 0.152.
 */
package mpi.metadata.search.client.viewer.valuefield;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.RepaintManager;
import mpi.metadata.search.client.viewer.MDAbstractSearchPanel;
import mpi.metadata.search.client.viewer.MDConstraintPanel;
import mpi.metadata.search.client.viewer.valuefield.AbstractKeyValueField;
import mpi.metadata.search.client.viewer.valuefield.CVListCellRenderer;
import mpi.metadata.search.client.viewer.valuefield.CVValueField;
import mpi.metadata.search.client.viewer.valuefield.NumberValueField;
import mpi.metadata.search.client.viewer.valuefield.TextValueField;
import mpi.metadata.search.model.AbstractCVUtil;
import mpi.vocabs.IMDIVocab;
import nl.mpi.util.MetadataCVEntry;
import nl.mpi.util.gui.DescriptedObjectListCellRenderer;

class FreeKVPValueField
extends AbstractKeyValueField {
    static IMDIVocab CVList = IMDIVocab.get("http://www.mpi.nl/IMDI/Schema/CVList.xml");
    static Vector _cvlabelsStand = new Vector(10);
    IMDIVocab cv = null;
    Vector cventries = new Vector();

    FreeKVPValueField(String name, boolean editable, String cvLink, boolean listType, String path, AbstractCVUtil cvUtil, Object cbobj) {
        super(name, editable, cvLink, listType, path, cvUtil, cbobj);
        if (this.entries != null) {
            this.cvEntryComboBox = new JComboBox<Object>(this.entries.toArray());
            this.cvEntryComboBox.setRenderer(new CVListCellRenderer());
        } else {
            Vector cvlabels = new Vector();
            if (cvLink != null && cvLink.length() > 0) {
                IMDIVocab thisCVlist = IMDIVocab.get(cvLink);
                if (thisCVlist.getStatus()) {
                    cvlabels.addAll(thisCVlist.getCVentries());
                    this.cvEntryComboBox = new JComboBox(cvlabels);
                    this.cvEntryComboBox.setRenderer(new DescriptedObjectListCellRenderer());
                    this.cvEntryComboBox.setFont(MDAbstractSearchPanel.DEFAULT_FONT);
                } else {
                    this.cvEntryComboBox = new JComboBox(_cvlabelsStand);
                    this.cvEntryComboBox.setRenderer(new DescriptedObjectListCellRenderer());
                    this.cvEntryComboBox.setFont(MDAbstractSearchPanel.DEFAULT_FONT);
                    cvlabels = _cvlabelsStand;
                }
            } else {
                System.out.println("IMDIFreeKVPValueField: no cvLink " + cvLink);
                this.cvEntryComboBox = new JComboBox(_cvlabelsStand);
                this.cvEntryComboBox.setRenderer(new DescriptedObjectListCellRenderer());
                this.cvEntryComboBox.setFont(MDAbstractSearchPanel.DEFAULT_FONT);
            }
            this.cvEntryComboBox.setEditable(true);
        }
        this.cvEntryComboBox.addItemListener((MDConstraintPanel)cbobj);
        this.cvEntryComboBox.setFont(MDAbstractSearchPanel.DEFAULT_FONT);
        this.add((Component)this.nameLabel, this.c);
        this.add((Component)this.cvEntryComboBox, this.c);
        this.add((Component)this.valueLabel, this.c);
        this.setInternalValueField();
        this.cvEntryComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                FreeKVPValueField.this.setInternalValueField();
                FreeKVPValueField.this.myItemListener.itemStateChanged(e);
            }
        });
    }

    private void setInternalValueField() {
        Object selectedItem;
        if (this.innerValueField != null) {
            this.innerValueField.remove();
            this.remove(this.innerValueField);
        }
        if ((selectedItem = this.cvEntryComboBox.getSelectedItem()) instanceof MetadataCVEntry) {
            String keyName = ((MetadataCVEntry)selectedItem).getValue();
            System.out.println("KeyName: " + keyName);
            this.innerValueField = new CVValueField("", this.editable, keyName, false, this.path + "." + keyName, false, this.cvUtil, this.cbobj);
        } else {
            this.innerValueField = new TextValueField("", false, this.cbobj);
        }
        this.add((Component)this.innerValueField, this.c);
    }

    static {
        emptyVector.add(new MetadataCVEntry("", null, null, ""));
        if (CVList.getStatus()) {
            _cvlabelsStand.addAll(CVList.getCVentries());
        }
    }

    class CVCItemListener
    implements ItemListener {
        Vector _cvlabels;
        int _hidx;
        MDConstraintPanel constraintPanel;

        CVCItemListener(Vector cvlabels, MDConstraintPanel constraintPanel) {
            this._cvlabels = cvlabels;
            this.constraintPanel = constraintPanel;
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                MetadataCVEntry value = null;
                value = e.getItem().getClass().getName().equals("java.lang.String") ? new MetadataCVEntry((String)e.getItem(), "") : (MetadataCVEntry)e.getItem();
                IMDIVocab test = IMDIVocab.get(value.getValue());
                if (test.getStatus()) {
                    FreeKVPValueField.this.cv = test;
                    if (FreeKVPValueField.this.cv.getType() != null && FreeKVPValueField.this.cv.getType().equals("NumberType")) {
                        FreeKVPValueField.this.innerValueField.remove();
                        FreeKVPValueField.this.remove(FreeKVPValueField.this.innerValueField);
                        FreeKVPValueField.this.innerValueField = new NumberValueField("", this.constraintPanel);
                        FreeKVPValueField.this.add((Component)FreeKVPValueField.this.innerValueField, FreeKVPValueField.this.c);
                    } else {
                        if (this._cvlabels.indexOf(value) < 0) {
                            MetadataCVEntry cvlabel = new MetadataCVEntry(value.getValue(), FreeKVPValueField.this.cv.getName(), null, FreeKVPValueField.this.cv.getDescription());
                            this._cvlabels.add(cvlabel);
                            FreeKVPValueField.this.cvEntryComboBox.setSelectedItem(cvlabel);
                        }
                        FreeKVPValueField.this.innerValueField.remove();
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "Not a CV definition\n" + value);
                }
            }
            FreeKVPValueField.this.myItemListener.itemStateChanged(e);
            RepaintManager.currentManager(FreeKVPValueField.this.innerValueField).addInvalidComponent(FreeKVPValueField.this.innerValueField);
        }
    }
}

