/*
 * Decompiled with CFR 0.152.
 */
package mpi.metadata.search.client.viewer.valuefield;

import mpi.metadata.search.client.model.MDPathItem;
import mpi.metadata.search.client.viewer.valuefield.AbstractValueField;
import mpi.metadata.search.client.viewer.valuefield.AgeValueField;
import mpi.metadata.search.client.viewer.valuefield.CVValueField;
import mpi.metadata.search.client.viewer.valuefield.DateValueField;
import mpi.metadata.search.client.viewer.valuefield.DependCVValueField;
import mpi.metadata.search.client.viewer.valuefield.FreeKVPValueField;
import mpi.metadata.search.client.viewer.valuefield.NumberValueField;
import mpi.metadata.search.client.viewer.valuefield.TextValueField;
import mpi.metadata.search.model.AbstractCVUtil;

public class ValueFieldFactory {
    public static AbstractValueField createValueField(MDPathItem pathItem, String path, Object cbobj, boolean addEmptyFirstEntry, AbstractCVUtil cvUtil) {
        AbstractValueField valueField;
        String type = pathItem.getType();
        String name = pathItem.getName();
        boolean listType = pathItem.getListType();
        if (type != null && type.startsWith("Age")) {
            valueField = new AgeValueField(name, cbobj);
        } else if (type != null && type.startsWith("Boolean")) {
            valueField = new CVValueField(name, false, "http://www.mpi.nl/IMDI/Schema/Boolean.xml", false, path, false, cvUtil, cbobj);
        } else if (type != null && type.startsWith("CV:")) {
            valueField = new CVValueField(name, true, pathItem.getLink(), listType, path, addEmptyFirstEntry, cvUtil, cbobj);
        } else if (type != null && type.startsWith("Date")) {
            valueField = new DateValueField(name, cbobj);
        } else if (type != null && type.startsWith("DependCV:")) {
            valueField = new DependCVValueField(name, true, pathItem.getLink(), listType, path, cvUtil, cbobj);
        } else if (type != null && type.startsWith("FixedKeyValuePair")) {
            valueField = new FreeKVPValueField(name, false, pathItem.getLink(), listType, path, cvUtil, cbobj);
        } else if (type != null && type.startsWith("FreeKeyValuePair")) {
            valueField = new FreeKVPValueField(name, true, pathItem.getLink(), listType, path, cvUtil, cbobj);
        } else if (type != null && type.startsWith("Numeric")) {
            valueField = new NumberValueField(name, cbobj);
        } else if (type != null && type.startsWith("Percentage")) {
            valueField = new NumberValueField(name, cbobj);
        } else if (type != null && type.equals("String")) {
            valueField = new TextValueField(name, listType, cbobj);
        } else {
            type = "Unknown";
            valueField = new TextValueField(name, listType, cbobj);
        }
        return valueField;
    }
}

