/*
 * Decompiled with CFR 0.152.
 */
package mpi.metadata.search.model;

import mpi.metadata.search.model.MDSearchDomain;
import mpi.search.query.model.Query;
import mpi.search.result.model.Result;

public class MDQuery
extends Query {
    private static final int NO_LIMIT = -1;
    private int limit = -1;
    private int offset = 0;
    private final Result result;
    private String field = null;
    private final String searchExpression;
    private final MDSearchDomain[] searchDomains;
    private final boolean fulltext;
    private boolean includeUrl = false;
    private boolean includeResources = false;
    private boolean includeTitle = false;
    private int displayContext = -1;
    private long sessionAndCatalogCount;

    public MDQuery(MDSearchDomain[] searchDomains, String searchExpression, Result result, boolean fulltext, int displayContext) {
        this(searchDomains, searchExpression, result, fulltext);
        this.displayContext = displayContext;
    }

    public MDQuery(MDSearchDomain searchDomain, String searchExpression, Result result, boolean fulltext, int displayContext) {
        this(new MDSearchDomain[]{searchDomain}, searchExpression, result, fulltext);
        this.displayContext = displayContext;
    }

    public MDQuery(MDSearchDomain[] searchDomains, String searchExpression, Result result) {
        this(searchDomains, searchExpression, result, false);
    }

    public MDQuery(MDSearchDomain[] searchDomains, String searchExpression, Result result, boolean fulltext) {
        this.searchDomains = searchDomains;
        this.searchExpression = searchExpression;
        this.result = result;
        this.fulltext = fulltext;
    }

    public void setField(String s) {
        this.field = s;
    }

    public String getField() {
        return this.field;
    }

    public int getDisplayContext() {
        return this.displayContext;
    }

    public boolean isFulltext() {
        return this.fulltext;
    }

    public Result getResult() {
        return this.result;
    }

    public MDSearchDomain getSearchDomain(int i) {
        return this.searchDomains[i];
    }

    public MDSearchDomain[] getSearchDomains() {
        return this.searchDomains;
    }

    public String getSearchExpression() {
        return this.searchExpression;
    }

    public int getSearchServiceCount() {
        return this.searchDomains.length;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MDQuery)) {
            return false;
        }
        MDQuery query = (MDQuery)o;
        if (!this.searchExpression.equals(query.getSearchExpression())) {
            return false;
        }
        return this.searchDomains.equals(query.getSearchDomains());
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setIncludeUrl(boolean b) {
        this.includeUrl = b;
    }

    public boolean isIncludeUrl() {
        return this.includeUrl;
    }

    public void setIncludeResources(boolean b) {
        this.includeResources = b;
    }

    public boolean isIncludeResources() {
        return this.includeResources;
    }

    public void setIncludeTitle(boolean b) {
        this.includeTitle = b;
    }

    public boolean isIncludeTitle() {
        return this.includeTitle;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SearchExpression: " + this.getSearchExpression());
        if (this.fulltext) {
            sb.append(" (keyword search)");
        }
        if (this.includeUrl) {
            sb.append(" including url ");
        }
        if (this.includeResources) {
            sb.append(" including resources ");
        }
        sb.append("\n");
        for (int i = 0; i < this.getSearchServiceCount(); ++i) {
            sb.append("CorpusStructure nr " + (i + 1) + " : " + this.searchDomains[i].getCorpusStructure() + "\n");
            if (this.searchDomains[i].getNodes() != null) {
                sb.append("Search within following Nodes and their descendants: \n");
                for (int j = 0; j < this.searchDomains[i].getNodes().size(); ++j) {
                    sb.append(this.searchDomains[i].getNodes().get(j) + " ");
                }
                continue;
            }
            sb.append("No restriction - Search on whole corpus");
        }
        return sb.toString();
    }

    public long getSessionAndCatalogCount() {
        return this.sessionAndCatalogCount;
    }

    public void setSessionAndCatalogCount(long sessionAndCatalogCount) {
        this.sessionAndCatalogCount = sessionAndCatalogCount;
    }
}

