/*
 * Decompiled with CFR 0.152.
 */
package mpi.search.model;

import mpi.search.model.ProgressListener;
import mpi.search.model.SearchController;
import mpi.search.model.SearchEngine;
import mpi.search.model.SearchListener;
import mpi.search.query.model.Query;
import mpi.search.result.model.Result;
import nl.mpi.util.SwingWorker;

public class DefaultSearchController
implements SearchController {
    protected ProgressListener progressListener;
    protected Result result;
    protected SearchListener searchListener;
    protected SwingWorker worker;
    private SearchEngine searchEngine;
    private boolean interrupted = false;
    private boolean isExecuting = false;
    private long endTime = -1L;
    private long startTime = -1L;

    public DefaultSearchController(SearchListener searchTool, SearchEngine searchEngine) {
        this.searchListener = searchTool;
        this.searchEngine = searchEngine;
    }

    public boolean isExecuting() {
        return this.isExecuting;
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public Result getResult() {
        return this.result;
    }

    public long getSearchDuration() {
        return (this.worker != null && this.worker.isRunning() ? System.currentTimeMillis() : this.endTime) - this.startTime;
    }

    public void execute(final Query query) {
        if (this.isExecuting()) {
            return;
        }
        this.isExecuting = true;
        this.searchListener.executionStarted();
        this.result = query.getResult();
        this.result.setStatus(0);
        this.interrupted = false;
        this.worker = new SwingWorker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object construct() {
                try {
                    DefaultSearchController.this.searchEngine.performSearch(query);
                }
                catch (Exception e) {
                    if (e.toString().startsWith("java.util.ConcurrentModificationException")) {
                        System.out.println(e.toString() + " - ignored");
                    } else {
                        DefaultSearchController.this.searchListener.handleException(e);
                    }
                }
                finally {
                    DefaultSearchController.this.executionStopped();
                }
                return DefaultSearchController.this.result;
            }

            public void finished() {
            }
        };
        this.startTime = System.currentTimeMillis();
        if (this.progressListener != null) {
            this.progressListener.setProgress(0);
        }
        this.worker.start();
    }

    public void stopExecution() {
        if (this.result != null) {
            this.interrupted = true;
            if (this.worker != null && this.worker.isRunning()) {
                this.worker.interrupt();
            }
            this.executionStopped();
        }
    }

    protected void executionStopped() {
        this.isExecuting = false;
        this.result.setStatus(this.interrupted ? -1 : 1);
        if (this.progressListener != null) {
            this.progressListener.setIndeterminate(false);
            this.progressListener.setStatus(this.result.getStatus());
        }
        this.endTime = System.currentTimeMillis();
        this.searchListener.executionStopped();
    }
}

