/*
 * Decompiled with CFR 0.152.
 */
package mpi.search.query.viewer;

import javax.swing.JPanel;
import mpi.search.model.SearchController;
import mpi.search.model.SearchListener;
import mpi.search.query.model.Query;
import mpi.search.result.viewer.MatchCounter;
import mpi.search.result.viewer.ResultViewer;
import mpi.search.viewer.ProgressViewer;

public abstract class AbstractSearchPanel
extends JPanel
implements SearchListener {
    protected final ProgressViewer progressViewer = new ProgressViewer();
    protected MatchCounter matchCounter = new MatchCounter();
    protected ResultViewer resultViewer;
    protected SearchController searchEngine;

    public void executionStarted() {
        this.matchCounter.setVisible(true);
        this.progressViewer.setVisible(true);
    }

    public void stopSearch() {
        if (this.searchEngine != null) {
            this.searchEngine.stopExecution();
        }
    }

    protected abstract Query getQuery();

    protected void startSearch() {
        Query query;
        if (this.searchEngine.getResult() != null) {
            this.searchEngine.getResult().removeListeners();
        }
        if ((query = this.getQuery()) != null) {
            query.getResult().reset();
            query.getResult().addResultChangeListener(this.matchCounter);
            query.getResult().addResultChangeListener(this.resultViewer);
            this.searchEngine.execute(query);
        }
    }
}

