/*
 * Decompiled with CFR 0.152.
 */
package mpi.vocabs;

import java.io.File;
import java.io.IOException;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Vector;
import mpi.vocabs.Cache;
import mpi.vocabs.CacheUpdateHandler;
import mpi.vocabs.DefaultUpdateHandler;
import nl.mpi.util.OurURL;
import nl.mpi.util.gui.AuthenticatedHttpConnection;

public abstract class CacheUpdater {
    public static boolean VERBOSE = false;
    public static int REQUEST = 0;
    public static int NEVER = 1;
    public static int ONCE_SESSION = 2;
    public static int ONCE_PERIOD = 3;
    public static int START = 4;
    private static int update_policy = ONCE_SESSION;
    private static int update_period = 7;
    private static CacheUpdateHandler handler = new DefaultUpdateHandler();
    private static Vector updated = new Vector();

    public static void update(Cache cache) throws IOException {
        handler.update(cache);
    }

    public static void update(Cache[] caches) throws IOException {
        handler.update(caches);
    }

    public static void updateFile(Cache cache, File file) throws IOException {
        boolean doUpdate = false;
        if (CacheUpdater.getUpdatingPolicy() == REQUEST) {
            doUpdate = true;
        }
        if (CacheUpdater.getUpdatingPolicy() == ONCE_SESSION && !updated.contains(file.getPath())) {
            doUpdate = true;
            updated.addElement(file.getPath());
        }
        if (doUpdate) {
            handler.updateFile(cache, file);
        }
    }

    public static void updateURL(Cache cache, String url) throws IOException {
        boolean doUpdate = false;
        if (CacheUpdater.getUpdatingPolicy() == REQUEST) {
            doUpdate = true;
        }
        if (CacheUpdater.getUpdatingPolicy() == ONCE_SESSION && !updated.contains(url)) {
            doUpdate = true;
            updated.addElement(url);
        }
        if (doUpdate) {
            handler.updateURL(cache, url);
        }
    }

    public static void updateURLNow(Cache cache, String url) throws IOException {
        handler.updateURL(cache, url);
    }

    public static void updateFiles(Cache cache, File[] files) throws IOException {
        Vector<File> filesV = new Vector<File>();
        for (int i = 0; i < files.length; ++i) {
            boolean doUpdate = false;
            File file = files[i];
            if (CacheUpdater.getUpdatingPolicy() == REQUEST) {
                doUpdate = true;
            }
            if (CacheUpdater.getUpdatingPolicy() == ONCE_SESSION && !updated.contains(file.getPath())) {
                doUpdate = true;
                updated.addElement(file.getPath());
            }
            if (!doUpdate) continue;
            filesV.addElement(file);
        }
        File[] files2 = new File[filesV.size()];
        for (int i = 0; i < filesV.size(); ++i) {
            files2[i] = (File)filesV.elementAt(i);
        }
        if (files2.length > 0) {
            handler.updateFiles(cache, files2);
        }
    }

    public static void updateURLs(Cache cache, String[] urls) throws IOException {
        Vector<String> urlsV = new Vector<String>();
        for (int i = 0; i < urls.length; ++i) {
            boolean doUpdate = false;
            String url = urls[i];
            if (CacheUpdater.getUpdatingPolicy() == REQUEST) {
                doUpdate = true;
            }
            if (CacheUpdater.getUpdatingPolicy() == ONCE_SESSION && !updated.contains(url)) {
                doUpdate = true;
                updated.addElement(url);
            }
            if (!doUpdate) continue;
            urlsV.addElement(url);
        }
        String[] urls2 = new String[urlsV.size()];
        for (int i = 0; i < urlsV.size(); ++i) {
            urls2[i] = (String)urlsV.elementAt(i);
        }
        if (urls.length > 0) {
            handler.updateURLs(cache, urls2);
        }
    }

    public static boolean fileNeedsUpdate(File file, String urlstr) throws IOException {
        if (VERBOSE) {
            System.out.println("Checking file: " + file + "\n         with: " + urlstr);
        }
        long flm = file.lastModified();
        try {
            AuthenticatedHttpConnection ahc = new AuthenticatedHttpConnection(urlstr, true, true);
            ahc.connect();
            URLConnection urlcon = ahc.getURLConnection();
            long ulm = urlcon.getLastModified();
            return ulm > flm;
        }
        catch (UnknownHostException uhe) {
            return false;
        }
    }

    public static boolean fileNeedsUpdate(File file, OurURL url) throws IOException {
        if (VERBOSE) {
            System.out.println("Checking file: " + file + "\n         with: " + url);
        }
        long flm = file.lastModified();
        try {
            AuthenticatedHttpConnection ahc = new AuthenticatedHttpConnection(url, true, true);
            ahc.connect();
            URLConnection urlcon = ahc.getURLConnection();
            long ulm = urlcon.getLastModified();
            return ulm > flm;
        }
        catch (UnknownHostException uhe) {
            return false;
        }
    }

    public static int getUpdatingPolicy() {
        return update_policy;
    }

    public static void setUpdatingPolicy(int policy) {
        update_policy = policy;
    }

    public static int getUpdatePeriod() {
        return update_period;
    }

    public static void setUpdatePeriod(int period) {
        update_period = period;
    }

    public static CacheUpdateHandler getHandler() {
        return handler;
    }

    public static void setHandler(CacheUpdateHandler cuhandler) {
        handler = cuhandler;
    }
}

