/*
 * Decompiled with CFR 0.152.
 */
package mpi.vocabs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.Date;
import java.util.Vector;
import mpi.vocabs.Cache;
import mpi.vocabs.CacheUpdater;
import nl.mpi.util.gui.AuthenticatedHttpConnection;

public class DefaultCache
implements Cache {
    private File cachedir;
    private String prefix;
    private float fileCopyProgress = 0.0f;
    private Date update_date;

    public DefaultCache(File cachedir, String prefix) {
        this.cachedir = cachedir;
        this.prefix = prefix;
    }

    public void copyFile(String urlstr) throws IOException {
        AuthenticatedHttpConnection ahc = new AuthenticatedHttpConnection(urlstr, true, true);
        ahc.connect();
        URLConnection urlcon = ahc.getURLConnection();
        this.copyFile(this.getFile(urlstr), urlcon);
    }

    public Vector getFilesThatNeedUpdate() throws IOException {
        Vector<File> ht = new Vector<File>();
        Vector allfiles = this.getAllCacheFiles();
        for (int i = 0; i < allfiles.size(); ++i) {
            String url;
            File file = (File)allfiles.elementAt(i);
            boolean up = CacheUpdater.fileNeedsUpdate(file, url = this.getURL(file));
            if (!up) continue;
            ht.addElement(file);
        }
        return ht;
    }

    public Vector getAllCacheFiles() {
        File[] files = this.cachedir.listFiles();
        Vector<File> ht = new Vector<File>();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                String urlstr = this.makeURL(files[i], this.prefix);
                Vector subht = this.getAllCacheFiles(files[i], urlstr);
                ht.addAll(subht);
            }
            if (!files[i].isFile()) continue;
            ht.addElement(files[i]);
        }
        return ht;
    }

    private Vector getAllCacheFiles(File dir, String prefix) {
        File[] files = dir.listFiles();
        Vector<File> ht = new Vector<File>();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                String urlstr = this.makeURL(files[i], prefix);
                Vector subht = this.getAllCacheFiles(files[i], urlstr);
                ht.addAll(subht);
            }
            if (!files[i].isFile()) continue;
            ht.addElement(files[i]);
        }
        return ht;
    }

    public Date getLastUpdate() {
        return this.update_date;
    }

    public void setLastUpdate(Date date) {
        date = this.update_date;
    }

    public float getFileCopyProgress() {
        return this.fileCopyProgress;
    }

    public String getURL(File file) {
        String pref = this.prefix;
        String pth = file.getParentFile().getPath();
        if (pth.startsWith(this.cachedir.getPath())) {
            pth = pth.substring(this.cachedir.getPath().length());
        }
        if (!pref.endsWith("/")) {
            pref = pref + "/";
        }
        if (pth.startsWith("/")) {
            pth = pth.substring(1);
        }
        if (!(pref = pref + pth).endsWith("/")) {
            pref = pref + "/";
        }
        String urlstr = pref + file.getName();
        return urlstr;
    }

    public File getFile(String urlstr) {
        return new File(this.cachedir, urlstr.substring(this.prefix.length()));
    }

    private void copyFile(File file, URLConnection urlcon) throws IOException {
        InputStream is = urlcon.getInputStream();
        FileOutputStream os = new FileOutputStream(file);
        int c = 0;
        int len = urlcon.getContentLength();
        int pos = 0;
        this.fileCopyProgress = 0.0f;
        while ((c = is.read()) != -1) {
            this.fileCopyProgress = (float)(++pos) / (float)len;
            ((OutputStream)os).write(c);
        }
        is.close();
        ((OutputStream)os).close();
    }

    private String makeURL(File file, String prefix) {
        if (!prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        return prefix + file.getName();
    }
}

