/*
 * Decompiled with CFR 0.152.
 */
package mpi.vocabs;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import mpi.vocabs.Cache;
import mpi.vocabs.CacheUpdateHandler;
import mpi.vocabs.CacheUpdater;

public class DefaultUpdateHandler
implements CacheUpdateHandler {
    public void update(Cache cache) throws IOException {
        Vector ht = cache.getFilesThatNeedUpdate();
        for (int i = 0; i < ht.size(); ++i) {
            File file = (File)ht.elementAt(i);
            String urlstr = cache.getURL(file);
            cache.copyFile(urlstr);
        }
    }

    public void update(Cache[] caches) throws IOException {
        for (int i = 0; i < caches.length; ++i) {
            Cache cache = caches[i];
            Vector ht = cache.getFilesThatNeedUpdate();
            for (int o = 0; o < ht.size(); ++o) {
                File file = (File)ht.elementAt(o);
                String urlstr = cache.getURL(file);
                cache.copyFile(urlstr);
            }
        }
    }

    public void updateFile(Cache cache, File file) throws IOException {
        String urlstr = cache.getURL(file);
        if (CacheUpdater.fileNeedsUpdate(file, urlstr)) {
            cache.copyFile(urlstr);
        }
    }

    public void updateURL(Cache cache, String url) throws IOException {
        File file = cache.getFile(url);
        if (file != null && CacheUpdater.fileNeedsUpdate(file, url)) {
            cache.copyFile(url);
        }
    }

    public void updateFiles(Cache cache, File[] files) throws IOException {
        for (int i = 0; i < files.length; ++i) {
            String urlstr = cache.getURL(files[i]);
            if (!CacheUpdater.fileNeedsUpdate(files[i], urlstr)) continue;
            cache.copyFile(urlstr);
        }
    }

    public void updateURLs(Cache cache, String[] urls) throws IOException {
        for (int i = 0; i < urls.length; ++i) {
            File file = cache.getFile(urls[i]);
            if (!CacheUpdater.fileNeedsUpdate(file, urls[i])) continue;
            cache.copyFile(urls[i]);
        }
    }
}

