/*
 * Decompiled with CFR 0.152.
 */
package mpi.vocabs;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import mpi.vocabs.Cache;
import mpi.vocabs.CacheUpdater;
import nl.mpi.util.DescriptedObject;
import nl.mpi.util.MetadataCVEntry;
import nl.mpi.util.OurURL;
import nl.mpi.util.gui.DismissableListWindow;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class IMDIVocab
implements DescriptedObject {
    public static boolean useCache = true;
    private static File cacheDir = new File("." + File.separatorChar + "CVCACHE");
    static boolean networkAvailable = false;
    static Hashtable _cvHash = new Hashtable();
    private static Cache cvcache = new Cache(){

        public void copyFile(String urlstr) throws IOException {
            try {
                IMDIVocab.copyToCache(new OurURL(urlstr), this.getFile(urlstr));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public Vector getFilesThatNeedUpdate() throws IOException {
            Vector<File> ht = new Vector<File>();
            Vector allfiles = this.getAllCacheFiles();
            for (int i = 0; i < allfiles.size(); ++i) {
                String url;
                File file = (File)allfiles.elementAt(i);
                boolean up = CacheUpdater.fileNeedsUpdate(file, url = this.getURL(file));
                if (!up) continue;
                ht.addElement(file);
            }
            return ht;
        }

        public Vector getAllCacheFiles() {
            Vector<File> filesV = new Vector<File>();
            File[] files = cacheDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory() && !files[i].getName().equals("local")) {
                    filesV.addAll(this.getCacheFiles(files[i]));
                    continue;
                }
                filesV.addElement(files[i]);
            }
            return filesV;
        }

        public Date getLastUpdate() {
            return updateDate;
        }

        public void setLastUpdate(Date date) {
            updateDate = date;
        }

        public float getFileCopyProgress() {
            return fcProgress;
        }

        public String getURL(File file) {
            return IMDIVocab.toURL(file).toString();
        }

        public File getFile(String urlstr) {
            try {
                File cf = new File(cacheDir, IMDIVocab.toCacheName(new OurURL(urlstr)));
                return cf;
            }
            catch (Exception e) {
                System.err.println("IMDIVocab: error: " + urlstr + ", " + e.getMessage());
                e.printStackTrace();
                return null;
            }
        }

        private Vector getCacheFiles(File dir) {
            Vector<File> filesV = new Vector<File>();
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    filesV.addAll(this.getCacheFiles(files[i]));
                    continue;
                }
                filesV.addElement(files[i]);
            }
            return filesV;
        }
    };
    private static float fcProgress = 0.0f;
    private static Date updateDate;
    static XMLReaderFactory xmlReaderFactory;
    static SAXParser saxParser;
    static XMLReader xmlReader;
    private String _localfile = "";
    private OurURL _url;
    private String _name;
    private String _description;
    private String _date;
    private String _origin;
    private String _followup;
    private String _type;
    private String _languageid;
    private String _tag;
    private String _title;
    private Vector _valueEntries = new Vector(10);
    private Vector _nameEntries = new Vector(10);
    private Vector _descriptionEntries = new Vector(10);
    private Vector _followupEntries = new Vector(10);
    private File _cf = null;
    private boolean _status = false;

    private IMDIVocab() {
        this._status = false;
    }

    private IMDIVocab(String str) throws MalformedURLException {
        this(new OurURL(str).toURL());
    }

    private IMDIVocab(URL url) throws MalformedURLException {
        this._url = new OurURL(url);
        if (!url.getProtocol().equals("file") && useCache) {
            File cf = new File(cacheDir, IMDIVocab.toCacheName(this._url));
            if (cf.exists()) {
                this._status = this.read(cf);
                this.setCacheFile(cf);
            } else {
                this._status = this.read(this._url);
                if (this._status) {
                    IMDIVocab.copyToCache(this._url, cf);
                    this.setCacheFile(cf);
                } else {
                    this._status = this.readFromJar(this._url);
                    if (this._status) {
                        this.setCacheFile(null);
                    } else {
                        this.setCacheFile(null);
                    }
                }
            }
        } else {
            this._status = this.read(this._url);
            this.setCacheFile(null);
        }
    }

    public static IMDIVocab get(String urlstr, String abspath) {
        try {
            CacheUpdater.updateURL(cvcache, urlstr);
        }
        catch (IOException e) {
            // empty catch block
        }
        IMDIVocab cv = null;
        cv = (IMDIVocab)_cvHash.get(urlstr);
        if (cv == null) {
            try {
                cv = new IMDIVocab(urlstr);
                String nametemp = cv.getName();
                if (nametemp == null) {
                    nametemp = "";
                }
                try {
                    OurURL urltemp = new OurURL(cv.getURL().toString());
                    Object obj = urltemp.getContent();
                }
                catch (FileNotFoundException fnfe) {
                    cv.setLocalfile(abspath);
                }
                catch (UnknownHostException uhe) {
                    cv.setLocalfile(abspath);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                _cvHash.put(cv.getURL().toString(), cv);
            }
            catch (MalformedURLException e) {
                cv = new IMDIVocab();
                cv._status = false;
                System.err.println("IMDIVocab: Error creating URL from " + urlstr);
            }
        }
        return cv;
    }

    private static boolean testNetworkAvailable() {
        try {
            URL url = new URL("http://www.mpi.nl");
            URLConnection conn = url.openConnection();
            conn.connect();
            return true;
        }
        catch (Exception e) {
            System.out.println("Network is not available: " + e.getMessage());
            return false;
        }
    }

    public static IMDIVocab get(String urlstr) {
        if (networkAvailable) {
            try {
                CacheUpdater.updateURL(cvcache, urlstr);
            }
            catch (IOException e) {
                System.out.println("IMDIVocab:get(): Error from CacheUpdater: " + e);
                e.printStackTrace();
            }
        }
        IMDIVocab cv = null;
        cv = (IMDIVocab)_cvHash.get(urlstr);
        if (cv == null) {
            try {
                cv = new IMDIVocab(urlstr);
                if (cv.getURL() != null) {
                    _cvHash.put(cv.getURL().toString(), cv);
                }
            }
            catch (MalformedURLException e) {
                cv = new IMDIVocab();
                cv._status = false;
                System.err.println("IMDIVocab: Error creating URL from " + urlstr);
            }
        }
        return cv;
    }

    public static Cache getCache() {
        return cvcache;
    }

    public static void remove(Object strKey) {
        _cvHash.remove(strKey);
    }

    public static Hashtable getVocabHashtable() {
        return _cvHash;
    }

    private static void getDir(File dir) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                IMDIVocab.getDir(files[i]);
                continue;
            }
            IMDIVocab.getFile(files[i]);
        }
    }

    private static void getFile(File file) {
        OurURL url = IMDIVocab.toURL(file);
        if (url != null && file.getPath().endsWith(".xml")) {
            IMDIVocab.get("" + url, file.getAbsolutePath());
        } else {
            System.err.println("IMDIVocab: can not get " + file.getPath());
        }
    }

    public static void readAllFromCache() {
        if (cacheDir.exists() && cacheDir.isDirectory()) {
            IMDIVocab.getDir(cacheDir);
        } else {
            System.err.println("IMDIVocab: Non existing cacheDir " + cacheDir.toString());
        }
    }

    public static String getCVCacheAbsoluteDir() {
        return cacheDir.getAbsolutePath();
    }

    public static String valueToTag(String strValue, String strLink) {
        IMDIVocab iv = (IMDIVocab)_cvHash.get(strLink);
        if (iv == null) {
            iv = IMDIVocab.get(strLink);
        }
        Vector v1 = iv.getNameEntries();
        Vector v2 = iv.getValueEntries();
        int intIndex = v1.indexOf(strValue);
        if (intIndex >= 0) {
            return (String)v2.elementAt(intIndex);
        }
        return strValue;
    }

    public static String tagToValue(String str, String strLink) {
        IMDIVocab iv = (IMDIVocab)_cvHash.get(strLink);
        if (iv == null) {
            iv = IMDIVocab.get(strLink);
        }
        Vector v1 = iv.getNameEntries();
        Vector v2 = iv.getValueEntries();
        int intIndex = v2.indexOf(str);
        if (intIndex >= 0) {
            return (String)v1.elementAt(intIndex);
        }
        return str;
    }

    public static Vector getVocabs() {
        return new Vector(_cvHash.values());
    }

    public static String getCVCacheDir() {
        return cacheDir.getPath();
    }

    public static void setCacheDir(String str) {
        File cd = new File(str + File.separatorChar + "CVCACHE");
        if (cd.exists() && cd.isDirectory()) {
            cacheDir = cd;
            System.out.println("IMDIVocab: set CV cache directory to " + cd);
        } else {
            try {
                cd.mkdirs();
                cacheDir = cd;
                System.out.println("IMDIVocab: created cache directory " + cd);
            }
            catch (Exception e) {
                System.err.println("IMDIVocab: unable to create cache directory\n" + e);
            }
        }
    }

    public static void refreshCache() {
        if (cacheDir.exists() && cacheDir.isDirectory()) {
            IMDIVocab.refreshDir(cacheDir);
        } else {
            System.err.println("IMDIVocab: No refreshing non existing cacheDir " + cacheDir.toString());
        }
    }

    private static void refreshDir(File dir) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                IMDIVocab.refreshDir(files[i]);
                continue;
            }
            IMDIVocab.refreshFile(files[i]);
        }
    }

    public static void refreshFile(File file) {
        OurURL url = IMDIVocab.toURL(file);
        if (url != null) {
            IMDIVocab.copyToCache(url, file);
        } else {
            System.err.println("IMDIVocab: refreshFile, can not refresh " + file.getPath());
        }
    }

    public static void showVocabList() {
        final Vector vocabs = IMDIVocab.getVocabs();
        final JList cvList = new JList(vocabs);
        DismissableListWindow dlw = new DismissableListWindow(cvList, "Controlled Vocabularies", 500, 300);
        MouseAdapter cvListMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int index;
                if (e.getClickCount() == 1) {
                    index = cvList.locationToIndex(e.getPoint());
                }
                if (e.getClickCount() == 2) {
                    index = cvList.locationToIndex(e.getPoint());
                    IMDIVocab iMDIVocab = (IMDIVocab)vocabs.get(index);
                }
            }

            public void mousePressed(MouseEvent e) {
                int mod = e.getModifiers();
                int index = cvList.locationToIndex(e.getPoint());
                final IMDIVocab vocab = (IMDIVocab)vocabs.get(index);
                if ((mod & 4) != 0 || (mod & 1) != 0) {
                    JPopupMenu pm = new JPopupMenu("Actions");
                    pm.add(new AbstractAction("Refresh"){

                        public void actionPerformed(ActionEvent e) {
                            vocab.refresh();
                        }
                    });
                    pm.add(new AbstractAction("Show info"){

                        public void actionPerformed(ActionEvent e) {
                        }
                    });
                    pm.show(cvList, e.getX(), e.getY());
                }
            }
        };
        dlw.addMouseListener((MouseListener)cvListMouseListener);
    }

    private boolean readFromJar(OurURL url) {
        OurURL urlInJar = null;
        URL rurl = this.getClass().getResource("/mpi/vocabs/CV/" + IMDIVocab.toCacheName(url));
        if (rurl != null) {
            try {
                urlInJar = new OurURL(rurl);
            }
            catch (MalformedURLException mue) {
                urlInJar = null;
            }
        }
        this._cf = null;
        if (urlInJar != null && (this._status = this.read(urlInJar))) {
            System.out.println("IMDIVocab: using default from " + urlInJar);
            return true;
        }
        System.err.println("IMDIVocab: can not load " + url + " from /mpi/vocabs/CV/" + IMDIVocab.toCacheName(url));
        return false;
    }

    public void refresh() {
        try {
            OurURL url = this.getURL();
            if (this._cf != null) {
                this._cf.delete();
                IMDIVocab.copyToCache(url, this._cf);
            }
            this._status = this.read(url);
            if (!this._status) {
                this._status = this.readFromJar(url);
            }
        }
        catch (MalformedURLException e) {
            System.err.println("IMDIVocab: refresh() can not make URL from " + this._origin);
        }
    }

    private static boolean copyToCache(OurURL url, File cf) {
        try {
            int n;
            fcProgress = 0.0f;
            byte[] b = new byte[1024];
            if (!cf.getParentFile().exists()) {
                cf.getParentFile().mkdirs();
            }
            URLConnection urlcon = url.openConnection();
            InputStream is = urlcon.getInputStream();
            float unit = 1.0f / (float)urlcon.getContentLength();
            FileOutputStream os = new FileOutputStream(cf);
            while ((n = is.read(b)) != -1) {
                os.write(b, 0, n);
                fcProgress += (float)n * unit;
            }
            os.close();
        }
        catch (IOException ioe) {
            System.err.println("copyToCache: Error copying " + url + " to " + cf.getPath());
            return false;
        }
        System.out.println("copyToCache: Copied " + url + " to " + cf.getPath());
        return true;
    }

    private static String toCacheName(OurURL url) {
        return url.getHost() + url.getPath();
    }

    private static OurURL toURL(File file) {
        String path = file.getAbsolutePath();
        if (!path.startsWith(cacheDir.getAbsolutePath())) {
            System.err.println("IMDIVocab: toURL; filename does not start with cacheDir " + path + ", " + cacheDir.getAbsolutePath());
        } else {
            try {
                return new OurURL("http:/" + path.substring(cacheDir.getAbsolutePath().length()).replace('\\', '/'));
            }
            catch (MalformedURLException e) {
                System.err.println("IMDIVocab: toURL; unable to create URL from " + path);
            }
        }
        return null;
    }

    public boolean read(File file) {
        try {
            return this.read(new OurURL("file:" + file.getPath()));
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public boolean read(OurURL url) {
        xmlReader.setContentHandler(new IMDIVocabCH());
        try {
            xmlReader.parse(url.toString());
        }
        catch (SAXException se) {
            System.err.println("IMDIVocab:read(): error parsing file : " + url + '\n' + se + '\n' + se.getMessage());
            return false;
        }
        catch (IOException ioe) {
            System.err.println("IMDIVocab:read():io error parsing file : " + url + '\n' + ioe);
            return false;
        }
        catch (Exception e) {
            System.err.println("IMDIVocab:read():error parsing file : " + url + '\n' + e);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean contains(String value) {
        return this.containsValue(value);
    }

    public boolean containsValue(String value) {
        return this._valueEntries.contains(value);
    }

    public boolean containsList(String cslist) {
        return this.containsValueArray(this.cslist2array(cslist));
    }

    public boolean containsArray(String[] entries) {
        return this.containsValueArray(entries);
    }

    public boolean containsValueArray(String[] entries) {
        for (int i = 0; i < entries.length; ++i) {
            if (this.containsValue(entries[i])) continue;
            return false;
        }
        return true;
    }

    public String[] cslist2array(String cslist) {
        Vector<String> v = new Vector<String>();
        StringTokenizer st = new StringTokenizer(cslist, ",");
        while (st.hasMoreTokens()) {
            v.add(st.nextToken().trim());
        }
        return v.toArray(new String[1]);
    }

    public String getComment(String value) {
        int idx = this._valueEntries.indexOf(value);
        if (idx >= 0) {
            return (String)this._descriptionEntries.get(idx);
        }
        return "";
    }

    public String getFollowUp(String value) {
        int idx = this._valueEntries.indexOf(value);
        if (idx >= 0) {
            return (String)this._followupEntries.get(idx);
        }
        return "";
    }

    public String getDescription(int i) {
        return (String)this._descriptionEntries.get(i);
    }

    public String getDescriptionList(String cslist) {
        StringBuffer ss = new StringBuffer("");
        String[] keys = this.cslist2array(cslist);
        for (int i = 0; i < keys.length; ++i) {
            String cmt = (String)this._descriptionEntries.get(this._valueEntries.indexOf(keys[i]));
            if (cmt == null) {
                cmt = "";
            }
            ss = ss.append(keys[i]).append(" -> ").append(cmt).append("\n");
        }
        return ss.toString();
    }

    public String getDescription() {
        return this._description;
    }

    public String getDate() {
        return this._date;
    }

    public OurURL getURL() throws MalformedURLException {
        if (this._origin == null) {
            return null;
        }
        return new OurURL(this._origin);
    }

    public String getLanguageId() {
        return this._languageid;
    }

    public String getTag() {
        return this._tag;
    }

    public String getTitle() {
        return this._title;
    }

    public String getValueEntry(int i) {
        if (this._status) {
            return (String)this._valueEntries.get(i);
        }
        return null;
    }

    public String getNameEntry(int i) {
        if (this._status) {
            return (String)this._nameEntries.get(i);
        }
        return null;
    }

    public String getFollowUpEntry(int i) {
        if (this._status) {
            return (String)this._followupEntries.get(i);
        }
        return null;
    }

    public String getDescriptionEntry(int i) {
        if (this._status) {
            return (String)this._descriptionEntries.get(i);
        }
        return null;
    }

    public int size() {
        if (this._status) {
            return this._valueEntries.size();
        }
        return -1;
    }

    public boolean getStatus() {
        return this._status;
    }

    public String getType() {
        return this._type;
    }

    public String getName() {
        return this._name;
    }

    public String getLocalfile() {
        return this._localfile;
    }

    public void setLocalfile(String localfile) {
        this._localfile = localfile;
    }

    public Vector getValueEntries() {
        return this._valueEntries;
    }

    public Vector getNameEntries() {
        return this._nameEntries;
    }

    public Vector getDescriptionEntries() {
        return this._descriptionEntries;
    }

    public Vector getEntries() {
        return this.getValueEntries();
    }

    public String toString() {
        return this._name + ":\t" + this._origin;
    }

    protected void add(String name, String value, String description, String followup) {
        if (name == null || name.equals("")) {
            name = value;
        }
        this._nameEntries.add(name);
        this._valueEntries.add(value);
        this._followupEntries.add(followup);
        this._descriptionEntries.add(description);
    }

    protected void setCacheFile(File cf) {
        this._cf = cf;
    }

    public Vector getCVentries() {
        Vector<MetadataCVEntry> cventries = new Vector<MetadataCVEntry>(10);
        if (this.getStatus()) {
            for (int i = 0; i < this.size(); ++i) {
                cventries.add(new MetadataCVEntry(this.getNameEntry(i), this.getValueEntry(i), this.getFollowUpEntry(i), this.getDescriptionEntry(i)));
            }
            return cventries;
        }
        return null;
    }

    static {
        try {
            networkAvailable = IMDIVocab.testNetworkAvailable();
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParser = saxParserFactory.newSAXParser();
            xmlReader = saxParser.getXMLReader();
            xmlReader.setFeature("http://xml.org/sax/features/validation", false);
            xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
        }
        catch (Exception e) {
            System.err.println("error in setting up parser " + e);
            System.exit(0);
        }
    }

    private class IMDIVocabCH
    implements ContentHandler {
        private Locator _locator;
        private String _elementTextContent = "";
        private String _itemName;
        private String _itemValue;
        private String _followup;
        private String _itemDescription;
        private String _lastEntry;

        IMDIVocabCH() {
        }

        public void characters(char[] ch, int start, int end) {
            String str = new String(ch, start, end);
            this._elementTextContent = this._elementTextContent + str;
        }

        protected String getTextContent() {
            return new String(this._elementTextContent.trim());
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void processingInstruction(String target, String data) {
        }

        public void startPrefixMapping(String prefix, String uri) {
        }

        public void endPrefixMapping(String prefix) {
        }

        public void skippedEntity(String name) {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            this._elementTextContent = "";
            if (localName.equals("VocabularyDef")) {
                String title;
                String tag;
                String languageid;
                String origin;
                String date;
                String type = "CVType";
                String name = this.getValue(atts, "Name");
                if (name != null) {
                    IMDIVocab.this._name = name;
                }
                if ((date = this.getValue(atts, "Date")) != null) {
                    IMDIVocab.this._date = date;
                }
                if ((origin = this.getValue(atts, "Link")) != null) {
                    IMDIVocab.this._origin = origin;
                }
                if ((type = this.getValue(atts, "Type")) != null) {
                    IMDIVocab.this._type = type;
                }
                if ((languageid = this.getValue(atts, "LanguageId")) != null) {
                    IMDIVocab.this._languageid = languageid;
                }
                if ((tag = this.getValue(atts, "Tag")) != null) {
                    IMDIVocab.this._tag = tag;
                }
                if ((title = this.getValue(atts, "Title")) != null) {
                    IMDIVocab.this._title = title;
                }
            } else if (!localName.equals("Description")) {
                if (localName.equals("Entry")) {
                    String value = this.getValue(atts, "Tag");
                    this._itemName = value != null ? value : "";
                    value = this.getValue(atts, "Value");
                    this._itemValue = value != null ? value : "";
                    value = this.getValue(atts, "FollowUp");
                    if (value != null) {
                        OurURL url = null;
                        try {
                            url = new OurURL(IMDIVocab.this._url, value);
                        }
                        catch (Exception e) {
                            System.out.println("IMDIVocabCH: Error: cannot combine followUp: " + value + " with " + IMDIVocab.this._url);
                            return;
                        }
                        this._followup = url.toString();
                    } else {
                        this._followup = "";
                    }
                } else {
                    System.out.println("IMDIVocabCH::startElement(); Error, unexpected element " + localName);
                }
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) {
            if (localName.equals("Entry")) {
                if (this._itemName.equals("")) {
                    this._itemName = this._itemValue;
                }
                IMDIVocab.this.add(this._itemName.trim(), this._itemValue.trim(), this.getTextContent().trim(), this._followup);
            } else if (localName.equals("Description")) {
                IMDIVocab.this._description = this.getTextContent();
            }
        }

        public void ignorableWhitespace(char[] ch, int start, int end) {
        }

        public void setDocumentLocator(Locator locator) {
            this._locator = locator;
        }

        protected String getValue(Attributes atts, String str) {
            for (int i = 0; i < atts.getLength(); ++i) {
                if (!atts.getLocalName(i).equals(str)) continue;
                return atts.getValue(i);
            }
            return null;
        }
    }
}

