/*
 * Decompiled with CFR 0.152.
 */
package mpi.vocabs;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import mpi.vocabs.Cache;
import mpi.vocabs.CacheUpdater;
import nl.mpi.util.OurURL;
import nl.mpi.util.gui.DismissableListWindow;

public class SchemaCache {
    static File cacheDir = new File("." + File.separatorChar + "SCHEMACACHE");
    static Hashtable _schemaHash = new Hashtable();
    private static Cache schemacache = new Cache(){

        public void copyFile(String urlstr) throws IOException {
            if (urlstr.startsWith("file:")) {
                System.out.println("Cache: do never update local schema file: " + urlstr);
            } else {
                try {
                    SchemaCache.copyToCache(new OurURL(urlstr), this.getFile(urlstr));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public Vector getFilesThatNeedUpdate() throws IOException {
            Vector<File> ht = new Vector<File>();
            Vector allfiles = this.getAllCacheFiles();
            for (int i = 0; i < allfiles.size(); ++i) {
                String url;
                File file = (File)allfiles.elementAt(i);
                boolean up = CacheUpdater.fileNeedsUpdate(file, url = this.getURL(file));
                if (!up) continue;
                ht.addElement(file);
            }
            return ht;
        }

        public Vector getAllCacheFiles() {
            return this.getCacheFiles(cacheDir);
        }

        public Date getLastUpdate() {
            return updateDate;
        }

        public void setLastUpdate(Date date) {
            updateDate = date;
        }

        public float getFileCopyProgress() {
            return fcProgress;
        }

        public String getURL(File file) {
            return SchemaCache.toURL(file).toString();
        }

        public File getFile(String urlstr) {
            try {
                File cf = new File(cacheDir, SchemaCache.toCacheName(new OurURL(urlstr)));
                return cf;
            }
            catch (Exception exception) {
                return null;
            }
        }

        private Vector getCacheFiles(File dir) {
            Vector<File> filesV = new Vector<File>();
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    filesV.addAll(this.getCacheFiles(files[i]));
                    continue;
                }
                filesV.addElement(files[i]);
            }
            return filesV;
        }
    };
    private static float fcProgress = 0.0f;
    private static Date updateDate;
    private String _name;
    private String _description;
    private String _date;
    private String _origin;
    private File _cf = null;
    private boolean _status = false;

    private SchemaCache() {
        this._status = false;
    }

    private SchemaCache(String str) throws MalformedURLException {
        this(new OurURL(str));
    }

    private SchemaCache(OurURL url) {
        System.out.println("SchemaCache: constr()" + url + ", " + url.getProtocol() + ", " + url.getHost() + ", " + url.getFile());
        if (!url.getProtocol().equals("file")) {
            File cf = new File(cacheDir, SchemaCache.toCacheName(url));
            if (cf.exists()) {
                this._status = true;
                this.setCacheFile(cf);
                this._origin = url.toString();
            } else {
                this._status = SchemaCache.copyToCache(url, cf);
                if (this._status) {
                    this.setCacheFile(cf);
                    this._origin = url.toString();
                    this._status = true;
                } else {
                    this.setCacheFile(null);
                }
            }
        } else {
            this._origin = url.getFile();
            this._status = true;
            this.setCacheFile(new File(this._origin));
        }
    }

    public static File get(String urlstr) {
        SchemaCache schema = null;
        schema = (SchemaCache)_schemaHash.get(urlstr);
        if (schema == null) {
            try {
                schema = new SchemaCache(urlstr);
                _schemaHash.put(urlstr, schema);
                System.out.println("SchemaCache: New Schema " + schema.getName() + " under " + urlstr);
            }
            catch (MalformedURLException e) {
                schema = new SchemaCache();
                schema._status = false;
                schema._cf = null;
                System.out.println("SchemaCache: Error creating URL from " + urlstr);
            }
        } else {
            System.out.println("SchemaCache: got: " + urlstr + " from cache");
        }
        return schema.getFile();
    }

    public static Vector getSchema() {
        return new Vector(_schemaHash.values());
    }

    public static String getCacheDir() {
        return cacheDir.getPath();
    }

    public static void setCacheDir(String str) {
        File cd = new File(str + File.separatorChar + "SCHEMACACHE");
        if (cd.exists() && cd.isDirectory()) {
            cacheDir = cd;
            System.out.println("SchemaCache: set Schena cache directory to " + cd);
        } else {
            try {
                cd.mkdirs();
                cacheDir = cd;
                System.out.println("SchemaCache: created cache directory " + cd);
            }
            catch (Exception e) {
                System.err.println("SchemaCache: unable to create cache directory\n" + e);
            }
        }
    }

    public static void refreshCache() {
        if (cacheDir.exists() && cacheDir.isDirectory()) {
            SchemaCache.refreshDir(cacheDir);
        } else {
            System.err.println("SchemaCache: No refreshing non existing cacheDir " + cacheDir.toString());
        }
    }

    private static void refreshDir(File dir) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                SchemaCache.refreshDir(files[i]);
                continue;
            }
            SchemaCache.refreshFile(files[i]);
        }
    }

    private static void refreshFile(File file) {
        OurURL url = SchemaCache.toURL(file);
        if (url != null) {
            SchemaCache.copyToCache(url, file);
        } else {
            System.err.println("SchemaCache: refreshFile, can not refresh " + file.getPath());
        }
    }

    public static Cache getCache() {
        return schemacache;
    }

    public static void showSchemaList() {
        final Vector schemas = SchemaCache.getSchema();
        final JList cvList = new JList(schemas);
        DismissableListWindow dlw = new DismissableListWindow(cvList, "Schemas", 500, 300);
        MouseAdapter cvListMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int index;
                if (e.getClickCount() == 1) {
                    index = cvList.locationToIndex(e.getPoint());
                }
                if (e.getClickCount() == 2) {
                    index = cvList.locationToIndex(e.getPoint());
                    SchemaCache schemaCache = (SchemaCache)schemas.get(index);
                }
            }

            public void mousePressed(MouseEvent e) {
                int mod = e.getModifiers();
                int index = cvList.locationToIndex(e.getPoint());
                final SchemaCache schema = (SchemaCache)schemas.get(index);
                if ((mod & 4) != 0 || (mod & 1) != 0) {
                    JPopupMenu pm = new JPopupMenu("Actions");
                    pm.add(new AbstractAction("Refresh"){

                        public void actionPerformed(ActionEvent e) {
                            schema.refresh();
                        }
                    });
                    pm.add(new AbstractAction("Show info"){

                        public void actionPerformed(ActionEvent e) {
                        }
                    });
                    pm.show(cvList, e.getX(), e.getY());
                }
            }
        };
        dlw.addMouseListener((MouseListener)cvListMouseListener);
    }

    public void refresh() {
        try {
            OurURL url = this.getURL();
            if (this._cf != null) {
                this._cf.delete();
                this._status = SchemaCache.copyToCache(url, this._cf);
            }
        }
        catch (MalformedURLException e) {
            System.err.println("SchemaCache: refresh() can not make URL from " + this._origin);
        }
    }

    private static boolean copyToCache(OurURL ourl, File cf) {
        return SchemaCache.copyToCache(ourl.toURL(), cf);
    }

    private static boolean copyToCache(URL url, File cf) {
        try {
            int n;
            byte[] b = new byte[1024];
            if (!cf.getParentFile().exists()) {
                cf.getParentFile().mkdirs();
            }
            URLConnection urlcon = url.openConnection();
            InputStream is = urlcon.getInputStream();
            float unit = 1.0f / (float)urlcon.getContentLength();
            FileOutputStream os = new FileOutputStream(cf);
            fcProgress = 0.0f;
            while ((n = is.read(b)) != -1) {
                os.write(b, 0, n);
                fcProgress += (float)n * unit;
            }
            os.close();
        }
        catch (IOException ioe) {
            System.err.println("copyToCache: Error copying " + url + " to " + cf.getPath() + "\n" + ioe);
            return false;
        }
        System.out.println("copyToCache: Copied " + url + " to " + cf.getPath());
        return true;
    }

    private static String toCacheName(OurURL url) {
        String s = "";
        if (url.getProtocol().equals("http")) {
            s = url.getHost() + url.getPath();
        } else if (url.toString().startsWith("jar:")) {
            s = url.toString();
            if (s.indexOf(33) > -1) {
                s = s.substring(s.indexOf(33) + 1);
            }
            if (s.startsWith("file:")) {
                s = s.substring(5);
            }
        } else {
            s = url.getHost() + url.getPath();
        }
        System.out.println("toCacheName: " + url + " -> " + s);
        return s;
    }

    private static OurURL toURL(File file) {
        String path = file.getAbsolutePath();
        if (!path.startsWith(cacheDir.getAbsolutePath())) {
            System.err.println("SchemaCache: toURL; filename does not start with cacheDir " + path + ", " + cacheDir.getAbsolutePath());
        } else {
            try {
                return new OurURL("http:/" + path.substring(cacheDir.getAbsolutePath().length()));
            }
            catch (MalformedURLException e) {
                System.err.println("SchemaCache: toURL; unable to create URL from " + path);
            }
        }
        return null;
    }

    public OurURL getURL() throws MalformedURLException {
        OurURL ourl = new OurURL(this._origin);
        return ourl;
    }

    public boolean getStatus() {
        return this._status;
    }

    public File getFile() {
        return this._cf;
    }

    public String getName() {
        if (this._status) {
            return this._origin.substring(this._origin.lastIndexOf(47) + 1);
        }
        return null;
    }

    public String toString() {
        return this._name + ":\t" + this._origin;
    }

    protected void setCacheFile(File cf) {
        this._cf = cf;
    }
}

