/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.gsm;

import com.ibm.media.codec.audio.AudioPacketizer;
import com.ibm.media.codec.audio.gsm.PacketSizeAdapter;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class Packetizer
extends AudioPacketizer {
    public Packetizer() {
        this.packetSize = 99;
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("gsm", 8000.0, -1, 1, -1, -1, 264, -1.0, Format.byteArray)};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("gsm/rtp", 8000.0, -1, 1, -1, -1, 264, -1.0, Format.byteArray)};
        this.PLUGIN_NAME = "GSM Packetizer";
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[1];
            this.controls[0] = new PacketSizeAdapter(this, this.packetSize, true);
        }
        return this.controls;
    }

    protected Format[] getMatchingOutputFormats(Format format) {
        AudioFormat audioFormat = (AudioFormat)format;
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("gsm/rtp", 8000.0, -1, 1, -1, -1, 264, -1.0, Format.byteArray)};
        return this.supportedOutputFormats;
    }

    public void open() throws ResourceUnavailableException {
        this.setPacketSize(this.packetSize);
        this.reset();
    }

    public synchronized void setPacketSize(int n2) {
        this.packetSize = n2;
        this.sample_count = this.packetSize / 33 * 160;
        if (this.history == null) {
            this.history = new byte[this.packetSize];
            return;
        }
        if (this.packetSize > this.history.length) {
            byte[] byArray = new byte[this.packetSize];
            System.arraycopy(this.history, 0, byArray, 0, this.historyLength);
            this.history = byArray;
        }
    }
}

