/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.audio;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.ExclusiveUse;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.SimpleGraphBuilder;
import com.sun.media.controls.GainControlAdapter;
import com.sun.media.renderer.audio.AudioRenderer;
import com.sun.media.renderer.audio.device.AudioOutput;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12CreateThreadRunnableAction;
import com.sun.media.util.jdk12PriorityAction;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class DirectAudioRenderer
extends AudioRenderer
implements Runnable,
ExclusiveUse {
    static String NAME;
    public static final int REQ_OPEN = 1;
    public static final int REQ_START = 2;
    public static final int REQ_STOP = 3;
    public static final int REQ_FLUSH = 4;
    public static final int REQ_DRAIN = 5;
    public static final int REQ_CLOSE = 6;
    public static final int REQ_SETGAIN = 7;
    public static final int REQ_SETMUTE = 8;
    public static final int REQ_SETRATE = 9;
    public static final int REQ_WRITE = 10;
    public static final int REQ_AVAILABLE = 11;
    public static final int REQ_TIME = 12;
    private static JMFSecurity jmfSecurity;
    private static boolean securityPrivelege;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    private Format ulawFormat;
    private Format linearFormat;
    private Codec ulawDecoder;
    private Format ulawOutputFormat;
    Buffer decodeBuffer = null;
    static boolean loaded;
    private int nativeData = 0;
    static /* synthetic */ Class class$java$lang$Thread;

    static {
        block4: {
            NAME = "DirectSound Renderer";
            jmfSecurity = null;
            securityPrivelege = false;
            try {
                jmfSecurity = JMFSecurityManager.getJMFSecurity();
                securityPrivelege = true;
            }
            catch (SecurityException securityException) {}
            loaded = false;
            if (loaded) break block4;
            try {
                JMFSecurityManager.loadLibrary("jmdaud");
                loaded = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                loaded = false;
            }
        }
    }

    public DirectAudioRenderer() {
        this.supportedFormats = new Format[2];
        this.ulawFormat = new AudioFormat("ULAW");
        this.linearFormat = new AudioFormat("LINEAR");
        this.supportedFormats[0] = new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1);
        this.supportedFormats[1] = this.ulawFormat;
        this.gainControl = new MCA(this);
    }

    Thread chpThread() {
        Object object;
        Thread thread = null;
        if (jmfSecurity != null) {
            object = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    object = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    object = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Throwable throwable) {
                securityPrivelege = false;
            }
        }
        if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
            try {
                object = jdk12CreateThreadRunnableAction.cons;
                thread = (Thread)jdk12.doPrivM.invoke((Object)jdk12.ac, ((Constructor)object).newInstance(class$java$lang$Thread != null ? class$java$lang$Thread : (class$java$lang$Thread = DirectAudioRenderer.class$("java.lang.Thread")), this));
                thread.setName("DirectSound Request Thread");
                object = jdk12PriorityAction.cons;
                jdk12.doPrivM.invoke((Object)jdk12.ac, ((Constructor)object).newInstance(thread, new Integer(10)));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            thread = new Thread(this);
            thread.setName("DirectSound Request Thread");
            thread.setPriority(10);
        }
        return thread;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void close() {
        super.close();
    }

    protected AudioOutput createDevice(AudioFormat audioFormat) {
        return new DirectAudioOutput();
    }

    public String getName() {
        return NAME;
    }

    private static synchronized boolean grabDevice() {
        return true;
    }

    protected boolean initDevice(AudioFormat audioFormat) {
        Format format = audioFormat;
        if (this.ulawDecoder != null) {
            this.ulawDecoder.close();
            this.ulawDecoder = null;
        }
        Format[] formatArray = new Format[1];
        if (this.ulawFormat.matches(audioFormat)) {
            this.ulawDecoder = SimpleGraphBuilder.findCodec(audioFormat, this.linearFormat, null, formatArray);
            if (this.ulawDecoder != null) {
                format = formatArray[0];
                this.ulawOutputFormat = format;
            } else {
                return false;
            }
        }
        this.devFormat = audioFormat;
        return super.initDevice((AudioFormat)format);
    }

    public boolean isExclusive() {
        return false;
    }

    private native int nBufferAvailable(int var1);

    private native void nCheckUnderflow(int var1);

    private native void nClose(int var1);

    private native void nDrain(int var1);

    private native void nFlush(int var1);

    private native long nGetSamplesPlayed(int var1);

    private native int nOpen(int var1, int var2, int var3, int var4);

    private native void nPause(int var1);

    private native void nResume(int var1);

    private native boolean nSetFrequency(int var1, int var2);

    private native void nSetGain(int var1, float var2);

    private native void nSetMute(int var1, boolean var2);

    private native int nWrite(int var1, byte[] var2, int var3, int var4, boolean var5, boolean var6);

    public void open() throws ResourceUnavailableException {
        if (this.device == null && this.inputFormat != null && !this.initDevice(this.inputFormat)) {
            throw new ResourceUnavailableException("Cannot intialize audio device for playback");
        }
    }

    public int processData(Buffer buffer) {
        if (!this.checkInput(buffer)) {
            return 1;
        }
        if (this.ulawDecoder == null) {
            return super.doProcessData(buffer);
        }
        if (this.decodeBuffer == null) {
            this.decodeBuffer = new Buffer();
            this.decodeBuffer.setFormat(this.ulawOutputFormat);
        }
        this.decodeBuffer.setLength(0);
        this.decodeBuffer.setOffset(0);
        this.decodeBuffer.setFlags(buffer.getFlags());
        this.decodeBuffer.setTimeStamp(buffer.getTimeStamp());
        this.decodeBuffer.setSequenceNumber(buffer.getSequenceNumber());
        int n2 = this.ulawDecoder.process(buffer, this.decodeBuffer);
        if (n2 == 0) {
            return super.doProcessData(this.decodeBuffer);
        }
        return 1;
    }

    public void run() {
        ((Runnable)((Object)this.device)).run();
    }

    class MCA
    extends GainControlAdapter {
        AudioRenderer renderer;

        protected MCA(AudioRenderer audioRenderer) {
            super(1.0f);
            this.renderer = audioRenderer;
        }

        public float setLevel(float f2) {
            float f3 = super.setLevel(f2);
            f2 = this.getDB();
            if (this.renderer != null && this.renderer.device != null) {
                this.renderer.device.setGain(f2);
            }
            return f3;
        }

        public void setMute(boolean bl) {
            if (this.renderer != null && this.renderer.device != null) {
                this.renderer.device.setMute(bl);
            }
            super.setMute(bl);
        }
    }

    class DirectAudioOutput
    implements AudioOutput,
    Runnable {
        private int bufSize;
        private AudioFormat format;
        private float gain;
        private boolean muted;
        private int request = 0;
        private Integer reqLock = new Integer(0);
        private boolean response = false;
        private Thread reqThread = null;
        private float rate = 1.0f;
        private boolean swapBytes = false;
        private boolean signChange = false;
        private float reqRate = 1.0f;
        private byte[] writeData;
        private int writeOffset;
        private int writeLen;
        private int writeResponse;
        private long nanoseconds;
        private int bufferAvailable;
        private boolean started = false;
        private Integer writeLock = new Integer(1);

        public synchronized int bufferAvailable() {
            this.makeRequest(11);
            this.waitForResponse();
            return this.bufferAvailable;
        }

        public synchronized void dispose() {
            if (DirectAudioRenderer.this.nativeData != 0) {
                this.makeRequest(6);
                this.waitForResponse();
            }
        }

        public float doSetRate(float f2) {
            if ((double)f2 * this.format.getSampleRate() > 100000.0) {
                f2 = 100000.0f / (float)this.format.getSampleRate();
            }
            if (f2 < 0.1f) {
                f2 = 0.1f;
            }
            int n2 = (int)((double)f2 * this.format.getSampleRate());
            if (DirectAudioRenderer.this.nSetFrequency(DirectAudioRenderer.this.nativeData, n2)) {
                this.rate = f2;
            } else {
                this.rate = 1.0f;
                f2 = 1.0f;
            }
            return f2;
        }

        public synchronized void drain() {
            this.makeRequest(5);
            this.waitForResponse();
            this.started = false;
        }

        public synchronized void flush() {
            this.makeRequest(4);
            this.waitForResponse();
            this.started = false;
        }

        public AudioFormat getFormat() {
            return this.format;
        }

        public double getGain() {
            return this.gain;
        }

        public long getMediaNanoseconds() {
            long l2 = DirectAudioRenderer.this.nGetSamplesPlayed(DirectAudioRenderer.this.nativeData);
            this.nanoseconds = (long)((double)(1000000L * l2) / this.format.getSampleRate()) * 1000L;
            return this.nanoseconds;
        }

        public boolean getMute() {
            return this.muted;
        }

        public float getRate() {
            return this.rate;
        }

        public boolean initialize(AudioFormat audioFormat, int n2) {
            if (!loaded) {
                return false;
            }
            this.format = audioFormat;
            this.bufSize = (int)(audioFormat.getSampleRate() * (double)audioFormat.getSampleSizeInBits() * (double)audioFormat.getChannels() / 8.0 / 32.0);
            if (this.reqThread == null) {
                this.reqThread = DirectAudioRenderer.this.chpThread();
                this.reqThread.start();
            }
            this.swapBytes = audioFormat.getEndian() == 1 && audioFormat.getSampleSizeInBits() == 16;
            this.signChange = audioFormat.getSigned() == 1 && audioFormat.getSampleSizeInBits() == 8;
            this.makeRequest(1);
            this.waitForResponse();
            return DirectAudioRenderer.this.nativeData != 0;
        }

        private void makeRequest(int n2) {
            Integer n3 = this.reqLock;
            synchronized (n3) {
                this.request = n2;
                this.response = false;
                this.reqLock.notifyAll();
            }
        }

        public synchronized void pause() {
            this.makeRequest(3);
            this.waitForResponse();
            this.started = false;
        }

        public synchronized void resume() {
            this.makeRequest(2);
            this.waitForResponse();
            this.started = true;
        }

        public void run() {
            boolean bl = false;
            while (!bl) {
                int n2;
                Integer n3 = this.reqLock;
                synchronized (n3) {
                    try {
                        if (this.request == 0) {
                            this.reqLock.wait(50L);
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                    n2 = this.request;
                    this.request = 0;
                }
                switch (n2) {
                    case 1: {
                        DirectAudioRenderer.this.nativeData = DirectAudioRenderer.this.nOpen((int)this.format.getSampleRate(), this.format.getSampleSizeInBits(), this.format.getChannels(), this.bufSize);
                        break;
                    }
                    case 2: {
                        DirectAudioRenderer.this.nResume(DirectAudioRenderer.this.nativeData);
                        break;
                    }
                    case 3: {
                        DirectAudioRenderer.this.nPause(DirectAudioRenderer.this.nativeData);
                        break;
                    }
                    case 4: {
                        DirectAudioRenderer.this.nFlush(DirectAudioRenderer.this.nativeData);
                        break;
                    }
                    case 5: {
                        DirectAudioRenderer.this.nDrain(DirectAudioRenderer.this.nativeData);
                        break;
                    }
                    case 7: {
                        DirectAudioRenderer.this.nSetGain(DirectAudioRenderer.this.nativeData, this.gain);
                        break;
                    }
                    case 8: {
                        DirectAudioRenderer.this.nSetMute(DirectAudioRenderer.this.nativeData, this.muted);
                        break;
                    }
                    case 9: {
                        this.doSetRate(this.reqRate);
                        break;
                    }
                    case 10: {
                        this.writeResponse = DirectAudioRenderer.this.nWrite(DirectAudioRenderer.this.nativeData, this.writeData, this.writeOffset, this.writeLen, this.swapBytes, this.signChange);
                        break;
                    }
                    case 12: {
                        long l2 = DirectAudioRenderer.this.nGetSamplesPlayed(DirectAudioRenderer.this.nativeData);
                        this.nanoseconds = (long)((double)(1000000L * l2) / this.format.getSampleRate()) * 1000L;
                        break;
                    }
                    case 11: {
                        this.bufferAvailable = DirectAudioRenderer.this.nBufferAvailable(DirectAudioRenderer.this.nativeData);
                        break;
                    }
                    case 6: {
                        n3 = this.writeLock;
                        synchronized (n3) {
                            DirectAudioRenderer.this.nClose(DirectAudioRenderer.this.nativeData);
                            DirectAudioRenderer.this.nativeData = 0;
                            bl = true;
                            break;
                        }
                    }
                    default: {
                        if (!this.started) break;
                        n3 = this.writeLock;
                        synchronized (n3) {
                            DirectAudioRenderer.this.nCheckUnderflow(DirectAudioRenderer.this.nativeData);
                            break;
                        }
                    }
                }
                if (n2 <= 0) continue;
                Integer n4 = this.reqLock;
                synchronized (n4) {
                    this.response = true;
                    this.reqLock.notifyAll();
                }
            }
            this.reqThread = null;
        }

        public synchronized void setGain(double d2) {
            this.gain = (float)d2;
            this.makeRequest(7);
            this.waitForResponse();
        }

        public synchronized void setMute(boolean bl) {
            this.muted = bl;
            this.makeRequest(8);
            this.waitForResponse();
        }

        public synchronized float setRate(float f2) {
            this.reqRate = f2;
            this.makeRequest(9);
            this.waitForResponse();
            return this.rate;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void waitForResponse() {
            Integer n2 = this.reqLock;
            synchronized (n2) {
                while (true) {
                    if (this.response) {
                        return;
                    }
                    try {
                        this.reqLock.wait(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        public int write(byte[] byArray, int n2, int n3) {
            this.writeData = byArray;
            this.writeOffset = n2;
            this.writeLen = n3;
            Integer n4 = this.writeLock;
            synchronized (n4) {
                this.writeResponse = DirectAudioRenderer.this.nWrite(DirectAudioRenderer.this.nativeData, this.writeData, this.writeOffset, this.writeLen, this.swapBytes, this.signChange);
            }
            return this.writeResponse;
        }
    }
}

