/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.RTCPPacket;
import com.sun.media.rtp.RTCPReportBlock;
import java.io.DataOutputStream;
import java.io.IOException;

public class RTCPSRPacket
extends RTCPPacket {
    int ssrc;
    long ntptimestampmsw;
    long ntptimestamplsw;
    long rtptimestamp;
    long packetcount;
    long octetcount;
    RTCPReportBlock[] reports;

    RTCPSRPacket(int n2, RTCPReportBlock[] rTCPReportBlockArray) {
        this.ssrc = n2;
        this.reports = rTCPReportBlockArray;
        if (rTCPReportBlockArray.length > 31) {
            throw new IllegalArgumentException("Too many reports");
        }
    }

    RTCPSRPacket(RTCPPacket rTCPPacket) {
        super(rTCPPacket);
        this.type = 200;
    }

    void assemble(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(128 + this.reports.length);
        dataOutputStream.writeByte(200);
        dataOutputStream.writeShort(6 + this.reports.length * 6);
        dataOutputStream.writeInt(this.ssrc);
        dataOutputStream.writeInt((int)this.ntptimestampmsw);
        dataOutputStream.writeInt((int)this.ntptimestamplsw);
        dataOutputStream.writeInt((int)this.rtptimestamp);
        dataOutputStream.writeInt((int)this.packetcount);
        dataOutputStream.writeInt((int)this.octetcount);
        int n2 = 0;
        while (n2 < this.reports.length) {
            dataOutputStream.writeInt(this.reports[n2].ssrc);
            dataOutputStream.writeInt((this.reports[n2].packetslost & 0xFFFFFF) + (this.reports[n2].fractionlost << 24));
            dataOutputStream.writeInt((int)this.reports[n2].lastseq);
            dataOutputStream.writeInt(this.reports[n2].jitter);
            dataOutputStream.writeInt((int)this.reports[n2].lsr);
            dataOutputStream.writeInt((int)this.reports[n2].dlsr);
            ++n2;
        }
    }

    public int calcLength() {
        return 28 + this.reports.length * 24;
    }

    public String toString() {
        return "\tRTCP SR (sender report) packet for sync source " + this.ssrc + "\n\t\tNTP timestampMSW: " + this.ntptimestampmsw + "\n\t\tNTP timestampLSW: " + this.ntptimestamplsw + "\n\t\tRTP timestamp: " + this.rtptimestamp + "\n\t\tnumber of packets sent: " + this.packetcount + "\n\t\tnumber of octets (bytes) sent: " + this.octetcount + "\n" + RTCPReportBlock.toString(this.reports);
    }
}

