/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import javax.media.MediaLocator;

public class RTPMediaLocator
extends MediaLocator {
    String address = "";
    String contentType = "";
    private boolean valid = true;
    public static final int PORT_UNDEFINED = -1;
    public static final int SSRC_UNDEFINED = 0;
    public static final int TTL_UNDEFINED = 1;
    int port = -1;
    long ssrc = 0L;
    int ttl = 1;

    public RTPMediaLocator(String string) throws MalformedURLException {
        super(string);
        this.parseLocator(string);
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getSSRC() {
        return this.ssrc;
    }

    public String getSessionAddress() {
        return this.address;
    }

    public int getSessionPort() {
        return this.port;
    }

    public int getTTL() {
        return this.ttl;
    }

    public boolean isValid() {
        return this.valid;
    }

    private void parseLocator(String string) throws MalformedURLException {
        block15: {
            Number number;
            Object object;
            Object object2;
            String string2 = this.getRemainder();
            int n2 = string2.indexOf(":");
            int n3 = string2.indexOf("/", 2);
            int n4 = -1;
            int n5 = -1;
            if (n2 != -1) {
                n4 = string2.indexOf(":", n2 + 1);
            }
            if (n3 != -1) {
                n5 = string2.indexOf("/", n3 + 1);
            }
            if (n2 != -1) {
                this.address = string2.substring(2, n2);
            }
            try {
                object2 = InetAddress.getByName(this.address);
            }
            catch (UnknownHostException unknownHostException) {
                throw new MalformedURLException("Valid RTP Session Address must be given");
            }
            if (n2 == -1 || n3 == -1) {
                throw new MalformedURLException("RTP MediaLocator is Invalid. Must be of form rtp://addr:port/content/ttl");
            }
            object2 = "";
            object2 = n4 == -1 ? string2.substring(n2 + 1, n3) : string2.substring(n2 + 1, n4);
            try {
                object = Integer.valueOf((String)object2);
                this.port = (Integer)object;
            }
            catch (NumberFormatException numberFormatException) {
                throw new MalformedURLException("RTP MediaLocator Port must be a valid integer");
            }
            if (n4 != -1) {
                object = string2.substring(n4 + 1, n3);
                try {
                    number = Long.valueOf((String)object);
                    this.ssrc = (Long)number;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (n3 != -1) {
                this.contentType = n5 == -1 ? string2.substring(n3 + 1, string2.length()) : string2.substring(n3 + 1, n5);
                if (!this.contentType.equals("audio") && !this.contentType.equals("video")) {
                    throw new MalformedURLException("Content Type in URL must be audio or video ");
                }
                this.contentType = "rtp/" + this.contentType;
            }
            if (n5 == -1) break block15;
            object = string2.substring(n5 + 1, string2.length());
            try {
                number = Integer.valueOf((String)object);
                this.ttl = (Integer)number;
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }
}

