/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.batik.apps.svgbrowser.ConfigurationPanelSelector;
import org.apache.batik.apps.svgbrowser.IconCellRenderer;
import org.apache.batik.apps.svgbrowser.Resources;
import org.apache.batik.apps.svgbrowser.XMLPreferenceManager;
import org.apache.batik.ext.swing.GridBagConstants;
import org.apache.batik.ext.swing.JGridBagPanel;
import org.apache.batik.util.PreferenceManager;
import org.apache.batik.util.gui.CSSMediaPanel;
import org.apache.batik.util.gui.LanguageDialog;
import org.apache.batik.util.gui.UserStyleDialog;

public class PreferenceDialog
extends JDialog
implements GridBagConstants {
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    public static final String ICON_USER_LANGUAGE = "PreferenceDialog.icon.userLanguagePref";
    public static final String ICON_USER_STYLESHEET = "PreferenceDialog.icon.userStylesheetPref";
    public static final String ICON_BEHAVIOR = "PreferenceDialog.icon.behaviorsPref";
    public static final String ICON_NETWORK = "PreferenceDialog.icon.networkPref";
    public static final String LABEL_USER_OPTIONS = "PreferenceDialog.label.user.options";
    public static final String LABEL_BEHAVIOR = "PreferenceDialog.label.behavior";
    public static final String LABEL_NETWORK = "PreferenceDialog.label.network";
    public static final String LABEL_USER_LANGUAGE = "PreferenceDialog.label.user.language";
    public static final String LABEL_USER_STYLESHEET = "PreferenceDialog.label.user.stylesheet";
    public static final String LABEL_USER_FONT = "PreferenceDialog.label.user.font";
    public static final String LABEL_APPLICATIONS = "PreferenceDialog.label.applications";
    public static final String LABEL_SHOW_RENDERING = "PreferenceDialog.label.show.rendering";
    public static final String LABEL_AUTO_ADJUST_WINDOW = "PreferenceDialog.label.auto.adjust.window";
    public static final String LABEL_ENABLE_DOUBLE_BUFFERING = "PreferenceDialog.label.enable.double.buffering";
    public static final String LABEL_SHOW_DEBUG_TRACE = "PreferenceDialog.label.show.debug.trace";
    public static final String LABEL_SELECTION_XOR_MODE = "PreferenceDialog.label.selection.xor.mode";
    public static final String LABEL_IS_XML_PARSER_VALIDATING = "PreferenceDialog.label.is.xml.parser.validating";
    public static final String LABEL_HOST = "PreferenceDialog.label.host";
    public static final String LABEL_PORT = "PreferenceDialog.label.port";
    public static final String LABEL_OK = "PreferenceDialog.label.ok";
    public static final String LABEL_CANCEL = "PreferenceDialog.label.cancel";
    public static final String TITLE_BEHAVIOR = "PreferenceDialog.title.behavior";
    public static final String TITLE_NETWORK = "PreferenceDialog.title.network";
    public static final String TITLE_DIALOG = "PreferenceDialog.title.dialog";
    public static final String CONFIG_HOST_TEXT_FIELD_LENGTH = "PreferenceDialog.config.host.text.field.length";
    public static final String CONFIG_PORT_TEXT_FIELD_LENGTH = "PreferenceDialog.config.port.text.field.length";
    public static final String CONFIG_OK_MNEMONIC = "PreferenceDialog.config.ok.mnemonic";
    public static final String CONFIG_CANCEL_MNEMONIC = "PreferenceDialog.config.cancel.mnemonic";
    public static final String PREFERENCE_KEY_LANGUAGES = "preference.key.languages";
    public static final String PREFERENCE_KEY_IS_XML_PARSER_VALIDATING = "preference.key.is.xml.parser.validating";
    public static final String PREFERENCE_KEY_USER_STYLESHEET = "preference.key.user.stylesheet";
    public static final String PREFERENCE_KEY_SHOW_RENDERING = "preference.key.show.rendering";
    public static final String PREFERENCE_KEY_AUTO_ADJUST_WINDOW = "preference.key.auto.adjust.window";
    public static final String PREFERENCE_KEY_ENABLE_DOUBLE_BUFFERING = "preference.key.enable.double.buffering";
    public static final String PREFERENCE_KEY_SHOW_DEBUG_TRACE = "preference.key.show.debug.trace";
    public static final String PREFERENCE_KEY_SELECTION_XOR_MODE = "preference.key.selection.xor.mode";
    public static final String PREFERENCE_KEY_PROXY_HOST = "preference.key.proxy.host";
    public static final String PREFERENCE_KEY_CSS_MEDIA = "preference.key.cssmedia";
    public static final String PREFERENCE_KEY_PROXY_PORT = "preference.key.proxy.port";
    protected PreferenceManager model;
    protected ConfigurationPanelSelector configPanelSelector;
    protected LanguageDialog.Panel languagePanel;
    protected UserStyleDialog.Panel userStylesheetPanel;
    protected JCheckBox showRendering;
    protected JCheckBox autoAdjustWindow;
    protected JCheckBox showDebugTrace;
    protected JCheckBox enableDoubleBuffering;
    protected JCheckBox selectionXorMode;
    protected JCheckBox isXMLParserValidating;
    protected JTextField host;
    protected JTextField port;
    protected CSSMediaPanel cssMediaPanel;
    protected int returnCode;

    public PreferenceDialog(PreferenceManager preferenceManager) {
        super((Frame)null, true);
        if (preferenceManager == null) {
            throw new IllegalArgumentException();
        }
        this.model = preferenceManager;
        this.buildGUI();
        this.initializeGUI();
        this.pack();
    }

    public PreferenceManager getPreferenceManager() {
        return this.model;
    }

    protected void initializeGUI() {
        String string = this.model.getString(PREFERENCE_KEY_LANGUAGES);
        this.languagePanel.setLanguages(string);
        String string2 = this.model.getString(PREFERENCE_KEY_USER_STYLESHEET);
        this.userStylesheetPanel.setPath(string2);
        this.showRendering.setSelected(this.model.getBoolean(PREFERENCE_KEY_SHOW_RENDERING));
        this.autoAdjustWindow.setSelected(this.model.getBoolean(PREFERENCE_KEY_AUTO_ADJUST_WINDOW));
        this.enableDoubleBuffering.setSelected(this.model.getBoolean(PREFERENCE_KEY_ENABLE_DOUBLE_BUFFERING));
        this.showDebugTrace.setSelected(this.model.getBoolean(PREFERENCE_KEY_SHOW_DEBUG_TRACE));
        this.selectionXorMode.setSelected(this.model.getBoolean(PREFERENCE_KEY_SELECTION_XOR_MODE));
        this.isXMLParserValidating.setSelected(this.model.getBoolean(PREFERENCE_KEY_IS_XML_PARSER_VALIDATING));
        this.showRendering.setEnabled(!this.model.getBoolean(PREFERENCE_KEY_ENABLE_DOUBLE_BUFFERING));
        this.host.setText(this.model.getString(PREFERENCE_KEY_PROXY_HOST));
        this.port.setText(this.model.getString(PREFERENCE_KEY_PROXY_PORT));
        this.cssMediaPanel.setMedia(this.model.getString(PREFERENCE_KEY_CSS_MEDIA));
        this.setTitle(Resources.getString(TITLE_DIALOG));
    }

    protected void savePreferences() {
        this.model.setString(PREFERENCE_KEY_LANGUAGES, this.languagePanel.getLanguages());
        this.model.setString(PREFERENCE_KEY_USER_STYLESHEET, this.userStylesheetPanel.getPath());
        this.model.setBoolean(PREFERENCE_KEY_SHOW_RENDERING, this.showRendering.isSelected());
        this.model.setBoolean(PREFERENCE_KEY_AUTO_ADJUST_WINDOW, this.autoAdjustWindow.isSelected());
        this.model.setBoolean(PREFERENCE_KEY_ENABLE_DOUBLE_BUFFERING, this.enableDoubleBuffering.isSelected());
        this.model.setBoolean(PREFERENCE_KEY_SHOW_DEBUG_TRACE, this.showDebugTrace.isSelected());
        this.model.setBoolean(PREFERENCE_KEY_SELECTION_XOR_MODE, this.selectionXorMode.isSelected());
        this.model.setBoolean(PREFERENCE_KEY_IS_XML_PARSER_VALIDATING, this.isXMLParserValidating.isSelected());
        this.model.setString(PREFERENCE_KEY_PROXY_HOST, this.host.getText());
        this.model.setString(PREFERENCE_KEY_PROXY_PORT, this.port.getText());
        this.model.setString(PREFERENCE_KEY_CSS_MEDIA, this.cssMediaPanel.getMediaAsString());
    }

    protected void buildGUI() {
        JPanel jPanel = new JPanel(new BorderLayout());
        Component component = this.buildConfigPanel();
        Component component2 = this.buildConfigPanelList();
        jPanel.add(component2, "West");
        jPanel.add(component, "Center");
        jPanel.add((Component)this.buildButtonsPanel(), "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 0, 0));
        this.getContentPane().add(jPanel);
    }

    protected JPanel buildButtonsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton(Resources.getString(LABEL_OK));
        jButton.setMnemonic(Resources.getCharacter(CONFIG_OK_MNEMONIC));
        JButton jButton2 = new JButton(Resources.getString(LABEL_CANCEL));
        jButton2.setMnemonic(Resources.getCharacter(CONFIG_CANCEL_MNEMONIC));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)PreferenceDialog.this).setVisible(false);
                PreferenceDialog.this.returnCode = 0;
                PreferenceDialog.this.savePreferences();
                PreferenceDialog.this.dispose();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)PreferenceDialog.this).setVisible(false);
                PreferenceDialog.this.returnCode = 1;
                PreferenceDialog.this.dispose();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    ((Component)PreferenceDialog.this).setVisible(false);
                    PreferenceDialog.this.returnCode = 1;
                    PreferenceDialog.this.dispose();
                }
            }
        });
        return jPanel;
    }

    protected Component buildConfigPanelList() {
        String[] stringArray = new String[]{Resources.getString(LABEL_NETWORK), Resources.getString(LABEL_USER_LANGUAGE), Resources.getString(LABEL_BEHAVIOR), Resources.getString(LABEL_USER_STYLESHEET)};
        final JList<String> jList = new JList<String>(stringArray);
        jList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    PreferenceDialog.this.configPanelSelector.select(jList.getSelectedValue().toString());
                }
            }
        });
        jList.setVisibleRowCount(4);
        ClassLoader classLoader = this.getClass().getClassLoader();
        Hashtable<String, ImageIcon> hashtable = new Hashtable<String, ImageIcon>();
        hashtable.put(Resources.getString(LABEL_USER_LANGUAGE), new ImageIcon(classLoader.getResource(Resources.getString(ICON_USER_LANGUAGE))));
        hashtable.put(Resources.getString(LABEL_USER_STYLESHEET), new ImageIcon(classLoader.getResource(Resources.getString(ICON_USER_STYLESHEET))));
        hashtable.put(Resources.getString(LABEL_BEHAVIOR), new ImageIcon(classLoader.getResource(Resources.getString(ICON_BEHAVIOR))));
        hashtable.put(Resources.getString(LABEL_NETWORK), new ImageIcon(classLoader.getResource(Resources.getString(ICON_NETWORK))));
        jList.setCellRenderer(new IconCellRenderer(hashtable));
        jList.setSelectedIndex(0);
        return new JScrollPane(jList);
    }

    protected Component buildConfigPanel() {
        JPanel jPanel = new JPanel();
        CardLayout cardLayout = new CardLayout();
        jPanel.setLayout(cardLayout);
        jPanel.add(this.buildUserLanguage(), Resources.getString(LABEL_USER_LANGUAGE));
        jPanel.add(this.buildUserStyleSheet(), Resources.getString(LABEL_USER_STYLESHEET));
        jPanel.add(this.buildBehavior(), Resources.getString(LABEL_BEHAVIOR));
        jPanel.add(this.buildNetwork(), Resources.getString(LABEL_NETWORK));
        jPanel.add(this.buildApplications(), Resources.getString(LABEL_APPLICATIONS));
        this.configPanelSelector = new ConfigurationPanelSelector(jPanel, cardLayout);
        return jPanel;
    }

    protected Component buildUserOptions() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add(this.buildUserLanguage(), Resources.getString(LABEL_USER_LANGUAGE));
        jTabbedPane.add(this.buildUserStyleSheet(), Resources.getString(LABEL_USER_STYLESHEET));
        jTabbedPane.add(this.buildUserFont(), Resources.getString(LABEL_USER_FONT));
        return jTabbedPane;
    }

    protected Component buildUserLanguage() {
        this.languagePanel = new LanguageDialog.Panel();
        return this.languagePanel;
    }

    protected Component buildUserStyleSheet() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.userStylesheetPanel = new UserStyleDialog.Panel();
        jPanel.add((Component)this.userStylesheetPanel, "North");
        this.cssMediaPanel = new CSSMediaPanel();
        jPanel.add((Component)this.cssMediaPanel, "South");
        return jPanel;
    }

    protected Component buildUserFont() {
        return new JButton("User Font");
    }

    protected Component buildBehavior() {
        JGridBagPanel jGridBagPanel = new JGridBagPanel();
        this.showRendering = new JCheckBox(Resources.getString(LABEL_SHOW_RENDERING));
        this.autoAdjustWindow = new JCheckBox(Resources.getString(LABEL_AUTO_ADJUST_WINDOW));
        this.enableDoubleBuffering = new JCheckBox(Resources.getString(LABEL_ENABLE_DOUBLE_BUFFERING));
        this.enableDoubleBuffering.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println("enableDoubleBuffering.actionPerformed");
                PreferenceDialog.this.showRendering.setEnabled(!PreferenceDialog.this.enableDoubleBuffering.isSelected());
            }
        });
        this.showDebugTrace = new JCheckBox(Resources.getString(LABEL_SHOW_DEBUG_TRACE));
        this.selectionXorMode = new JCheckBox(Resources.getString(LABEL_SELECTION_XOR_MODE));
        this.isXMLParserValidating = new JCheckBox(Resources.getString(LABEL_IS_XML_PARSER_VALIDATING));
        jGridBagPanel.add(this.showRendering, 0, 0, 1, 1, 17, 2, 1.0, 0.0);
        jGridBagPanel.add(this.autoAdjustWindow, 0, 1, 1, 1, 17, 2, 1.0, 0.0);
        jGridBagPanel.add(this.enableDoubleBuffering, 0, 2, 1, 1, 17, 2, 1.0, 0.0);
        jGridBagPanel.add(this.showDebugTrace, 0, 3, 1, 1, 17, 2, 1.0, 0.0);
        jGridBagPanel.add(this.selectionXorMode, 0, 4, 1, 1, 17, 2, 1.0, 0.0);
        jGridBagPanel.add(this.isXMLParserValidating, 0, 5, 1, 1, 17, 2, 1.0, 0.0);
        jGridBagPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Resources.getString(TITLE_BEHAVIOR)), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        return jGridBagPanel;
    }

    protected Component buildNetwork() {
        JGridBagPanel jGridBagPanel = new JGridBagPanel();
        this.host = new JTextField(Resources.getInteger(CONFIG_HOST_TEXT_FIELD_LENGTH));
        JLabel jLabel = new JLabel(Resources.getString(LABEL_HOST));
        this.port = new JTextField(Resources.getInteger(CONFIG_PORT_TEXT_FIELD_LENGTH));
        JLabel jLabel2 = new JLabel(Resources.getString(LABEL_PORT));
        jGridBagPanel.add(jLabel, 0, 0, 1, 1, 17, 2, 0.0, 0.0);
        jGridBagPanel.add(this.host, 0, 1, 1, 1, 10, 2, 1.0, 0.0);
        jGridBagPanel.add(jLabel2, 1, 0, 1, 1, 17, 2, 0.0, 0.0);
        jGridBagPanel.add(this.port, 1, 1, 1, 1, 10, 2, 0.0, 0.0);
        jGridBagPanel.add(new JLabel(""), 2, 1, 1, 1, 10, 2, 0.0, 0.0);
        jGridBagPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Resources.getString(TITLE_NETWORK)), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        return jGridBagPanel;
    }

    protected Component buildApplications() {
        return new JButton("Applications");
    }

    public int showDialog() {
        this.pack();
        this.show();
        return this.returnCode;
    }

    public static void main(String[] stringArray) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put(PREFERENCE_KEY_LANGUAGES, "fr");
        hashtable.put(PREFERENCE_KEY_SHOW_RENDERING, Boolean.TRUE);
        hashtable.put(PREFERENCE_KEY_SELECTION_XOR_MODE, Boolean.FALSE);
        hashtable.put(PREFERENCE_KEY_IS_XML_PARSER_VALIDATING, Boolean.FALSE);
        hashtable.put(PREFERENCE_KEY_AUTO_ADJUST_WINDOW, Boolean.TRUE);
        hashtable.put(PREFERENCE_KEY_ENABLE_DOUBLE_BUFFERING, Boolean.TRUE);
        hashtable.put(PREFERENCE_KEY_SHOW_DEBUG_TRACE, Boolean.TRUE);
        hashtable.put(PREFERENCE_KEY_PROXY_HOST, "webcache.eng.sun.com");
        hashtable.put(PREFERENCE_KEY_PROXY_PORT, "8080");
        XMLPreferenceManager xMLPreferenceManager = new XMLPreferenceManager(stringArray[0], hashtable);
        PreferenceDialog preferenceDialog = new PreferenceDialog(xMLPreferenceManager);
        int n = preferenceDialog.showDialog();
        if (n == 0) {
            try {
                xMLPreferenceManager.save();
                System.out.println("Done Saving options");
                System.exit(0);
            }
            catch (Exception exception) {
                System.err.println("Could not save options");
                exception.printStackTrace();
            }
        }
    }
}

