/*
 * Decompiled with CFR 0.152.
 */
package player;

import com.apple.eawt.CocoaComponent;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import player.JavaQTMoviePlayerCreatedListener;
import player.NoCocoaPlayerException;

public class JavaQTMoviePlayer
extends CocoaComponent
implements HierarchyListener,
ComponentListener {
    private JavaQTMoviePlayerCreatedListener isCreatedListener;
    private long cocoaId;
    private boolean isListener;
    private ArrayList listeners;
    private boolean playing;
    private boolean isInitialized;
    private String filePath;
    private long initTime;
    private float initRate;
    private float initVolume;
    private long initOffset;
    private int screenHeight = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
    private ArrayList drawingElementList;
    private static int drawingElementId = 0;
    static final int CREATE = 0;
    static final int START = 1;
    static final int STOP = 2;
    static final int FORWARD = 3;
    static final int BACKWARD = 4;
    static final int PLAY_SELECTION = 5;
    static final int SET_MEDIA_TIME = 6;
    static final int SET_RATE = 7;
    static final int SET_VOLUME = 8;
    static final int SET_SCREEN_XY = 9;
    static final int SET_DRAWING_VISIBLE = 10;
    static final int SET_DRAWING_PERIOD = 11;
    static final int ADD_DRAWING_ELEMENT = 12;
    static final int ADD_DRAWING_ELEMENT_LIST = 13;
    static final int REMOVE_DRAWING_ELEMENTS = 14;
    static final int ORGANIZE_DRAWING_ELEMENTS = 15;
    static final int SET_OFFSET = 16;
    static final int CREATE_DRAWING_VIEW = 17;
    static final int CLEAN_UP = 99;
    static final int LINE = 0;
    static final int RECT = 1;
    static final int ELLIPSE = 2;
    static final int STRING = 3;
    static final Dimension MIN_SIZE;
    static final Dimension PREF_SIZE;
    static final Dimension MAX_SIZE;

    public native long createNSViewLongNative();

    public native long createMovie(String var1);

    private native boolean isMovieCreated(long var1);

    private native boolean isMovieValid(long var1);

    private native boolean hasVideo(long var1);

    private native boolean isPlaying(long var1);

    private native long getFrameDuration(long var1);

    private native long getMediaDuration(long var1);

    private native long getMediaTime(long var1);

    private native float getRate(long var1);

    private native float getVolume(long var1);

    private native float getNaturalWidth(long var1);

    private native float getNaturalHeight(long var1);

    private native byte[] getFrameImage(long var1, long var3, int var5, int var6);

    private native boolean isFileSupported(String var1);

    public JavaQTMoviePlayer(String filePath, JavaQTMoviePlayerCreatedListener listener) throws NoCocoaPlayerException {
        this.filePath = filePath;
        if (!this.isFileSupported(this.filePath)) {
            throw new NoCocoaPlayerException("Cannot create a player: invalid file or file type");
        }
        this.isCreatedListener = listener;
        this.listeners = new ArrayList();
        this.drawingElementList = new ArrayList();
        this.addHierarchyListener(this);
        this.addComponentListener(this);
    }

    public JavaQTMoviePlayer(String filePath, long time, float rate, float volume, JavaQTMoviePlayerCreatedListener listener) throws NoCocoaPlayerException {
        this.filePath = filePath;
        if (!this.isFileSupported(this.filePath)) {
            throw new NoCocoaPlayerException("Cannot create a player: invalid file or file type");
        }
        this.initTime = time;
        this.initRate = rate;
        this.initVolume = volume;
        this.initOffset = 0L;
        this.isCreatedListener = listener;
        this.listeners = new ArrayList();
        this.drawingElementList = new ArrayList();
        this.addHierarchyListener(this);
        this.addComponentListener(this);
    }

    public void hierarchyChanged(HierarchyEvent e) {
        if (!this.isInitialized && (e.getChangeFlags() & 1L) > 0L && this.isInFrameOrWindow(e.getChangedParent())) {
            this.createQTMovie(this.filePath);
            try {
                while (!this.isMovieCreated(this.cocoaId)) {
                    Thread.sleep(100L);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.isInitialized = true;
            if (this.initTime != 0L || this.initRate != 0.0f || this.initVolume != 0.0f || this.initOffset != 0L) {
                this.setVolume(this.initVolume);
                this.setRate(this.initRate);
                this.setMediaTime(this.initTime);
                this.setOffset(this.initOffset);
            }
            if (this.isCreatedListener != null) {
                this.isCreatedListener.playerCreated(this);
            }
        }
    }

    private boolean isInFrameOrWindow(Container c) {
        do {
            if (!(c instanceof Frame) && !(c instanceof Window)) continue;
            c.setVisible(true);
            c.addComponentListener(this);
            return true;
        } while ((c = c.getParent()) != null);
        return false;
    }

    public long createNSViewLong() {
        this.cocoaId = this.createNSViewLongNative();
        return this.cocoaId;
    }

    public boolean isMovieCreated() {
        if (this.cocoaId == 0L) {
            return false;
        }
        return this.isMovieCreated(this.cocoaId);
    }

    public boolean isMovieValid() {
        if (this.cocoaId == 0L) {
            return false;
        }
        return this.isMovieValid(this.cocoaId);
    }

    public boolean hasVideo() {
        if (this.cocoaId == 0L) {
            return false;
        }
        return this.hasVideo(this.cocoaId);
    }

    public boolean isPlaying() {
        if (this.cocoaId == 0L) {
            return false;
        }
        return this.isPlaying(this.cocoaId);
    }

    public long getFrameDuration() {
        if (this.cocoaId == 0L) {
            return 0L;
        }
        return this.getFrameDuration(this.cocoaId);
    }

    public long getMediaDuration() {
        if (this.cocoaId == 0L) {
            return 0L;
        }
        return this.getMediaDuration(this.cocoaId);
    }

    public long getMediaTime() {
        if (this.cocoaId == 0L) {
            return 0L;
        }
        return this.getMediaTime(this.cocoaId);
    }

    public float getRate() {
        if (this.cocoaId == 0L) {
            return 0.0f;
        }
        return this.getRate(this.cocoaId);
    }

    public float getVolume() {
        if (this.cocoaId == 0L) {
            return 0.0f;
        }
        return this.getVolume(this.cocoaId);
    }

    public float getNaturalWidth() {
        if (this.cocoaId == 0L) {
            return 0.0f;
        }
        return this.getNaturalWidth(this.cocoaId);
    }

    public float getNaturalHeight() {
        if (this.cocoaId == 0L) {
            return 0.0f;
        }
        return this.getNaturalHeight(this.cocoaId);
    }

    public void addListener(JavaQTMoviePlayer player) {
        player.setListener(true);
        player.setVolume(0.0f);
        if (!this.listeners.contains(player)) {
            this.listeners.add(player);
        }
    }

    public void removeListener(JavaQTMoviePlayer player) {
        player.setListener(false);
        player.setVolume(this.getVolume(this.cocoaId));
        this.listeners.remove(player);
    }

    public void removeAllListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            JavaQTMoviePlayer player = (JavaQTMoviePlayer)this.listeners.get(i);
            player.setListener(false);
            player.setVolume(this.getVolume(this.cocoaId));
        }
        this.listeners.clear();
    }

    private void setListener(boolean isListener) {
        this.isListener = isListener;
    }

    public long getId() {
        return this.cocoaId;
    }

    private void createQTMovie(String path) {
        this.sendMessage(0, path);
    }

    public void start() {
        if (this.isListener || this.cocoaId == 0L) {
            return;
        }
        long[] players = new long[this.listeners.size() + 2];
        players[0] = this.getMediaTime(this.cocoaId);
        players[1] = this.cocoaId;
        for (int i = 0; i < this.listeners.size(); ++i) {
            players[i + 2] = ((JavaQTMoviePlayer)this.listeners.get(i)).getId();
        }
        this.sendMessage(1, players);
        this.playing = true;
    }

    public void stop() {
        if (this.isListener || this.cocoaId == 0L) {
            return;
        }
        long[] players = new long[this.listeners.size() + 1];
        players[0] = this.cocoaId;
        for (int i = 0; i < this.listeners.size(); ++i) {
            players[i + 1] = ((JavaQTMoviePlayer)this.listeners.get(i)).getId();
        }
        this.sendMessage(2, players);
        this.playing = false;
    }

    public void playInterval(long startTime, long stopTime) {
        if (this.isListener || this.cocoaId == 0L) {
            return;
        }
        long[] players = new long[this.listeners.size() + 3];
        players[0] = startTime;
        players[1] = stopTime;
        players[2] = this.cocoaId;
        for (int i = 0; i < this.listeners.size(); ++i) {
            players[i + 3] = ((JavaQTMoviePlayer)this.listeners.get(i)).getId();
        }
        this.sendMessage(5, players);
    }

    public void nextFrame() {
        if (this.isListener || this.cocoaId == 0L) {
            return;
        }
        long[] players = new long[this.listeners.size() + 1];
        players[0] = this.cocoaId;
        for (int i = 0; i < this.listeners.size(); ++i) {
            players[i + 1] = ((JavaQTMoviePlayer)this.listeners.get(i)).getId();
        }
        this.sendMessage(3, players);
    }

    public void previousFrame() {
        if (this.isListener || this.cocoaId == 0L) {
            return;
        }
        long[] players = new long[this.listeners.size() + 1];
        players[0] = this.cocoaId;
        for (int i = 0; i < this.listeners.size(); ++i) {
            players[i + 1] = ((JavaQTMoviePlayer)this.listeners.get(i)).getId();
        }
        this.sendMessage(4, players);
    }

    public void setMediaTime(long time) {
        if (this.isListener || this.cocoaId == 0L) {
            return;
        }
        long[] players = new long[this.listeners.size() + 2];
        players[0] = time;
        players[1] = this.cocoaId;
        for (int i = 0; i < this.listeners.size(); ++i) {
            players[i + 2] = ((JavaQTMoviePlayer)this.listeners.get(i)).getId();
        }
        if (this.isInitialized) {
            if (this.isListener) {
                return;
            }
            this.sendMessage(6, players);
        } else {
            this.initTime = time;
        }
    }

    public void setRate(float rate) {
        if (this.isListener || this.cocoaId == 0L) {
            return;
        }
        long[] players = new long[this.listeners.size() + 2];
        players[0] = (long)(100000.0f / rate);
        players[1] = this.cocoaId;
        for (int i = 0; i < this.listeners.size(); ++i) {
            players[i + 2] = ((JavaQTMoviePlayer)this.listeners.get(i)).getId();
        }
        if (this.isInitialized) {
            if (this.isListener) {
                return;
            }
            this.sendMessage(7, players);
        } else {
            this.initRate = rate;
        }
    }

    public void setVolume(float volume) {
        if (this.cocoaId == 0L) {
            return;
        }
        if (this.isInitialized) {
            float[] parameters = new float[]{volume};
            this.sendMessage(8, parameters);
        } else {
            this.initVolume = volume;
        }
    }

    public void setOffset(long offset) {
        if (this.cocoaId == 0L) {
            return;
        }
        if (this.isInitialized) {
            long[] parameters = new long[]{offset};
            this.sendMessage(16, parameters);
        } else {
            this.initOffset = offset;
        }
    }

    public byte[] getFrame(long time, int width, int height) {
        if (this.cocoaId == 0L || this.playing) {
            return null;
        }
        if (this.isPlaying(this.cocoaId)) {
            return null;
        }
        return this.getFrameImage(this.cocoaId, time, width, height);
    }

    public void cleanUpOnClose() {
        if (this.cocoaId == 0L) {
            return;
        }
        this.cocoaId = 0L;
        this.sendMessage(99, null);
    }

    public void createDrawingView() {
        this.sendMessage(17, null);
    }

    public void setDrawingVisible(boolean isVisible) {
        boolean[] parameters = new boolean[]{isVisible};
        this.sendMessage(10, parameters);
    }

    public void setDrawingPeriod(long period) {
        long[] parameters = new long[]{period};
        this.sendMessage(11, parameters);
    }

    public void removeElement(int id) {
        String elementString = "ID " + id;
        this.sendMessage(14, elementString);
    }

    public void removeAllElements() {
        String elementString = "ALL";
        this.sendMessage(14, elementString);
    }

    public void removeAllElementsBetween(long beginTime, long endTime) {
        String elementString = "INTERVAL " + beginTime + " " + endTime;
        this.sendMessage(14, elementString);
    }

    public long addLine(long beginTime, long endTime, float x, float y, float x2, float y2, int red, int green, int blue, float alpha, float lineWidth) {
        if (this.cocoaId == 0L) {
            return -1L;
        }
        String elementString = this.makeLineString(beginTime, endTime, x, y, x2, y2, red, green, blue, alpha, lineWidth);
        if (elementString != null) {
            int id = drawingElementId++;
            elementString = id + " " + elementString;
            this.sendMessage(12, elementString);
            return id;
        }
        return -1L;
    }

    public long addRectangle(long beginTime, long endTime, float x, float y, float width, float height, int red, int green, int blue, float alpha, float lineWidth, boolean filled) {
        if (this.cocoaId == 0L) {
            return -1L;
        }
        String elementString = this.makeRectangleString(beginTime, endTime, x, y, width, height, red, green, blue, alpha, lineWidth, filled);
        if (elementString != null) {
            int id = drawingElementId++;
            elementString = id + " " + elementString;
            this.sendMessage(12, elementString);
            return id;
        }
        return -1L;
    }

    public long addEllipse(long beginTime, long endTime, float cx, float cy, float rx, float ry, int red, int green, int blue, float alpha, float lineWidth, boolean filled) {
        if (this.cocoaId == 0L) {
            return -1L;
        }
        String elementString = this.makeEllipseString(beginTime, endTime, cx, cy, rx, ry, red, green, blue, alpha, lineWidth, filled);
        if (elementString != null) {
            int id = drawingElementId++;
            elementString = id + " " + elementString;
            this.sendMessage(12, elementString);
            return id;
        }
        return -1L;
    }

    public long addString(String text, long beginTime, long endTime, float x, float y, int red, int green, int blue, float alpha, String fontName, int fontSize) {
        if (this.cocoaId == 0L) {
            return -1L;
        }
        String elementString = this.makeStringString(text, beginTime, endTime, x, y, red, green, blue, alpha, fontName, fontSize);
        if (elementString != null) {
            int id = drawingElementId++;
            elementString = id + " " + elementString;
            this.sendMessage(12, elementString);
            return id;
        }
        return -1L;
    }

    public void clearDrawingElementList() {
        this.drawingElementList.clear();
    }

    public void sendDrawingElementList() {
        Object[] elements = this.drawingElementList.toArray();
        this.sendMessage(13, elements);
    }

    public long addLineToDrawingElementList(long beginTime, long endTime, float x, float y, float x2, float y2, int red, int green, int blue, float alpha, float lineWidth) {
        if (this.cocoaId == 0L) {
            return -1L;
        }
        String elementString = this.makeLineString(beginTime, endTime, x, y, x2, y2, red, green, blue, alpha, lineWidth);
        if (elementString != null) {
            int id = drawingElementId++;
            elementString = id + " " + elementString;
            this.drawingElementList.add(elementString);
            return id;
        }
        return -1L;
    }

    public long addRectangleToDrawingElementList(long beginTime, long endTime, float x, float y, float width, float height, int red, int green, int blue, float alpha, float lineWidth, boolean filled) {
        if (this.cocoaId == 0L) {
            return -1L;
        }
        String elementString = this.makeRectangleString(beginTime, endTime, x, y, width, height, red, green, blue, alpha, lineWidth, filled);
        if (elementString != null) {
            int id = drawingElementId++;
            elementString = id + " " + elementString;
            this.drawingElementList.add(elementString);
            return id;
        }
        return -1L;
    }

    public long addEllipseToDrawingElementList(long beginTime, long endTime, float cx, float cy, float rx, float ry, int red, int green, int blue, float alpha, float lineWidth, boolean filled) {
        if (this.cocoaId == 0L) {
            return -1L;
        }
        String elementString = this.makeEllipseString(beginTime, endTime, cx, cy, rx, ry, red, green, blue, alpha, lineWidth, filled);
        if (elementString != null) {
            int id = drawingElementId++;
            elementString = id + " " + elementString;
            this.drawingElementList.add(elementString);
            return id;
        }
        return -1L;
    }

    public long addStringToDrawingElementList(String text, long beginTime, long endTime, float x, float y, int red, int green, int blue, float alpha, String fontName, int fontSize) {
        if (this.cocoaId == 0L) {
            return -1L;
        }
        String elementString = this.makeStringString(text, beginTime, endTime, x, y, red, green, blue, alpha, fontName, fontSize);
        if (elementString != null) {
            int id = drawingElementId++;
            elementString = id + " " + elementString;
            this.drawingElementList.add(elementString);
            return id;
        }
        return -1L;
    }

    private String makeLineString(long beginTime, long endTime, float x, float y, float x2, float y2, int red, int green, int blue, float alpha, float lineWidth) {
        String elementString = "0";
        if (beginTime < 0L) {
            return null;
        }
        elementString = elementString + " " + beginTime;
        if (endTime < 0L) {
            return null;
        }
        elementString = elementString + " " + endTime;
        if (!(x >= 0.0f) || !(x <= 1.0f)) {
            return null;
        }
        elementString = elementString + " " + x;
        if (!(y >= 0.0f) || !(y <= 1.0f)) {
            return null;
        }
        elementString = elementString + " " + y;
        if (!(x2 >= 0.0f) || !(x2 <= 1.0f)) {
            return null;
        }
        elementString = elementString + " " + x2;
        if (!(y2 >= 0.0f) || !(y2 <= 1.0f)) {
            return null;
        }
        elementString = elementString + " " + y2;
        if (red < 0 || red > 255) {
            return null;
        }
        elementString = elementString + " " + red;
        if (green < 0 || green > 255) {
            return null;
        }
        elementString = elementString + " " + green;
        if (blue < 0 || blue > 255) {
            return null;
        }
        elementString = elementString + " " + blue;
        if (!(alpha >= 0.0f) || !(alpha <= 1.0f)) {
            return null;
        }
        elementString = elementString + " " + alpha;
        if (lineWidth > 0.0f) {
            elementString = elementString + " " + lineWidth;
        }
        return elementString;
    }

    private String makeRectangleString(long beginTime, long endTime, float x, float y, float width, float height, int red, int green, int blue, float alpha, float lineWidth, boolean filled) {
        String elementString = "1";
        if (beginTime < 0L) {
            return null;
        }
        elementString = elementString + " " + beginTime;
        if (endTime < 0L) {
            return null;
        }
        elementString = elementString + " " + endTime;
        if (!(x >= 0.0f) || !(x <= 1.0f)) {
            return null;
        }
        elementString = elementString + " " + x;
        if (!(y >= 0.0f) || !(y <= 1.0f)) {
            return null;
        }
        elementString = elementString + " " + y;
        if (!(width >= 0.0f) || !(width <= 1.0f)) {
            return null;
        }
        elementString = elementString + " " + width;
        if (!(height >= 0.0f) || !(height <= 1.0f)) {
            return null;
        }
        elementString = elementString + " " + height;
        if (red < 0 || red > 255) {
            return null;
        }
        elementString = elementString + " " + red;
        if (green < 0 || green > 255) {
            return null;
        }
        elementString = elementString + " " + green;
        if (blue < 0 || blue > 255) {
            return null;
        }
        elementString = elementString + " " + blue;
        if (!(alpha >= 0.0f) || !(alpha <= 1.0f)) {
            return null;
        }
        elementString = elementString + " " + alpha;
        if (lineWidth > 0.0f) {
            elementString = elementString + " " + lineWidth;
        }
        elementString = filled ? elementString + " 1" : elementString + " 0";
        return elementString;
    }

    private String makeEllipseString(long beginTime, long endTime, float cx, float cy, float rx, float ry, int red, int green, int blue, float alpha, float lineWidth, boolean filled) {
        String elementString = "2";
        if (beginTime < 0L) {
            return null;
        }
        elementString = elementString + " " + beginTime;
        if (endTime < 0L) {
            return null;
        }
        elementString = elementString + " " + endTime;
        if (!(cx >= 0.0f) || !(cx <= 1.0f)) {
            return null;
        }
        elementString = elementString + " " + cx;
        if (!(cy >= 0.0f) || !(cy <= 1.0f)) {
            return null;
        }
        elementString = elementString + " " + cy;
        if (!(rx >= 0.0f) || !(rx <= 1.0f)) {
            return null;
        }
        elementString = elementString + " " + rx;
        if (!(ry >= 0.0f) || !(ry <= 1.0f)) {
            return null;
        }
        elementString = elementString + " " + ry;
        if (red < 0 || red > 255) {
            return null;
        }
        elementString = elementString + " " + red;
        if (green < 0 || green > 255) {
            return null;
        }
        elementString = elementString + " " + green;
        if (blue < 0 || blue > 255) {
            return null;
        }
        elementString = elementString + " " + blue;
        if (!(alpha >= 0.0f) || !(alpha <= 1.0f)) {
            return null;
        }
        elementString = elementString + " " + alpha;
        if (lineWidth > 0.0f) {
            elementString = elementString + " " + lineWidth;
        }
        elementString = filled ? elementString + " 1" : elementString + " 0";
        return elementString;
    }

    private String makeStringString(String text, long beginTime, long endTime, float x, float y, int red, int green, int blue, float alpha, String fontName, int fontSize) {
        String delimiter = "AxQzyQRcD";
        String elementString = "3 " + delimiter + " " + delimiter + text;
        if (beginTime < 0L) {
            return null;
        }
        elementString = elementString + delimiter + beginTime;
        if (endTime < 0L) {
            return null;
        }
        elementString = elementString + delimiter + endTime;
        if (!(x >= 0.0f) || !(x <= 1.0f)) {
            return null;
        }
        elementString = elementString + delimiter + x;
        if (!(y >= 0.0f) || !(y <= 1.0f)) {
            return null;
        }
        elementString = elementString + delimiter + y;
        if (red < 0 || red > 255) {
            return null;
        }
        elementString = elementString + delimiter + red;
        if (green < 0 || green > 255) {
            return null;
        }
        elementString = elementString + delimiter + green;
        if (blue < 0 || blue > 255) {
            return null;
        }
        elementString = elementString + delimiter + blue;
        if (!(alpha >= 0.0f) || !(alpha <= 1.0f)) {
            return null;
        }
        elementString = elementString + delimiter + alpha;
        elementString = fontName != null ? elementString + delimiter + fontName : elementString + delimiter + "Monaco";
        if (fontSize <= 0) {
            return null;
        }
        elementString = elementString + delimiter + fontSize;
        return elementString;
    }

    public void organizeDrawingElements() {
        this.sendMessage(15, null);
    }

    public void componentMoved(ComponentEvent e) {
        if (this.cocoaId == 0L) {
            return;
        }
        if (this.isShowing()) {
            this.setFrameXY((int)this.getLocationOnScreen().getX(), this.screenHeight - this.getHeight() - (int)this.getLocationOnScreen().getY());
        }
    }

    public void componentResized(ComponentEvent e) {
        if (this.cocoaId == 0L) {
            return;
        }
        if (this.isShowing()) {
            this.setFrameXY((int)this.getLocationOnScreen().getX(), this.screenHeight - this.getHeight() - (int)this.getLocationOnScreen().getY());
        }
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    private void setFrameXY(int x, int y) {
        long[] parameters = new long[]{x, y};
        this.sendMessage(9, parameters);
    }

    public Dimension getPreferredSize() {
        return PREF_SIZE;
    }

    public Dimension getMinimumSize() {
        return MIN_SIZE;
    }

    public Dimension getMaximumSize() {
        return MAX_SIZE;
    }

    public int createNSView() {
        return (int)this.createNSViewLong();
    }

    static {
        System.loadLibrary("JavaQTMovieView");
        MIN_SIZE = new Dimension(200, 200);
        PREF_SIZE = new Dimension(400, 400);
        MAX_SIZE = new Dimension(600, 600);
    }
}

