/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexus.wsclient.extension;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import mpi.eudico.server.corpora.lexicon.LexiconIdentification;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexusResourceListParser {
    private XMLReader reader;
    private ArrayList<LexiconIdentification> lexica;

    public LexusResourceListParser() {
        try {
            this.reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            this.reader.setFeature("http://xml.org/sax/features/namespaces", true);
            this.reader.setFeature("http://xml.org/sax/features/validation", true);
            this.reader.setFeature("http://apache.org/xml/features/validation/schema", true);
            this.reader.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            this.reader.setContentHandler(new LexusResourcesContentHandler());
            this.reader.setErrorHandler(new LexusResourcesErrorHandler());
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
    }

    public ArrayList<LexiconIdentification> getLexica(String webServiceResponse) {
        this.lexica = new ArrayList();
        this.parse(webServiceResponse);
        return this.lexica;
    }

    private void parse(String webServiceResponse) {
        try {
            this.reader.parse(new InputSource(new StringReader(webServiceResponse)));
        }
        catch (SAXException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    class LexusResourcesErrorHandler
    implements ErrorHandler {
        LexusResourcesErrorHandler() {
        }

        public void error(SAXParseException exception) throws SAXException {
            System.out.println("Error: " + exception.getMessage());
            System.out.println("System id " + exception.getSystemId());
            System.out.println("Public id " + exception.getPublicId());
            System.out.println("Line: " + exception.getLineNumber());
            System.out.println("Column: " + exception.getColumnNumber());
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            System.out.println("FatalError: " + exception.getMessage());
        }

        public void warning(SAXParseException exception) throws SAXException {
            System.out.println("Warning: " + exception.getMessage());
        }
    }

    class LexusResourcesContentHandler
    implements ContentHandler {
        LexiconIdentification currentLexicon;
        String content = "";

        LexusResourcesContentHandler() {
        }

        public void characters(char[] ch, int start, int end) throws SAXException {
            this.content = this.content + new String(ch, start, end);
        }

        public void endDocument() throws SAXException {
        }

        public void endElement(String nameSpaceURI, String name, String rawName) throws SAXException {
            if (name.equals("name")) {
                this.currentLexicon.setName(this.content);
            } else if (name.equals("description")) {
                this.currentLexicon.setDescription(this.content);
            } else if (name.equals("lexicon")) {
                LexusResourceListParser.this.lexica.add(this.currentLexicon);
                this.currentLexicon = null;
            }
        }

        public void endPrefixMapping(String arg0) throws SAXException {
        }

        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        }

        public void processingInstruction(String arg0, String arg1) throws SAXException {
        }

        public void setDocumentLocator(Locator arg0) {
        }

        public void skippedEntity(String arg0) throws SAXException {
        }

        public void startDocument() throws SAXException {
        }

        public void startElement(String nameSpaceURI, String name, String rawName, Attributes attributes) throws SAXException {
            this.content = "";
            if (name.equals("lexicon")) {
                String lexiconID = attributes.getValue("id");
                this.currentLexicon = new LexiconIdentification();
                this.currentLexicon.setId(lexiconID);
            }
        }

        public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        }
    }
}

