/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexus.wsclient.extension;

import java.io.IOException;
import java.io.StringReader;
import mpi.eudico.server.corpora.lexicon.EntryElement;
import mpi.eudico.server.corpora.lexicon.Lexicon;
import mpi.eudico.server.corpora.lexicon.LexiconEntry;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class LexusSearchResultsParser {
    private XMLReader reader;
    public String content;
    private Lexicon searchResponseLexicon;
    private final String LEX_ENTRY = "lexical-entry";
    private final String ID = "id";
    private final String NAME = "name";
    private final String VALUE = "value";
    private final String DATA = "data";
    private final String CONTAINER = "container";

    public LexusSearchResultsParser() {
        try {
            this.reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            this.reader.setContentHandler(new LSRContentHandler());
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
    }

    public Lexicon parseToLexicon(String searchResponse, String fieldOfFocus) {
        ((LSRContentHandler)this.reader.getContentHandler()).setFieldOfFocus(fieldOfFocus);
        this.searchResponseLexicon = new Lexicon();
        try {
            this.reader.parse(new InputSource(new StringReader(searchResponse)));
        }
        catch (SAXException e) {
            System.out.println("SAX error: " + e);
        }
        catch (IOException e) {
            System.out.println("IO error: " + e);
        }
        return this.searchResponseLexicon;
    }

    private class LSRContentHandler
    implements ContentHandler {
        private EntryElement currentElement;
        private EntryElement currentContainer;
        private LexiconEntry currentEntry;
        private String contentText = "";
        private String fieldOfFocus;

        private LSRContentHandler() {
        }

        public void setFieldOfFocus(String fieldOfFocus) {
            this.fieldOfFocus = fieldOfFocus;
        }

        public void characters(char[] ch, int start, int end) throws SAXException {
            this.contentText = this.contentText + new String(ch, start, end);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void startElement(String nameSpaceURI, String name, String rawName, Attributes attributes) throws SAXException {
            if (name.equals("lexical-entry")) {
                LexiconEntry entry = new LexiconEntry(name);
                String id = attributes.getValue("id");
                entry.setId(id);
                entry.setFieldOfFocus(this.fieldOfFocus);
                LexusSearchResultsParser.this.searchResponseLexicon.addEntry(entry);
                this.currentElement = entry;
                this.currentEntry = entry;
                this.currentContainer = entry;
            } else if (name.equals("data")) {
                EntryElement element = new EntryElement(attributes.getValue("name"), this.currentContainer);
                this.currentContainer.addElement(element);
                this.currentElement = element;
                if (!name.equals(this.fieldOfFocus)) {
                    // empty if block
                }
            } else if (name.equals("container")) {
                EntryElement element = new EntryElement(attributes.getValue("name"), this.currentContainer);
                this.currentContainer.addElement(element);
                this.currentContainer = element;
            }
            this.contentText = "";
        }

        public void endElement(String nameSpaceURI, String name, String rawName) throws SAXException {
            if (name.equals("lexical-entry")) {
                this.currentElement = null;
                this.currentEntry = null;
                this.currentContainer = null;
            } else if (name.equals("container")) {
                this.currentContainer = this.currentContainer.getParent();
            } else if (name.equals("data")) {
                if (this.currentElement.getName().equals(this.fieldOfFocus)) {
                    this.currentEntry.addFocusFieldValue(this.currentElement.getValue());
                }
            } else if (name.equals("value")) {
                this.currentElement.setValue(this.contentText.trim());
            }
            this.contentText = "";
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void endPrefixMapping(String arg0) throws SAXException {
        }

        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        }

        public void processingInstruction(String arg0, String arg1) throws SAXException {
        }

        public void setDocumentLocator(Locator arg0) {
        }

        public void skippedEntity(String arg0) throws SAXException {
        }

        public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        }
    }
}

