/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.recognizer.remote.clam;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JPanel;
import mpi.eudico.client.annotator.recognizer.api.Recognizer;
import mpi.eudico.client.annotator.recognizer.api.RecognizerHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClamRecognizer
implements Recognizer {
    protected RecognizerHost host;
    private String name = "CLAM remote recognizer";
    protected List<String> mediaPaths;
    private String baseUrl = "http://mpcserver.let.ru.nl/aamlr/";
    private String projectId = null;
    private String currentMediaFile = null;
    private String currentMediaName = null;
    private String outputFile = null;
    private Map<String, String> fileProjectMap = new HashMap<String, String>(5);
    private List<String> uploadedProjects = new ArrayList<String>(5);
    private float progress = 0.0f;
    private boolean isRunning = false;
    private boolean interrupted = false;
    private StringBuilder reportBuilder = null;
    private long startTime;

    public boolean canCombineMultipleFiles() {
        return false;
    }

    public boolean canHandleMedia(String mediaFilePath) {
        if (mediaFilePath == null) {
            return false;
        }
        String lower = mediaFilePath.toLowerCase();
        return lower.endsWith(".wav") || lower.endsWith(".wave");
    }

    public void dispose() {
    }

    public JPanel getControlPanel() {
        return null;
    }

    public int getExamplesSupport() {
        return 2;
    }

    public String getName() {
        return this.name;
    }

    public Object getParameterValue(String param) {
        return null;
    }

    public int getRecognizerType() {
        return 0;
    }

    public String getReport() {
        if (this.reportBuilder != null) {
            return this.reportBuilder.toString();
        }
        return null;
    }

    public boolean setMedia(List<String> mediaFilePaths) {
        this.mediaPaths = mediaFilePaths;
        if (mediaFilePaths != null && mediaFilePaths.size() >= 1) {
            int slashIndex;
            this.currentMediaFile = mediaFilePaths.get(0);
            if (this.currentMediaFile.startsWith("file:")) {
                this.currentMediaFile = this.currentMediaFile.substring(5);
            }
            if (this.currentMediaFile.startsWith("///")) {
                this.currentMediaFile = this.currentMediaFile.substring(2);
            }
            if ((slashIndex = this.currentMediaFile.lastIndexOf("/") + 1) > 0) {
                this.currentMediaName = this.currentMediaFile.substring(slashIndex);
            }
            this.projectId = null;
        }
        return true;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParameterValue(String param, String value) {
        if (param == null || param.length() == 0 || value == null || value.length() == 0) {
            return;
        }
        if (param.equals("xmloutput")) {
            this.outputFile = value;
        } else if (param.equals("base_url")) {
            this.baseUrl = value;
        }
    }

    public void setParameterValue(String param, float value) {
    }

    public void setRecognizerHost(RecognizerHost host) {
        this.host = host;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        if (this.isRunning) {
            return;
        }
        if (this.currentMediaFile == null) {
            this.host.errorOccurred("There is no audio file.");
            return;
        }
        this.interrupted = false;
        this.progress = 0.0f;
        if (this.reportBuilder != null) {
            this.reportBuilder.delete(0, this.reportBuilder.length());
        }
        this.reportBuilder = new StringBuilder();
        this.startTime = System.currentTimeMillis();
        SimpleDateFormat df = new SimpleDateFormat("d MMM yyyy HH:mm:ss");
        this.reportBuilder.append("Starting process at " + df.format(new Date(this.startTime)) + "\n");
        this.reportBuilder.append("Server url:\t" + this.baseUrl + "\n");
        this.reportBuilder.append("Media file:\t" + this.currentMediaFile + "\n");
        this.reportBuilder.append("Output file: \t" + this.outputFile + "\n");
        this.host.setProgress(this.progress, "Retrieving project ID");
        this.projectId = this.fileProjectMap.get(this.currentMediaFile);
        if (this.projectId == null) {
            this.host.setProgress(this.progress, "Creating project");
            this.reportBuilder.append("Creating a project...: ");
            this.projectId = this.createProjectID();
            if (this.projectId == null) {
                this.host.errorOccurred("Could not create project.");
                return;
            }
            this.fileProjectMap.put(this.currentMediaFile, this.projectId);
        } else {
            this.reportBuilder.append("A project exists: ");
        }
        this.reportBuilder.append(String.valueOf(this.projectId) + "\n");
        this.progress = 0.05f;
        this.host.setProgress(this.progress, "Project exists or is created");
        if (this.interrupted) {
            this.host.setProgress(this.progress, "Process canceled.");
            this.reportBuilder.append("The process has been canceled after: " + (System.currentTimeMillis() - this.startTime) / 1000L + " sec\n");
            return;
        }
        if (!this.uploadedProjects.contains(this.projectId)) {
            int uploadStatus = this.uploadFile();
            if (uploadStatus != 200) {
                this.host.errorOccurred("File upload failed.");
                this.reportBuilder.append("Unable to upload the wav file to the server: " + uploadStatus + "\n");
                return;
            }
            this.host.setProgress(this.progress, "File uploaded");
            this.uploadedProjects.add(this.projectId);
            this.reportBuilder.append("The file has been uploaded, uploading took: " + (System.currentTimeMillis() - this.startTime) / 1000L + " sec\n");
        } else {
            this.progress = 0.2f;
            this.host.setProgress(this.progress, "File already uploaded...");
            this.reportBuilder.append("The wave file is already available on the server\n");
        }
        if (this.interrupted) {
            this.host.setProgress(this.progress, "Process canceled.");
            this.reportBuilder.append("The process has been canceled after: " + (System.currentTimeMillis() - this.startTime) / 1000L + " sec\n");
            return;
        }
        URL url = null;
        try {
            url = new URL(String.valueOf(this.baseUrl) + this.projectId);
        }
        catch (MalformedURLException mue) {
            this.reportBuilder.append("Could not create a project url\n");
            this.host.errorOccurred("Could not create the project url.");
            return;
        }
        this.progress += 0.05f;
        long recStart = System.currentTimeMillis();
        this.reportBuilder.append("Starting the recognizer process...\n");
        int processStatus = this.startProject(url);
        if (processStatus != 202) {
            this.reportBuilder.append("Failed to start the recognizer process...\n");
            return;
        }
        this.progress += 0.05f;
        float remaining = 1.0f - this.progress - 0.1f;
        boolean procSucces = this.checkProgress(url, remaining);
        if (!procSucces) {
            this.host.errorOccurred("An error occurred during execution.");
            this.reportBuilder.append("Exiting after an error during execution...\n");
            return;
        }
        this.reportBuilder.append("Recognition process completed successfully, processing took: " + (System.currentTimeMillis() - recStart) / 1000L + " sec\n");
        this.host.setProgress(0.9f, "Fetching results");
        if (this.interrupted) {
            this.host.setProgress(this.progress, "Process canceled.");
            this.reportBuilder.append("The process has been canceled after: " + (System.currentTimeMillis() - this.startTime) / 1000L + " sec\n");
            return;
        }
        boolean contents = this.getResult();
        if (!contents) {
            this.reportBuilder.append("Unable to download the results from the server.\n");
            this.host.errorOccurred("Unable to get the results.");
            return;
        }
        this.reportBuilder.append("Results downloaded.\n");
        this.host.setProgress(0.95f, "Retrieved the results");
        this.reportBuilder.append("Process finished after: " + (System.currentTimeMillis() - this.startTime) / 1000L + " sec\n");
        this.host.setProgress(1.0f, "Process finished.");
    }

    public void stop() {
        this.interrupted = true;
    }

    public void updateLocale(Locale locale) {
    }

    protected String createProjectID() {
        String nextId = null;
        int respCode = 400;
        int retries = 0;
        do {
            try {
                nextId = "ELAN_" + String.valueOf(System.currentTimeMillis());
                URL url = new URL(String.valueOf(this.baseUrl) + nextId);
                respCode = this.invokeService(url, null, "PUT");
                if (respCode == 201) continue;
                this.reportBuilder.append("Unable to create a project: " + respCode + "\n");
            }
            catch (MalformedURLException mue) {
                this.reportBuilder.append("Unable to create a project: " + mue.getMessage() + "\n");
                nextId = null;
            }
        } while (respCode != 201 && ++retries < 10);
        return nextId;
    }

    private int invokeService(URL url, String query, String method) {
        if (url == null) {
            return 400;
        }
        try {
            HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
            httpConn.setDefaultUseCaches(false);
            httpConn.setRequestMethod(method != null ? method : "GET");
            httpConn.connect();
            return httpConn.getResponseCode();
        }
        catch (ProtocolException protocolException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 400;
    }

    private int startProject(URL url) {
        this.host.setProgress(this.progress, "Starting the recognizer process...");
        if (url == null) {
            this.reportBuilder.append("The service url is null.\n");
            return 400;
        }
        try {
            HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
            httpConn.setDefaultUseCaches(false);
            httpConn.setRequestMethod("POST");
            httpConn.connect();
            int startCode = httpConn.getResponseCode();
            if (startCode == 202) {
                return startCode;
            }
            this.reportBuilder.append("Unable to start the project: " + startCode + "\n");
            return startCode;
        }
        catch (ProtocolException pe) {
            this.reportBuilder.append("Unable to start the project: " + pe.getMessage() + "\n");
        }
        catch (IOException ioe) {
            this.reportBuilder.append("Unable to start the project: " + ioe.getMessage() + "\n");
        }
        return 400;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkProgress(URL url, float timeRemain) {
        if (url == null) {
            return false;
        }
        this.reportBuilder.append("Checking the progress of the recognizer process...\n");
        HttpURLConnection httpConn = null;
        int lastCompletion = 0;
        boolean error = false;
        String status = "<status";
        String completion = "completion=";
        String noError = "errors=\"no\"";
        while (true) {
            if (error) {
                this.reportBuilder.append("An unknown error occurred while checking the progress of the recognizer...\n");
                if (!error) return true;
                return false;
            }
            try {
                block15: {
                    httpConn = (HttpURLConnection)url.openConnection();
                    httpConn.setDefaultUseCaches(false);
                    httpConn.setRequestMethod("GET");
                    httpConn.connect();
                    int startCode = httpConn.getResponseCode();
                    if (startCode != 200) break block15;
                    BufferedReader procReader = new BufferedReader(new InputStreamReader(httpConn.getInputStream()));
                    String line = null;
                    while (true) {
                        int q2;
                        String com;
                        int q1;
                        block16: {
                            String message;
                            block19: {
                                block17: {
                                    String rest;
                                    block18: {
                                        if ((line = procReader.readLine()) == null) {
                                            try {
                                                Thread.sleep(1500L);
                                            }
                                            catch (InterruptedException interruptedException) {
                                                // empty catch block
                                            }
                                            break;
                                        }
                                        if (line.indexOf("<status") <= -1) continue;
                                        if (line.indexOf("errors=\"no\"") >= 0) break block16;
                                        error = true;
                                        message = "";
                                        String mesAttr = "errormsg";
                                        int mesIndex = line.indexOf("errormsg");
                                        if (mesIndex <= -1) break block17;
                                        rest = line.substring(mesIndex + "errormsg".length());
                                        int q12 = rest.indexOf("\"");
                                        if (q12 <= -1) break block18;
                                        int q22 = rest.indexOf("\"", q12 + 1);
                                        if (q22 > q12 + 1) {
                                            message = rest.substring(q12 + 1, q22);
                                            if (message.length() == 0) {
                                                message = "Unknown error occurred";
                                            }
                                            break block19;
                                        } else {
                                            message = rest.substring(q12);
                                        }
                                        break block19;
                                    }
                                    message = rest;
                                    break block19;
                                }
                                message = "Unknown error occurred";
                            }
                            this.host.setProgress(this.progress + timeRemain - (float)(100 - lastCompletion) * timeRemain, message);
                            return false;
                        }
                        int comIndex = line.indexOf("completion=");
                        if (comIndex <= -1 || (q1 = (com = line.substring(comIndex + "completion=".length())).indexOf("\"")) <= -1 || (q2 = com.indexOf("\"", q1 + 1)) <= q1 + 1) continue;
                        String perc = com.substring(q1 + 1, q2);
                        try {
                            int percInt = Integer.parseInt(perc);
                            if (percInt <= lastCompletion) continue;
                            lastCompletion = percInt;
                            this.host.setProgress(this.progress + timeRemain - (float)(100 - lastCompletion) * timeRemain);
                            if (lastCompletion != 100) continue;
                            this.reportBuilder.append("Recognizer process completed successfully...\n");
                            return true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                            continue;
                        }
                        break;
                    }
                }
                if (!this.interrupted) continue;
                this.reportBuilder.append("The process has been canceled, checking for progress has been stopped...\n");
                return false;
            }
            catch (ProtocolException pe) {
                this.reportBuilder.append("Could not contact the server: " + pe.getMessage() + "\n");
                error = true;
                continue;
            }
            catch (IOException ioe) {
                this.reportBuilder.append("Could not contact the server: " + ioe.getMessage() + "\n");
                error = true;
                continue;
            }
            break;
        }
    }

    private boolean getResult() {
        block16: {
            BufferedWriter bufWriter;
            BufferedReader procReader;
            block17: {
                URL url = null;
                try {
                    url = new URL(String.valueOf(this.baseUrl) + this.projectId + "/output/" + this.currentMediaName + ".out");
                }
                catch (MalformedURLException mue) {
                    this.reportBuilder.append("Could not create the input file url: " + mue.getMessage() + "\n");
                    return false;
                }
                if (url == null) {
                    return false;
                }
                HttpURLConnection httpConn = null;
                httpConn = (HttpURLConnection)url.openConnection();
                httpConn.setDefaultUseCaches(false);
                httpConn.setUseCaches(false);
                httpConn.setDoOutput(true);
                httpConn.setRequestMethod("GET");
                httpConn.connect();
                int respCode = httpConn.getResponseCode();
                if (respCode != 200) {
                    this.reportBuilder.append("Unable to get the results: " + respCode + "\n");
                    this.host.errorOccurred("Unable to get the results.");
                    break block16;
                }
                procReader = new BufferedReader(new InputStreamReader(httpConn.getInputStream()));
                bufWriter = null;
                try {
                    bufWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFile), "UTF-8"));
                }
                catch (IOException iie) {
                    System.out.println("Cannot write to file: " + this.outputFile + " " + iie.getMessage());
                    try {
                        bufWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(String.valueOf(this.currentMediaFile) + ".xml"), "UTF-8"));
                    }
                    catch (IOException iie2) {
                        System.out.println("Cannot write to file: " + this.currentMediaFile + ".xml" + " " + iie2.getMessage());
                    }
                }
                if (bufWriter != null) break block17;
                return false;
            }
            try {
                String line = null;
                String nl = "\n";
                String end = "</TIER>";
                boolean xmlStarted = false;
                while ((line = procReader.readLine()) != null) {
                    if (!xmlStarted && line.startsWith("<?xml")) {
                        bufWriter.write(line);
                        bufWriter.write("\n");
                        xmlStarted = true;
                        continue;
                    }
                    if (!xmlStarted) continue;
                    bufWriter.write(line);
                    bufWriter.write("\n");
                    if (line.indexOf("</TIER>") > -1) break;
                    if (!this.interrupted) continue;
                    bufWriter.write("</TIER>");
                    this.reportBuilder.append("The process has been canceled while retrieving the results. Incomplete results have been stored.\n");
                    break;
                }
                try {
                    bufWriter.flush();
                    bufWriter.close();
                    procReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return true;
            }
            catch (ProtocolException pe) {
                this.reportBuilder.append("Could not contact the server: " + pe.getMessage() + "\n");
            }
            catch (IOException ioe) {
                this.reportBuilder.append("Could not contact the server: " + ioe.getMessage() + "\n");
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int uploadFile() {
        if (this.currentMediaFile == null) {
            this.reportBuilder.append("There is no audio file url.\n");
            return 400;
        }
        this.host.setProgress(this.progress, "Uploading wav file");
        URL url = null;
        try {
            url = new URL(String.valueOf(this.baseUrl) + this.projectId + "/input/" + this.currentMediaName + "?inputtemplate=wavinput&file=" + this.currentMediaName);
        }
        catch (MalformedURLException mue) {
            this.reportBuilder.append("Could not create the input file url: " + mue.getMessage() + "\n");
            return 400;
        }
        if (url == null) {
            this.reportBuilder.append("Could not create the input file url.\n");
            return 400;
        }
        String boundary = "DaDa0x";
        String nl = "\r\n";
        StringBuilder preFileString = new StringBuilder("--DaDa0x\r\n");
        preFileString.append("content-disposition: form-data; name=\"file\"; filename=\"" + this.currentMediaName + "\"" + "\r\n");
        preFileString.append("\r\n");
        byte[] preBytes = preFileString.toString().getBytes();
        byte[] postBytes = "\r\n--DaDa0x--\r\n".getBytes();
        File f = new File(this.currentMediaFile);
        long fileLength = 0L;
        if (f.exists() && !f.isDirectory()) {
            fileLength = f.length();
            try {
                HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
                httpConn.setDefaultUseCaches(false);
                httpConn.setUseCaches(false);
                httpConn.setDoInput(true);
                httpConn.setDoOutput(true);
                httpConn.setRequestMethod("POST");
                httpConn.setInstanceFollowRedirects(false);
                httpConn.setFixedLengthStreamingMode((int)((long)preBytes.length + fileLength + (long)postBytes.length));
                httpConn.setRequestProperty("Connection", "Keep-Alive");
                httpConn.setRequestProperty("Content-Type", "multipart/form-data;boundary=DaDa0x");
                FileInputStream fis = null;
                DataOutputStream dos = null;
                float startProg = this.progress;
                float progPart = 0.4f;
                try {
                    try {
                        fis = new FileInputStream(f);
                        dos = new DataOutputStream(httpConn.getOutputStream());
                        dos.write(preBytes);
                        int totalBytesRead = 0;
                        byte[] chunk = new byte[0x100000];
                        while (true) {
                            int numBytesRead;
                            if ((numBytesRead = fis.read(chunk, 0, chunk.length)) == -1 || this.interrupted) {
                                if (this.interrupted) {
                                    this.reportBuilder.append("The process has been canceled, uploading has been stopped...\n");
                                }
                                dos.write(postBytes);
                                dos.flush();
                                this.host.setProgress(this.progress, "File uploaded, waiting for server confirmation.");
                                break;
                            }
                            dos.write(chunk, 0, numBytesRead);
                            dos.flush();
                            totalBytesRead += numBytesRead;
                            if (fileLength <= 0L) continue;
                            this.progress = startProg + progPart * ((float)totalBytesRead / (float)fileLength);
                            this.host.setProgress(this.progress);
                        }
                    }
                    catch (IOException ioe) {
                        this.reportBuilder.append("An error occurred while uploading the audio file: " + ioe.getMessage() + "\n");
                        if (dos != null) {
                            dos.flush();
                            dos.close();
                        }
                        if (fis == null) return 400;
                        fis.close();
                        return 400;
                    }
                }
                finally {
                    if (dos != null) {
                        dos.flush();
                        dos.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
                int responseCode = httpConn.getResponseCode();
                if (responseCode == 200) return responseCode;
                this.reportBuilder.append("An error occurred while uploading the audio file: " + responseCode + "\n");
                return responseCode;
            }
            catch (ProtocolException pe) {
                this.reportBuilder.append("Could not contact the server: " + pe.getMessage() + "\n");
                return 400;
            }
            catch (IOException ioe) {
                this.reportBuilder.append("Could not contact the server: " + ioe.getMessage() + "\n");
                return 400;
            }
        }
        this.reportBuilder.append("Errro: the file does not exist\n");
        return 400;
    }
}

