/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annex.search;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.mpi.annex.data.AnnexTranscription;
import nl.mpi.annex.search.SearchHSQLDB;
import nl.mpi.annex.search.SearchHit;
import nl.mpi.annex.search.SearchQuery;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HSQLDBQuery
extends SearchQuery {
    private static Logger _logger = Logger.getLogger(HSQLDBQuery.class.getName());
    private Connection queryCon;
    private Statement queryStatement;
    private Connection hitCon;
    private Statement hitStatement;
    private static Pattern staticRegExpPattern;
    private SearchHSQLDB _ingester;

    public HSQLDBQuery(int queryIdInt) {
        super(queryIdInt);
        String createSchema = "CREATE SCHEMA " + this.schemaName + " AUTHORIZATION DBA";
        String createTierTable = "CREATE TABLE " + this.schemaName + ".tiers (" + "tier_id INTEGER, " + "tier_name VARCHAR, " + "tier_type VARCHAR, " + "default_locale VARCHAR, " + "annotator VARCHAR, " + "participant VARCHAR, " + "n_annotations INTEGER, " + "ref_tier_id INTEGER, " + "transcription_type INTEGER, " + "node_id VARCHAR, " + "aligned_annotations INTEGER )";
        String createAnnotationTable = "CREATE TABLE " + this.schemaName + ".annotations (" + "ann_id INTEGER, " + "annotation VARCHAR, " + "ann_position INTEGER, " + "begin_time BIGINT, " + "end_time BIGINT, " + "ann_tier_id INTEGER)";
        try {
            this.queryCon = DriverManager.getConnection("jdbc:hsqldb:mem:doQuery", "sa", "");
            this.queryStatement = this.queryCon.createStatement();
            this.hitCon = DriverManager.getConnection("jdbc:hsqldb:mem:getHits", "sa", "");
            this.hitStatement = this.hitCon.createStatement();
            this.queryStatement.executeUpdate(createSchema);
            this.queryStatement.executeUpdate(createTierTable);
            this.queryStatement.executeUpdate(createAnnotationTable);
            this.queryStatement.executeUpdate("CREATE INDEX ann_begin_time_index ON " + this.schemaName + ".annotations( begin_time )");
            this.queryStatement.executeUpdate("CREATE INDEX ann_end_time_index ON " + this.schemaName + ".annotations( end_time )");
            this.hitStatement.executeUpdate(createSchema);
            this.hitStatement.executeUpdate(createTierTable);
            this.hitStatement.executeUpdate(createAnnotationTable);
            this.hitStatement.executeUpdate("CREATE INDEX ann_begin_time_index ON " + this.schemaName + ".annotations( begin_time )");
            this.hitStatement.executeUpdate("CREATE INDEX ann_end_time_index ON " + this.schemaName + ".annotations( end_time )");
        }
        catch (SQLException e) {
            _logger.error("HSQLDBQuery create tables SQLException: " + e, e);
        }
        this._ingester = new SearchHSQLDB(this.schemaName);
    }

    public void doQuery(String encodedQuery) {
        this.cancelQuery();
        this.statistics.reset();
        this.clearFrequencyStatistics();
        if (this._ingester.getDomain().size() == 0) {
            return;
        }
        this.createLayers(encodedQuery);
        this.keepExecuting = true;
        this.isExecuting = true;
        new Thread(new QueryExecutor()).start();
    }

    public void cancelQuery() {
        if (this.isExecuting) {
            this.keepExecuting = false;
            try {
                while (this.isExecuting) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.isExecuting = false;
    }

    @Override
    protected String createQueryPatternPart(String pattern, String[] queryModes, Pattern regexpPattern, boolean patternNOTMode) {
        String queryPart = "";
        this.patternNeedsFullStatistics = false;
        if (queryModes[0].equals(" Annotation")) {
            if (queryModes[1].equals(" case sensitive")) {
                if (queryModes[2].equals(" exact match")) {
                    queryPart = patternNOTMode ? "annotation != '" + pattern + "'" : "annotation = '" + pattern + "'";
                } else if (queryModes[2].equals(" substring match")) {
                    if (patternNOTMode) {
                        queryPart = "annotation NOT LIKE '%" + this.escape(pattern) + "%' ESCAPE '~'";
                    } else {
                        queryPart = "annotation LIKE '%" + this.escape(pattern) + "%' ESCAPE '~'";
                        this.patternNeedsFullStatistics = true;
                    }
                } else if (queryModes[2].equals(" regular expression")) {
                    staticRegExpPattern = regexpPattern;
                    if (patternNOTMode) {
                        queryPart = "\"nl.mpi.annex.search.HSQLDBQuery.match\"(annotation, true, true)";
                    } else {
                        queryPart = "\"nl.mpi.annex.search.HSQLDBQuery.match\"(annotation, true, false)";
                        this.patternNeedsFullStatistics = true;
                    }
                } else {
                    _logger.warn("Mode is neither EXACT nor SUBSTRING nor REGEXP for ANNOTATIONS/CASE but: " + queryModes[1]);
                    queryPart = "42 = 43";
                }
            } else if (queryModes[2].equals(" exact match")) {
                queryPart = patternNOTMode ? "LCASE(annotation) != '" + pattern.toLowerCase() + "'" : "LCASE(annotation) = '" + pattern.toLowerCase() + "'";
            } else if (queryModes[2].equals(" substring match")) {
                if (patternNOTMode) {
                    queryPart = "LCASE(annotation) NOT LIKE '%" + this.escape(pattern.toLowerCase()) + "%' ESCAPE '~'";
                } else {
                    queryPart = "LCASE(annotation) LIKE '%" + this.escape(pattern.toLowerCase()) + "%' ESCAPE '~'";
                    this.patternNeedsFullStatistics = true;
                }
            } else if (queryModes[2].equals(" regular expression")) {
                staticRegExpPattern = regexpPattern;
                if (patternNOTMode) {
                    queryPart = "\"nl.mpi.annex.search.HSQLDBQuery.match\"(annotation, false, true)";
                } else {
                    queryPart = "\"nl.mpi.annex.search.HSQLDBQuery.match\"(annotation, false, false)";
                    this.patternNeedsFullStatistics = true;
                }
            }
        } else if (queryModes[0].equals(" N-gram over annotations") || queryModes[0].equals(" N-gram within annotation")) {
            String nGramPart = this.getLongestNonWildcardPart(pattern);
            if (queryModes[2].equals(" regular expression")) {
                if (queryModes[0].equals(" N-gram within annotation")) {
                    if (nGramPart.startsWith("^")) {
                        nGramPart = nGramPart.substring(1);
                    }
                    if (nGramPart.endsWith("$")) {
                        nGramPart = nGramPart.substring(0, nGramPart.length() - 1);
                    }
                }
                staticRegExpPattern = Pattern.compile(nGramPart);
                if (queryModes[1].equals(" case sensitive")) {
                    if (patternNOTMode) {
                        queryPart = "\"nl.mpi.annex.search.HSQLDBQuery.match\"(annotation, true, true)";
                    } else {
                        queryPart = "\"nl.mpi.annex.search.HSQLDBQuery.match\"(annotation, true, false)";
                        this.patternNeedsFullStatistics = true;
                    }
                } else if (patternNOTMode) {
                    queryPart = "\"nl.mpi.annex.search.HSQLDBQuery.match\"(annotation, false, true)";
                } else {
                    queryPart = "\"nl.mpi.annex.search.HSQLDBQuery.match\"(annotation, false, false)";
                    this.patternNeedsFullStatistics = true;
                }
            } else if (queryModes[1].equals(" case sensitive")) {
                if (patternNOTMode) {
                    queryPart = "annotation NOT LIKE '%" + this.escape(nGramPart) + "%'";
                } else {
                    queryPart = "annotation LIKE '%" + this.escape(nGramPart) + "%'";
                    this.patternNeedsFullStatistics = true;
                }
            } else if (patternNOTMode) {
                queryPart = "LCASE(annotation) NOT LIKE '%" + this.escape(nGramPart.toLowerCase()) + "%'";
            } else {
                queryPart = "LCASE(annotation) LIKE '%" + this.escape(nGramPart.toLowerCase()) + "%'";
                this.patternNeedsFullStatistics = true;
            }
        } else {
            _logger.warn("Mode is neither ANNOTATIONS nor N_GRAMS_WITHIN_ANNOTATIONS nor N_GRAMS_OVER_ANNOTATIONS but: " + queryModes[0] + " (" + queryModes[1] + "/" + queryModes[2] + ")");
            queryPart = "42 = 43";
        }
        return queryPart;
    }

    @Override
    protected String convertRegexpPatternsIfNeeded(String queryString) {
        if (queryString.indexOf("nl.mpi.annex.search.HSQLDBQuery.match") != -1) {
            _logger.debug("next layerq: [regexp = '" + staticRegExpPattern + "']");
        }
        return queryString;
    }

    public static boolean match(String annotation, boolean caseSensitive, boolean notMode) {
        Matcher matcher = caseSensitive ? staticRegExpPattern.matcher(annotation) : staticRegExpPattern.matcher(annotation.toLowerCase());
        if (notMode) {
            return !matcher.find();
        }
        return matcher.find();
    }

    public ArrayList<SearchHit> getHits(int fromIndex, int toIndex, int contextSize) {
        ArrayList<SearchHit> hitList = new ArrayList<SearchHit>();
        if (this.firstNonEmptyLayerIndex < 0 || this.firstNonEmptyLayerIndex >= this.nLayers || this.firstNonEmptyPatternIndex < 0 || this.firstNonEmptyPatternIndex >= this.nPatternsPerLayer) {
            _logger.warn("Empty query? no results. FirstNonEmpty: " + this.firstNonEmptyPatternIndex + "/" + this.firstNonEmptyLayerIndex + " Matrix: " + this.nPatternsPerLayer + "*" + this.nLayers);
            return hitList;
        }
        try {
            int prevFileId = -1;
            File file = null;
            ArrayList<Long> beginTimes = new ArrayList<Long>();
            int[][] hitAnnIds = new int[this.nLayers][this.nPatternsPerLayer];
            int[] savedHitAnnId = this.searchLayers[this.firstNonEmptyLayerIndex].getHitAnnIdsForPattern(this.firstNonEmptyPatternIndex);
            int[] savedHitNumber = this.searchLayers[this.firstNonEmptyLayerIndex].getHitNumberForPattern(this.firstNonEmptyPatternIndex);
            int[] savedHitFileId = this.searchLayers[this.firstNonEmptyLayerIndex].getHitFileIds();
            for (int i = fromIndex; i < toIndex && i < this.statistics.nHits && i < 100000; ++i) {
                SearchHit hit = new SearchHit();
                int annId = savedHitAnnId[i];
                int fileId = savedHitFileId[i];
                if (fileId != prevFileId) {
                    file = this._ingester.getDomain().get(fileId);
                    AnnexTranscription transcription = new AnnexTranscription(file.getName(), 0, file);
                    this._ingester.ingestCounting(transcription, this.hitCon);
                    prevFileId = fileId;
                }
                ResultSet rs = this.hitStatement.executeQuery("SELECT ann_position, annotation, begin_time, end_time, ann_tier_id FROM " + this.schemaName + ".annotations WHERE ann_id = " + annId);
                rs.next();
                hit.positionInTier = rs.getInt(1);
                if (this.isSimpleQuery) {
                    hit.annotation = rs.getString(2);
                    hit.beginTime = this.getValue(rs, 3);
                    hit.endTime = this.getValue(rs, 4);
                } else {
                    for (int layer = 0; layer < this.nLayers; ++layer) {
                        for (int pattern = 0; pattern < this.nPatternsPerLayer; ++pattern) {
                            int[] annIds = this.searchLayers[layer].getHitAnnIdsForPattern(pattern);
                            hitAnnIds[layer][pattern] = annIds != null ? annIds[i] : -1;
                        }
                    }
                    SearchQuery.ComplexHitData hitData = this.constructComplexHitResultString(null, this.hitStatement, hitAnnIds, true);
                    hit.annotation = hitData.hitString;
                    hit.beginTime = hitData.beginTime;
                    hit.endTime = hitData.endTime;
                }
                int ann_tier_id = rs.getInt(5);
                rs = this.hitStatement.executeQuery("SELECT node_id, tier_name, tier_type, participant, annotator, n_annotations, aligned_annotations FROM " + this.schemaName + ".tiers WHERE tier_id = " + ann_tier_id);
                rs.next();
                hit.transcriptionNodeId = rs.getString(1);
                hit.transcriptionName = file.getAbsolutePath();
                hit.tierName = rs.getString(2);
                hit.tierType = this.isSimpleQuery ? rs.getString(3) : "xxxCOMPLEX_QUERY_INDICATORxxx";
                hit.participant = rs.getString(4);
                hit.annotator = rs.getString(5);
                int nAnnotationsInTier = rs.getInt(6);
                int nAlignedAnnotationsInTier = rs.getInt(7);
                hit.aligned = nAlignedAnnotationsInTier == nAnnotationsInTier;
                hit.hitNumberInAnnotation = savedHitNumber[i];
                String pattern = this.searchLayers[this.firstNonEmptyLayerIndex].getPattern(this.firstNonEmptyPatternIndex);
                boolean patternNOTMode = this.searchLayers[this.firstNonEmptyLayerIndex].getPatternNOTMode(this.firstNonEmptyPatternIndex);
                Pattern regExpPattern = this.searchLayers[this.firstNonEmptyLayerIndex].getRegExpPattern(this.firstNonEmptyPatternIndex);
                String[] queryModes = this.searchLayers[this.firstNonEmptyLayerIndex].getMode(this.firstNonEmptyPatternIndex);
                hit.hitPositionInAnnotation = this.getHitPosition(hit.annotation, hit.hitNumberInAnnotation, queryModes, pattern, regExpPattern, patternNOTMode);
                hit.hitLength = this.getHitLength(hit.annotation, hit.hitNumberInAnnotation, queryModes, pattern, regExpPattern, patternNOTMode);
                if (queryModes[0].equals(" N-gram over annotations")) {
                    int leftContextSize = contextSize + this.nGramSizeLeftFromHit;
                    rs = this.hitStatement.executeQuery("SELECT annotation, ann_position, begin_time FROM " + this.schemaName + ".annotations " + "WHERE ann_tier_id = " + ann_tier_id + " AND ann_position < " + hit.positionInTier + " AND ann_position >= " + (hit.positionInTier - leftContextSize) + " ORDER BY ann_position DESC");
                    beginTimes.clear();
                    while (rs.next()) {
                        hit.leftContext.add(rs.getString(1));
                        beginTimes.add(this.getValue(rs, 3));
                    }
                    for (int j = 0; j < this.nGramSizeLeftFromHit; ++j) {
                        if (hit.leftContext.size() <= 0) continue;
                        String part = hit.leftContext.get(0);
                        hit.annotation = part + " " + hit.annotation;
                        hit.beginTime = (Long)beginTimes.get(0);
                        hit.leftContext.remove(0);
                        beginTimes.remove(0);
                    }
                    int rightContextSize = contextSize + this.nGramSizeRightFromHit;
                    rs = this.hitStatement.executeQuery("SELECT annotation, ann_position, end_time FROM " + this.schemaName + ".annotations " + "WHERE ann_tier_id = " + ann_tier_id + " AND ann_position > " + hit.positionInTier + " AND ann_position <= " + (hit.positionInTier + rightContextSize) + " ORDER BY ann_position");
                    int n = 0;
                    while (rs.next()) {
                        if (n < this.nGramSizeRightFromHit) {
                            hit.annotation = hit.annotation + " " + rs.getString(1);
                            hit.endTime = this.getValue(rs, 3);
                        } else {
                            hit.rightContext.add(rs.getString(1));
                        }
                        ++n;
                    }
                    hit.hitPositionInAnnotation = 0;
                    hit.hitLength = hit.annotation.length();
                    hit.positionInTier -= leftContextSize;
                    ++hit.positionInTier;
                } else {
                    rs = this.hitStatement.executeQuery("SELECT annotation, ann_position FROM " + this.schemaName + ".annotations " + "WHERE ann_tier_id = " + ann_tier_id + " AND ann_position < " + hit.positionInTier + " AND ann_position >= " + (hit.positionInTier - contextSize) + " ORDER BY ann_position DESC");
                    while (rs.next()) {
                        hit.leftContext.add(rs.getString(1));
                    }
                    rs = this.hitStatement.executeQuery("SELECT annotation, ann_position FROM " + this.schemaName + ".annotations " + "WHERE ann_tier_id = " + ann_tier_id + " AND ann_position > " + hit.positionInTier + " AND ann_position <= " + (hit.positionInTier + contextSize) + " ORDER BY ann_position");
                    while (rs.next()) {
                        hit.rightContext.add(rs.getString(1));
                    }
                    ++hit.positionInTier;
                }
                hitList.add(hit);
            }
        }
        catch (SQLException e) {
            _logger.error("SQLException in getHits: " + e, e);
        }
        return hitList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Object> getViewerParametersFor(int annId, int fileId) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        ResultSet rs = null;
        try {
            File file = this._ingester.getDomain().get(fileId);
            AnnexTranscription transcription = new AnnexTranscription(file.getName(), 0, file);
            this._ingester.ingestCounting(transcription, this.hitCon);
            rs = this.hitStatement.executeQuery("SELECT begin_time, end_time, ann_tier_id FROM " + this.schemaName + ".annotations WHERE ann_id = " + annId);
            rs.next();
            long beginTime = this.getValue(rs, 1);
            long endTime = this.getValue(rs, 2);
            int tierId = rs.getInt(3);
            rs.close();
            rs = null;
            rs = this.hitStatement.executeQuery("SELECT tier_name FROM " + this.schemaName + ".tiers WHERE tier_id = " + tierId);
            rs.next();
            String tierName = rs.getString(1);
            rs.close();
            rs = null;
            parameters.add(file.getAbsolutePath());
            parameters.add(tierName);
            parameters.add(beginTime);
            parameters.add(endTime);
        }
        catch (SQLException e) {
            _logger.error("SQLException in getViewerParametersFor: " + e, e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e2) {}
            }
        }
        return parameters;
    }

    private String escape(String string) {
        String s = string.replaceAll("~", "~~");
        s = s.replaceAll("%", "~%");
        s = s.replaceAll("'", "''");
        s = s.replaceAll("\"", "~\"");
        return s.replaceAll("_", "~_");
    }

    public SearchHSQLDB getIngester() {
        return this._ingester;
    }

    public void setDomain(ArrayList<File> eafFiles) {
        this.statistics.reset();
        this.clearFrequencyStatistics();
        this._ingester.setDomain(eafFiles);
    }

    public void setDomain(HSQLDBQuery query) {
        this.statistics.reset();
        this.clearFrequencyStatistics();
        this._ingester.setDomain(query.getIngester());
    }

    public float getDomainInitializationProgress() {
        return this._ingester.getDomainInitializationProgress();
    }

    public ArrayList<File> getDomain() {
        return this._ingester.getDomain();
    }

    public ArrayList<File> getProblemFiles() {
        return this._ingester.getProblemFiles();
    }

    public ArrayList<String> getTierNames() {
        return this._ingester.getTierNames();
    }

    public ArrayList<String> getTierTypes() {
        return this._ingester.getTierTypes();
    }

    public ArrayList<String> getParticipants() {
        return this._ingester.getParticipants();
    }

    public ArrayList<String> getAnnotators() {
        return this._ingester.getAnnotators();
    }

    static {
        try {
            Class.forName("org.hsqldb.jdbcDriver");
        }
        catch (ClassNotFoundException e) {
            System.out.println("No JAR with org.hsqldb.jdbcDriver in classpath!");
            _logger.error("No JAR with org.hsqldb.jdbcDriver in classpath!");
        }
    }

    private class QueryExecutor
    implements Runnable {
        String pattern;
        boolean patternNOTMode;
        Pattern regExpPattern;
        String[] queryModes;

        public QueryExecutor() {
            if (HSQLDBQuery.this.firstNonEmptyPatternIndex >= 0) {
                this.pattern = HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getPattern(HSQLDBQuery.this.firstNonEmptyPatternIndex);
                this.patternNOTMode = HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getPatternNOTMode(HSQLDBQuery.this.firstNonEmptyPatternIndex);
                this.regExpPattern = HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getRegExpPattern(HSQLDBQuery.this.firstNonEmptyPatternIndex);
                this.queryModes = HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getMode(HSQLDBQuery.this.firstNonEmptyPatternIndex);
            } else {
                _logger.warn("QueryExecutor: All patterns empty");
            }
        }

        public void run() {
            if (this.pattern == null || HSQLDBQuery.this.firstNonEmptyLayerIndex < 0 || HSQLDBQuery.this.firstNonEmptyPatternIndex < 0) {
                _logger.warn("Bad or empty query: " + (this.pattern == null ? "null" : "") + " at " + HSQLDBQuery.this.firstNonEmptyPatternIndex + "/" + HSQLDBQuery.this.firstNonEmptyLayerIndex);
                HSQLDBQuery.this.statistics.progress = 1.0f;
                HSQLDBQuery.this.isExecuting = false;
            } else {
                String queryString = "SELECT ann_id, annotation, begin_time, end_time, ann_position, ann_tier_id FROM " + HSQLDBQuery.this.schemaName + ".annotations WHERE ";
                queryString = queryString + HSQLDBQuery.this.createQueryPatternPart(this.pattern, this.queryModes, this.regExpPattern, this.patternNOTMode);
                queryString = queryString + HSQLDBQuery.this.createGlobalTimeConstraintPart();
                try {
                    AnnexTranscription transcription = null;
                    for (int fileIndex = 0; fileIndex < HSQLDBQuery.this._ingester.getDomain().size(); ++fileIndex) {
                        File file = HSQLDBQuery.this._ingester.getDomain().get(fileIndex);
                        if (file.exists()) {
                            transcription = new AnnexTranscription(file.getName(), 0, file);
                            if (transcription.isValid()) {
                                HSQLDBQuery.this.statistics.nAnnotationsSearched = (int)((long)HSQLDBQuery.this.statistics.nAnnotationsSearched + HSQLDBQuery.this._ingester.ingestCounting(transcription, HSQLDBQuery.this.queryCon));
                                if (fileIndex < HSQLDBQuery.this._ingester.getDomain().size() - 1) {
                                    HSQLDBQuery.this.statistics.progress = ((float)fileIndex - 0.5f) / (float)HSQLDBQuery.this._ingester.getDomain().size();
                                }
                                if (!HSQLDBQuery.this.isSimpleQuery) {
                                    staticRegExpPattern = this.regExpPattern;
                                }
                                boolean tierFreeLayersExist = HSQLDBQuery.this.setTierDomainForLayers(false, HSQLDBQuery.this.queryStatement, transcription.getNodeId());
                                String tierDomain = HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getTierIdsInLayerDomain();
                                String query = queryString;
                                if (tierFreeLayersExist) continue;
                                if (!tierDomain.equals(HSQLDBQuery.this.fullTranscriptionTierDomain)) {
                                    query = query + tierDomain;
                                }
                                String hint = "";
                                if (query.indexOf("nl.mpi.annex.search.HSQLDBQuery.match") != -1) {
                                    hint = hint + "[regexp = '" + staticRegExpPattern + "'] ";
                                }
                                if (!HSQLDBQuery.this.isSimpleQuery) {
                                    hint = hint + "[" + (HSQLDBQuery.this.firstNonEmptyLayerIndex + 1) + "/" + HSQLDBQuery.this.nLayers + "][" + (HSQLDBQuery.this.firstNonEmptyPatternIndex + 1) + "/" + HSQLDBQuery.this.nPatternsPerLayer + "] ";
                                }
                                _logger.debug("query: " + hint + query);
                                boolean logLayerq = true;
                                ResultSet rs = HSQLDBQuery.this.queryStatement.executeQuery(query);
                                while (rs.next()) {
                                    int annId = rs.getInt(1);
                                    String annotation = rs.getString(2);
                                    int tierId = rs.getInt(6);
                                    if (HSQLDBQuery.this.isSimpleQuery) {
                                        if (this.queryModes[0].equals(" Annotation")) {
                                            long beginTime = HSQLDBQuery.this.getValue(rs, 3);
                                            long endTime = HSQLDBQuery.this.getValue(rs, 4);
                                            if (!HSQLDBQuery.this.isDurationInRange(endTime - beginTime)) continue;
                                            HSQLDBQuery.this.updateFrequencyStatistics(annotation, annId, fileIndex, HSQLDBQuery.this.firstNonEmptyLayerIndex, HSQLDBQuery.this.firstNonEmptyPatternIndex);
                                            ++HSQLDBQuery.this.statistics.nAnnotationsWithHit;
                                            int nHitsInAnnotation = 1;
                                            if (HSQLDBQuery.this.patternNeedsFullStatistics) {
                                                nHitsInAnnotation = HSQLDBQuery.this.countHitsInAnnotation(annotation, this.queryModes, this.pattern, this.regExpPattern, this.patternNOTMode);
                                            }
                                            for (int j = 0; j < nHitsInAnnotation; ++j) {
                                                if (HSQLDBQuery.this.statistics.nHits < 100000) {
                                                    HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getHitAnnIdsForPattern((int)HSQLDBQuery.this.firstNonEmptyPatternIndex)[HSQLDBQuery.this.statistics.nHits] = annId;
                                                    HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getHitNumberForPattern((int)HSQLDBQuery.this.firstNonEmptyPatternIndex)[HSQLDBQuery.this.statistics.nHits] = j + 1;
                                                    HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getHitFileIds()[HSQLDBQuery.this.statistics.nHits] = fileIndex;
                                                }
                                                ++HSQLDBQuery.this.statistics.nHits;
                                            }
                                        } else {
                                            String[] nGrams;
                                            if (this.queryModes[0].equals(" N-gram over annotations")) {
                                                HSQLDBQuery.this.nGramSizeLeftFromHit = HSQLDBQuery.this.getLongestNonWildcardPartPosition(this.pattern);
                                                HSQLDBQuery.this.nGramSizeRightFromHit = HSQLDBQuery.this.getNGramLength(this.pattern) - HSQLDBQuery.this.nGramSizeLeftFromHit - 1;
                                            }
                                            if ((nGrams = HSQLDBQuery.this.constructNGrams(annId, HSQLDBQuery.this.queryStatement, HSQLDBQuery.this.schemaName, this.pattern, this.queryModes)) != null) {
                                                boolean frequencyStatisticsUpdated = false;
                                                boolean firstNAnnotationsUpdate = true;
                                                int hitNumber = 1;
                                                for (int j = 0; j < nGrams.length; ++j) {
                                                    String nGram = nGrams[j];
                                                    if (!HSQLDBQuery.this.isNGramMatch(nGram, this.pattern, this.queryModes)) continue;
                                                    if (!frequencyStatisticsUpdated) {
                                                        nGram = nGram.replace("xxxSAFE_SPLITTERxxx", " ");
                                                        HSQLDBQuery.this.updateFrequencyStatistics(nGram, annId, fileIndex, HSQLDBQuery.this.firstNonEmptyLayerIndex, HSQLDBQuery.this.firstNonEmptyPatternIndex);
                                                        frequencyStatisticsUpdated = true;
                                                    }
                                                    if (this.queryModes[0].equals(" N-gram over annotations") || firstNAnnotationsUpdate) {
                                                        ++HSQLDBQuery.this.statistics.nAnnotationsWithHit;
                                                        firstNAnnotationsUpdate = false;
                                                    }
                                                    if (HSQLDBQuery.this.statistics.nHits < 100000) {
                                                        HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getHitAnnIdsForPattern((int)HSQLDBQuery.this.firstNonEmptyPatternIndex)[HSQLDBQuery.this.statistics.nHits] = annId;
                                                        HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getHitNumberForPattern((int)HSQLDBQuery.this.firstNonEmptyPatternIndex)[HSQLDBQuery.this.statistics.nHits] = hitNumber++;
                                                        HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getHitFileIds()[HSQLDBQuery.this.statistics.nHits] = fileIndex;
                                                    }
                                                    ++HSQLDBQuery.this.statistics.nHits;
                                                }
                                            }
                                        }
                                    } else {
                                        HSQLDBQuery.this.currentTranscriptionTierDomain = "";
                                        HSQLDBQuery.this.clearHitData(fileIndex);
                                        HSQLDBQuery.this.globalHitAnnId[HSQLDBQuery.this.firstNonEmptyLayerIndex][HSQLDBQuery.this.firstNonEmptyPatternIndex] = annId;
                                        HSQLDBQuery.this.globalHitTierId[HSQLDBQuery.this.firstNonEmptyLayerIndex][HSQLDBQuery.this.firstNonEmptyPatternIndex] = tierId;
                                        HSQLDBQuery.this.globalHitBeginTime[HSQLDBQuery.this.firstNonEmptyLayerIndex][HSQLDBQuery.this.firstNonEmptyPatternIndex] = HSQLDBQuery.this.getValue(rs, 3);
                                        HSQLDBQuery.this.globalHitEndTime[HSQLDBQuery.this.firstNonEmptyLayerIndex][HSQLDBQuery.this.firstNonEmptyPatternIndex] = HSQLDBQuery.this.getValue(rs, 4);
                                        HSQLDBQuery.this.globalHitPosition[HSQLDBQuery.this.firstNonEmptyLayerIndex][HSQLDBQuery.this.firstNonEmptyPatternIndex] = rs.getInt(5);
                                        HSQLDBQuery.this.investigateComplexPattern(HSQLDBQuery.this.firstNonEmptyLayerIndex, HSQLDBQuery.this.firstNonEmptyPatternIndex, HSQLDBQuery.this.queryCon, logLayerq);
                                        logLayerq = false;
                                    }
                                    if (HSQLDBQuery.this.keepExecuting) continue;
                                    break;
                                }
                                if (!HSQLDBQuery.this.keepExecuting) break;
                            }
                            if (!HSQLDBQuery.this.keepExecuting) break;
                        }
                        if (!HSQLDBQuery.this.keepExecuting) break;
                        HSQLDBQuery.this.statistics.progress = (float)fileIndex / (float)HSQLDBQuery.this._ingester.getDomain().size();
                    }
                    HSQLDBQuery.this.statistics.progress = 1.0f;
                }
                catch (SQLException e) {
                    _logger.error("SQLException in run: " + e, e);
                    HSQLDBQuery.this.statistics.progress = 1.0f;
                }
                catch (RuntimeException re) {
                    _logger.error("RuntimeException in run: " + re, re);
                    HSQLDBQuery.this.statistics.progress = 1.0f;
                }
                HSQLDBQuery.this.isExecuting = false;
            }
        }
    }
}

