/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annex.search;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import nl.mpi.annex.data.AnnexParser;
import nl.mpi.annex.search.SearchHit;
import nl.mpi.annex.search.SearchLayer;
import nl.mpi.annex.search.SearchQuery;
import nl.mpi.annex.search.TierCollection;
import nl.mpi.annex.util.AnnexUtil;
import nl.mpi.annex.util.UTF8Validator;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgresQuery
extends SearchQuery {
    private static Logger logger = Logger.getLogger("ANNEX.PostgresQuery");
    private String url;
    private String usr;
    private String pwd;
    private ArrayList<Integer> _domainTiers;
    private HashMap<Integer, String> _domainTiersNodeId;

    public PostgresQuery(String url, String usr, String pwd) {
        super(null);
        this.url = url;
        this.usr = usr;
        this.pwd = pwd;
        this._domainTiers = new ArrayList();
        this._domainTiersNodeId = new HashMap();
    }

    public synchronized void doQuery(TierCollection domain, List<Integer> fileTypes, String encodedQuery) {
        int i;
        this.cancelQuery();
        this.statistics.reset();
        this.clearFrequencyStatistics();
        HashSet<String> domainNodeIds = new HashSet<String>();
        if (fileTypes != null) {
            for (i = 0; i < fileTypes.size(); ++i) {
                domainNodeIds.addAll(domain.getNodesForType(fileTypes.get(i)));
            }
        } else {
            for (i = 0; i < AnnexParser.getFileTypeCount(); ++i) {
                domainNodeIds.addAll(domain.getNodesForType(i));
            }
        }
        String tierConstraintSQL = domain.getRawSQLFilter(fileTypes);
        if (encodedQuery != null && encodedQuery.trim().length() > 0) {
            this.createLayers(encodedQuery);
        }
        this.keepExecuting = true;
        this.isExecuting = true;
        new Thread(new QueryExecutor(domainNodeIds, tierConstraintSQL)).start();
    }

    public void cancelQuery() {
        if (this.isExecuting) {
            this.keepExecuting = false;
            try {
                while (this.isExecuting) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.isExecuting = false;
    }

    @Override
    protected String createQueryPatternPart(String pattern, String[] queryModes, Pattern regexpPattern, boolean patternNOTMode) {
        String queryPart = "";
        this.patternNeedsFullStatistics = false;
        if (queryModes[0].equals(" Annotation")) {
            if (queryModes[1].equals(" case sensitive")) {
                if (queryModes[2].equals(" exact match")) {
                    queryPart = patternNOTMode ? "annotation != '" + pattern + "'" : "annotation = '" + pattern + "'";
                } else if (queryModes[2].equals(" substring match")) {
                    if (patternNOTMode) {
                        queryPart = "annotation NOT LIKE '%" + this.escape(pattern) + "%' ESCAPE '~'";
                    } else {
                        queryPart = "annotation LIKE '%" + this.escape(pattern) + "%' ESCAPE '~'";
                        this.patternNeedsFullStatistics = true;
                    }
                } else if (queryModes[2].equals(" regular expression")) {
                    if (patternNOTMode) {
                        queryPart = "annotation !~ E'" + this.escapeRegExp(pattern) + "'";
                    } else {
                        queryPart = "annotation ~ E'" + this.escapeRegExp(pattern) + "'";
                        this.patternNeedsFullStatistics = true;
                    }
                } else {
                    logger.warn("Mode is neither EXACT nor SUBSTRING nor REGEXP for ANNOTATIONS/CASE but: " + queryModes[1]);
                    queryPart = "42 = 43";
                }
            } else if (queryModes[2].equals(" exact match")) {
                queryPart = patternNOTMode ? "LOWER(annotation) != '" + pattern.toLowerCase() + "'" : "LOWER(annotation) = '" + pattern.toLowerCase() + "'";
            } else if (queryModes[2].equals(" substring match")) {
                if (patternNOTMode) {
                    queryPart = "annotation NOT ILIKE '%" + this.escape(pattern) + "%' ESCAPE '~'";
                } else {
                    queryPart = "annotation ILIKE '%" + this.escape(pattern) + "%' ESCAPE '~'";
                    this.patternNeedsFullStatistics = true;
                }
            } else if (queryModes[2].equals(" regular expression")) {
                if (patternNOTMode) {
                    queryPart = "annotation !~* E'" + this.escapeRegExp(pattern) + "'";
                } else {
                    queryPart = "annotation ~* E'" + this.escapeRegExp(pattern) + "'";
                    this.patternNeedsFullStatistics = true;
                }
            } else {
                logger.warn("Mode is neither EXACT nor SUBSTRING nor REGEXP for ANNOTATIONS/NOCASE but: " + queryModes[1]);
                queryPart = "42 = 43";
            }
        } else if (queryModes[0].equals(" N-gram over annotations") || queryModes[0].equals(" N-gram within annotation")) {
            String nGramPart = this.getLongestNonWildcardPart(pattern);
            if (queryModes[2].equals(" regular expression")) {
                if (queryModes[0].equals(" N-gram within annotation")) {
                    if (nGramPart.startsWith("^")) {
                        nGramPart = nGramPart.substring(1);
                    }
                    if (nGramPart.endsWith("$")) {
                        nGramPart = nGramPart.substring(0, nGramPart.length() - 1);
                    }
                }
                if (queryModes[1].equals(" case sensitive")) {
                    if (patternNOTMode) {
                        queryPart = "annotation !~ E'" + this.escapeRegExp(nGramPart) + "'";
                    } else {
                        queryPart = "annotation ~ E'" + this.escapeRegExp(nGramPart) + "'";
                        this.patternNeedsFullStatistics = true;
                    }
                } else if (patternNOTMode) {
                    queryPart = "annotation !~* E'" + this.escapeRegExp(nGramPart) + "'";
                } else {
                    queryPart = "annotation ~* E'" + this.escapeRegExp(nGramPart) + "'";
                    this.patternNeedsFullStatistics = true;
                }
            } else if (queryModes[1].equals(" case sensitive")) {
                if (patternNOTMode) {
                    queryPart = "annotation NOT LIKE '%" + this.escape(nGramPart) + "%' ESCAPE '~'";
                } else {
                    queryPart = "annotation LIKE '%" + this.escape(nGramPart) + "%' ESCAPE '~'";
                    this.patternNeedsFullStatistics = true;
                }
            } else if (patternNOTMode) {
                queryPart = "annotation NOT ILIKE '%" + this.escape(nGramPart) + "%' ESCAPE '~'";
            } else {
                queryPart = "annotation ILIKE '%" + this.escape(nGramPart) + "%' ESCAPE '~'";
                this.patternNeedsFullStatistics = true;
            }
        } else {
            logger.warn("Mode is neither ANNOTATIONS nor N_GRAMS_WITHIN_ANNOTATIONS nor N_GRAMS_OVER_ANNOTATIONS but: " + queryModes[0] + " (" + queryModes[1] + "/" + queryModes[2] + ")");
            queryPart = "42 = 43";
        }
        return queryPart;
    }

    private String constructCandidateConstraint(SearchLayer searchLayer) {
        ArrayList<String> keywords = new ArrayList<String>();
        for (int i = 0; i < searchLayer.getNumberOfPatterns(); ++i) {
            String[] modes;
            if (searchLayer.getPatternNOTMode(i) || (modes = searchLayer.getMode(i)) == null) continue;
            if (searchLayer.getRegExpPattern(i) != null) {
                keywords.addAll(PostgresQuery.dissectRegexp(searchLayer.getPattern(i)));
                continue;
            }
            if (" Annotation".equals(modes[0])) {
                keywords.add(searchLayer.getPattern(i));
                continue;
            }
            String[] parts = searchLayer.getPattern(i).split(" +");
            for (int j = 0; j < parts.length; ++j) {
                if ("#".equals(parts[j]) || SearchLayer.isNOTPattern(parts[j])) continue;
                keywords.add(parts[j]);
            }
        }
        int unigram_bits = 0;
        int[] bigram_bits = UTF8Validator.fingerprintBigrams("");
        int[] trigram_bits = UTF8Validator.fingerprintTrigrams("");
        int[] fourgram_bits = UTF8Validator.fingerprint4grams("");
        int minLength = 0;
        for (int i = 0; i < keywords.size(); ++i) {
            int keywordLength = ((String)keywords.get(i)).length();
            minLength = minLength > keywordLength ? minLength : keywordLength;
            unigram_bits |= UTF8Validator.fingerprintChars((String)keywords.get(i));
            int[] bigram_bits_keyword = UTF8Validator.fingerprintBigrams((String)keywords.get(i));
            for (int j = 0; j < bigram_bits.length; ++j) {
                int n = j;
                bigram_bits[n] = bigram_bits[n] | bigram_bits_keyword[j];
            }
            int[] trigram_bits_keyword = UTF8Validator.fingerprintTrigrams((String)keywords.get(i));
            for (int j = 0; j < trigram_bits.length; ++j) {
                int n = j;
                trigram_bits[n] = trigram_bits[n] | trigram_bits_keyword[j];
            }
            int[] fourgram_bits_keyword = UTF8Validator.fingerprint4grams((String)keywords.get(i));
            for (int j = 0; j < fourgram_bits.length; ++j) {
                int n = j;
                fourgram_bits[n] = fourgram_bits[n] | fourgram_bits_keyword[j];
            }
        }
        String bigram_string = UTF8Validator.hexifyBits(bigram_bits);
        String trigram_string = UTF8Validator.hexifyBits(trigram_bits);
        if (minLength >= 4) {
            String fourgram_string = UTF8Validator.hexifyBits(fourgram_bits);
            return "~fourgram_bits & X'" + fourgram_string + "' = 0::bit(" + fourgram_string.length() * 4 + ") AND " + "~trigram_bits & X'" + trigram_string + "' = 0::bit(" + trigram_string.length() * 4 + ") AND " + "~bigram_bits & X'" + bigram_string + "' = 0::bit(" + bigram_string.length() * 4 + ") AND " + "fourgram_bits IS NOT NULL AND trigram_bits IS NOT NULL AND " + "bigram_bits IS NOT NULL AND unigram_bits IS NOT NULL";
        }
        if (minLength >= 3) {
            return "~trigram_bits & X'" + trigram_string + "' = 0::bit(" + trigram_string.length() * 4 + ") AND " + "~bigram_bits & X'" + bigram_string + "' = 0::bit(" + bigram_string.length() * 4 + ") AND " + "trigram_bits IS NOT NULL AND bigram_bits IS NOT NULL AND " + "unigram_bits IS NOT NULL";
        }
        if (minLength >= 2) {
            return "~bigram_bits & X'" + bigram_string + "' = 0::bit(" + bigram_string.length() * 4 + ") AND " + "bigram_bits IS NOT NULL AND unigram_bits IS NOT NULL";
        }
        if (minLength >= 1) {
            return "~unigram_bits & " + unigram_bits + " = 0 AND " + "unigram_bits IS NOT NULL";
        }
        return "TRUE";
    }

    protected static Collection<String> dissectRegexp(String regexp) {
        HashSet<String> retval = new HashSet<String>();
        if (regexp.startsWith("***=")) {
            retval.add(regexp);
            return retval;
        }
        if (regexp.startsWith("***:")) {
            regexp = regexp.substring(4);
        }
        String simpler = regexp.replaceAll("\\\\\\\\", " ");
        simpler = simpler.replaceAll("[.^$]", " ");
        simpler = simpler.replaceAll("\\\\[0-9]{1,3}", " ").replaceAll("\\\\x[0-9a-fA-F]{2}", " ").replaceAll("\\\\u[0-9a-fA-F]{4}", " ").replaceAll("\\\\c.", " ").replaceAll("\\\\[tnrfaevbBmMdDsSwWyYZ0A1-9]", " ").replaceAll("\\\\[^a-zA-Z0-9]", " ");
        simpler = simpler.replaceAll("\\{([^0-9])", " $1");
        simpler = simpler.replaceAll("\\[[^\\]]*\\]+", " ");
        simpler = simpler.replaceAll("\\(.*\\)", " ");
        if ((simpler = simpler.replaceAll(".\\{0[^\\}]*\\}[?]?", " ").replaceAll("\\{[^\\}]*\\}[?]?", "").replaceAll("[+][?+]?", "").replaceAll(".[?*][?+]?", " ")).indexOf(124) != -1) {
            return retval;
        }
        String[] tokens = simpler.split("\\s+");
        for (int i = 0; i < tokens.length; ++i) {
            if (tokens[i].length() <= 0) continue;
            retval.add(tokens[i]);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String constructTierDomain(HashSet<String> domainNodeIds, String tierConstraintSQL, SearchLayer firstSearchLayer) {
        String candidateConstraint;
        block44: {
            SQLException e2222222;
            ResultSet rs;
            Statement ps;
            Statement st;
            Connection con;
            block38: {
                ArrayList<String> tierConstraints = firstSearchLayer.getTierConstraints();
                candidateConstraint = this.constructCandidateConstraint(firstSearchLayer);
                if (firstSearchLayer.isEmpty()) {
                    candidateConstraint = "FALSE";
                }
                this._domainTiers.clear();
                this._domainTiersNodeId.clear();
                if (tierConstraints != null && !tierConstraints.contains(" All Tiers ")) {
                    StringBuilder tierConstraintPart = new StringBuilder("");
                    for (int i = 0; i < tierConstraints.size(); ++i) {
                        String constraint = tierConstraints.get(i);
                        if (constraint.startsWith(" Tier Name: ")) {
                            tierConstraintPart.append((tierConstraintPart.length() > 0 ? " OR " : "") + " tier_name = '");
                            tierConstraintPart.append(constraint.substring(" Tier Name: ".length())).append('\'');
                            continue;
                        }
                        if (constraint.startsWith(" Tier Type: ")) {
                            tierConstraintPart.append((tierConstraintPart.length() > 0 ? " OR " : "") + " tier_type = '");
                            tierConstraintPart.append(constraint.substring(" Tier Type: ".length())).append('\'');
                            continue;
                        }
                        if (constraint.startsWith(" Participant: ")) {
                            tierConstraintPart.append((tierConstraintPart.length() > 0 ? " OR " : "") + " participant = '");
                            tierConstraintPart.append(constraint.substring(" Participant: ".length())).append('\'');
                            continue;
                        }
                        if (constraint.startsWith(" Annotator: ")) {
                            tierConstraintPart.append((tierConstraintPart.length() > 0 ? " OR " : "") + " annotator = '");
                            tierConstraintPart.append(constraint.substring(" Annotator: ".length())).append('\'');
                            continue;
                        }
                        if (constraint.equals(" Must be in same file") || !constraint.equals(" Must be parent and child") && !constraint.equals(" Must have same parent")) continue;
                        logger.warn("constructTierDomain: Constraint makes no sense for 1st layer, ignored: '" + constraint + "'");
                    }
                    if (tierConstraintPart.length() > 0) {
                        tierConstraintSQL = tierConstraintSQL + " AND ( " + tierConstraintPart.toString() + " )";
                    }
                }
                con = null;
                st = null;
                ps = null;
                rs = null;
                con = DriverManager.getConnection(this.url, this.usr, this.pwd);
                st = con.createStatement();
                rs = st.executeQuery("SELECT sum(n_annotations) FROM search.tiers WHERE " + tierConstraintSQL);
                this.statistics.nAnnotationsSearched = 0;
                while (rs.next()) {
                    this.statistics.nAnnotationsSearched = rs.getInt(1);
                }
                rs.close();
                rs = null;
                st.close();
                st = null;
                String tierQuery = "SELECT node_id, tier_id, n_annotations FROM search.tiers WHERE " + candidateConstraint + " AND " + tierConstraintSQL + " ORDER BY node_id";
                logger.debug("constructTierDomain: " + tierQuery);
                ps = con.prepareStatement(tierQuery);
                ps.setFetchSize(500);
                rs = ps.executeQuery();
                while (rs.next()) {
                    String nodeId = rs.getString(1);
                    if (!domainNodeIds.contains(nodeId)) continue;
                    int tierId = rs.getInt(2);
                    this._domainTiers.add(tierId);
                    this._domainTiersNodeId.put(tierId, nodeId);
                }
                logger.debug("#tiers in domain: " + this._domainTiers.size() + ", annot in corpus for our file/tier types: " + this.statistics.nAnnotationsSearched);
                rs.close();
                rs = null;
                ps.close();
                ps = null;
                Object var14_15 = null;
                if (rs == null) break block38;
                try {
                    rs.close();
                }
                catch (SQLException e2222222) {
                    logger.error("constructTierDomain: ResultSet close failed: " + e2222222);
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e2222222) {
                    logger.error("constructTierDomain: Statement close failed: " + e2222222);
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e2222222) {
                    logger.error("constructTierDomain: PreparedStatement close failed: " + e2222222);
                }
            }
            try {
                con.close();
            }
            catch (SQLException ex) {
                logger.debug("setDomain, close connection", ex);
            }
            break block44;
            {
                catch (SQLException e) {
                    SQLException e2222222;
                    logger.debug("setDomain: SQLException: " + e, e);
                    Object var14_16 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e2222222) {
                            logger.error("constructTierDomain: ResultSet close failed: " + e2222222);
                        }
                    }
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e2222222) {
                            logger.error("constructTierDomain: Statement close failed: " + e2222222);
                        }
                    }
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException e2222222) {
                            logger.error("constructTierDomain: PreparedStatement close failed: " + e2222222);
                        }
                    }
                    try {
                        con.close();
                    }
                    catch (SQLException ex) {
                        logger.debug("setDomain, close connection", ex);
                    }
                }
            }
            catch (Throwable throwable) {
                SQLException e2222222;
                Object var14_17 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e2222222) {
                        logger.error("constructTierDomain: ResultSet close failed: " + e2222222);
                    }
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e2222222) {
                        logger.error("constructTierDomain: Statement close failed: " + e2222222);
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e2222222) {
                        logger.error("constructTierDomain: PreparedStatement close failed: " + e2222222);
                    }
                }
                try {
                    con.close();
                }
                catch (SQLException ex) {
                    logger.debug("setDomain, close connection", ex);
                }
                throw throwable;
            }
        }
        return candidateConstraint + " AND " + tierConstraintSQL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Object> getViewerParametersFor(int annId, int fileId) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        Connection con = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            con = DriverManager.getConnection(this.url, this.usr, this.pwd);
            statement = con.createStatement();
            rs = statement.executeQuery("SELECT begin_time, end_time, ann_tier_id FROM " + this.schemaName + ".annotations WHERE ann_id = " + annId);
            rs.next();
            long beginTime = this.getValue(rs, 1);
            long endTime = this.getValue(rs, 2);
            int tierId = rs.getInt(3);
            rs.close();
            rs = statement.executeQuery("SELECT tier_name, node_id FROM " + this.schemaName + ".tiers WHERE tier_id = " + tierId);
            rs.next();
            String tierName = rs.getString(1);
            String nodeId = rs.getString(2);
            rs.close();
            rs = null;
            statement.close();
            statement = null;
            parameters.add(nodeId);
            parameters.add(tierName);
            parameters.add(beginTime);
            parameters.add(endTime);
        }
        catch (SQLException e) {
            logger.warn("getViewerParametersFor: SQLException: " + e, e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e2) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e2) {}
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException ex) {}
        }
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<SearchHit> getHits(int fromIndex, int toIndex, int contextSize) {
        ArrayList<SearchHit> hitList = new ArrayList<SearchHit>();
        if (this.firstNonEmptyLayerIndex < 0 || this.firstNonEmptyLayerIndex >= this.nLayers || this.firstNonEmptyPatternIndex < 0 || this.firstNonEmptyPatternIndex >= this.nPatternsPerLayer) {
            logger.warn("Empty query? no results. FirstNonEmpty: " + this.firstNonEmptyPatternIndex + "/" + this.firstNonEmptyLayerIndex + " Matrix: " + this.nPatternsPerLayer + "*" + this.nLayers);
            return hitList;
        }
        Connection con = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            con = DriverManager.getConnection(this.url, this.usr, this.pwd);
            st = con.createStatement();
            ArrayList<Long> beginTimes = new ArrayList<Long>();
            int[][] hitAnnIds = new int[this.nLayers][this.nPatternsPerLayer];
            int[] savedHitAnnId = this.searchLayers[this.firstNonEmptyLayerIndex].getHitAnnIdsForPattern(this.firstNonEmptyPatternIndex);
            int[] savedHitNumber = this.searchLayers[this.firstNonEmptyLayerIndex].getHitNumberForPattern(this.firstNonEmptyPatternIndex);
            for (int i = fromIndex; i < toIndex && i < this.statistics.nHits && i < 100000; ++i) {
                SearchHit hit = new SearchHit();
                int annId = savedHitAnnId[i];
                rs = st.executeQuery("SELECT ann_position, annotation, begin_time, end_time, ann_tier_id FROM " + this.schemaName + ".annotations WHERE ann_id = " + annId);
                rs.next();
                hit.positionInTier = rs.getInt(1);
                if (this.isSimpleQuery) {
                    hit.annotation = rs.getString(2);
                    hit.beginTime = this.getValue(rs, 3);
                    hit.endTime = this.getValue(rs, 4);
                } else {
                    for (int layer = 0; layer < this.nLayers; ++layer) {
                        for (int pattern = 0; pattern < this.nPatternsPerLayer; ++pattern) {
                            int[] annIds = this.searchLayers[layer].getHitAnnIdsForPattern(pattern);
                            hitAnnIds[layer][pattern] = annIds != null ? annIds[i] : -1;
                        }
                    }
                    Statement st2 = con.createStatement();
                    SearchQuery.ComplexHitData hitData = this.constructComplexHitResultString(null, st2, hitAnnIds, true);
                    st2.close();
                    hit.annotation = hitData.hitString;
                    hit.beginTime = hitData.beginTime;
                    hit.endTime = hitData.endTime;
                }
                int ann_tier_id = rs.getInt(5);
                rs.close();
                rs = st.executeQuery("SELECT node_id, tier_name, tier_type, participant, annotator, n_annotations, aligned_annotations FROM " + this.schemaName + ".tiers WHERE tier_id = " + ann_tier_id);
                rs.next();
                hit.transcriptionNodeId = rs.getString(1);
                hit.transcriptionName = AnnexUtil.getNamePathFor(hit.transcriptionNodeId);
                hit.tierName = rs.getString(2);
                hit.tierType = this.isSimpleQuery ? rs.getString(3) : "xxxCOMPLEX_QUERY_INDICATORxxx";
                hit.participant = rs.getString(4);
                hit.annotator = rs.getString(5);
                int nAnnotationsInTier = rs.getInt(6);
                int nAlignedAnnotationsInTier = rs.getInt(7);
                rs.close();
                rs = null;
                hit.aligned = nAlignedAnnotationsInTier == nAnnotationsInTier;
                hit.hitNumberInAnnotation = savedHitNumber[i];
                String pattern = this.searchLayers[this.firstNonEmptyLayerIndex].getPattern(this.firstNonEmptyPatternIndex);
                boolean patternNOTMode = this.searchLayers[this.firstNonEmptyLayerIndex].getPatternNOTMode(this.firstNonEmptyPatternIndex);
                Pattern regExpPattern = this.searchLayers[this.firstNonEmptyLayerIndex].getRegExpPattern(this.firstNonEmptyPatternIndex);
                String[] queryModes = this.searchLayers[this.firstNonEmptyLayerIndex].getMode(this.firstNonEmptyPatternIndex);
                hit.hitPositionInAnnotation = this.getHitPosition(hit.annotation, hit.hitNumberInAnnotation, queryModes, pattern, regExpPattern, patternNOTMode);
                hit.hitLength = this.getHitLength(hit.annotation, hit.hitNumberInAnnotation, queryModes, pattern, regExpPattern, patternNOTMode);
                if (queryModes[0].equals(" N-gram over annotations")) {
                    int leftContextSize = contextSize + this.nGramSizeLeftFromHit;
                    rs = st.executeQuery("SELECT annotation, ann_position, begin_time FROM " + this.schemaName + ".annotations " + "WHERE ann_tier_id = " + ann_tier_id + " AND ann_position < " + hit.positionInTier + " AND ann_position >= " + (hit.positionInTier - leftContextSize) + " ORDER BY ann_position DESC");
                    beginTimes.clear();
                    while (rs.next()) {
                        hit.leftContext.add(rs.getString(1));
                        beginTimes.add(this.getValue(rs, 3));
                    }
                    rs.close();
                    rs = null;
                    for (int j = 0; j < this.nGramSizeLeftFromHit; ++j) {
                        if (hit.leftContext.size() <= 0) continue;
                        String part = hit.leftContext.get(0);
                        hit.annotation = part + " " + hit.annotation;
                        hit.beginTime = (Long)beginTimes.get(0);
                        hit.leftContext.remove(0);
                        beginTimes.remove(0);
                    }
                    int rightContextSize = contextSize + this.nGramSizeRightFromHit;
                    rs = st.executeQuery("SELECT annotation, ann_position, end_time FROM " + this.schemaName + ".annotations " + "WHERE ann_tier_id = " + ann_tier_id + " AND ann_position > " + hit.positionInTier + " AND ann_position <= " + (hit.positionInTier + rightContextSize) + " ORDER BY ann_position");
                    int n = 0;
                    while (rs.next()) {
                        if (n < this.nGramSizeRightFromHit) {
                            hit.annotation = hit.annotation + " " + rs.getString(1);
                            hit.endTime = this.getValue(rs, 3);
                        } else {
                            hit.rightContext.add(rs.getString(1));
                        }
                        ++n;
                    }
                    rs.close();
                    rs = null;
                    hit.hitPositionInAnnotation = 0;
                    hit.hitLength = hit.annotation.length();
                    hit.positionInTier -= leftContextSize;
                    ++hit.positionInTier;
                } else {
                    rs = st.executeQuery("SELECT annotation, ann_position FROM " + this.schemaName + ".annotations " + "WHERE ann_tier_id = " + ann_tier_id + " AND ann_position < " + hit.positionInTier + " AND ann_position >= " + (hit.positionInTier - contextSize) + " ORDER BY ann_position DESC");
                    while (rs.next()) {
                        hit.leftContext.add(rs.getString(1));
                    }
                    rs.close();
                    rs = st.executeQuery("SELECT annotation, ann_position FROM " + this.schemaName + ".annotations " + "WHERE ann_tier_id = " + ann_tier_id + " AND ann_position > " + hit.positionInTier + " AND ann_position <= " + (hit.positionInTier + contextSize) + " ORDER BY ann_position");
                    while (rs.next()) {
                        hit.rightContext.add(rs.getString(1));
                    }
                    rs.close();
                    rs = null;
                    ++hit.positionInTier;
                }
                hitList.add(hit);
            }
            st.close();
            st = null;
        }
        catch (SQLException e) {
            logger.warn("getHits: SQLException: " + e, e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e2) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e2) {}
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException ex) {}
        }
        return hitList;
    }

    private String escape(String string) {
        String s = string.replaceAll("~", "~~");
        s = s.replaceAll("%", "~%");
        s = s.replaceAll("'", "''");
        s = s.replaceAll("\"", "~\"");
        return s.replaceAll("_", "~_");
    }

    private String escapeRegExp(String regexp) {
        String s = regexp.replaceAll("'", "''");
        return s.replaceAll("\\\\", "\\\\\\\\");
    }

    @Override
    protected String convertRegexpPatternsIfNeeded(String queryString) {
        return this.convertRegexpPatternsForPostgres(queryString);
    }

    private String convertRegexpPatternsForPostgres(String queryString) {
        for (int i = 2; i < queryString.length(); ++i) {
            if (queryString.charAt(i) == 'b' && queryString.charAt(i - 1) == '\\' && queryString.charAt(i - 2) == '\\') {
                queryString = queryString.substring(0, i) + "y" + queryString.substring(i + 1);
                continue;
            }
            if (queryString.charAt(i) != 'B' || queryString.charAt(i - 1) != '\\' || queryString.charAt(i - 2) != '\\') continue;
            queryString = queryString.substring(0, i) + "Y" + queryString.substring(i + 1);
        }
        return queryString;
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            System.out.println("Dissecting regexp: '" + args[i] + "'");
            Collection<String> words = PostgresQuery.dissectRegexp(args[i]);
            TreeSet<String> sortedWords = new TreeSet<String>();
            sortedWords.addAll(words);
            for (String word : sortedWords) {
                System.out.println("\t'" + word + "'");
            }
        }
    }

    static {
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException e) {
            System.out.println("You need the PostgreSQL JDBC JAR in ClassPath");
            System.exit(1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueryExecutor
    implements Runnable {
        private static final int TIER_BLOCK_SIZE = 42;
        private Connection con;
        private String pattern;
        private boolean _patternNOTMode;
        private Pattern _regExpPattern;
        private String[] queryModes;
        private Statement statement;
        private PreparedStatement _getHitsInTier;
        private String _queryTierConstraint = "TRUE";

        public QueryExecutor(HashSet<String> domainNodeIds, String tierConstraintSQL) {
            try {
                this.con = DriverManager.getConnection(PostgresQuery.this.url, PostgresQuery.this.usr, PostgresQuery.this.pwd);
                this.statement = this.con.createStatement();
                if (PostgresQuery.this.firstNonEmptyPatternIndex >= 0) {
                    this.pattern = PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getPattern(PostgresQuery.this.firstNonEmptyPatternIndex);
                    this._patternNOTMode = PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getPatternNOTMode(PostgresQuery.this.firstNonEmptyPatternIndex);
                    this._regExpPattern = PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getRegExpPattern(PostgresQuery.this.firstNonEmptyPatternIndex);
                    this.queryModes = PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getMode(PostgresQuery.this.firstNonEmptyPatternIndex);
                } else {
                    logger.warn("QueryExecutor: All patterns empty");
                }
                if (PostgresQuery.this.firstNonEmptyLayerIndex >= 0) {
                    this._queryTierConstraint = PostgresQuery.this.constructTierDomain(domainNodeIds, tierConstraintSQL, PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex]);
                } else {
                    PostgresQuery.this._domainTiers.clear();
                    PostgresQuery.this._domainTiersNodeId.clear();
                    logger.warn("QueryExecutor: All layers empty");
                }
                logger.debug("QueryExecutor: constructTierDomain for " + domainNodeIds.size() + " node IDs took " + PostgresQuery.this.statistics.getAge() + " msec, got " + PostgresQuery.this._domainTiers.size() + " candidate tiers");
                StringBuilder queryString = new StringBuilder("SELECT ann_id, annotation, begin_time, end_time, ann_position, ann_tier_id FROM " + PostgresQuery.this.schemaName + ".annotations WHERE ");
                queryString.append(" ann_tier_id ");
                queryString.append("IN (");
                for (int i = 0; i < 42; ++i) {
                    queryString.append(" ?");
                    queryString.append(i != 41 ? "," : " ");
                }
                queryString.append(")");
                queryString.append(" AND (ann_tier_id BETWEEN ? AND ?)");
                queryString.append(" AND ");
                if (this.pattern != null) {
                    queryString.append(PostgresQuery.this.createQueryPatternPart(this.pattern, this.queryModes, this._regExpPattern, this._patternNOTMode));
                } else {
                    logger.warn("QueryExecutor: Pattern empty");
                    queryString.append(" 42 = 43");
                }
                queryString.append(PostgresQuery.this.createGlobalTimeConstraintPart());
                String query = PostgresQuery.this.convertRegexpPatternsForPostgres(queryString.toString());
                logger.debug("query: " + query.replaceAll("[?], [?, ]*", "... "));
                this._getHitsInTier = this.con.prepareStatement(query);
            }
            catch (SQLException e) {
                logger.debug("constructor query executor", e);
                try {
                    this.con.close();
                }
                catch (SQLException ex) {
                    logger.debug("closing connection", ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int fileIndex = 42;
            String previousNodeId = "none";
            if (this.pattern == null || PostgresQuery.this.firstNonEmptyLayerIndex < 0 || PostgresQuery.this.firstNonEmptyPatternIndex < 0 || PostgresQuery.this._domainTiers.size() == 0) {
                if (PostgresQuery.this._domainTiers.size() > 0) {
                    logger.warn("Bad or empty query: " + (this.pattern == null ? "null" : "") + " at " + PostgresQuery.this.firstNonEmptyPatternIndex + "/" + PostgresQuery.this.firstNonEmptyLayerIndex);
                }
                PostgresQuery.this.statistics.progress = 1.0f;
                PostgresQuery.this.isExecuting = false;
                return;
            }
            ResultSet rs = null;
            try {
                int whichParam = 1;
                int minTier = Integer.MAX_VALUE;
                int maxTier = Integer.MIN_VALUE;
                for (int i = 0; i < PostgresQuery.this._domainTiers.size(); ++i) {
                    int checkTierId = (Integer)PostgresQuery.this._domainTiers.get(i);
                    this._getHitsInTier.setInt(whichParam, checkTierId);
                    minTier = checkTierId < minTier ? checkTierId : minTier;
                    int n = maxTier = checkTierId > maxTier ? checkTierId : maxTier;
                    if (++whichParam <= 42 && i < PostgresQuery.this._domainTiers.size() - 1) continue;
                    while (whichParam <= 42) {
                        this._getHitsInTier.setInt(whichParam, Integer.MIN_VALUE);
                        ++whichParam;
                    }
                    this._getHitsInTier.setInt(whichParam++, minTier);
                    this._getHitsInTier.setInt(whichParam++, maxTier);
                    whichParam = 1;
                    rs = this._getHitsInTier.executeQuery();
                    boolean logLayerq = true;
                    while (rs.next()) {
                        int annId = rs.getInt(1);
                        int tierId = rs.getInt(6);
                        if (PostgresQuery.this._domainTiersNodeId.get(tierId) == null) {
                            logger.debug("Hit in corpus but outside domain skipped: " + annId + " in " + tierId);
                            continue;
                        }
                        String annotation = rs.getString(2);
                        if (PostgresQuery.this.isSimpleQuery) {
                            if (this.queryModes[0].equals(" Annotation")) {
                                long beginTime = PostgresQuery.this.getValue(rs, 3);
                                long endTime = PostgresQuery.this.getValue(rs, 4);
                                if (!PostgresQuery.this.isDurationInRange(endTime - beginTime)) continue;
                                PostgresQuery.this.updateFrequencyStatistics(annotation, annId, 42, PostgresQuery.this.firstNonEmptyLayerIndex, PostgresQuery.this.firstNonEmptyPatternIndex);
                                ++PostgresQuery.this.statistics.nAnnotationsWithHit;
                                int nHitsInAnnotation = 1;
                                if (PostgresQuery.this.patternNeedsFullStatistics) {
                                    nHitsInAnnotation = PostgresQuery.this.countHitsInAnnotation(annotation, this.queryModes, this.pattern, this._regExpPattern, this._patternNOTMode);
                                }
                                for (int j = 0; j < nHitsInAnnotation; ++j) {
                                    if (PostgresQuery.this.statistics.nHits < 100000) {
                                        PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getHitAnnIdsForPattern((int)PostgresQuery.this.firstNonEmptyPatternIndex)[PostgresQuery.this.statistics.nHits] = annId;
                                        PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getHitNumberForPattern((int)PostgresQuery.this.firstNonEmptyPatternIndex)[PostgresQuery.this.statistics.nHits] = j + 1;
                                        PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getHitFileIds()[PostgresQuery.this.statistics.nHits] = 42;
                                    }
                                    ++PostgresQuery.this.statistics.nHits;
                                }
                            } else {
                                String[] nGrams;
                                if (this.queryModes[0].equals(" N-gram over annotations")) {
                                    PostgresQuery.this.nGramSizeLeftFromHit = PostgresQuery.this.getLongestNonWildcardPartPosition(this.pattern);
                                    PostgresQuery.this.nGramSizeRightFromHit = PostgresQuery.this.getNGramLength(this.pattern) - PostgresQuery.this.nGramSizeLeftFromHit - 1;
                                }
                                if ((nGrams = PostgresQuery.this.constructNGrams(annId, this.statement, PostgresQuery.this.schemaName, this.pattern, this.queryModes)) != null) {
                                    boolean frequencyStatisticsUpdated = false;
                                    boolean firstNAnnotationsUpdate = true;
                                    int hitNumber = 1;
                                    for (int j = 0; j < nGrams.length; ++j) {
                                        String nGram = nGrams[j];
                                        if (!PostgresQuery.this.isNGramMatch(nGram, this.pattern, this.queryModes)) continue;
                                        if (!frequencyStatisticsUpdated) {
                                            nGram = nGram.replace("xxxSAFE_SPLITTERxxx", " ");
                                            PostgresQuery.this.updateFrequencyStatistics(nGram, annId, 42, PostgresQuery.this.firstNonEmptyLayerIndex, PostgresQuery.this.firstNonEmptyPatternIndex);
                                            frequencyStatisticsUpdated = true;
                                        }
                                        if (this.queryModes[0].equals(" N-gram over annotations") || firstNAnnotationsUpdate) {
                                            ++PostgresQuery.this.statistics.nAnnotationsWithHit;
                                            firstNAnnotationsUpdate = false;
                                        }
                                        if (PostgresQuery.this.statistics.nHits < 100000) {
                                            PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getHitAnnIdsForPattern((int)PostgresQuery.this.firstNonEmptyPatternIndex)[PostgresQuery.this.statistics.nHits] = annId;
                                            PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getHitNumberForPattern((int)PostgresQuery.this.firstNonEmptyPatternIndex)[PostgresQuery.this.statistics.nHits] = hitNumber++;
                                            PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getHitFileIds()[PostgresQuery.this.statistics.nHits] = 42;
                                        }
                                        ++PostgresQuery.this.statistics.nHits;
                                    }
                                }
                            }
                        } else {
                            String currentNodeId = (String)PostgresQuery.this._domainTiersNodeId.get(tierId);
                            if (!currentNodeId.equals(previousNodeId)) {
                                previousNodeId = currentNodeId;
                                if (PostgresQuery.this.isMultipleLayerQuery) {
                                    PostgresQuery.this.setTierDomainForLayers(true, this.statement, currentNodeId);
                                }
                            }
                            PostgresQuery.this.clearHitData(42);
                            PostgresQuery.this.globalHitAnnId[PostgresQuery.this.firstNonEmptyLayerIndex][PostgresQuery.this.firstNonEmptyPatternIndex] = annId;
                            PostgresQuery.this.globalHitTierId[PostgresQuery.this.firstNonEmptyLayerIndex][PostgresQuery.this.firstNonEmptyPatternIndex] = tierId;
                            PostgresQuery.this.globalHitBeginTime[PostgresQuery.this.firstNonEmptyLayerIndex][PostgresQuery.this.firstNonEmptyPatternIndex] = PostgresQuery.this.getValue(rs, 3);
                            PostgresQuery.this.globalHitEndTime[PostgresQuery.this.firstNonEmptyLayerIndex][PostgresQuery.this.firstNonEmptyPatternIndex] = PostgresQuery.this.getValue(rs, 4);
                            PostgresQuery.this.globalHitPosition[PostgresQuery.this.firstNonEmptyLayerIndex][PostgresQuery.this.firstNonEmptyPatternIndex] = rs.getInt(5);
                            PostgresQuery.this.investigateComplexPattern(PostgresQuery.this.firstNonEmptyLayerIndex, PostgresQuery.this.firstNonEmptyPatternIndex, this.con, logLayerq);
                            logLayerq = false;
                        }
                        if (PostgresQuery.this.keepExecuting) continue;
                        break;
                    }
                    rs.close();
                    PostgresQuery.this.statistics.progress = i == PostgresQuery.this._domainTiers.size() - 1 ? 1.0f : (float)i / (float)PostgresQuery.this._domainTiers.size();
                    if (!PostgresQuery.this.keepExecuting) break;
                }
                PostgresQuery.this.statistics.progress = 1.0f;
            }
            catch (SQLException e) {
                logger.warn("exception during query execution", e);
                PostgresQuery.this.statistics.progress = 1.0f;
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e2) {}
                }
                try {
                    this.con.close();
                    this._getHitsInTier.close();
                }
                catch (SQLException ex) {
                    logger.debug("exception during finally part of query execution", ex);
                }
            }
            logger.debug("Query finished: " + PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getPattern(PostgresQuery.this.firstNonEmptyPatternIndex) + "... took: " + PostgresQuery.this.statistics.getAge() + " msec, progress: " + PostgresQuery.this.statistics.progress);
            PostgresQuery.this.isExecuting = false;
        }
    }
}

