/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annex.search;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import nl.mpi.annex.search.PostgresQuery;
import nl.mpi.annex.search.SearchCorpusDB;
import nl.mpi.annex.util.AnnexUtil;

public class SearchClient {
    private String url;
    private String usr;
    private String pwd;
    private SearchCorpusDB scdb;

    public SearchClient(String jdbc, String user, String pass) throws SQLException {
        this.url = jdbc;
        if (user == null || pass == null) {
            System.err.println("User or password not set");
        }
        this.usr = user;
        this.pwd = pass;
        this.scdb = new SearchCorpusDB(this.url, this.usr, this.pwd);
    }

    public SearchClient(String corpusDBHost, String corpusDBUser, String corpusDBPwd, String searchDBHost, String searchDBUser, String searchDBPwd) throws SQLException {
        AnnexUtil.setCorpusDB(corpusDBHost, corpusDBUser, corpusDBPwd);
        this.scdb = new SearchCorpusDB(searchDBHost, searchDBUser, searchDBPwd);
    }

    public static String[] getSearchableFormats() {
        String[] types = new String[]{"text/x-eaf+xml", "text/x-shoebox-text", "text/x-shoebox-text".replaceFirst("shoe", "tool"), "text/x-chat", "text/plain", "text/html", "text/xml", "text/csv"};
        return types;
    }

    public void close() {
        this.scdb.close();
    }

    public PostgresQuery createQuery() {
        return new PostgresQuery(this.url, this.usr, this.pwd);
    }

    public synchronized void add(String nodeId) throws SQLException {
        this.scdb.addNode(nodeId);
    }

    public synchronized void remove(String nodeId) throws SQLException {
        this.scdb.removeNode(nodeId);
    }

    public synchronized void update(String nodeId) throws SQLException {
        this.remove(nodeId);
        this.add(nodeId);
    }

    public PreparedStatement getPreparedStatement(String statement) throws SQLException {
        return this.scdb.getPreparedStatement(statement);
    }
}

