/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annex.swingsearch;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.basic.BasicArrowButton;
import nl.mpi.annex.search.Constants;
import nl.mpi.annex.swingsearch.SearchDomainPanel;
import nl.mpi.annex.swingsearch.SearchHistoryPanel;
import nl.mpi.annex.swingsearch.SearchListener;
import nl.mpi.annex.swingsearch.SearchMediator;
import nl.mpi.annex.swingsearch.SearchResultPanel;
import nl.mpi.annex.swingsearch.SearchUtil;

public class MultipleLayerSearchPanel
extends JPanel
implements SearchListener,
ActionListener {
    private static final String DELTA = "\u0394";
    private int nROWS;
    private int nCOLS;
    private SearchMediator mediator;
    private Color backgroundColor;
    private String queryId;
    private SearchDomainPanel domainPanel;
    private SearchHistoryPanel historyPanel;
    private JPanel patternPanel;
    private SearchResultPanel resultPanel;
    private JComboBox caseModeChooser;
    private JComboBox matchModeChooser;
    private JTextField[] patternFields;
    private ConstraintLabel[][] horizontalRelations;
    private ConstraintLabel[][] verticalRelations;
    private JComboBox[] layerTiers;
    private JComboBox[] layerTiers2;
    private ConstraintLabel popupSource;
    private JPopupMenu horizontalRelationMenu;
    private JPopupMenu verticalRelationMenu;
    private boolean relationPending = false;
    private JButton minDurationButton;
    private JButton maxDurationButton;
    private JButton beginAfterButton;
    private JButton endBeforeButton;
    private long minimalDuration;
    private long maximalDuration;
    private long beginAfter;
    private long endBefore;

    public MultipleLayerSearchPanel(SearchMediator mediator) {
        this(mediator, 3, 2);
    }

    public MultipleLayerSearchPanel(SearchMediator mediator, int nLayers, int nColumns) {
        int j;
        if (nLayers < 1 || nColumns < 1) {
            throw new IllegalArgumentException("Must have at least 1 layer and column");
        }
        this.mediator = mediator;
        this.backgroundColor = mediator.getBackgroundColor();
        this.setBackground(this.backgroundColor);
        this.queryId = mediator.createQuery();
        this.setLayout(new BoxLayout(this, 1));
        JPanel definitionPanel = new JPanel();
        definitionPanel.setLayout(new BoxLayout(definitionPanel, 1));
        definitionPanel.setBackground(this.backgroundColor);
        this.add(definitionPanel);
        this.domainPanel = new SearchDomainPanel(mediator, this.queryId, this);
        definitionPanel.add(this.domainPanel);
        definitionPanel.add(Box.createVerticalStrut(15));
        this.historyPanel = new SearchHistoryPanel(this, this.backgroundColor);
        this.historyPanel.setHistory(mediator.getPersistent("multipleTierHistory"));
        definitionPanel.add(this.historyPanel);
        definitionPanel.add(Box.createVerticalStrut(15));
        JPanel modePanel = new JPanel();
        modePanel.setBackground(this.backgroundColor);
        modePanel.setLayout(new BoxLayout(modePanel, 0));
        JLabel modeLabel = new JLabel("Mode:");
        modeLabel.setFont(Constants.bigBoldFont);
        modePanel.add(Box.createHorizontalStrut(5));
        modePanel.add(modeLabel);
        modePanel.add(Box.createHorizontalStrut(10));
        ArrayList<String> searchModes = mediator.getSearchModes(this.queryId);
        int i = 0;
        int nTargetModes = Integer.parseInt(searchModes.get(i));
        for (int j2 = 0; j2 < nTargetModes; ++j2) {
            ++i;
        }
        modePanel.add(Box.createHorizontalStrut(5));
        int nCaseModes = Integer.parseInt(searchModes.get(++i));
        String[] caseModes = new String[nCaseModes];
        for (int j3 = 0; j3 < nCaseModes; ++j3) {
            caseModes[j3] = searchModes.get(++i);
        }
        this.caseModeChooser = new JComboBox<String>(caseModes);
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.caseModeChooser.setBackground(this.backgroundColor);
        }
        modePanel.add(this.caseModeChooser);
        modePanel.add(Box.createHorizontalStrut(5));
        int nMatchModes = Integer.parseInt(searchModes.get(++i));
        String[] matchModes = new String[nMatchModes];
        for (j = 0; j < nMatchModes; ++j) {
            matchModes[j] = searchModes.get(++i);
        }
        this.matchModeChooser = new JComboBox();
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.matchModeChooser.setBackground(this.backgroundColor);
        }
        for (j = 0; j < matchModes.length; ++j) {
            this.matchModeChooser.addItem(matchModes[j]);
        }
        modePanel.add(this.matchModeChooser);
        modePanel.add(Box.createHorizontalGlue());
        modePanel.add(this.makeButton("Clear", "clear"));
        modePanel.add(Box.createHorizontalStrut(30));
        definitionPanel.add(modePanel);
        definitionPanel.add(Box.createVerticalStrut(15));
        JPanel timeButtonPanel = new JPanel();
        timeButtonPanel.setBackground(this.backgroundColor);
        timeButtonPanel.setLayout(new BoxLayout(timeButtonPanel, 0));
        timeButtonPanel.add(Box.createHorizontalStrut(30));
        this.minDurationButton = this.makeButton("Minimal Duration", "min duration");
        timeButtonPanel.add(this.minDurationButton);
        timeButtonPanel.add(Box.createHorizontalStrut(15));
        this.maxDurationButton = this.makeButton("Maximal Duration", "max duration");
        timeButtonPanel.add(this.maxDurationButton);
        timeButtonPanel.add(Box.createHorizontalStrut(15));
        this.beginAfterButton = this.makeButton("Begin After", "begin after");
        timeButtonPanel.add(this.beginAfterButton);
        timeButtonPanel.add(Box.createHorizontalStrut(15));
        this.endBeforeButton = this.makeButton("End Before", "end before");
        timeButtonPanel.add(this.endBeforeButton);
        timeButtonPanel.add(Box.createHorizontalGlue());
        definitionPanel.add(timeButtonPanel);
        definitionPanel.add(Box.createVerticalStrut(15));
        this.patternPanel = new JPanel();
        this.patternPanel.setLayout(new BoxLayout(this.patternPanel, 0));
        this.patternPanel.setBackground(this.backgroundColor);
        definitionPanel.add(this.patternPanel);
        definitionPanel.add(Box.createVerticalStrut(15));
        this.layoutGridGUI(nColumns, nLayers, false);
        JPanel findPanel = new JPanel();
        findPanel.setLayout(new BoxLayout(findPanel, 0));
        findPanel.setBackground(this.backgroundColor);
        findPanel.add(Box.createHorizontalStrut(30));
        findPanel.add(this.makeButton("Find", "find"));
        findPanel.add(Box.createHorizontalGlue());
        findPanel.add(this.makeButton("Fewer Columns", "cols--"));
        findPanel.add(this.makeButton("More Columns", "cols++"));
        findPanel.add(this.makeButton("Fewer Layers", "rows--"));
        findPanel.add(this.makeButton("More Layers", "rows++"));
        findPanel.add(Box.createHorizontalStrut(30));
        definitionPanel.add(findPanel);
        definitionPanel.add(Box.createVerticalStrut(15));
        this.resultPanel = new SearchResultPanel(mediator, this.queryId);
        this.add(this.resultPanel);
        this.add(Box.createVerticalGlue());
        this.horizontalRelationMenu = this.makeHorizontalRelations();
        this.verticalRelationMenu = this.makeVerticalRelations();
    }

    private JButton makeButton(String text, String action) {
        JButton button = new JButton(text);
        button.setActionCommand(action);
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            button.setBackground(this.backgroundColor);
        }
        button.addActionListener(this);
        return button;
    }

    private void layoutGridGUI(int cols, int rows, boolean preserve) {
        int k;
        int j;
        JComboBox[] oldLayerTiers = null;
        JComboBox[] oldLayerTiers2 = null;
        JTextField[] oldPatternFields = null;
        ConstraintLabel[][] oldHorizontalRelations = null;
        ConstraintLabel[][] oldVerticalRelations = null;
        int oldCOLS = 0;
        if (preserve) {
            oldCOLS = this.nCOLS;
            oldLayerTiers = this.layerTiers;
            oldLayerTiers2 = this.layerTiers2;
            oldPatternFields = this.patternFields;
            oldHorizontalRelations = this.horizontalRelations;
            oldVerticalRelations = this.verticalRelations;
        }
        this.nCOLS = cols;
        this.nROWS = rows;
        JPanel[] columns = new JPanel[2 * this.nCOLS];
        this.patternPanel.removeAll();
        this.patternPanel.add(Box.createHorizontalStrut(30));
        for (int j2 = 0; j2 < 2 * this.nCOLS; ++j2) {
            JPanel column = new JPanel();
            column.setLayout(new GridLayout(0, 1, 0, 6));
            column.setBackground(this.backgroundColor);
            columns[j2] = column;
            this.patternPanel.add(column);
            if (j2 == 2 * this.nCOLS - 2) {
                this.patternPanel.add(Box.createHorizontalStrut(20));
                continue;
            }
            if (j2 == 2 * this.nCOLS - 1) {
                this.patternPanel.add(Box.createHorizontalStrut(30));
                continue;
            }
            this.patternPanel.add(Box.createHorizontalStrut(5));
        }
        MouseHandler mouseHandler = new MouseHandler();
        this.patternFields = new JTextField[this.nROWS * this.nCOLS];
        ArrayList<Component> order = new ArrayList<Component>();
        for (j = 0; j < this.nROWS * this.nCOLS; ++j) {
            this.patternFields[j] = new JTextField(10);
            this.patternFields[j].setFont(Constants.normalFont);
            this.patternFields[j].setHorizontalAlignment(0);
            order.add(this.patternFields[j]);
        }
        this.horizontalRelations = new ConstraintLabel[this.nROWS][this.nCOLS - 1];
        this.verticalRelations = new ConstraintLabel[this.nROWS - 1][this.nCOLS];
        for (j = 0; j < this.nROWS; ++j) {
            for (k = 0; k < this.nCOLS - 1; ++k) {
                this.horizontalRelations[j][k] = new ConstraintLabel(mouseHandler);
            }
        }
        for (j = 0; j < this.nROWS - 1; ++j) {
            for (k = 0; k < this.nCOLS; ++k) {
                this.verticalRelations[j][k] = new ConstraintLabel(mouseHandler);
            }
        }
        for (j = 0; j < this.nCOLS + this.nCOLS - 1; ++j) {
            if ((j & 1) == 0) {
                for (k = 0; k < this.nROWS; ++k) {
                    columns[j].add(this.patternFields[k * this.nCOLS + (j >> 1)]);
                    if (k < this.nROWS - 1) {
                        columns[j].add(this.verticalRelations[k][j >> 1]);
                        continue;
                    }
                    columns[j].setMinimumSize(new Dimension(120, 20 * (this.nROWS + this.nROWS - 1)));
                }
                continue;
            }
            for (k = 0; k < this.nROWS; ++k) {
                columns[j].add(this.horizontalRelations[k][j - 1 >> 1]);
                if (k < this.nROWS - 1) {
                    columns[j].add(Box.createVerticalGlue());
                    continue;
                }
                columns[j].setMinimumSize(new Dimension(42, 20 * (this.nROWS + this.nROWS - 1)));
                columns[j].setPreferredSize(new Dimension(80, 20 * (this.nROWS + this.nROWS - 1)));
            }
        }
        Dimension comboSize = new Dimension(200, 28);
        this.layerTiers = new JComboBox[this.nROWS];
        this.layerTiers2 = new JComboBox[this.nROWS - 1];
        for (int j3 = 0; j3 < this.nROWS; ++j3) {
            this.layerTiers[j3] = new JComboBox();
            this.layerTiers[j3].setMaximumRowCount(20);
            this.layerTiers[j3].setPreferredSize(comboSize);
            if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
                this.layerTiers[j3].setBackground(this.backgroundColor);
            }
            columns[2 * this.nCOLS - 1].add(this.layerTiers[j3]);
            if (j3 == this.nROWS - 1) continue;
            this.layerTiers2[j3] = new JComboBox();
            this.layerTiers2[j3].setPreferredSize(comboSize);
            if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
                this.layerTiers2[j3].setBackground(this.backgroundColor);
            }
            this.layerTiers2[j3].addItem(" Must be in same file");
            this.layerTiers2[j3].addItem(" Must be parent and child");
            this.layerTiers2[j3].addItem(" Must have same parent");
            this.layerTiers2[j3].setEnabled(true);
            this.layerTiers2[j3].setBackground(Constants.CONSTRAINT_LABEL_COLOR);
            this.layerTiers2[j3].setSelectedItem(" Must be in same file");
            columns[2 * this.nCOLS - 1].add(this.layerTiers2[j3]);
        }
        columns[2 * this.nCOLS - 1].setMinimumSize(new Dimension(150, 20 * (this.nROWS + this.nROWS - 1)));
        try {
            Method sftppMethod = Container.class.getDeclaredMethod("setFocusTraversalPolicyProvider", Boolean.TYPE);
            if (sftppMethod != null) {
                sftppMethod.invoke((Object)this, true);
            }
        }
        catch (InvocationTargetException ite) {
            System.out.println("Cannot set traversal policy: InvocationTargetException " + ite);
        }
        catch (NoSuchMethodException nsme) {
            System.out.println("Cannot set traversal policy: NoSuchMethodException " + nsme);
        }
        catch (IllegalAccessException iae) {
            System.out.println("Cannot set traversal policy: IllegalAccessException " + iae);
        }
        this.setFocusTraversalPolicy(new MyOwnFocusTraversalPolicy(order));
        this.fillTierConstraintsCombos();
        if (preserve) {
            int j4;
            int i;
            for (i = 0; i < Math.min(this.layerTiers.length, oldLayerTiers.length); ++i) {
                this.layerTiers[i].setSelectedItem(oldLayerTiers[i].getSelectedItem());
            }
            for (i = 0; i < Math.min(this.layerTiers2.length, oldLayerTiers2.length); ++i) {
                this.layerTiers2[i].setSelectedItem(oldLayerTiers2[i].getSelectedItem());
            }
            for (i = 0; i < Math.min(this.horizontalRelations.length, oldHorizontalRelations.length); ++i) {
                for (j4 = 0; j4 < Math.min(this.horizontalRelations[0].length, oldHorizontalRelations[0].length); ++j4) {
                    this.horizontalRelations[i][j4].setText(oldHorizontalRelations[i][j4].getText());
                    this.horizontalRelations[i][j4].setConstraint(oldHorizontalRelations[i][j4].getConstraint());
                }
            }
            for (i = 0; i < Math.min(this.verticalRelations.length, oldVerticalRelations.length); ++i) {
                for (j4 = 0; j4 < Math.min(this.verticalRelations[0].length, oldVerticalRelations[0].length); ++j4) {
                    this.verticalRelations[i][j4].setText(oldVerticalRelations[i][j4].getText());
                    this.verticalRelations[i][j4].setConstraint(oldVerticalRelations[i][j4].getConstraint());
                }
            }
            for (i = 0; i < Math.min(this.layerTiers.length, oldLayerTiers.length); ++i) {
                for (j4 = 0; j4 < Math.min(this.nCOLS, oldCOLS); ++j4) {
                    this.patternFields[i * this.nCOLS + j4].setText(oldPatternFields[i * oldCOLS + j4].getText());
                }
            }
        }
        this.validate();
    }

    private JMenuItem makeMenuItem(String text, String action) {
        JMenuItem item = new JMenuItem(text);
        item.setActionCommand(action);
        item.addActionListener(this);
        return item;
    }

    private JPopupMenu makeHorizontalRelations() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.makeMenuItem("= N annotations", "hAnnEqual"));
        menu.add(this.makeMenuItem("> N annotations", "hAnnMore"));
        menu.add(this.makeMenuItem("< N annotations", "hAnnLess"));
        menu.addSeparator();
        menu.add(this.makeMenuItem("= X milliseconds", "hMilEqual"));
        menu.add(this.makeMenuItem("> X milliseconds", "hMilMore"));
        menu.add(this.makeMenuItem("< X milliseconds", "hMilLess"));
        menu.addSeparator();
        menu.add(this.makeMenuItem("No constraint", "hNoConstraint"));
        menu.add(this.makeMenuItem("Clear", "hClear"));
        return menu;
    }

    private JPopupMenu makeVerticalRelations() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.makeMenuItem("Fully aligned", "vFullyAligned"));
        menu.add(this.makeMenuItem("Overlap", "vOverlap"));
        menu.add(this.makeMenuItem("Left overlap", "vLeftOverlap"));
        menu.add(this.makeMenuItem("Right overlap", "vRightOverlap"));
        menu.add(this.makeMenuItem("Surrounding", "vSurrounding"));
        menu.add(this.makeMenuItem("Within", "vWithin"));
        menu.add(this.makeMenuItem("No overlap", "vNoOverlap"));
        menu.addSeparator();
        menu.add(this.makeMenuItem("begin time - begin time = X msec", "vBeginBeginEqual"));
        menu.add(this.makeMenuItem("begin time - begin time < X msec", "vBeginBeginLess"));
        menu.add(this.makeMenuItem("begin time - begin time > X msec", "vBeginBeginMore"));
        menu.addSeparator();
        menu.add(this.makeMenuItem("begin time - end time = X msec", "vBeginEndEqual"));
        menu.add(this.makeMenuItem("begin time - end time < X msec", "vBeginEndLess"));
        menu.add(this.makeMenuItem("begin time - end time > X msec", "vBeginEndMore"));
        menu.addSeparator();
        menu.add(this.makeMenuItem("end time - begin time = X msec", "vEndBeginEqual"));
        menu.add(this.makeMenuItem("end time - begin time < X msec", "vEndBeginLess"));
        menu.add(this.makeMenuItem("end time - begin time > X msec", "vEndBeginMore"));
        menu.addSeparator();
        menu.add(this.makeMenuItem("end time - end time = X msec", "vEndEndEqual"));
        menu.add(this.makeMenuItem("end time - end time < X msec", "vEndEndLess"));
        menu.add(this.makeMenuItem("end time - end time > X msec", "vEndEndMore"));
        menu.addSeparator();
        menu.add(this.makeMenuItem("No constraint", "vNoConstraint"));
        menu.add(this.makeMenuItem("Clear", "vClear"));
        return menu;
    }

    public void fillTierConstraintsCombos() {
        int i;
        if (this.mediator.getDomainInitializationProgress(this.queryId) < 1.0f) {
            for (int i2 = 0; i2 < this.nROWS; ++i2) {
                this.layerTiers[i2].removeAllItems();
                this.layerTiers[i2].addItem("Loading...");
                this.layerTiers[i2].setEnabled(false);
            }
            return;
        }
        boolean okay = false;
        while (!okay) {
            try {
                okay = true;
                for (i = 0; i < this.nROWS; ++i) {
                    if (this.layerTiers[i] != null) continue;
                    okay = false;
                }
                Thread.currentThread();
                Thread.sleep(200L);
            }
            catch (InterruptedException ie) {}
        }
        for (i = 0; i < this.nROWS; ++i) {
            this.layerTiers[i].removeAllItems();
            this.layerTiers[i].addItem(" All Tiers ");
            ArrayList<String> tierTypes = this.mediator.getTierTypes(this.queryId);
            for (int j = 0; j < tierTypes.size(); ++j) {
                this.layerTiers[i].addItem(" Tier Type: " + tierTypes.get(j));
            }
            ArrayList<String> tierNames = this.mediator.getTierNames(this.queryId);
            for (int j = 0; j < tierNames.size(); ++j) {
                this.layerTiers[i].addItem(" Tier Name: " + tierNames.get(j));
            }
            ArrayList<String> participants = this.mediator.getParticipants(this.queryId);
            for (int j = 0; j < participants.size(); ++j) {
                this.layerTiers[i].addItem(" Participant: " + participants.get(j));
            }
            ArrayList<String> annotators = this.mediator.getAnnotators(this.queryId);
            for (int j = 0; j < annotators.size(); ++j) {
                this.layerTiers[i].addItem(" Annotator: " + annotators.get(j));
            }
            this.layerTiers[i].setEnabled(true);
        }
    }

    public void domainChanged() {
        this.resetPatterns();
        this.resetRelations();
        this.fillTierConstraintsCombos();
        this.validate();
    }

    public void queryStopped() {
    }

    public void setQuery(String savedQuery) {
        int j;
        int i;
        String[] q = savedQuery.split("xxxSAFE_SPLITTERxxx");
        if (q.length != 3 + this.nROWS * this.nCOLS + 2 * this.nROWS * (this.nCOLS - 1) + 2 * (this.nROWS - 1) * this.nCOLS + this.nROWS + 1) {
            String[] magic = q[q.length - 1].split(":");
            if (magic.length == 6) {
                this.layoutGridGUI(Integer.parseInt(magic[4]), Integer.parseInt(magic[5]), false);
                this.setQuery(savedQuery);
            } else {
                int rows = 3;
                int cols = 3;
                this.layoutGridGUI(cols, rows, false);
                this.setQuery(savedQuery);
            }
        }
        int x = 0;
        int n = ++x;
        this.caseModeChooser.setSelectedItem(q[n]);
        int n2 = ++x;
        ++x;
        this.matchModeChooser.setSelectedItem(q[n2]);
        for (i = 0; i < this.nROWS * this.nCOLS; ++i) {
            this.patternFields[i].setText(q[x++]);
        }
        for (i = 0; i < this.nROWS; ++i) {
            for (j = 0; j < this.nCOLS - 1; ++j) {
                this.horizontalRelations[i][j].setText(q[x++]);
                this.horizontalRelations[i][j].setConstraint(q[x++]);
            }
        }
        for (i = 0; i < this.nROWS - 1; ++i) {
            for (j = 0; j < this.nCOLS; ++j) {
                this.verticalRelations[i][j].setText(q[x++]);
                this.verticalRelations[i][j].setConstraint(q[x++]);
            }
        }
        for (int j2 = 0; j2 < this.nROWS; ++j2) {
            String tierConstraints = q[x++];
            String tierRelation = "";
            if (tierConstraints.startsWith(" Must be in same file")) {
                tierRelation = " Must be in same file";
            } else if (tierConstraints.startsWith(" Must be parent and child")) {
                tierRelation = " Must be parent and child";
            } else if (tierConstraints.startsWith(" Must have same parent")) {
                tierRelation = " Must have same parent";
            }
            String tierConstraint = tierConstraints.substring(tierRelation.length());
            if (tierRelation.length() == 0) {
                tierRelation = " Must be in same file";
            }
            if (j2 > 0) {
                this.layerTiers2[j2 - 1].setSelectedItem(tierRelation);
            }
            this.layerTiers[j2].setSelectedItem(tierConstraint);
        }
        String[] times = q[x++].split(":");
        this.minimalDuration = Long.parseLong(times[0]);
        if (this.minimalDuration <= 0L) {
            this.minDurationButton.setText("Minimal Duration");
            this.minimalDuration = 0L;
        } else if (this.minimalDuration > 0L) {
            this.minDurationButton.setText("Minimal Duration: " + SearchUtil.formatShortTimeString(this.minimalDuration));
        }
        this.maximalDuration = Long.parseLong(times[1]);
        if (this.maximalDuration <= 0L) {
            this.maxDurationButton.setText("Maximal Duration");
            this.maximalDuration = 0L;
        } else if (this.maximalDuration > 0L) {
            this.maxDurationButton.setText("Maximal Duration: " + SearchUtil.formatShortTimeString(this.maximalDuration));
        }
        this.beginAfter = Long.parseLong(times[2]);
        if (this.beginAfter <= 0L) {
            this.beginAfterButton.setText("Begin After");
            this.beginAfter = 0L;
        } else if (this.beginAfter > 0L) {
            this.beginAfterButton.setText("Begin After: " + SearchUtil.formatShortTimeString(this.beginAfter));
        }
        this.endBefore = Long.parseLong(times[3]);
        if (this.endBefore <= 0L) {
            this.endBeforeButton.setText("End Before");
            this.endBefore = 0L;
        } else if (this.endBefore > 0L) {
            this.endBeforeButton.setText("End Before: " + SearchUtil.formatShortTimeString(this.endBefore));
        }
    }

    public String makeSaveableQuery() {
        int j;
        int i;
        StringBuilder retval = new StringBuilder("xxxSAFE_SPLITTERxxx");
        retval.append((String)this.caseModeChooser.getSelectedItem()).append("xxxSAFE_SPLITTERxxx");
        retval.append((String)this.matchModeChooser.getSelectedItem()).append("xxxSAFE_SPLITTERxxx");
        for (i = 0; i < this.nROWS * this.nCOLS; ++i) {
            retval.append(this.patternFields[i].getText());
            retval.append("xxxSAFE_SPLITTERxxx");
        }
        for (i = 0; i < this.nROWS; ++i) {
            for (j = 0; j < this.nCOLS - 1; ++j) {
                retval.append(this.horizontalRelations[i][j].getText());
                retval.append("xxxSAFE_SPLITTERxxx");
                retval.append(this.horizontalRelations[i][j].getConstraint());
                retval.append("xxxSAFE_SPLITTERxxx");
            }
        }
        for (i = 0; i < this.nROWS - 1; ++i) {
            for (j = 0; j < this.nCOLS; ++j) {
                retval.append(this.verticalRelations[i][j].getText());
                retval.append("xxxSAFE_SPLITTERxxx");
                retval.append(this.verticalRelations[i][j].getConstraint());
                retval.append("xxxSAFE_SPLITTERxxx");
            }
        }
        for (i = 0; i < this.nROWS; ++i) {
            if (i > 0) {
                retval.append(this.layerTiers2[i - 1].getSelectedItem());
            } else {
                retval.append(" Must be in same file");
            }
            retval.append(this.layerTiers[i].getSelectedItem()).append("xxxSAFE_SPLITTERxxx");
        }
        retval.append("" + this.minimalDuration + ":" + this.maximalDuration);
        retval.append(":" + this.beginAfter + ":" + this.endBefore);
        retval.append(":" + this.nCOLS + ":" + this.nROWS);
        return retval.toString();
    }

    private String encodeQuery() {
        String mode = " AnnotationxxxMODE_SPLITTERxxx" + (String)this.caseModeChooser.getSelectedItem() + "xxxMODE_SPLITTERxxx" + (String)this.matchModeChooser.getSelectedItem();
        StringBuilder query = new StringBuilder(this.minimalDuration + "," + this.maximalDuration + "," + this.beginAfter + "," + this.endBefore + "," + this.nROWS + ", " + this.nCOLS + ", ");
        for (int i = 0; i < this.nROWS; ++i) {
            query.append("" + (i > 0 ? "2" : "1"));
            if (i >= this.nROWS - 1) continue;
            query.append(", ");
        }
        query.append("xxxSAFE_SPLITTERxxx");
        for (int layer = 0; layer < this.nROWS; ++layer) {
            for (int column = 0; column < this.nCOLS; ++column) {
                query.append(this.patternFields[this.nCOLS * layer + column].getText());
                query.append("xxxSAFE_SPLITTERxxx");
                query.append(mode);
                query.append("xxxSAFE_SPLITTERxxx");
                if (column < this.nCOLS - 1) {
                    query.append(this.horizontalRelations[layer][column].getConstraint());
                    query.append("xxxSAFE_SPLITTERxxx");
                } else {
                    query.append("cns none").append("xxxSAFE_SPLITTERxxx");
                }
                if (layer < this.nROWS - 1) {
                    query.append(this.verticalRelations[layer][column].getConstraint());
                    query.append("xxxSAFE_SPLITTERxxx");
                    continue;
                }
                query.append("cns none").append("xxxSAFE_SPLITTERxxx");
            }
            if (layer > 0) {
                query.append(this.layerTiers2[layer - 1].getSelectedItem());
                query.append("xxxSAFE_SPLITTERxxx");
            }
            query.append(this.layerTiers[layer].getSelectedItem());
            query.append("xxxSAFE_SPLITTERxxx");
        }
        return query.toString();
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        String command = e.getActionCommand();
        String menuText = "";
        this.relationPending = false;
        if (source instanceof JMenuItem) {
            menuText = ((JMenuItem)source).getText();
        }
        if ("find".equals(command)) {
            if (this.checkQueryValidity()) {
                this.mediator.doQuery(this.encodeQuery(), this.queryId);
                this.mediator.setMatrixUsage(this.getMatrixUse(), this.queryId);
                this.resultPanel.startUpdating();
                this.historyPanel.remember(this.makeSaveableQuery());
                this.mediator.putPersistent("multipleTierHistory", this.historyPanel.getHistory());
            }
        } else if ("clear".equals(command)) {
            int i;
            this.resetPatterns();
            this.resetRelations();
            for (i = 0; i < this.nROWS; ++i) {
                this.layerTiers[i].setSelectedIndex(0);
            }
            for (i = 0; i < this.nROWS - 1; ++i) {
                this.layerTiers2[i].setSelectedIndex(0);
            }
            this.minDurationButton.setText("Minimal Duration");
            this.minimalDuration = 0L;
            this.maxDurationButton.setText("Maximal Duration");
            this.maximalDuration = 0L;
            this.beginAfterButton.setText("Begin After");
            this.beginAfter = 0L;
            this.endBeforeButton.setText("End Before");
            this.endBefore = 0L;
            this.historyPanel.reset();
        } else if ("rows--".equals(command)) {
            if (this.nROWS <= 1) {
                return;
            }
            this.layoutGridGUI(this.nCOLS, this.nROWS - 1, true);
        } else if ("rows++".equals(command)) {
            if (this.nROWS >= 8) {
                return;
            }
            this.layoutGridGUI(this.nCOLS, this.nROWS + 1, true);
        } else if ("cols--".equals(command)) {
            if (this.nCOLS <= 1) {
                return;
            }
            this.layoutGridGUI(this.nCOLS - 1, this.nROWS, true);
        } else if ("cols++".equals(command)) {
            if (this.nCOLS >= 8) {
                return;
            }
            this.layoutGridGUI(this.nCOLS + 1, this.nROWS, true);
        } else if ("min duration".equals(command)) {
            String currentValue = SearchUtil.HHMMSSmmmFormat(this.minimalDuration);
            String value = JOptionPane.showInputDialog(this, "<html> Enter a Minimal Duration for the complete pattern as: <ul> <li> milliseconds <li> hours:minutes:seconds.milliseconds </ul> <p> Enter a value <= 0 to undefine the Minimal Duration</html>", currentValue);
            if (value != null) {
                this.minimalDuration = SearchUtil.parseTimeString(value);
                if (this.minimalDuration == 98373696L) {
                    JOptionPane.showMessageDialog(null, "Could not interpret: " + value, "Illegal number format", 0);
                    this.minimalDuration = 0L;
                } else if (this.minimalDuration <= 0L) {
                    this.minDurationButton.setText("Minimal Duration");
                    this.minimalDuration = 0L;
                } else if (this.maximalDuration != 0L && this.minimalDuration > this.maximalDuration) {
                    JOptionPane.showMessageDialog(null, "The Minimal Duration must be smaller than the Maximal Duration", "Impossible value", 0);
                    this.minimalDuration = 0L;
                } else if (this.beginAfter > 0L && this.endBefore > 0L && this.minimalDuration > this.endBefore - this.beginAfter) {
                    JOptionPane.showMessageDialog(null, "The Minimal Duration must be smaller than (end before - begin after)", "Impossible value", 0);
                    this.minimalDuration = 0L;
                } else if (this.beginAfter <= 0L && this.endBefore > 0L && this.minimalDuration > this.endBefore) {
                    JOptionPane.showMessageDialog(null, "The Minimal Duration must be smaller than end before", "Impossible value", 0);
                    this.minimalDuration = 0L;
                } else if (this.minimalDuration > 0L) {
                    this.minDurationButton.setText("Minimal Duration: " + SearchUtil.HHMMSSmmmFormat(this.minimalDuration));
                }
            }
        } else if ("max duration".equals(command)) {
            String currentValue = SearchUtil.HHMMSSmmmFormat(this.maximalDuration);
            String value = JOptionPane.showInputDialog(this, "<html> Enter a Maximal Duration for the complete pattern as: <ul> <li> milliseconds <li> hours:minutes:seconds.milliseconds </ul> <p> Enter a value <= 0 to undefine the Minimal Duration</html>", currentValue);
            if (value != null) {
                this.maximalDuration = SearchUtil.parseTimeString(value);
                if (this.maximalDuration == 98373696L) {
                    JOptionPane.showMessageDialog(null, "Could not interpret: " + value, "Illegal number format", 0);
                    this.maximalDuration = 0L;
                } else if (this.maximalDuration <= 0L) {
                    this.maxDurationButton.setText("Maximal Duration");
                    this.maximalDuration = 0L;
                } else if (this.maximalDuration < this.minimalDuration) {
                    JOptionPane.showMessageDialog(null, "The Maximal Duration must be bigger than the Minimal Duration", "Impossible value", 0);
                    this.maximalDuration = 0L;
                } else if (this.maximalDuration > 0L) {
                    this.maxDurationButton.setText("Maximal Duration: " + SearchUtil.HHMMSSmmmFormat(this.maximalDuration));
                }
            }
        } else if ("begin after".equals(command)) {
            String currentValue = SearchUtil.HHMMSSmmmFormat(this.beginAfter);
            String value = JOptionPane.showInputDialog(this, "<html> Enter a time after which the pattern must begin as: <ul> <li> milliseconds <li> hours:minutes:seconds.milliseconds </ul> <p> Enter a value <= 0 to undefine the Minimal Duration</html>", currentValue);
            if (value != null) {
                this.beginAfter = SearchUtil.parseTimeString(value);
                if (this.beginAfter == 98373696L) {
                    JOptionPane.showMessageDialog(null, "Could not interpret: " + value, "Illegal number format", 0);
                    this.beginAfter = 0L;
                } else if (this.beginAfter <= 0L) {
                    this.beginAfterButton.setText("Begin After");
                    this.beginAfter = 0L;
                } else if (this.endBefore != 0L && this.beginAfter > this.endBefore) {
                    JOptionPane.showMessageDialog(null, "The Begin After time must be smaller than the End Before time", "Impossible value", 0);
                    this.beginAfter = 0L;
                } else if (this.minimalDuration > 0L && this.endBefore > 0L && this.minimalDuration > this.endBefore - this.beginAfter) {
                    JOptionPane.showMessageDialog(null, "The Minimal Duration must be smaller than (end before - begin after)", "Impossible value", 0);
                    this.beginAfter = 0L;
                } else if (this.beginAfter <= 0L && this.endBefore > 0L && this.minimalDuration > this.endBefore) {
                    JOptionPane.showMessageDialog(null, "The Minimal Duration must be smaller than end before", "Impossible value", 0);
                    this.minimalDuration = 0L;
                } else if (this.beginAfter > 0L) {
                    this.beginAfterButton.setText("Begin After: " + SearchUtil.HHMMSSmmmFormat(this.beginAfter));
                }
            }
        } else if ("end before".equals(command)) {
            String currentValue = SearchUtil.HHMMSSmmmFormat(this.endBefore);
            String value = JOptionPane.showInputDialog(this, "<html> Enter a time before which the pattern must end as: <ul> <li> milliseconds <li> hours:minutes:seconds.milliseconds </ul> <p> Enter a value <= 0 to undefine the Minimal Duration</html>", currentValue);
            if (value != null) {
                this.endBefore = SearchUtil.parseTimeString(value);
                if (this.endBefore == 98373696L) {
                    JOptionPane.showMessageDialog(null, "Could not interpret: " + value, "Illegal number format", 0);
                    this.endBefore = 0L;
                } else if (this.endBefore <= 0L) {
                    this.endBeforeButton.setText("End Before");
                    this.endBefore = 0L;
                } else if (this.endBefore < this.beginAfter) {
                    JOptionPane.showMessageDialog(null, "The End Before time must be bigger than the Begin After time", "Impossible value", 0);
                    this.endBefore = 0L;
                } else if (this.minimalDuration > 0L && this.beginAfter > 0L && this.minimalDuration > this.endBefore - this.beginAfter) {
                    JOptionPane.showMessageDialog(null, "The Minimal Duration must be smaller than (end before begin after)", "Impossible value", 0);
                    this.endBefore = 0L;
                } else if (this.beginAfter <= 0L && this.endBefore > 0L && this.minimalDuration > this.endBefore) {
                    JOptionPane.showMessageDialog(null, "The Minimal Duration must be smaller than end before", "Impossible value", 0);
                    this.minimalDuration = 0L;
                } else if (this.endBefore > 0L) {
                    this.endBeforeButton.setText("End Before: " + SearchUtil.HHMMSSmmmFormat(this.endBefore));
                }
            }
        } else {
            if ("hAnnEqual".equals(command)) {
                int n = this.getConstraintValue(menuText);
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText("= " + n + " " + "annotation");
                    } else {
                        this.popupSource.setText("= " + n + " " + "ann. ");
                    }
                    this.popupSource.setConstraint("cns an=:" + n);
                }
            } else if ("hAnnMore".equals(command)) {
                int n = this.getConstraintValue(menuText);
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText("> " + n + " " + "annotation");
                    } else {
                        this.popupSource.setText("> " + n + " " + "ann.");
                    }
                    this.popupSource.setConstraint("cns an+:" + n);
                }
            } else if ("hAnnLess".equals(command)) {
                int n = this.getConstraintValue(menuText);
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText("< " + n + " " + "annotation");
                    } else {
                        this.popupSource.setText("< " + n + " " + "ann.");
                    }
                    this.popupSource.setConstraint("cns an-:" + n);
                }
            } else if ("hMilEqual".equals(command)) {
                int n = this.getConstraintValue(menuText);
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText("= " + n + " " + "millisecond");
                    } else {
                        this.popupSource.setText("= " + n + " " + "msec");
                    }
                    this.popupSource.setConstraint("cns ms=:" + n);
                }
            } else if ("hMilMore".equals(command)) {
                int n = this.getConstraintValue(menuText);
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText("> " + n + " " + "millisecond");
                    } else {
                        this.popupSource.setText("> " + n + " " + "msec");
                    }
                    this.popupSource.setConstraint("cns ms+:" + n);
                }
            } else if ("hMilLess".equals(command)) {
                int n = this.getConstraintValue(menuText);
                if (n >= 0) {
                    if (n == 1) {
                        this.popupSource.setText("< " + n + " " + "millisecond");
                    } else {
                        this.popupSource.setText("< " + n + " " + "msec");
                    }
                    this.popupSource.setConstraint("cns ms-:" + n);
                }
            } else if ("hNoConstraint".equals(command)) {
                this.popupSource.setText(menuText);
                this.popupSource.setConstraint("cns none");
            } else if ("hClear".equals(command)) {
                this.popupSource.setText("");
                this.popupSource.setConstraint("cns none");
            } else if ("vFullyAligned".equals(command)) {
                this.popupSource.setText(menuText);
                this.popupSource.setConstraint("cns aligned");
            } else if ("vOverlap".equals(command)) {
                this.popupSource.setText(menuText);
                this.popupSource.setConstraint("cns overlap");
            } else if ("vLeftOverlap".equals(command)) {
                this.popupSource.setText(menuText);
                this.popupSource.setConstraint("cns l overlap");
            } else if ("vRightOverlap".equals(command)) {
                this.popupSource.setText(menuText);
                this.popupSource.setConstraint("cns r overlap");
            } else if ("vSurrounding".equals(command)) {
                this.popupSource.setText(menuText);
                this.popupSource.setConstraint("cns surrounding");
            } else if ("vWithin".equals(command)) {
                this.popupSource.setText(menuText);
                this.popupSource.setConstraint("cns within");
            } else if ("vNoOverlap".equals(command)) {
                this.popupSource.setText(menuText);
                this.popupSource.setConstraint("cns no overlap");
            } else if ("vBeginBeginEqual".equals(command)) {
                int n = this.getConstraintValue(menuText);
                if (n >= 0) {
                    this.popupSource.setText("<html>\u0394t<sub>begin</sub> =&nbsp;" + n + "&nbsp;" + "msec" + "</html>");
                    this.popupSource.setConstraint("cns bb=:" + n);
                }
            } else if ("vBeginBeginLess".equals(command)) {
                int n = this.getConstraintValue(menuText);
                if (n >= 0) {
                    this.popupSource.setText("<html>\u0394t<sub>begin</sub> &lt;&nbsp;" + n + "&nbsp;" + "msec" + "</html>");
                    this.popupSource.setConstraint("cns bb-:" + n);
                }
            } else if ("vBeginBeginMore".equals(command)) {
                int n = this.getConstraintValue(menuText);
                if (n >= 0) {
                    this.popupSource.setText("<html>\u0394t<sub>begin</sub> &gt;&nbsp;" + n + "&nbsp;" + "msec" + "</html>");
                    this.popupSource.setConstraint("cns bb+:" + n);
                }
            } else if ("vBeginEndEqual".equals(command)) {
                int n = this.getConstraintValue(menuText);
                if (n >= 0) {
                    this.popupSource.setText("<html>t<sub>begin</sub> - t<sub>end</sub> =&nbsp;" + n + "&nbsp;" + "msec" + "</html>");
                    this.popupSource.setConstraint("cns be=:" + n);
                }
            } else if ("vBeginEndLess".equals(command)) {
                int n = this.getConstraintValue(menuText);
                if (n >= 0) {
                    this.popupSource.setText("<html>t<sub>begin</sub> - t<sub>end</sub> &lt;&nbsp;" + n + "&nbsp;" + "msec" + "</html>");
                    this.popupSource.setConstraint("cns be-:" + n);
                }
            } else if ("vBeginEndMore".equals(command)) {
                int n = this.getConstraintValue(menuText);
                if (n >= 0) {
                    this.popupSource.setText("<html>t<sub>begin</sub> - t<sub>end</sub> &gt;&nbsp;" + n + "&nbsp;" + "msec" + "</html>");
                    this.popupSource.setConstraint("cns be+:" + n);
                }
            } else if ("vEndBeginEqual".equals(command)) {
                int n = this.getConstraintValue(menuText);
                if (n >= 0) {
                    this.popupSource.setText("<html>t<sub>end</sub> - t<sub>begin</sub> =&nbsp;" + n + "&nbsp;" + "msec" + "</html>");
                    this.popupSource.setConstraint("cns eb=:" + n);
                }
            } else if ("vEndBeginLess".equals(command)) {
                int n = this.getConstraintValue(menuText);
                if (n >= 0) {
                    this.popupSource.setText("<html>t<sub>end</sub> - t<sub>begin</sub> &lt;&nbsp;" + n + "&nbsp;" + "msec" + "</html>");
                    this.popupSource.setConstraint("cns eb-:" + n);
                }
            } else if ("vEndBeginMore".equals(command)) {
                int n = this.getConstraintValue(menuText);
                if (n >= 0) {
                    this.popupSource.setText("<html>t<sub>end</sub> - t<sub>begin</sub> &gt;&nbsp;" + n + "&nbsp;" + "msec" + "</html>");
                    this.popupSource.setConstraint("cns eb+:" + n);
                }
            } else if ("vEndEndEqual".equals(command)) {
                int n = this.getConstraintValue(menuText);
                if (n >= 0) {
                    this.popupSource.setText("<html>\u0394t<sub>end</sub> =&nbsp;" + n + "&nbsp;" + "msec" + "</html>");
                    this.popupSource.setConstraint("cns ee=:" + n);
                }
            } else if ("vEndEndLess".equals(command)) {
                int n = this.getConstraintValue(menuText);
                if (n >= 0) {
                    this.popupSource.setText("<html>\u0394t<sub>end</sub> &lt;&nbsp;" + n + "&nbsp;" + "msec" + "</html>");
                    this.popupSource.setConstraint("cns ee-:" + n);
                }
            } else if ("vEndEndMore".equals(command)) {
                int n = this.getConstraintValue(menuText);
                if (n >= 0) {
                    this.popupSource.setText("<html>\u0394t<sub>end</sub> &gt;&nbsp;" + n + "&nbsp;" + "msec" + "</html>");
                    this.popupSource.setConstraint("cns ee+:" + n);
                }
            } else if ("vNoConstraint".equals(command)) {
                this.popupSource.setText(menuText);
                this.popupSource.setConstraint("cns none");
            } else if ("vClear".equals(command)) {
                this.popupSource.setText("");
                this.popupSource.setConstraint("cns none");
            }
            this.popupSource.requestFocus();
        }
        this.invalidate();
    }

    private boolean checkQueryValidity() {
        int n;
        int j;
        int i;
        int j2;
        int i2;
        boolean valid = true;
        for (i2 = 0; i2 < this.nROWS; ++i2) {
            for (j2 = 0; j2 < this.nCOLS - 1; ++j2) {
                if (!this.horizontalRelations[i2][j2].getText().equals("XXXX")) continue;
                this.horizontalRelations[i2][j2].setText("");
            }
        }
        for (i2 = 0; i2 < this.nROWS - 1; ++i2) {
            for (j2 = 0; j2 < this.nCOLS; ++j2) {
                if (!this.verticalRelations[i2][j2].getText().equals("XXXX")) continue;
                this.verticalRelations[i2][j2].setText("");
            }
        }
        int nPatterns = 0;
        boolean[][] inUse = new boolean[this.nROWS][this.nCOLS];
        for (i = 0; i < this.nROWS; ++i) {
            for (j = 0; j < this.nCOLS; ++j) {
                inUse[i][j] = false;
                n = i * this.nCOLS + j;
                if (this.patternFields[n].getText().equals("XXXX")) {
                    this.patternFields[n].setText("");
                    continue;
                }
                if (this.patternFields[n].getText().trim().length() <= 0) continue;
                inUse[i][j] = true;
                ++nPatterns;
                if (!this.patternFields[n].getText().trim().equals("NOT()")) continue;
                this.patternFields[n].requestFocus();
                valid = false;
            }
        }
        if (!valid) {
            JOptionPane.showMessageDialog(null, "A NOT() must have a value between ( and ) ", "Illegal NOT() pattern", 0);
            return valid;
        }
        if (nPatterns > 1) {
            for (i = 0; i < this.nROWS; ++i) {
                for (j = 0; j < this.nCOLS; ++j) {
                    if (!inUse[i][j]) continue;
                    int adjacent = 0;
                    if (j > 0 && inUse[i][j - 1]) {
                        ++adjacent;
                    }
                    if (j < this.nCOLS - 1 && inUse[i][j + 1]) {
                        ++adjacent;
                    }
                    if (i > 0 && inUse[i - 1][j]) {
                        ++adjacent;
                    }
                    if (i < this.nROWS - 1 && inUse[i + 1][j]) {
                        ++adjacent;
                    }
                    if (adjacent != 0) continue;
                    valid = false;
                }
            }
        }
        if (!valid) {
            JOptionPane.showMessageDialog(null, "Please make sure that all non empty patterns are connected with constraints", "Illegal query", 0);
            return valid;
        }
        for (i = 0; i < this.nROWS; ++i) {
            for (j = 0; j < this.nCOLS; ++j) {
                n = i * this.nCOLS + j;
                if (inUse[i][j]) continue;
                if (j < this.nCOLS - 1 && this.horizontalRelations[i][j].getText().trim().length() > 0 || j > 0 && this.horizontalRelations[i][j - 1].getText().trim().length() > 0) {
                    this.patternFields[n].setText("XXXX");
                    valid = false;
                }
                if ((i >= this.nROWS - 1 || this.verticalRelations[i][j].getText().trim().length() <= 0) && (i <= 0 || this.verticalRelations[i - 1][j].getText().trim().length() <= 0)) continue;
                this.patternFields[n].setText("XXXX");
                valid = false;
            }
        }
        if (!valid) {
            JOptionPane.showMessageDialog(null, "Please define the patterns marked with XXXX", "Illegal query", 0);
            return valid;
        }
        for (i = 0; i < this.nROWS; ++i) {
            for (j = 0; j < this.nCOLS - 1; ++j) {
                if (this.horizontalRelations[i][j].getText().trim().length() != 0 || !inUse[i][j] || !inUse[i][j + 1]) continue;
                this.horizontalRelations[i][j].setText("XXXX");
                valid = false;
            }
        }
        for (i = 0; i < this.nROWS - 1; ++i) {
            for (j = 0; j < this.nCOLS; ++j) {
                if (this.verticalRelations[i][j].getText().trim().length() != 0 || !inUse[i][j] || !inUse[i + 1][j]) continue;
                this.verticalRelations[i][j].setText("XXXX");
                valid = false;
            }
        }
        if (!valid) {
            JOptionPane.showMessageDialog(null, "Please define the constraints marked with XXXX", "Not all constraints are defined", 0);
            return valid;
        }
        String matchMode = (String)this.matchModeChooser.getSelectedItem();
        if (matchMode.equals(" regular expression")) {
            for (int i3 = 0; i3 < this.nROWS * this.nCOLS; ++i3) {
                if (this.checkRegexp(this.patternFields[i3])) continue;
                this.patternFields[i3].requestFocus();
                return false;
            }
        }
        return true;
    }

    private boolean[][] getMatrixUse() {
        boolean[][] cells = new boolean[this.nROWS][this.nCOLS];
        for (int i = 0; i < this.nROWS * this.nCOLS; ++i) {
            cells[i / this.nCOLS][i % this.nCOLS] = this.patternFields[i].getText().trim().length() > 0;
        }
        return cells;
    }

    private boolean checkRegexp(JTextField patternField) {
        String[] queryParts = new String[]{patternField.getText()};
        for (int i = 0; i < queryParts.length; ++i) {
            try {
                Pattern.compile(queryParts[i]);
                continue;
            }
            catch (IllegalArgumentException e) {
                JOptionPane.showMessageDialog(null, "Not a valid regular expression:\n\n     " + queryParts[i], "Error", 0);
                patternField.requestFocus();
                return false;
            }
        }
        return true;
    }

    private boolean checkNGram(JTextField patternField) {
        String queryString = patternField.getText();
        if (queryString.trim().length() > 0) {
            String[] parts = queryString.split(" +");
            boolean onlyWildcards = true;
            for (int i = 0; i < parts.length; ++i) {
                System.out.println("prt " + parts[i]);
                if (parts[i].equals("#")) continue;
                onlyWildcards = false;
            }
            if (onlyWildcards) {
                JOptionPane.showMessageDialog(null, "An n-gram pattern must contain at least one character other than #", "Only wildcards in pattern", 0);
                return false;
            }
        }
        return true;
    }

    private void resetPatterns() {
        if (this.patternFields == null || this.patternFields[this.nROWS * this.nCOLS - 1] == null) {
            return;
        }
        for (int i = 0; i < this.nROWS * this.nCOLS; ++i) {
            this.patternFields[i].setText("");
        }
    }

    private void resetRelations() {
        int j;
        int i;
        if (this.nCOLS >= 2 && (this.horizontalRelations == null || this.horizontalRelations[this.nROWS - 1][this.nCOLS - 2] == null)) {
            return;
        }
        if (this.nROWS >= 2 && (this.verticalRelations == null || this.verticalRelations[this.nROWS - 2][this.nCOLS - 1] == null)) {
            return;
        }
        for (i = 0; i < this.nROWS; ++i) {
            for (j = 0; j < this.nCOLS - 1; ++j) {
                this.horizontalRelations[i][j].setText("");
                this.horizontalRelations[i][j].setConstraint("cns none");
            }
        }
        for (i = 0; i < this.nROWS - 1; ++i) {
            for (j = 0; j < this.nCOLS; ++j) {
                this.verticalRelations[i][j].setText("");
                this.verticalRelations[i][j].setConstraint("cns none");
            }
        }
    }

    private int getConstraintValue(String constraint) {
        String selectedValue = "";
        String question = "";
        question = constraint.indexOf("milli") >= 0 || constraint.indexOf("msec") >= 0 ? "Please enter the time in milliseconds" : "Please enter the number of annotations";
        selectedValue = (String)JOptionPane.showInputDialog(null, question, constraint, 1, null, null, "");
        int i = -1;
        if (selectedValue != null) {
            try {
                i = Integer.parseInt(selectedValue);
                if (i < 0) {
                    JOptionPane.showMessageDialog(this, "A negative value is not allowed", constraint, 0);
                } else if (i == 0 && constraint.indexOf(60) >= 0) {
                    JOptionPane.showMessageDialog(this, "The value 0 is not allowed for this constraint", constraint, 0);
                    i = -1;
                }
            }
            catch (IllegalArgumentException e) {
                JOptionPane.showMessageDialog(null, selectedValue + " " + "is not a valid integer number", "Error", 0);
            }
        }
        return i;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyOwnFocusTraversalPolicy
    extends FocusTraversalPolicy {
        ArrayList<Component> order;

        public MyOwnFocusTraversalPolicy(ArrayList<Component> order) {
            this.order = new ArrayList(order.size());
            this.order.addAll(order);
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            int idx = (this.order.indexOf(aComponent) + 1) % this.order.size();
            return this.order.get(idx);
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            int idx = this.order.indexOf(aComponent) - 1;
            if (idx < 0 || idx >= this.order.size()) {
                idx = this.order.size() - 1;
            }
            return this.order.get(idx);
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            return this.order.get(0);
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            return this.order.get(this.order.size() - 1);
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            return this.order.get(0);
        }
    }

    private static class ConstraintLabel
    extends JPanel {
        private String constraint = "cns none";
        private JLabel myLabel = new JLabel("");

        public String getConstraint() {
            return this.constraint;
        }

        public void setConstraint(String cons) {
            this.constraint = cons;
        }

        public String getText() {
            return this.myLabel.getText();
        }

        public void setText(String text) {
            this.myLabel.setText(text);
        }

        public ConstraintLabel(MouseInputAdapter mouseListener) {
            this.myLabel.setBackground(Constants.CONSTRAINT_LABEL_COLOR);
            this.myLabel.setHorizontalAlignment(0);
            this.myLabel.setMinimumSize(new Dimension(30, 20));
            this.myLabel.setOpaque(true);
            this.setLayout(new BorderLayout());
            this.add((Component)this.myLabel, "Center");
            BasicArrowButton arrow = new BasicArrowButton(5);
            arrow.setMaximumSize(new Dimension(5, 999));
            arrow.addMouseListener(mouseListener);
            this.add((Component)arrow, "East");
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEtchedBorder(1));
            this.addMouseListener(mouseListener);
        }
    }

    private class MouseHandler
    extends MouseInputAdapter {
        private MouseHandler() {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            this.openConstraintMenu(e);
        }

        public void mouseClicked(MouseEvent e) {
        }

        private void openConstraintMenu(MouseEvent e) {
            JComponent comp;
            Object source = e.getSource();
            if (source instanceof JComponent && (comp = (JComponent)source).getParent() instanceof ConstraintLabel) {
                source = comp.getParent();
            }
            if (source instanceof ConstraintLabel) {
                MultipleLayerSearchPanel.this.popupSource = (ConstraintLabel)source;
                boolean found = false;
                for (int i = 0; i < MultipleLayerSearchPanel.this.nROWS - 1; ++i) {
                    for (int j = 0; j < MultipleLayerSearchPanel.this.nCOLS; ++j) {
                        if (source != MultipleLayerSearchPanel.this.verticalRelations[i][j]) continue;
                        found = true;
                        if (MultipleLayerSearchPanel.this.relationPending) {
                            MultipleLayerSearchPanel.this.relationPending = false;
                            MultipleLayerSearchPanel.this.verticalRelationMenu.setVisible(false);
                            continue;
                        }
                        MultipleLayerSearchPanel.this.relationPending = true;
                        MultipleLayerSearchPanel.this.verticalRelationMenu.show(MultipleLayerSearchPanel.this.popupSource, 0, MultipleLayerSearchPanel.this.popupSource.getHeight());
                    }
                }
                if (!found) {
                    if (MultipleLayerSearchPanel.this.relationPending) {
                        MultipleLayerSearchPanel.this.relationPending = false;
                        MultipleLayerSearchPanel.this.horizontalRelationMenu.setVisible(false);
                    } else {
                        MultipleLayerSearchPanel.this.relationPending = true;
                        MultipleLayerSearchPanel.this.horizontalRelationMenu.show(MultipleLayerSearchPanel.this.popupSource, 0, MultipleLayerSearchPanel.this.popupSource.getHeight());
                    }
                }
            }
        }
    }
}

