/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annex.swingsearch;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import nl.mpi.annex.search.SearchHit;
import nl.mpi.annex.swingsearch.SaverBasics;
import nl.mpi.annex.swingsearch.SearchMediator;

public class SaverAllHits
extends SaverBasics {
    private final File _saveFile;
    private final int _nToBeSaved;
    private final int _hitContextSize;
    private boolean _includeFilePath;
    private boolean _includeFileName;
    private boolean _msFormat;
    private BufferedWriter _out;
    private final int _stepSize = 10;
    private final String _delimiter = "\t";
    private static final DecimalFormat threeFracs = new DecimalFormat("000");
    private final String[] _columnNames;
    private final String[] _columnNamesComplex;

    public SaverAllHits(File file, int hitCount, SearchMediator mediator, String queryId, int hitContextSize) {
        super(mediator, queryId);
        this._saveFile = file;
        this._nToBeSaved = hitCount < 100000 ? hitCount : 100000;
        this._hitContextSize = hitContextSize;
        this._columnNames = "Annotation,HitPositionInAnnotation,HitLength,HitNumberInAnnotation,AnnotationBeginTime,AnnotationEndTime,AnnotationDuration,HitPositionInTier,TierName,TierType,TierParticipant,TierAnnotator,LeftContext,RightContext,TranscriptionName".split(",");
        this._columnNamesComplex = "Annotation,HitPositionInTier,BeginTime,EndTime,Duration,TranscriptionName".split(",");
    }

    public void run() {
        try {
            this._out = SaverAllHits.writeSaveFile(this._saveFile);
            this._includeFilePath = true;
            this._includeFileName = false;
            this._msFormat = true;
            String val = null;
            val = this.getMediator().getPersistent("MFSearchResult.ExportIncludeFileName");
            if (val != null) {
                this._includeFileName = Boolean.parseBoolean(val);
            }
            if ((val = this.getMediator().getPersistent("MFSearchResult.ExportIncludeFilePath")) != null) {
                this._includeFilePath = Boolean.parseBoolean(val);
            }
            if ((val = this.getMediator().getPersistent("MFSearchResult.ExportTimeFormat")) != null) {
                boolean bl = this._msFormat = !val.equals("sec.ms");
            }
            if (!this._includeFileName && !this._includeFilePath) {
                this._includeFilePath = true;
            }
            ArrayList<SearchHit> hits = this.getMediator().getHitsFromDatabase(0, 1, this._hitContextSize, this.getQueryId());
            SearchHit hit = (SearchHit)hits.get(0);
            boolean isComplex = hit.tierType.equals("xxxCOMPLEX_QUERY_INDICATORxxx");
            String allColumns = this.getMediator().getPersistent("MFSearchResult" + (isComplex ? "Complex" : "") + ".ExportColumnOrder");
            val = this.getMediator().getPersistent("MFSearchResult" + (isComplex ? "Complex" : "") + ".ExportColumnIncluded");
            String[] headers = this.parseHeaderDefinition(val, allColumns, isComplex ? "Annotation,HitPositionInTier,BeginTime,EndTime,Duration,TranscriptionName" : "Annotation,HitPositionInAnnotation,HitLength,HitNumberInAnnotation,AnnotationBeginTime,AnnotationEndTime,AnnotationDuration,HitPositionInTier,TierName,TierType,TierParticipant,TierAnnotator,LeftContext,RightContext,TranscriptionName");
            if (isComplex) {
                boolean multipleRowsPerHit = false;
                val = this.getMediator().getPersistent("MFSearchResultComplex.ExportMultipleRowsPerHit");
                if (val != null) {
                    multipleRowsPerHit = Boolean.parseBoolean(val);
                }
                this.saveComplexHits(headers, multipleRowsPerHit);
            } else {
                this.saveSimpleHits(headers);
            }
            this._out.flush();
            this._out.close();
            if (this.getSaving()) {
                JOptionPane.showMessageDialog(null, "Ready saving hits", "Save Hits", 1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.toString(), "Save Hits", 0);
        }
        this.cancel();
        this.setProgress(-1.0f);
    }

    private void writeTime(long time) throws IOException {
        if (this._msFormat) {
            this._out.write(Long.toString(time));
        } else {
            this._out.write(Long.toString(time / 1000L) + "." + threeFracs.format(time % 1000L));
        }
    }

    private String[] parseHeaderDefinition(String definition, String allColumns, String fallback) {
        if (allColumns == null) {
            return fallback.split(",");
        }
        if (definition == null) {
            return allColumns.split(",");
        }
        String[] colInd = definition.split(",");
        String[] headers = new String[colInd.length];
        String[] allColumnArray = allColumns.split(",");
        for (int i = 0; i < colInd.length; ++i) {
            headers[i] = "";
            try {
                int index = Integer.parseInt(colInd[i]);
                if (index < 0 || index >= allColumnArray.length) continue;
                headers[i] = allColumnArray[index];
                continue;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return headers;
    }

    private void savePathNameHeaders() throws IOException {
        if (this._includeFilePath) {
            this._out.write("\"TranscriptionPath\"");
        }
        if (this._includeFileName) {
            if (this._includeFilePath) {
                this._out.write("\t");
            }
            this._out.write("\"TranscriptionName\"");
        }
    }

    private void savePathNameColumns(String path) throws IOException {
        if (this._includeFilePath) {
            this._out.write("\"" + path.replaceAll("\"", "\"\"") + "\"");
        }
        if (this._includeFileName) {
            if (this._includeFilePath) {
                this._out.write("\t");
            }
            this._out.write("\"" + SaverAllHits.nameFromPath(path).replaceAll("\"", "\"\"") + "\"");
        }
    }

    private void saveSimpleHits(String[] headers) throws IOException {
        int i;
        for (i = 0; i < headers.length; ++i) {
            if (headers[i].equals("TranscriptionName")) {
                this.savePathNameHeaders();
            } else {
                this._out.write("\"" + headers[i] + "\"");
            }
            if (i == headers.length - 1) continue;
            this._out.write("\t");
        }
        this._out.newLine();
        this._out.newLine();
        for (i = 0; i < this._nToBeSaved && this.getSaving(); i += 10) {
            ArrayList<SearchHit> hits = this.getMediator().getHitsFromDatabase(i, i + 10, this._hitContextSize, this.getQueryId());
            for (int j = 0; j < hits.size(); ++j) {
                this.setProgress((float)(i + j) / (float)this._nToBeSaved);
                SearchHit hit = (SearchHit)hits.get(j);
                for (int k = 0; k < headers.length; ++k) {
                    int z;
                    if (headers[k].equals(this._columnNames[0])) {
                        this._out.write("\"" + hit.annotation.replaceAll("\"", "\"\"") + "\"");
                    } else if (headers[k].equals(this._columnNames[1])) {
                        this._out.write(Integer.toString(hit.hitPositionInAnnotation + 1));
                    } else if (headers[k].equals(this._columnNames[2])) {
                        this._out.write(Integer.toString(hit.hitLength));
                    } else if (headers[k].equals(this._columnNames[3])) {
                        this._out.write(Integer.toString(hit.hitNumberInAnnotation));
                    } else if (headers[k].equals(this._columnNames[4])) {
                        this.writeTime(hit.beginTime);
                    } else if (headers[k].equals(this._columnNames[5])) {
                        this.writeTime(hit.endTime);
                    } else if (headers[k].equals(this._columnNames[6])) {
                        this.writeTime(hit.endTime - hit.beginTime);
                    } else if (headers[k].equals(this._columnNames[7])) {
                        this._out.write(Integer.toString(hit.positionInTier));
                    } else if (headers[k].equals(this._columnNames[8])) {
                        this._out.write("\"" + hit.tierName.replaceAll("\"", "\"\"") + "\"");
                    } else if (headers[k].equals(this._columnNames[9])) {
                        this._out.write("\"" + hit.tierType.replaceAll("\"", "\"\"") + "\"");
                    } else if (headers[k].equals(this._columnNames[10])) {
                        if (hit.participant == null) {
                            hit.participant = "";
                        }
                        this._out.write("\"" + hit.participant.replaceAll("\"", "\"\"") + "\"");
                    } else if (headers[k].equals(this._columnNames[11])) {
                        if (hit.annotator == null) {
                            hit.annotator = "";
                        }
                        this._out.write("\"" + hit.annotator.replaceAll("\"", "\"\"") + "\"");
                    } else if (headers[k].equals(this._columnNames[12])) {
                        String leftContext = hit.leftContext.size() > 0 ? hit.leftContext.get(0) : "";
                        for (z = 1; z < hit.leftContext.size(); ++z) {
                            leftContext = hit.leftContext.get(z) + "  " + leftContext;
                        }
                        this._out.write("\"" + leftContext.replaceAll("\"", "\"\"") + "\"");
                    } else if (headers[k].equals(this._columnNames[13])) {
                        StringBuilder rightContext = new StringBuilder("");
                        if (hit.rightContext.size() > 0) {
                            rightContext.append(hit.rightContext.get(0));
                        }
                        for (z = 1; z < hit.rightContext.size(); ++z) {
                            rightContext.append("  ");
                            rightContext.append(hit.rightContext.get(z));
                        }
                        this._out.write("\"" + rightContext.toString().replaceAll("\"", "\"\"") + "\"");
                    } else if (headers[k].equals(this._columnNames[14])) {
                        this.savePathNameColumns(hit.transcriptionName);
                    }
                    if (k == headers.length - 1) continue;
                    this._out.write("\t");
                }
                this._out.newLine();
            }
        }
    }

    private void writeComplexPart(String[] headers, String[] patternParts) throws IOException {
        String annotation = patternParts[0].substring(1, patternParts[0].length() - 1);
        if (patternParts.length < 4) {
            patternParts = (annotation + "xxxNUMBER_SPLITTERxxx" + "0" + "xxxNUMBER_SPLITTERxxx" + "0" + "xxxNUMBER_SPLITTERxxx" + "0").split("xxxNUMBER_SPLITTERxxx");
        }
        int position = Integer.parseInt(patternParts[1]);
        long beginTime = Long.parseLong(patternParts[2]);
        long endTime = Long.parseLong(patternParts[3]);
        long duration = endTime - beginTime;
        for (int h = 0; h < headers.length; ++h) {
            if (headers[h].equals(this._columnNamesComplex[0])) {
                this._out.write(annotation);
            } else if (headers[h].equals(this._columnNamesComplex[1])) {
                this._out.write(Integer.toString(position + 1));
            } else if (headers[h].equals(this._columnNamesComplex[2])) {
                this.writeTime(beginTime);
            } else if (headers[h].equals(this._columnNamesComplex[3])) {
                this.writeTime(endTime);
            } else if (headers[h].equals(this._columnNamesComplex[4])) {
                this.writeTime(duration);
            } else if (headers[h].equals(this._columnNamesComplex[5])) continue;
            this._out.write("\t");
        }
    }

    private void saveComplexHits(String[] headers, boolean multipleRowsPerHit) throws IOException {
        int i;
        boolean pathNameFirst = false;
        boolean pathNameLast = false;
        boolean[][] cellsInUse = this.getMediator().getMatrixUsage(this.getQueryId());
        boolean[] layersInUse = null;
        boolean[] columnsInUse = null;
        if (headers[0].equals(this._columnNamesComplex[5])) {
            this.savePathNameHeaders();
            pathNameFirst = true;
            pathNameLast = false;
            this._out.write("\t");
        }
        if (multipleRowsPerHit) {
            layersInUse = new boolean[cellsInUse.length];
            block0: for (int r = 0; r < cellsInUse.length; ++r) {
                layersInUse[r] = false;
                for (int c = 0; c < cellsInUse[r].length; ++c) {
                    if (!cellsInUse[r][c]) continue;
                    layersInUse[r] = true;
                    continue block0;
                }
            }
            columnsInUse = new boolean[cellsInUse[0].length];
            block2: for (int c = 0; c < cellsInUse[0].length; ++c) {
                columnsInUse[c] = false;
                for (int r = 0; r < cellsInUse.length; ++r) {
                    if (!cellsInUse[r][c]) continue;
                    columnsInUse[c] = true;
                    continue block2;
                }
            }
            for (i = 0; i < columnsInUse.length; ++i) {
                if (!columnsInUse[i]) continue;
                for (int k = 0; k < headers.length; ++k) {
                    if (headers[k].equals(this._columnNamesComplex[5])) continue;
                    if (headers[k].equals(this._columnNamesComplex[0])) {
                        this._out.write("\"" + headers[k] + "x-" + (i + 1) + "\"");
                        this._out.write("\t");
                        continue;
                    }
                    this._out.write("\"" + headers[k] + "\"");
                    this._out.write("\t");
                }
            }
        } else {
            for (i = 0; i < cellsInUse.length; ++i) {
                for (int j = 0; j < cellsInUse[i].length; ++j) {
                    if (!cellsInUse[i][j]) continue;
                    for (int k = 0; k < headers.length; ++k) {
                        if (headers[k].equals(this._columnNamesComplex[5])) continue;
                        if (headers[k].equals(this._columnNamesComplex[0])) {
                            this._out.write("\"" + headers[k] + (i + 1) + "-" + (j + 1) + "\"");
                            this._out.write("\t");
                            continue;
                        }
                        this._out.write("\"" + headers[k] + "\"");
                        this._out.write("\t");
                    }
                }
            }
        }
        for (i = 1; i < headers.length; ++i) {
            if (headers.length <= 1 || !this._columnNamesComplex[5].equals(headers[i])) continue;
            pathNameLast = true;
            this.savePathNameHeaders();
            break;
        }
        this._out.newLine();
        this._out.newLine();
        for (i = 0; i < this._nToBeSaved && this.getSaving(); i += 10) {
            ArrayList<SearchHit> hits = this.getMediator().getHitsFromDatabase(i, i + 10, this._hitContextSize, this.getQueryId());
            for (int j = 0; j < hits.size(); ++j) {
                String part;
                int n;
                String[] layerParts;
                int k;
                this.setProgress((float)(i + j) / (float)this._nToBeSaved);
                SearchHit hit = (SearchHit)hits.get(j);
                String[] layerStrings = hit.annotation.trim().split("xxxLAYER_SPLITTERxxx");
                if (multipleRowsPerHit) {
                    for (k = 0; k < layerStrings.length - 1; ++k) {
                        if (!layersInUse[k]) continue;
                        if (pathNameFirst) {
                            this.savePathNameColumns(hit.transcriptionName);
                            this._out.write("\t");
                        }
                        layerParts = layerStrings[k + 1].trim().split("xxxSAFE_SPLITTERxxx");
                        for (n = 0; n < layerParts.length - 1; ++n) {
                            part = layerParts[n + 1];
                            if (!columnsInUse[n]) continue;
                            if (cellsInUse[k][n]) {
                                this.writeComplexPart(headers, part.split("xxxNUMBER_SPLITTERxxx"));
                                continue;
                            }
                            for (int h = 0; h < headers.length; ++h) {
                                if (headers[h].equals(this._columnNamesComplex[5])) continue;
                                this._out.write("\t");
                            }
                        }
                        if (pathNameLast) {
                            this.savePathNameColumns(hit.transcriptionName);
                        }
                        if (k + 1 >= layerStrings.length - 1 || !layersInUse[k + 1]) continue;
                        this._out.newLine();
                    }
                } else {
                    if (pathNameFirst) {
                        this.savePathNameColumns(hit.transcriptionName);
                        this._out.write("\t");
                    }
                    for (k = 1; k < layerStrings.length; ++k) {
                        layerParts = layerStrings[k].trim().split("xxxSAFE_SPLITTERxxx");
                        for (n = 1; n < layerParts.length; ++n) {
                            part = layerParts[n];
                            if (!cellsInUse[k - 1][n - 1]) continue;
                            this.writeComplexPart(headers, part.split("xxxNUMBER_SPLITTERxxx"));
                        }
                    }
                    if (pathNameLast) {
                        this.savePathNameColumns(hit.transcriptionName);
                    }
                }
                this._out.newLine();
            }
        }
    }
}

