/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annex.swingsearch;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import nl.mpi.annex.search.Constants;
import nl.mpi.annex.swingsearch.SearchDomainPanel;
import nl.mpi.annex.swingsearch.SearchHistoryPanel;
import nl.mpi.annex.swingsearch.SearchListener;
import nl.mpi.annex.swingsearch.SearchMediator;
import nl.mpi.annex.swingsearch.SearchResultPanel;

public class SingleLayerSearchPanel
extends JPanel
implements SearchListener,
ActionListener,
ItemListener {
    private SearchMediator mediator;
    private String queryId;
    private Color backgroundColor;
    private String domainTypes;
    private String[] targetModes;
    private String[] caseModes;
    private String[] matchModes;
    private JComboBox targetModeChooser;
    private JComboBox caseModeChooser;
    private JComboBox matchModeChooser;
    private JComboBox tierConstraintsChooser;
    private JButton findButton;
    private JTextField queryField;
    private SearchResultPanel resultPanel;
    private SearchHistoryPanel historyPanel;

    public SingleLayerSearchPanel(SearchMediator mediator) {
        this.mediator = mediator;
        this.backgroundColor = mediator.getBackgroundColor();
        this.setBackground(this.backgroundColor);
        this.queryId = mediator.createQuery();
        this.setLayout(new BorderLayout());
        JPanel definitionPanel = new JPanel();
        definitionPanel.setLayout(new BoxLayout(definitionPanel, 1));
        definitionPanel.setBackground(this.backgroundColor);
        SearchDomainPanel domainPanel = new SearchDomainPanel(mediator, this.queryId, this);
        definitionPanel.add(domainPanel);
        definitionPanel.add(Box.createVerticalStrut(15));
        this.historyPanel = new SearchHistoryPanel(this, this.backgroundColor);
        this.historyPanel.setHistory(mediator.getPersistent("singleTierHistory"));
        definitionPanel.add(this.historyPanel);
        definitionPanel.add(Box.createVerticalStrut(15));
        JPanel modePanel = new JPanel();
        modePanel.setBackground(this.backgroundColor);
        modePanel.setLayout(new BoxLayout(modePanel, 0));
        JLabel modeLabel = new JLabel("Mode:");
        modeLabel.setFont(Constants.bigBoldFont);
        modePanel.add(Box.createHorizontalStrut(5));
        modePanel.add(modeLabel);
        modePanel.add(Box.createHorizontalStrut(10));
        ArrayList<String> searchModes = mediator.getSearchModes(this.queryId);
        int i = 0;
        int nTargetModes = Integer.parseInt(searchModes.get(i));
        this.targetModes = new String[nTargetModes];
        for (int j = 0; j < nTargetModes; ++j) {
            this.targetModes[j] = searchModes.get(++i);
        }
        this.targetModeChooser = new JComboBox<String>(this.targetModes);
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.targetModeChooser.setBackground(this.backgroundColor);
        }
        this.targetModeChooser.addItemListener(this);
        modePanel.add(this.targetModeChooser);
        modePanel.add(Box.createHorizontalStrut(5));
        int nCaseModes = Integer.parseInt(searchModes.get(++i));
        this.caseModes = new String[nCaseModes];
        for (int j = 0; j < nCaseModes; ++j) {
            this.caseModes[j] = searchModes.get(++i);
        }
        this.caseModeChooser = new JComboBox<String>(this.caseModes);
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.caseModeChooser.setBackground(this.backgroundColor);
        }
        this.caseModeChooser.addItemListener(this);
        modePanel.add(this.caseModeChooser);
        modePanel.add(Box.createHorizontalStrut(5));
        int nMatchModes = Integer.parseInt(searchModes.get(++i));
        this.matchModes = new String[nMatchModes];
        for (int j = 0; j < nMatchModes; ++j) {
            this.matchModes[j] = searchModes.get(++i);
        }
        this.matchModeChooser = new JComboBox<String>(this.matchModes);
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.matchModeChooser.setBackground(this.backgroundColor);
        }
        this.matchModeChooser.addItemListener(this);
        modePanel.add(this.matchModeChooser);
        modePanel.add(Box.createHorizontalStrut(30));
        definitionPanel.add(modePanel);
        definitionPanel.add(Box.createVerticalStrut(15));
        JPanel queryPanel = new JPanel();
        queryPanel.setBackground(this.backgroundColor);
        queryPanel.setLayout(new BoxLayout(queryPanel, 0));
        queryPanel.add(Box.createHorizontalStrut(30));
        this.findButton = new JButton("Find");
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.findButton.setBackground(this.backgroundColor);
        }
        this.findButton.addActionListener(this);
        queryPanel.add(this.findButton);
        queryPanel.add(Box.createHorizontalStrut(10));
        this.queryField = new JTextField();
        this.queryField.setFont(Constants.normalFont);
        this.queryField.addActionListener(this);
        this.queryField.requestFocus();
        queryPanel.add(this.queryField);
        queryPanel.add(Box.createHorizontalStrut(10));
        Dimension comboSize = new Dimension(250, 25);
        this.tierConstraintsChooser = new JComboBox();
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.tierConstraintsChooser.setBackground(this.backgroundColor);
        }
        this.tierConstraintsChooser.setPreferredSize(comboSize);
        this.tierConstraintsChooser.setMaximumRowCount(20);
        queryPanel.add(this.tierConstraintsChooser);
        queryPanel.add(Box.createHorizontalStrut(30));
        definitionPanel.add(queryPanel);
        definitionPanel.add(Box.createVerticalStrut(15));
        this.add((Component)definitionPanel, "North");
        this.resultPanel = new SearchResultPanel(mediator, this.queryId);
        this.add((Component)this.resultPanel, "Center");
        this.queryField.requestFocus();
    }

    public void fillTierConstraintsCombo() {
        while (this.tierConstraintsChooser == null) {
            try {
                Thread.currentThread();
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {}
        }
        this.tierConstraintsChooser.removeAllItems();
        this.tierConstraintsChooser.addItem(" All Tiers ");
        ArrayList<String> tierTypes = this.mediator.getTierTypes(this.queryId);
        for (int i = 0; i < tierTypes.size(); ++i) {
            this.tierConstraintsChooser.addItem(" Tier Type: " + tierTypes.get(i));
        }
        ArrayList<String> tierNames = this.mediator.getTierNames(this.queryId);
        for (int i = 0; i < tierNames.size(); ++i) {
            this.tierConstraintsChooser.addItem(" Tier Name: " + tierNames.get(i));
        }
        ArrayList<String> participants = this.mediator.getParticipants(this.queryId);
        for (int i = 0; i < participants.size(); ++i) {
            this.tierConstraintsChooser.addItem(" Participant: " + participants.get(i));
        }
        ArrayList<String> annotators = this.mediator.getAnnotators(this.queryId);
        for (int i = 0; i < annotators.size(); ++i) {
            this.tierConstraintsChooser.addItem(" Annotator: " + annotators.get(i));
        }
    }

    public void domainChanged() {
        this.fillTierConstraintsCombo();
        this.validate();
    }

    public void queryStopped() {
        this.queryField.requestFocus();
    }

    private String makeSaveableQuery() {
        String keyword = this.queryField.getText();
        if (keyword == null) {
            keyword = "";
        }
        if (keyword.indexOf("xxxSAFE_SPLITTERxxx") != -1) {
            keyword = "[UNPRINTABLE]";
        }
        return (String)this.targetModeChooser.getSelectedItem() + "xxxSAFE_SPLITTERxxx" + (String)this.caseModeChooser.getSelectedItem() + "xxxSAFE_SPLITTERxxx" + (String)this.matchModeChooser.getSelectedItem() + "xxxSAFE_SPLITTERxxx" + keyword + "xxxSAFE_SPLITTERxxx" + (String)this.tierConstraintsChooser.getSelectedItem();
    }

    public void setQuery(String savedQuery) {
        String[] q = savedQuery.split("xxxSAFE_SPLITTERxxx");
        this.targetModeChooser.setSelectedItem(q[0]);
        this.caseModeChooser.setSelectedItem(q[1]);
        this.matchModeChooser.setSelectedItem(q[2]);
        this.queryField.setText(q[3]);
        this.tierConstraintsChooser.setSelectedItem(q[4]);
    }

    private String encodeQuery() {
        String mode = (String)this.targetModeChooser.getSelectedItem() + "xxxMODE_SPLITTERxxx" + (String)this.caseModeChooser.getSelectedItem() + "xxxMODE_SPLITTERxxx" + (String)this.matchModeChooser.getSelectedItem();
        String query = "0, 0, 0, 0, 1, 1, 1xxxSAFE_SPLITTERxxx";
        String keyword = this.queryField.getText();
        if (keyword == null) {
            keyword = "";
        }
        if (keyword.indexOf("xxxSAFE_SPLITTERxxx") != -1) {
            keyword = "[UNPRINTABLE]";
        }
        query = query + keyword.trim() + "xxxSAFE_SPLITTERxxx" + mode + "xxxSAFE_SPLITTERxxx" + "cns none" + "xxxSAFE_SPLITTERxxx" + "cns none" + "xxxSAFE_SPLITTERxxx";
        query = query + this.tierConstraintsChooser.getSelectedItem();
        return query;
    }

    private boolean checkQueryValidity() {
        String matchMode;
        int i;
        String targetMode = (String)this.targetModeChooser.getSelectedItem();
        String queryString = this.queryField.getText().trim();
        if (!targetMode.equals(" Annotation")) {
            String[] parts = queryString.split(" +");
            boolean onlyWildcards = true;
            for (i = 0; i < parts.length; ++i) {
                if (!parts[i].equals("#")) {
                    onlyWildcards = false;
                }
                if (!parts[i].equals("NOT()")) continue;
                JOptionPane.showMessageDialog(null, "A NOT() must have a value between ( and ) ", "Illegal NOT() pattern", 0);
                this.queryField.requestFocus();
                return false;
            }
            if (onlyWildcards) {
                JOptionPane.showMessageDialog(null, "An n-gram pattern must contain at least one character other than #", "Only wildcards in pattern", 0);
                this.queryField.requestFocus();
                return false;
            }
        }
        if ((matchMode = (String)this.matchModeChooser.getSelectedItem()).equals(" regular expression")) {
            String[] queryParts = new String[]{queryString};
            if (((String)this.targetModeChooser.getSelectedItem()).toLowerCase().indexOf("gram") >= 0) {
                queryParts = queryString.split(" ");
            }
            for (i = 0; i < queryParts.length; ++i) {
                try {
                    Pattern.compile(queryParts[i]);
                    continue;
                }
                catch (PatternSyntaxException e) {
                    JOptionPane.showMessageDialog(null, "Not a valid regular expression:\n\n     " + queryParts[i], "Error", 0);
                    this.queryField.requestFocus();
                    return false;
                }
            }
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object source = actionEvent.getSource();
        if (source == this.findButton || source == this.queryField) {
            if (this.queryField.getText().length() != 0 && !this.queryField.getText().equals("Error, empty query string") && !this.queryField.getText().startsWith("Not a valid regular expression")) {
                if (this.checkQueryValidity()) {
                    this.mediator.doQuery(this.encodeQuery(), this.queryId);
                    this.resultPanel.startUpdating();
                    this.historyPanel.remember(this.makeSaveableQuery());
                    this.mediator.putPersistent("singleTierHistory", this.historyPanel.getHistory());
                }
            } else {
                this.queryField.requestFocus();
                this.queryField.setText("Error, empty query string");
                this.queryField.setSelectionStart(0);
                this.queryField.setSelectionEnd(100);
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        this.queryField.requestFocus();
    }
}

