/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annex.util;

import java.net.URL;
import java.util.ArrayList;
import nl.mpi.corpusstructure.AccessInfo;
import nl.mpi.corpusstructure.ArchiveAccessContext;
import nl.mpi.corpusstructure.ArchiveObjectsDB;
import nl.mpi.corpusstructure.CorpusStructureDB;
import nl.mpi.corpusstructure.CorpusStructureDBImpl;
import nl.mpi.corpusstructure.StreamingPreparation;
import nl.mpi.corpusstructure.UnknownNodeException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnexUtil {
    private static Logger logger = Logger.getLogger("ANNEX.Util");
    private static String _corpusDbURL;
    private static String _corpusDbUser;
    private static String _corpusDbPassword;
    private static CorpusStructureDB csdb;
    private static ArchiveObjectsDB aodb;

    public static void setCorpusDB(String jdbc, String user, String pass) {
        _corpusDbURL = jdbc;
        _corpusDbUser = user;
        _corpusDbPassword = pass;
    }

    public static StreamingPreparation getStreamingPreparation(String anonymizerHost, int anonymizerPort) {
        return new StreamingPreparation(_corpusDbURL, _corpusDbUser, _corpusDbPassword, anonymizerHost, anonymizerPort);
    }

    public static boolean hasAccessTo(String user, String nodeId) {
        boolean b;
        AccessInfo ai = AnnexUtil.getArchiveObjectsDB().getObjectAccessInfo(nodeId);
        if (user == null || "anonymous".equals(user) || user.trim().length() == 0) {
            user = "everybody";
        }
        if (!(b = ai.hasReadAccess(user))) {
            logger.warn("hasAccessTo: false for: " + user + " ai: " + ai + " in: " + nodeId);
        }
        return b;
    }

    public static URL getURLFor(String nodeId) {
        return AnnexUtil.getArchiveObjectsDB().getObjectURL(nodeId, 3).toURL();
    }

    public static String getFilePathFor(String nodeId) {
        return nodeId == null ? null : AnnexUtil.getArchiveObjectsDB().getObjectURL(nodeId, ArchiveAccessContext.getFileUrlContext()).getPath();
    }

    public static ArrayList<String> getPossibleMediaFor(String nodeId) {
        ArrayList<String> media = new ArrayList<String>();
        if (AnnexUtil.getTypeFor(nodeId) == -1) {
            return media;
        }
        try {
            String[] parentNodeIds = AnnexUtil.getCorpusStructureDB().getParentNodes(nodeId);
            if (parentNodeIds == null) {
                return media;
            }
            String[] mediaNodeIds = AnnexUtil.getCorpusStructureDB().getDescendants(parentNodeIds[0], 16, (String)null);
            for (int i = 0; i < mediaNodeIds.length; ++i) {
                media.add(AnnexUtil.getCorpusStructureDB().getNode(mediaNodeIds[i]).getName());
            }
        }
        catch (UnknownNodeException une) {
            logger.error("getPossibleMediaFor: UnknownNodeException: " + (Object)((Object)une), une);
        }
        return media;
    }

    public static int getTypeFor(String nodeId) {
        if (nodeId == null) {
            return -1;
        }
        String format = AnnexUtil.getCorpusStructureDB().getNode(nodeId).getFormat();
        if (format.equals("text/x-eaf+xml")) {
            return 0;
        }
        if (format.equals("text/x-chat")) {
            return 1;
        }
        if (format.equals("text/x-shoebox-text")) {
            return 2;
        }
        if (format.equals("text/x-shoebox-text".replaceFirst("shoe", "tool"))) {
            return 2;
        }
        if (format.equals("text/plain")) {
            return 3;
        }
        if (format.equals("text/xml")) {
            return 5;
        }
        if (format.equals("text/html")) {
            return 4;
        }
        if (format.equals("text/csv")) {
            return 6;
        }
        return -1;
    }

    public static String getNameFor(String nodeId) {
        if (nodeId == null) {
            return null;
        }
        try {
            return AnnexUtil.getCorpusStructureDB().getNode(nodeId).getName();
        }
        catch (UnknownNodeException une) {
            logger.warn("getNameFor: Node " + nodeId + " not known");
            return "UNKNOWN";
        }
    }

    public static String getNamePathFor(String nodeId) {
        return nodeId == null ? null : AnnexUtil.getCorpusStructureDB().getNamePath(nodeId);
    }

    private static void initCorpusStructureDBImpl() {
        if (csdb != null && aodb != null) {
            return;
        }
        CorpusStructureDBImpl csdbimpl = new CorpusStructureDBImpl(_corpusDbURL, false, _corpusDbUser, _corpusDbPassword);
        csdb = csdbimpl;
        aodb = csdbimpl;
    }

    public static CorpusStructureDB getCorpusStructureDB() {
        if (csdb == null) {
            AnnexUtil.initCorpusStructureDBImpl();
        }
        return csdb;
    }

    public static ArchiveObjectsDB getArchiveObjectsDB() {
        if (aodb == null) {
            AnnexUtil.initCorpusStructureDBImpl();
        }
        return aodb;
    }

    public static void closeCorpusStructureDBImpl() {
        if (csdb != null) {
            csdb.close();
            csdb = null;
        }
        if (aodb != null) {
            aodb.close();
            aodb = null;
        }
    }
}

