/*
 * Decompiled with CFR 0.152.
 */
package guk.im;

import guk.im.Action;
import guk.im.GateIMDescriptor;
import guk.im.Key;
import guk.im.KeyboardMap;
import guk.im.LocaleHandler;
import guk.im.State;
import java.awt.AWTEvent;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.im.spi.InputMethod;
import java.awt.im.spi.InputMethodContext;
import java.io.IOException;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class GateIM
implements InputMethod {
    Locale currentLocale;
    Locale defaultLocale = new Locale("en", "", "ASCII");
    LocaleHandler currentHandler;
    InputMethodContext myContext;
    Map supportedLocales;
    Map loadedLocales;
    boolean enabled;
    String composedText = "";
    State currentState;
    Map additionalKeymaps;
    KeyboardMap keyboardMap;
    boolean mapVisible = false;
    private static String imBase = "/guk/im/data/";
    private static Font keyboardFont = new Font("Arial Unicode MS", 0, 12);

    public GateIM(Map map) {
        this.supportedLocales = map;
        this.loadedLocales = new HashMap();
    }

    public void setInputMethodContext(InputMethodContext inputMethodContext) {
        this.myContext = inputMethodContext;
        this.myContext.enableClientWindowNotification(this, false);
    }

    public boolean setLocale(Locale locale) {
        this.endComposition();
        try {
            if (this.supportedLocales.containsKey(locale)) {
                this.currentLocale = locale;
                this.loadLocale(locale);
                if (this.keyboardMap != null) {
                    this.keyboardMap.update(this.currentHandler, this.currentState);
                }
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            return false;
        }
        return false;
    }

    public Locale getLocale() {
        return this.currentLocale;
    }

    public GateIMDescriptor getDescriptor() {
        return new GateIMDescriptor();
    }

    public void setCharacterSubsets(Character.Subset[] subsetArray) {
    }

    public void setCompositionEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isCompositionEnabled() {
        return this.enabled;
    }

    public void reconvert() {
        throw new UnsupportedOperationException("Reconversion not supported!");
    }

    public void dispatchEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)aWTEvent;
            char c = keyEvent.getKeyChar();
            int n = keyEvent.getKeyCode();
            int n2 = keyEvent.getModifiers();
            int n3 = keyEvent.getID();
            if ((n3 == 401 || n3 == 402) && (n2 & 2) > 0 && n != 17) {
                boolean bl;
                boolean bl2 = bl = (n2 & 1) > 0;
                if (c == '\uffff' || Character.isISOControl(c)) {
                    if (48 <= n && n <= 57) {
                        if (!bl) {
                            c = (char)n;
                        } else {
                            switch ((char)n) {
                                case '0': {
                                    c = ')';
                                    break;
                                }
                                case '1': {
                                    c = '!';
                                    break;
                                }
                                case '2': {
                                    c = '\"';
                                    break;
                                }
                                case '3': {
                                    c = '\u00a3';
                                    break;
                                }
                                case '4': {
                                    c = '$';
                                    break;
                                }
                                case '5': {
                                    c = '%';
                                    break;
                                }
                                case '6': {
                                    c = '^';
                                    break;
                                }
                                case '7': {
                                    c = '&';
                                    break;
                                }
                                case '8': {
                                    c = '*';
                                    break;
                                }
                                case '9': {
                                    c = '(';
                                }
                            }
                        }
                    } else if (65 <= n && n <= 90) {
                        c = (char)n;
                        if (!bl) {
                            c = Character.toLowerCase(c);
                        }
                    } else {
                        switch (n) {
                            case 45: {
                                c = bl ? (char)'_' : '-';
                                break;
                            }
                            case 61: {
                                c = bl ? (char)'+' : '=';
                                break;
                            }
                            case 91: {
                                c = bl ? (char)'{' : '[';
                                break;
                            }
                            case 93: {
                                c = bl ? (char)'}' : ']';
                                break;
                            }
                            case 59: {
                                c = bl ? (char)':' : ';';
                                break;
                            }
                            case 192: {
                                c = bl ? (char)'@' : '\'';
                                break;
                            }
                            case 222: {
                                c = bl ? (char)'~' : '#';
                                break;
                            }
                            case 92: {
                                c = bl ? (char)'|' : '\\';
                                break;
                            }
                            case 44: {
                                c = bl ? (char)'<' : ',';
                                break;
                            }
                            case 65480: {
                                c = bl ? (char)'>' : '.';
                                break;
                            }
                            case 47: {
                                char c2 = c = bl ? (char)'?' : '/';
                            }
                        }
                    }
                }
                if (n3 == 401) {
                    n3 = 400;
                }
            }
            ((KeyEvent)aWTEvent).setKeyChar(c);
            if (this.keyboardMap != null) {
                this.keyboardMap.addJob(aWTEvent);
            }
            if (!(n3 != 400 || c != ' ' && Character.isISOControl(c))) {
                Key key = new Key(c, n2);
                Action action = this.currentState.getNext(key);
                if (action == null) {
                    if (this.currentState.isFinal()) {
                        this.myContext.dispatchInputMethodEvent(1100, new AttributedString(this.composedText).getIterator(), this.composedText.length(), null, null);
                    }
                    this.composedText = "";
                    this.currentState = this.currentHandler.getInitialState();
                    action = this.currentState.getNext(key);
                }
                if (action == null) {
                    this.composedText = "";
                } else {
                    this.currentState = action.getNext();
                    this.composedText = action.getComposedText();
                }
                ((KeyEvent)aWTEvent).consume();
                boolean bl = !this.currentState.hasNext();
                this.myContext.dispatchInputMethodEvent(1100, new AttributedString(this.composedText).getIterator(), bl ? this.composedText.length() : 0, null, null);
                if (bl) {
                    this.composedText = "";
                }
                if (this.keyboardMap != null) {
                    this.keyboardMap.update(this.currentHandler, this.currentState);
                }
            }
        }
    }

    public void notifyClientWindowChange(Rectangle rectangle) {
    }

    public void activate() {
        this.enabled = true;
        if (this.currentLocale == null) {
            this.setLocale(this.defaultLocale);
        }
        if (this.mapVisible) {
            this.keyboardMap.addJob("SHOW");
        }
    }

    public void deactivate(boolean bl) {
        this.endComposition();
        this.enabled = false;
    }

    public void hideWindows() {
        if (this.mapVisible) {
            this.keyboardMap.addJob("HIDE");
        }
    }

    public void removeNotify() {
    }

    public void endComposition() {
        if (this.composedText.length() > 0 && this.currentState.isFinal()) {
            this.myContext.dispatchInputMethodEvent(1100, new AttributedString(this.composedText).getIterator(), this.composedText.length(), null, null);
        }
        this.composedText = "";
    }

    public void dispose() {
        this.endComposition();
        if (this.keyboardMap != null) {
            this.keyboardMap.addJob("DIE");
            this.keyboardMap = null;
        }
        this.currentLocale = null;
        this.currentHandler = null;
        this.currentState = null;
        this.myContext = null;
        this.supportedLocales.clear();
        this.supportedLocales = null;
        this.loadedLocales.clear();
        this.loadedLocales = null;
    }

    public Object getControlObject() {
        return this;
    }

    public void setMapVisible(boolean bl) {
        if (bl) {
            this.mapVisible = true;
            if (this.keyboardMap == null) {
                this.keyboardMap = new KeyboardMap(this, this.currentHandler, this.currentState);
            }
            this.keyboardMap.addJob("SHOW");
        } else {
            this.mapVisible = false;
            if (this.keyboardMap != null) {
                this.keyboardMap.addJob("HIDE");
            }
        }
    }

    protected void loadLocale(Locale locale) {
        String string = (String)this.supportedLocales.get(locale);
        if (string == null) {
            throw new IllegalArgumentException("Unknown locale: " + locale);
        }
        this.currentHandler = (LocaleHandler)this.loadedLocales.get(locale);
        if (this.currentHandler == null) {
            try {
                this.currentHandler = new LocaleHandler(locale, string);
                this.loadedLocales.put(locale, this.currentHandler);
                this.currentState = this.currentHandler.getInitialState();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Cannot load locale: " + locale);
            }
        }
    }

    public InputMethodContext getContext() {
        return this.myContext;
    }

    public static void setIMBase(String string) {
        imBase = string;
    }

    public static String getIMBase() {
        return imBase;
    }

    public static Font getKeyboardFont() {
        return keyboardFont;
    }
}

