/*
 * Decompiled with CFR 0.152.
 */
package mpi.dcr;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionListener;
import mpi.dcr.AbstractDCSelectPanel;
import mpi.dcr.DCRConnectorException;
import mpi.dcr.DCSmall;
import mpi.dcr.ILATDCRConnector;
import mpi.dcr.ProfileSelectPanel;
import mpi.dcr.isocat.Profile;
import mpi.dcr.isocat.RestDCRConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteDCSelectPanel
extends AbstractDCSelectPanel
implements ActionListener,
ItemListener,
ListSelectionListener,
TreeSelectionListener {
    public static final int ALL_PROFILES = 0;
    public static final int PROFILE_SELECTION = 1;
    protected JButton addProfButton;
    protected JButton removeProfButton;
    private int mode = 0;

    public RemoteDCSelectPanel(ILATDCRConnector connector) {
        super(connector);
        if (connector instanceof RestDCRConnector) {
            this.connector = (RestDCRConnector)connector;
        }
        this.initComponents();
    }

    public RemoteDCSelectPanel(ILATDCRConnector connector, ResourceBundle resBundle) {
        super(connector, resBundle);
        if (connector instanceof RestDCRConnector) {
            this.connector = (RestDCRConnector)connector;
        }
        this.initComponents();
    }

    public RemoteDCSelectPanel(ILATDCRConnector connector, int mode) {
        super(connector);
        if (connector instanceof RestDCRConnector) {
            this.connector = (RestDCRConnector)connector;
        }
        if (mode == 1) {
            this.mode = 1;
        }
        this.initComponents();
    }

    public RemoteDCSelectPanel(ILATDCRConnector connector, ResourceBundle resBundle, int mode) {
        super(connector, resBundle);
        if (connector instanceof RestDCRConnector) {
            this.connector = (RestDCRConnector)connector;
        }
        if (mode == 1) {
            this.mode = 1;
        }
        this.initComponents();
    }

    public RemoteDCSelectPanel() {
        this.initComponents();
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        if (this.mode == 1) {
            this.addProfButton = new JButton();
            this.removeProfButton = new JButton();
            Insets insets = new Insets(2, 6, 2, 6);
            this.addProfButton.addActionListener(this);
            this.removeProfButton.addActionListener(this);
            JPanel buttonPanel = new JPanel(new GridLayout(2, 1, 6, 2));
            buttonPanel.add(this.addProfButton);
            buttonPanel.add(this.removeProfButton);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.insets = insets;
            gbc.gridy = 1;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            this.profPanel.add((Component)buttonPanel, gbc);
        } else if (this.connector != null) {
            try {
                ArrayList profiles = (ArrayList)this.connector.getProfiles();
                this.addProfiles(profiles);
            }
            catch (DCRConnectorException dce) {
                dce.printStackTrace();
            }
        }
        this.updateLocale();
    }

    @Override
    protected void updateLocale() {
        super.updateLocale();
        String addProf = "Add Profile";
        String remProf = "Remove Profile";
        String selCats = "Select Categories";
        if (this.resBundle != null) {
            try {
                addProf = this.resBundle.getString("DCR.Label.AddProfile");
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                remProf = this.resBundle.getString("DCR.Label.RemoveProfile");
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                selCats = this.resBundle.getString("DCR.Label.SelectCategories");
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (this.mode == 1) {
            this.addProfButton.setText(addProf);
            this.removeProfButton.setText(remProf);
        }
        this.catPanel.setBorder(new TitledBorder(selCats));
        this.sortModeCombo.addItemListener(this);
    }

    @Override
    public void addProfiles(List<Profile> profiles) {
        if (profiles != null) {
            block0: for (int i = 0; i < profiles.size(); ++i) {
                Profile profile = profiles.get(i);
                if (profile == null) continue;
                for (int j = 0; j < this.profList.getModel().getSize(); ++j) {
                    if (profile.getId().equals(((Profile)this.profList.getModel().getElementAt(j)).getId())) continue block0;
                }
                ((DefaultListModel)this.profList.getModel()).addElement(profile);
            }
            if (this.profList.getModel().getSize() == 1) {
                this.profList.setSelectedIndex(0);
            }
        }
    }

    private void addProfiles() {
        ProfileSelectPanel pp = new ProfileSelectPanel(this.connector);
        int ret = JOptionPane.showConfirmDialog(this, pp, "", 2, -1);
        if (ret == 0) {
            this.addProfiles(pp.getSelectedProfiles());
        }
    }

    private void removeProfile() {
        if (this.profList.getSelectedIndex() > -1) {
            this.profModel.remove(this.profList.getSelectedIndex());
        }
    }

    public List<Profile> getSelectedProfiles() {
        ArrayList<Profile> selProfs = new ArrayList<Profile>();
        for (int j = 0; j < this.profList.getModel().getSize(); ++j) {
            selProfs.add((Profile)this.profList.getModel().getElementAt(j));
        }
        return selProfs;
    }

    @Override
    public List getSelectedCategories() {
        return super.getSelectedCategories();
    }

    @Override
    protected List getDataCategories(Profile profile) {
        return super.getDataCategories(profile);
    }

    @Override
    protected void updateCategories(List datcats) {
        if (datcats == null) {
            datcats = new ArrayList(0);
        }
        super.updateCategories(datcats);
    }

    @Override
    protected void updateDescription(DCSmall dc) {
        super.updateDescription(dc);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addProfButton) {
            this.addProfiles();
        } else if (e.getSource() == this.removeProfButton) {
            this.removeProfile();
        }
    }
}

