/*
 * Decompiled with CFR 0.152.
 */
package mpi.dcr.isocat;

import java.util.ArrayList;
import java.util.List;
import mpi.dcr.DCSmall;
import mpi.dcr.isocat.Profile;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class DCIF_DC_Handler
implements ContentHandler {
    private DCSmall curDC;
    private boolean inLanguage = false;
    private boolean inEng = false;
    private boolean recordContent = false;
    private String curContent;
    private List<Profile> curProfs = new ArrayList<Profile>();

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.recordContent) {
            this.curContent = new String(ch, start, length);
        }
    }

    public DCSmall getDC() {
        return this.curDC;
    }

    public void endDocument() throws SAXException {
        this.curDC.setLoaded(true);
        this.curProfs.clear();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        Profile pf;
        if (qName.equals("dcif:dataCategory")) {
            if (this.curProfs.size() > 0) {
                this.curDC.setProfiles(this.curProfs.toArray(new Profile[0]));
            }
        } else if (qName.equals("dcif:identifier")) {
            if (this.curDC != null) {
                this.curDC.setIdentifier(this.curContent);
            }
        } else if (qName.equals("dcif:language")) {
            if (this.inLanguage && this.curContent != null && this.curContent.equals("en")) {
                this.inEng = true;
            }
        } else if (qName.equals("dcif:languageSection")) {
            this.inLanguage = false;
            this.inEng = false;
        } else if (qName.equals("dcif:definition")) {
            if (this.inLanguage && this.inEng && this.curDC != null) {
                this.curDC.setDesc(this.curContent);
            }
        } else if (qName.equals("dcif:name")) {
            if (this.inLanguage && this.inEng && this.curDC != null) {
                this.curDC.setName(this.curContent);
            }
        } else if (qName.equals("dcif:profile") && !this.curProfs.contains(pf = new Profile(null, this.curContent))) {
            this.curProfs.add(pf);
        }
        this.recordContent = false;
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
        this.curDC = null;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals("dcif:dataCategory")) {
            this.curDC = new DCSmall(atts.getValue("pid"), null);
        } else if (qName.equals("dcif:profile")) {
            this.recordContent = true;
        } else if (qName.equals("dcif:languageSection")) {
            this.inLanguage = true;
        } else if (qName.equals("dcif:language")) {
            if (this.inLanguage) {
                this.recordContent = true;
            }
        } else if (qName.equals("dcif:definition")) {
            this.recordContent = true;
        } else if (qName.equals("dcif:name")) {
            if (this.inEng) {
                this.recordContent = true;
            }
        } else if (qName.equals("dcif:identifier")) {
            this.recordContent = true;
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }
}

