/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.PreferencesListener;
import mpi.eudico.client.annotator.gui.ChangedTranscriptionsPane;
import mpi.eudico.client.annotator.gui.ExitStrategyPane;
import mpi.eudico.client.annotator.integration.ExternalLauncher;
import mpi.eudico.client.annotator.util.FileUtility;
import mpi.eudico.client.annotator.util.FrameInfo;
import mpi.eudico.client.annotator.util.MonitoringLogger;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class FrameManager
implements PreferencesListener {
    private static final FrameManager manager = new FrameManager();
    private boolean exitAllowed = false;
    private Map recentFilesMap;
    private List<String> recentFilesList;
    private List openFrameList;
    private final int maxFilePathLength = 40;
    private int frameCounter = 0;
    private final String FR_NAME = "Frame-";
    private final String RECENTS_PREF = "FrameManager.RecentFiles";
    private final String EXIT_PREF = "FrameManager.ExitMes";
    private List completeRecentItems;
    private int nrRecentItemsPreference = 5;

    private FrameManager() {
        Integer recentItems = (Integer)Preferences.get("UI.RecentItems", null);
        if (recentItems != null) {
            this.nrRecentItemsPreference = recentItems;
        }
        this.recentFilesMap = new HashMap(this.nrRecentItemsPreference);
        this.recentFilesList = new ArrayList<String>(this.nrRecentItemsPreference);
        this.openFrameList = new ArrayList(10);
        this.completeRecentItems = (ArrayList)Preferences.get("FrameManager.RecentFiles", null);
        if (this.completeRecentItems != null) {
            for (int i = 0; i < this.completeRecentItems.size() && i < this.nrRecentItemsPreference; ++i) {
                String url = (String)this.completeRecentItems.get(i);
                if (url == null) continue;
                this.recentFilesList.add(url);
                String shUrl = this.fullPathToDisplayPath(url);
                if (shUrl == null) continue;
                this.recentFilesMap.put(url, shUrl);
            }
        } else {
            this.completeRecentItems = new ArrayList();
        }
        Preferences.addPreferencesListener(null, this);
    }

    private void updateRecentFileMenu() {
        Integer recentItems = (Integer)Preferences.get("UI.RecentItems", null);
        if (recentItems != null) {
            this.nrRecentItemsPreference = recentItems;
        }
        ArrayList<String> old_recentFilesList = new ArrayList<String>(this.recentFilesList.subList(0, this.recentFilesList.size()));
        int nrTotalRecentFiles = this.completeRecentItems.size();
        if (this.nrRecentItemsPreference <= nrTotalRecentFiles) {
            this.recentFilesList.clear();
            this.recentFilesList.addAll(this.completeRecentItems.subList(0, this.nrRecentItemsPreference));
        } else {
            this.recentFilesList.clear();
            this.recentFilesList.addAll(this.completeRecentItems);
        }
        for (Object frame_info : this.openFrameList) {
            if (!(((FrameInfo)frame_info).getFrame() instanceof ElanFrame2)) continue;
            ElanFrame2 elan_frame = (ElanFrame2)((FrameInfo)frame_info).getFrame();
            for (String url : old_recentFilesList) {
                elan_frame.removeActionFromMenu(url, 11);
            }
            for (int i = 0; i < this.recentFilesList.size(); ++i) {
                String lon = this.recentFilesList.get(i);
                String sho = (String)this.recentFilesMap.get(lon);
                elan_frame.addActionToMenu(new RecentAction(elan_frame, sho, lon), 11, i);
            }
        }
    }

    public static FrameManager getInstance() {
        return manager;
    }

    public void closeFrame(String frameId) {
        if (frameId == null) {
            return;
        }
        FrameInfo fin = null;
        for (int i = 0; i < this.openFrameList.size() && !(fin = (FrameInfo)this.openFrameList.get(i)).getFrameId().equals(frameId); ++i) {
            fin = null;
        }
        if (fin != null) {
            this.closeFrame(fin.getFrame());
        }
    }

    public void closeFrame(JFrame frame) {
        int i;
        if (frame == null) {
            return;
        }
        FrameInfo fin = null;
        for (int i2 = 0; i2 < this.openFrameList.size() && (fin = (FrameInfo)this.openFrameList.get(i2)).getFrame() != frame; ++i2) {
            fin = null;
        }
        if (fin == null) {
            return;
        }
        String id = fin.getFrameId();
        this.openFrameList.remove(fin);
        if (id != null) {
            for (i = 0; i < this.openFrameList.size(); ++i) {
                FrameInfo info = (FrameInfo)this.openFrameList.get(i);
                if (!(info.getFrame() instanceof ElanFrame2)) continue;
                ((ElanFrame2)info.getFrame()).removeActionFromMenu(id, 800);
            }
        }
        FrameInfo actInfo = null;
        for (i = 0; i < this.openFrameList.size() && !(actInfo = (FrameInfo)this.openFrameList.get(i)).getFrame().isActive(); ++i) {
            actInfo = null;
        }
        if (actInfo != null) {
            for (int i3 = 0; i3 < this.openFrameList.size(); ++i3) {
                FrameInfo other = (FrameInfo)this.openFrameList.get(i3);
                if (!(other.getFrame() instanceof ElanFrame2)) continue;
                ((ElanFrame2)other.getFrame()).setMenuSelected(actInfo.getFrameId(), 800);
            }
        }
        if (this.openFrameList.size() == 0) {
            if (frame instanceof ElanFrame2) {
                if (((ElanFrame2)frame).getViewerManager() != null) {
                    this.createEmptyFrame();
                } else {
                    this.exit();
                }
            } else {
                this.createEmptyFrame();
            }
        }
    }

    public void setToFront(String frameId) {
        FrameInfo fin = null;
        for (int i = 0; i < this.openFrameList.size(); ++i) {
            fin = (FrameInfo)this.openFrameList.get(i);
            if (!fin.getFrameId().equals(frameId)) continue;
            fin.getFrame().toFront();
            break;
        }
    }

    public void activateNextFrame(boolean forward) {
        FrameInfo loopInfo;
        if (this.openFrameList.size() <= 1) {
            return;
        }
        int current = -1;
        for (int i = 0; i < this.openFrameList.size(); ++i) {
            ElanFrame2 ef2;
            loopInfo = (FrameInfo)this.openFrameList.get(i);
            if (!(loopInfo.getFrame() instanceof ElanFrame2) || !(ef2 = (ElanFrame2)loopInfo.getFrame()).isActive()) continue;
            current = i;
            break;
        }
        int next = -1;
        next = current == this.openFrameList.size() - 1 ? (forward ? 0 : current - 1) : (current == 0 ? (forward ? 1 : this.openFrameList.size() - 1) : (forward ? current + 1 : current - 1));
        if (next > -1 && next < this.openFrameList.size()) {
            loopInfo = (FrameInfo)this.openFrameList.get(next);
            loopInfo.getFrame().toFront();
        }
    }

    public void frameActivated(JFrame frame) {
        if (frame == null) {
            return;
        }
        FrameInfo fin = null;
        for (int i = 0; i < this.openFrameList.size(); ++i) {
            fin = (FrameInfo)this.openFrameList.get(i);
            if (fin.getFrame() != frame) continue;
            this.frameActivated(fin.getFrameId());
        }
    }

    public void frameActivated(String frameId) {
        if (frameId != null) {
            FrameInfo fin = null;
            for (int i = 0; i < this.openFrameList.size(); ++i) {
                fin = (FrameInfo)this.openFrameList.get(i);
                if (!(fin.getFrame() instanceof ElanFrame2)) continue;
                ((ElanFrame2)fin.getFrame()).setMenuSelected(frameId, 800);
            }
        }
    }

    public JFrame getActiveFrame() {
        if (this.openFrameList.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.openFrameList.size(); ++i) {
            ElanFrame2 ef2;
            FrameInfo loopInfo = (FrameInfo)this.openFrameList.get(i);
            if (!(loopInfo.getFrame() instanceof ElanFrame2) || !(ef2 = (ElanFrame2)loopInfo.getFrame()).isActive()) continue;
            return ef2;
        }
        return null;
    }

    public ElanFrame2 getFrameFor(String filePath) {
        if (filePath == null) {
            return null;
        }
        FrameInfo fin = null;
        for (int i = 0; i < this.openFrameList.size(); ++i) {
            fin = (FrameInfo)this.openFrameList.get(i);
            if (fin.getFilePath() == null || !fin.getFilePath().equals(filePath) || !(fin.getFrame() instanceof ElanFrame2)) continue;
            return (ElanFrame2)fin.getFrame();
        }
        return this.createFrame(filePath);
    }

    public void updateFrameTitle(JFrame frame, String newPath) {
        if (frame == null || newPath == null) {
            return;
        }
        if (newPath.startsWith("file")) {
            newPath = newPath.substring(5);
        }
        FrameInfo fin = null;
        for (int i = 0; i < this.openFrameList.size() && (fin = (FrameInfo)this.openFrameList.get(i)).getFrame() != frame; ++i) {
            fin = null;
        }
        if (fin == null) {
            return;
        }
        String nextName = FileUtility.fileNameFromPath(newPath);
        for (int i = 0; i < this.openFrameList.size(); ++i) {
            FrameInfo loopInfo = (FrameInfo)this.openFrameList.get(i);
            if (!(loopInfo.getFrame() instanceof ElanFrame2)) continue;
            ElanFrame2 ef2 = (ElanFrame2)loopInfo.getFrame();
            ef2.removeActionFromMenu(fin.getFrameId(), 800);
            ef2.addActionToMenu(new ActiveWindowAction(fin.getFrameId(), nextName), 800, -1);
            if (!frame.isActive()) continue;
            ef2.setMenuSelected(fin.getFrameId(), 800);
        }
        fin.setFilePath(newPath);
        fin.setFrameName(nextName);
        this.addToRecentFiles(newPath);
    }

    public void exit() {
        Boolean again = (Boolean)Preferences.get("FrameManager.ExitMes", null);
        if (again == null || !again.booleanValue()) {
            ExitStrategyPane pane = new ExitStrategyPane();
            int option = JOptionPane.showConfirmDialog(this.getActiveFrame(), pane, ElanLocale.getString("Menu.File.Exit"), 2, 2);
            if (option != 0) {
                return;
            }
            boolean sel = pane.getDontShowAgain();
            if (sel) {
                Preferences.set("FrameManager.ExitMes", new Boolean(sel), null);
            }
        }
        ArrayList<String> changedTrans = new ArrayList<String>(this.openFrameList.size());
        for (int i = 0; i < this.openFrameList.size(); ++i) {
            FrameInfo loopInfo = (FrameInfo)this.openFrameList.get(i);
            if (!(loopInfo.getFrame() instanceof ElanFrame2)) continue;
            ElanFrame2 ef2 = (ElanFrame2)loopInfo.getFrame();
            if (ef2.getViewerManager() != null) {
                if (!ef2.getViewerManager().getTranscription().isChanged()) continue;
                changedTrans.add(loopInfo.getFrameName());
                continue;
            }
            ef2.doClose(false);
        }
        ArrayList vals = null;
        if (changedTrans.size() > 0) {
            ChangedTranscriptionsPane pane = new ChangedTranscriptionsPane(changedTrans);
            int option = JOptionPane.showConfirmDialog(this.getActiveFrame(), pane, ElanLocale.getString("Menu.File.Save"), 2, 3);
            if (option != 0) {
                return;
            }
            vals = pane.getSelectedValues();
        }
        for (int j = 0; j < this.openFrameList.size(); ++j) {
            FrameInfo loopInfo = (FrameInfo)this.openFrameList.get(j);
            if (vals != null && vals.contains(loopInfo.getFrameName())) {
                if (!(loopInfo.getFrame() instanceof ElanFrame2)) continue;
                ElanFrame2 ef2 = (ElanFrame2)loopInfo.getFrame();
                ef2.saveAndClose(false);
                continue;
            }
            if (!(loopInfo.getFrame() instanceof ElanFrame2)) continue;
            ElanFrame2 ef2 = (ElanFrame2)loopInfo.getFrame();
            ef2.doClose(false);
        }
        Preferences.set("FrameManager.RecentFiles", this.completeRecentItems, null);
        ArrayList<FrameInfo> closed = new ArrayList<FrameInfo>(this.openFrameList.size());
        for (int i = this.openFrameList.size() - 1; i >= 0; --i) {
            ElanFrame2 ef2;
            FrameInfo loopInfo = (FrameInfo)this.openFrameList.get(i);
            if (!(loopInfo.getFrame() instanceof ElanFrame2) || (ef2 = (ElanFrame2)loopInfo.getFrame()).isShowing()) continue;
            closed.add(loopInfo);
            this.openFrameList.remove(loopInfo);
        }
        if (this.openFrameList.size() > 0) {
            for (int i = 0; i < closed.size(); ++i) {
                FrameInfo loopInfo = (FrameInfo)closed.get(i);
                for (int j = 0; j < this.openFrameList.size(); ++j) {
                    FrameInfo ofi = (FrameInfo)this.openFrameList.get(j);
                    if (!(ofi.getFrame() instanceof ElanFrame2)) continue;
                    ElanFrame2 ef2 = (ElanFrame2)ofi.getFrame();
                    ef2.removeActionFromMenu(loopInfo.getFrameId(), 800);
                }
            }
            return;
        }
        ExternalLauncher.stop();
        if (this.exitAllowed) {
            MonitoringLogger.exitElan();
            System.exit(0);
        }
    }

    ElanFrame2 createEmptyFrame() {
        ElanFrame2 ef2 = new ElanFrame2();
        this.addFrame(ef2);
        return ef2;
    }

    public ElanFrame2 createFrame(String eafPath) {
        if (eafPath == null) {
            return null;
        }
        ElanFrame2 ef2 = null;
        if (this.openFrameList.size() == 1) {
            FrameInfo fin = (FrameInfo)this.openFrameList.get(0);
            if (fin.getFrame() instanceof ElanFrame2) {
                ef2 = (ElanFrame2)fin.getFrame();
                if (ef2.getViewerManager() == null) {
                    ef2.openEAF(eafPath);
                    this.updateFrameTitle(ef2, eafPath);
                } else {
                    ef2 = new ElanFrame2(eafPath);
                    this.addFrame(ef2);
                }
            }
        } else {
            ef2 = new ElanFrame2(eafPath);
            this.addFrame(ef2);
        }
        return ef2;
    }

    public ElanFrame2 createFrame(String eafPath, List files) {
        if (eafPath == null) {
            return null;
        }
        if (files == null) {
            return this.createFrame(eafPath);
        }
        Vector fileVector = null;
        fileVector = files instanceof Vector ? (Vector)files : new Vector(files);
        ElanFrame2 ef2 = null;
        if (this.openFrameList.size() == 1) {
            FrameInfo fin = (FrameInfo)this.openFrameList.get(0);
            if (fin.getFrame() instanceof ElanFrame2) {
                ef2 = (ElanFrame2)fin.getFrame();
                if (ef2.getViewerManager() == null) {
                    ef2.openEAF(eafPath, fileVector);
                    this.updateFrameTitle(ef2, eafPath);
                } else {
                    ef2 = new ElanFrame2(eafPath, fileVector);
                    this.addFrame(ef2);
                }
            }
        } else {
            ef2 = new ElanFrame2(eafPath, fileVector);
            this.addFrame(ef2);
        }
        return ef2;
    }

    public ElanFrame2 createFrame(Transcription transcription) {
        if (transcription == null) {
            return null;
        }
        ElanFrame2 ef2 = null;
        if (this.openFrameList.size() == 1) {
            FrameInfo fin = (FrameInfo)this.openFrameList.get(0);
            if (fin.getFrame() instanceof ElanFrame2) {
                ef2 = (ElanFrame2)fin.getFrame();
                if (ef2.getViewerManager() == null) {
                    ef2.setTranscription(transcription);
                    String fullPath = transcription.getName();
                    if (!transcription.getName().equals("aishug294879ryshfda9763afo8947a5gf")) {
                        fullPath = transcription.getFullPath();
                        if (fullPath.startsWith("file")) {
                            fullPath = fullPath.substring(5);
                        }
                        this.updateFrameTitle(ef2, fullPath);
                    }
                } else {
                    ef2 = new ElanFrame2(transcription);
                    this.addFrame(ef2);
                }
            }
        } else {
            ef2 = new ElanFrame2(transcription);
            this.addFrame(ef2);
        }
        return ef2;
    }

    public void addFrame(JFrame frame) {
        int i;
        if (frame == null) {
            return;
        }
        String id = "Frame-" + this.frameCounter++;
        String fullPath = null;
        String fileName = ElanLocale.getString("Frame.ElanFrame.Untitled") + "-" + this.frameCounter;
        FrameInfo frInfo = new FrameInfo(frame, id);
        frInfo.setFrameName(fileName);
        this.openFrameList.add(frInfo);
        if (frame instanceof ElanFrame2) {
            TranscriptionImpl tr;
            ElanFrame2 ef2 = (ElanFrame2)frame;
            if (ef2.getViewerManager() != null && !(tr = (TranscriptionImpl)ef2.getViewerManager().getTranscription()).getName().equals("aishug294879ryshfda9763afo8947a5gf")) {
                fullPath = tr.getFullPath();
                if (fullPath.startsWith("file")) {
                    fullPath = fullPath.substring(5);
                }
                fileName = tr.getName();
                frInfo.setFilePath(fullPath);
                frInfo.setFrameName(fileName);
            }
            for (i = 0; i < this.recentFilesList.size(); ++i) {
                String lon = this.recentFilesList.get(i);
                String sho = (String)this.recentFilesMap.get(lon);
                ef2.addActionToMenu(new RecentAction(ef2, sho, lon), 11, i);
            }
        }
        for (i = 0; i < this.openFrameList.size(); ++i) {
            ActiveWindowAction ac;
            ElanFrame2 ef2;
            FrameInfo fin = (FrameInfo)this.openFrameList.get(i);
            if (fin.getFrame() instanceof ElanFrame2) {
                ef2 = (ElanFrame2)fin.getFrame();
                ac = new ActiveWindowAction(id, fileName);
                ef2.addActionToMenu(ac, 800, -1);
                ef2.setMenuSelected(id, 800);
            }
            if (fin == frInfo || !(frInfo.getFrame() instanceof ElanFrame2)) continue;
            ef2 = (ElanFrame2)frInfo.getFrame();
            ac = new ActiveWindowAction(fin.getFrameId(), fin.getFrameName());
            ef2.addActionToMenu(ac, 800, i);
        }
        if (fullPath != null) {
            this.addToRecentFiles(fullPath);
        }
    }

    private void addToRecentFiles(String fullPath) {
        if (fullPath == null) {
            return;
        }
        if (!fullPath.toLowerCase().endsWith(".eaf")) {
            return;
        }
        String shortUrl = this.fullPathToDisplayPath(fullPath);
        boolean move = false;
        if (this.completeRecentItems.contains(fullPath)) {
            if (this.completeRecentItems.indexOf(fullPath) == 0) {
                return;
            }
            move = true;
            this.completeRecentItems.remove(fullPath);
            this.completeRecentItems.add(0, fullPath);
        } else {
            this.completeRecentItems.add(0, fullPath);
            if (this.completeRecentItems.size() > 30) {
                this.completeRecentItems.remove(this.completeRecentItems.size() - 1);
            }
            if (shortUrl != null) {
                this.recentFilesMap.put(fullPath, shortUrl);
            }
        }
        this.recentFilesList.clear();
        if (this.completeRecentItems.size() > this.nrRecentItemsPreference) {
            this.recentFilesList.addAll(this.completeRecentItems.subList(0, this.nrRecentItemsPreference));
        } else {
            this.recentFilesList.addAll(this.completeRecentItems);
        }
        for (int i = 0; i < this.openFrameList.size(); ++i) {
            Action ac;
            FrameInfo fin = (FrameInfo)this.openFrameList.get(i);
            if (!(fin.getFrame() instanceof ElanFrame2)) continue;
            ElanFrame2 ef2 = (ElanFrame2)fin.getFrame();
            if (move) {
                ac = ef2.removeActionFromMenu(fullPath, 11);
                ef2.addActionToMenu(ac, 11, 0);
                continue;
            }
            ac = new RecentAction(ef2, shortUrl, fullPath);
            ef2.addActionToMenu(ac, 11, 0);
        }
        Preferences.set("FrameManager.RecentFiles", this.completeRecentItems, null);
    }

    private void removeFromRecentFiles(String fullPath) {
        if (fullPath == null) {
            return;
        }
        if (this.completeRecentItems.contains(fullPath)) {
            this.completeRecentItems.remove(fullPath);
            this.recentFilesList.remove(fullPath);
            for (int i = 0; i < this.openFrameList.size(); ++i) {
                FrameInfo fin = (FrameInfo)this.openFrameList.get(i);
                if (!(fin.getFrame() instanceof ElanFrame2)) continue;
                ElanFrame2 ef2 = (ElanFrame2)fin.getFrame();
                ef2.removeActionFromMenu(fullPath, 11);
            }
            Preferences.set("FrameManager.RecentFiles", this.completeRecentItems, null);
        }
    }

    public String fullPathToDisplayPath(String fullPath) {
        int colon;
        if (fullPath == null) {
            return "";
        }
        int start = 0;
        int lastSep = fullPath.lastIndexOf(File.separatorChar);
        if (lastSep < 0) {
            if (fullPath.length() <= 40) {
                return fullPath;
            }
            return fullPath.substring(0, 37) + "...";
        }
        if (fullPath.startsWith("file:")) {
            start = 5;
        }
        if ((colon = fullPath.indexOf(58, start)) - start > 0 && colon - start < 5) {
            start = colon - 1;
        } else {
            int ad = 0;
            for (int i = 0; i < 3; ++i) {
                if (fullPath.charAt(start + i) != File.separatorChar) continue;
                ++ad;
            }
            if (ad == 3) {
                start += 2;
            }
        }
        if (fullPath.length() - start < 40) {
            return fullPath.substring(start);
        }
        int fl = fullPath.length() - lastSep;
        if (fl > 40) {
            return fullPath.substring(lastSep, lastSep + 40);
        }
        int fd = fullPath.indexOf(File.separatorChar, start + 3);
        if (fd == lastSep) {
            if (fl + fd - start <= 40) {
                return fullPath.substring(start);
            }
            return fullPath.substring(start, start + 40 - fl - 3) + "..." + fullPath.substring(lastSep);
        }
        if (fd >= 0 && fl + (fd - start) < 37) {
            int nextSep = fd;
            while ((nextSep = fullPath.indexOf(File.separatorChar, fd + 1)) > 0 && nextSep != lastSep && fl + (nextSep - start) < 37) {
                fd = nextSep;
            }
            return fullPath.substring(start, fd + 1) + "..." + fullPath.substring(lastSep);
        }
        if (fd >= 0) {
            int rm = Math.max(40 - fl - 4, 1);
            if (fd - start > rm) {
                fd = start + rm;
                return fullPath.substring(start, fd) + "." + File.separator + "..." + fullPath.substring(lastSep);
            }
            return fullPath.substring(start, fd + 1) + "..." + fullPath.substring(lastSep);
        }
        return fullPath.substring(start);
    }

    public boolean isExitAllowed() {
        return this.exitAllowed;
    }

    public void setExitAllowed(boolean exitAllowed) {
        this.exitAllowed = exitAllowed;
    }

    public void preferencesChanged() {
        Integer recentItems = (Integer)Preferences.get("UI.RecentItems", null);
        if (recentItems != null) {
            this.nrRecentItemsPreference = recentItems;
        }
        if (this.nrRecentItemsPreference != this.recentFilesList.size()) {
            this.updateRecentFileMenu();
        }
    }

    class ActiveWindowAction
    extends AbstractAction {
        ActiveWindowAction(String frameId, String fileName) {
            this.putValue("Name", fileName);
            this.putValue("LongDescription", frameId);
        }

        public void actionPerformed(ActionEvent e) {
            FrameManager.getInstance().setToFront((String)this.getValue("LongDescription"));
        }
    }

    class RecentAction
    extends AbstractAction {
        private JFrame fr;

        RecentAction(JFrame fr, String shortUrl, String fullUrl) {
            this.fr = fr;
            this.putValue("Name", shortUrl);
            this.putValue("LongDescription", fullUrl);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                String path = (String)this.getValue("LongDescription");
                File fileTemp = new File(path);
                if (!fileTemp.exists() || fileTemp.isDirectory()) {
                    String strMessage = ElanLocale.getString("Menu.Dialog.Message1");
                    strMessage = strMessage + path;
                    strMessage = strMessage + ElanLocale.getString("Menu.Dialog.Message2");
                    String strError = ElanLocale.getString("Message.Error");
                    JOptionPane.showMessageDialog(this.fr, strMessage, strError, 0);
                    FrameManager.this.removeFromRecentFiles(path);
                    return;
                }
            }
            catch (Exception exc) {
                // empty catch block
            }
            ElanFrame2 frame = FrameManager.getInstance().createFrame((String)this.getValue("LongDescription"));
        }
    }
}

