/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.StopEvent;
import mpi.eudico.client.mediacontrol.TimeEvent;

public class MediaPlayerControlSlider
extends AbstractViewer {
    private static Dimension SLIDERDIMENSION = new Dimension(600, 30);
    private int x1;
    private int x2;
    private int x3;
    private int y1 = 10;
    private int y2 = 28;
    private boolean bDraggedInMediaSlider = false;
    private int dragStart = -1;
    private int dragEnd = -1;
    private float sliderValue;

    MediaPlayerControlSlider() {
        this.setPreferredSize(SLIDERDIMENSION);
        this.setValue(0.0f);
        this.addMouseListener(new MediaPlayerControlSliderMouseListener());
        this.addMouseMotionListener(new MediaPlayerControlSliderMouseMotionListener());
    }

    public void setBDraggedInMediaSlider(boolean b) {
        this.bDraggedInMediaSlider = b;
    }

    public boolean getBDraggedInMediaSlider() {
        return this.bDraggedInMediaSlider;
    }

    public void setDragStart(int dragStart) {
        this.dragStart = dragStart;
    }

    public int getDragStart() {
        return this.dragStart;
    }

    public void setDragEnd(int dragEnd) {
        this.dragEnd = dragEnd;
    }

    public int getDragEnd() {
        return this.dragEnd;
    }

    public void updateMediaTime(int xcoord) {
        long lngTime = this.getMediaDuration() * (long)xcoord / (long)this.getWidth();
        if (lngTime > this.getMediaDuration()) {
            lngTime = this.getMediaDuration();
        } else if (lngTime < 0L) {
            lngTime = 0L;
        }
        this.setMediaTime(lngTime);
    }

    public void setValue(float value_in) {
        this.sliderValue = value_in;
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        float f;
        int value;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setColor(Constants.MEDIAPLAYERCONTROLSLIDERSELECTIONCOLOR);
        g2.draw3DRect(0, 15, this.getWidth(), 4, false);
        int selectedBeginTime = (int)this.getSelectionBeginTime();
        int selectedEndTime = (int)this.getSelectionEndTime();
        int duration = (int)this.getMediaDuration();
        if (duration == 0) {
            return;
        }
        if (selectedBeginTime != selectedEndTime) {
            int begin = this.getWidth() * selectedBeginTime / duration;
            int end = this.getWidth() * selectedEndTime / duration;
            g2.fillRect(begin, 15, end - begin, 4);
        }
        if ((value = (int)Math.floor(f = this.sliderValue * (float)(this.getWidth() - 1))) < 0) {
            value = 0;
        }
        if (value > this.getWidth() - 1) {
            value = this.getWidth() - 1;
        }
        this.x3 = value;
        this.x1 = this.x3 - 5;
        this.x2 = this.x3 + 5;
        if (this.x2 > this.getWidth() - 1) {
            this.x2 = this.getWidth() - 1;
        }
        g2.setColor(Constants.MEDIAPLAYERCONTROLSLIDERCROSSHAIRCOLOR);
        g2.drawLine(this.x1, this.y1, this.x2, this.y1);
        g2.drawLine(this.x1, this.y2, this.x2, this.y2);
        g2.drawLine(this.x3, this.y1, this.x3, this.y2);
    }

    public void updateLocale() {
    }

    public void updateActiveAnnotation() {
    }

    public void updateSelection() {
        this.repaint();
    }

    public void controllerUpdate(ControllerEvent event) {
        if (event instanceof TimeEvent || event instanceof StopEvent) {
            float position = (float)this.getMediaTime() * 1.0f / ((float)this.getMediaDuration() * 1.0f);
            this.setValue(position);
        }
    }

    public void preferencesChanged() {
    }

    private class MediaPlayerControlSliderMouseMotionListener
    extends MouseMotionAdapter {
        private MediaPlayerControlSliderMouseMotionListener() {
        }

        public void mouseDragged(MouseEvent e) {
            if (!e.isShiftDown()) {
                MediaPlayerControlSlider.this.updateMediaTime(e.getX());
                return;
            }
            MediaPlayerControlSlider.this.setBDraggedInMediaSlider(true);
            MediaPlayerControlSlider.this.setDragEnd(e.getX());
            int duration = (int)MediaPlayerControlSlider.this.getMediaDuration();
            long lngBeginSelectionTime = duration * MediaPlayerControlSlider.this.getDragStart() / MediaPlayerControlSlider.this.getWidth();
            long lngEndSelectionTime = duration * MediaPlayerControlSlider.this.getDragEnd() / MediaPlayerControlSlider.this.getWidth();
            if (lngBeginSelectionTime > lngEndSelectionTime) {
                long temp = lngBeginSelectionTime;
                lngBeginSelectionTime = lngEndSelectionTime;
                lngEndSelectionTime = temp;
            }
            MediaPlayerControlSlider.this.setSelection(lngBeginSelectionTime, lngEndSelectionTime);
            MediaPlayerControlSlider.this.updateMediaTime(MediaPlayerControlSlider.this.getDragEnd());
        }
    }

    private class MediaPlayerControlSliderMouseListener
    extends MouseAdapter {
        MediaPlayerControlSliderMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) && e.getButton() == 1 ^ e.isMetaDown() || e.isPopupTrigger()) {
                return;
            }
            int intX = e.getX();
            MediaPlayerControlSlider.this.updateMediaTime(intX);
            MediaPlayerControlSlider.this.setDragStart(intX);
        }

        public void mouseReleased(MouseEvent e) {
            MediaPlayerControlSlider.this.setBDraggedInMediaSlider(false);
            MediaPlayerControlSlider.this.setDragStart(-1);
            MediaPlayerControlSlider.this.setDragEnd(-1);
        }
    }
}

