/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.PreferencesUser;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.StopEvent;
import mpi.eudico.client.mediacontrol.TimeEvent;
import mpi.eudico.util.TimeFormatter;

public class TimePanel
extends AbstractViewer
implements ActionListener,
PreferencesUser {
    private JLabel timeLabel;
    private String STRCROSSHAIRTIMEINPUTBOX1 = "";
    private String STRCROSSHAIRTIMEINPUTBOX2 = "";
    private String STRCROSSHAIRTIMEINPUTBOX3 = "";
    private String STRCROSSHAIRTIMEINPUTBOX4 = "";
    private String STRCROSSHAIRTIMEINPUTBOX5 = "";
    private JPopupMenu popup;
    private ButtonGroup formatBG;
    private JMenu formatMenu;
    private JRadioButtonMenuItem hhmmssmsMI;
    private JRadioButtonMenuItem timecodePalMI;
    private JRadioButtonMenuItem timecodeNtscMI;
    private JRadioButtonMenuItem msMI;
    private final int TC = 0;
    private final int TC_PAL = 1;
    private final int TC_NTSC = 2;
    private final int MS = 3;
    private int mode = 0;

    public TimePanel() {
        this.setLayout(new BorderLayout());
        this.timeLabel = new JLabel("00:00:00.000");
        this.timeLabel.setFont(Constants.SMALLFONT);
        this.addMouseListener(new TimeLabelMouseHandler());
        this.add((Component)this.timeLabel, "Center");
        this.updateLocale();
        this.setVisible(true);
    }

    public void controllerUpdate(ControllerEvent event) {
        if (event instanceof TimeEvent || event instanceof StopEvent) {
            this.updateLabel();
        }
    }

    public void updateLabel() {
        switch (this.mode) {
            case 3: {
                this.timeLabel.setText(String.valueOf(this.getMediaTime()));
                break;
            }
            case 1: {
                this.timeLabel.setText(TimeFormatter.toTimecodePAL(this.getMediaTime()));
                break;
            }
            case 2: {
                this.timeLabel.setText(TimeFormatter.toTimecodeNTSC(this.getMediaTime()));
                break;
            }
            default: {
                this.timeLabel.setText(TimeFormatter.toString(this.getMediaTime()));
            }
        }
        this.repaint();
    }

    public void showCrosshairTimeInputBox() {
        boolean bAgain = true;
        while (bAgain) {
            String strNewTime = JOptionPane.showInputDialog(this, this.STRCROSSHAIRTIMEINPUTBOX1, this.STRCROSSHAIRTIMEINPUTBOX2, -1);
            if (strNewTime != null && !strNewTime.equals("")) {
                long lngSeconds = TimeFormatter.toMilliSeconds(strNewTime);
                if ((double)lngSeconds >= 0.0) {
                    this.setMediaTime(lngSeconds);
                    bAgain = false;
                } else {
                    JOptionPane.showMessageDialog(this, this.STRCROSSHAIRTIMEINPUTBOX3 + "\n" + this.STRCROSSHAIRTIMEINPUTBOX4, this.STRCROSSHAIRTIMEINPUTBOX5, 0);
                    bAgain = true;
                }
            }
            if (strNewTime != null) continue;
            break;
        }
    }

    private void createPopupMenu() {
        this.popup = new JPopupMenu();
        this.formatBG = new ButtonGroup();
        this.formatMenu = new JMenu();
        this.hhmmssmsMI = new JRadioButtonMenuItem();
        this.timecodePalMI = new JRadioButtonMenuItem();
        this.timecodeNtscMI = new JRadioButtonMenuItem();
        this.msMI = new JRadioButtonMenuItem();
        this.formatBG.add(this.hhmmssmsMI);
        this.formatBG.add(this.timecodePalMI);
        this.formatBG.add(this.timecodeNtscMI);
        this.formatBG.add(this.msMI);
        this.hhmmssmsMI.setSelected(this.mode == 0);
        this.timecodePalMI.setSelected(this.mode == 1);
        this.timecodeNtscMI.setSelected(this.mode == 2);
        this.msMI.setSelected(this.mode == 3);
        this.hhmmssmsMI.addActionListener(this);
        this.timecodePalMI.addActionListener(this);
        this.timecodeNtscMI.addActionListener(this);
        this.msMI.addActionListener(this);
        this.popup.add(this.formatMenu);
        this.formatMenu.add(this.hhmmssmsMI);
        this.formatMenu.add(this.timecodePalMI);
        this.formatMenu.add(this.timecodeNtscMI);
        this.formatMenu.add(this.msMI);
        this.updateLocale();
    }

    public void updateLocale() {
        this.STRCROSSHAIRTIMEINPUTBOX1 = ElanLocale.getString("MediaPlayerControlPanel.STRCROSSHAIRTIMEINPUTBOX1");
        this.STRCROSSHAIRTIMEINPUTBOX2 = ElanLocale.getString("MediaPlayerControlPanel.STRCROSSHAIRTIMEINPUTBOX2");
        this.STRCROSSHAIRTIMEINPUTBOX3 = ElanLocale.getString("MediaPlayerControlPanel.STRCROSSHAIRTIMEINPUTBOX3");
        this.STRCROSSHAIRTIMEINPUTBOX4 = ElanLocale.getString("MediaPlayerControlPanel.STRCROSSHAIRTIMEINPUTBOX4");
        this.STRCROSSHAIRTIMEINPUTBOX5 = ElanLocale.getString("MediaPlayerControlPanel.STRCROSSHAIRTIMEINPUTBOX5");
        if (this.popup != null) {
            this.formatMenu.setText(ElanLocale.getString("TimeCodeFormat.Label.TimeFormat"));
            this.hhmmssmsMI.setText(ElanLocale.getString("TimeCodeFormat.TimeCode"));
            this.timecodePalMI.setText(ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.PAL"));
            this.timecodeNtscMI.setText(ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.NTSC"));
            this.msMI.setText(ElanLocale.getString("TimeCodeFormat.MilliSec"));
        }
    }

    public void updateActiveAnnotation() {
    }

    public void updateSelection() {
    }

    public void actionPerformed(ActionEvent e) {
        if (this.timecodePalMI.isSelected()) {
            this.mode = 1;
            this.setPreference("TimePanel.TimeFormat", "PAL", this.getViewerManager().getTranscription());
        } else if (this.timecodeNtscMI.isSelected()) {
            this.mode = 2;
            this.setPreference("TimePanel.TimeFormat", "NTSC", this.getViewerManager().getTranscription());
        } else if (this.msMI.isSelected()) {
            this.mode = 3;
            this.setPreference("TimePanel.TimeFormat", "ms", this.getViewerManager().getTranscription());
        } else {
            this.mode = 0;
            this.setPreference("TimePanel.TimeFormat", "hh:mm:ss.ms", this.getViewerManager().getTranscription());
        }
        this.updateLabel();
    }

    public void preferencesChanged() {
        String timeformat = (String)this.getPreference("TimePanel.TimeFormat", this.getViewerManager().getTranscription());
        if (timeformat != null) {
            if (timeformat.equals("hh:mm:ss.ms")) {
                this.mode = 0;
            } else if (timeformat.equals("PAL")) {
                this.mode = 1;
            } else if (timeformat.equals("NTSC")) {
                this.mode = 2;
            } else if (timeformat.equals("ms")) {
                this.mode = 3;
            }
            this.updateLabel();
        }
    }

    private class TimeLabelMouseHandler
    extends MouseAdapter {
        private TimeLabelMouseHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) || e.getButton() == 1 && !e.isMetaDown() && e.isControlDown() || e.isPopupTrigger()) {
                return;
            }
            TimePanel.this.showCrosshairTimeInputBox();
        }

        public void mousePressed(MouseEvent e) {
            Point pp = e.getPoint();
            if (SwingUtilities.isRightMouseButton(e) && e.getButton() == 1 ^ e.isMetaDown() || e.isPopupTrigger()) {
                if (TimePanel.this.popup == null) {
                    TimePanel.this.createPopupMenu();
                }
                TimePanel.this.popup.show(TimePanel.this, pp.x, pp.y);
            }
        }
    }
}

