/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.ControlledVocabulary;

public class AddCVCommand
implements UndoableCommand {
    private String commandName;
    private TranscriptionImpl transcription;
    private String cvName;
    private String description;
    private ControlledVocabulary conVoc;

    public AddCVCommand(String name) {
        this.commandName = name;
    }

    public void undo() {
        if (this.transcription != null) {
            this.transcription.removeControlledVocabulary(this.conVoc);
        }
    }

    public void redo() {
        if (this.transcription != null && this.transcription.getControlledVocabulary(this.conVoc.getName()) == null) {
            this.transcription.addControlledVocabulary(this.conVoc);
        }
    }

    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        if (arguments.length == 2 && arguments[0] instanceof String) {
            this.cvName = (String)arguments[0];
            if (arguments[1] != null) {
                this.description = (String)arguments[1];
            }
            if (this.transcription.getControlledVocabulary(this.cvName) == null) {
                this.conVoc = new ControlledVocabulary(this.cvName, this.description);
                this.transcription.addControlledVocabulary(this.conVoc);
            }
        } else if (arguments[0] instanceof ControlledVocabulary) {
            this.conVoc = (ControlledVocabulary)arguments[0];
            if (this.transcription.getControlledVocabulary(this.conVoc.getName()) == null) {
                this.transcription.addControlledVocabulary(this.conVoc);
            }
        }
    }

    public String getName() {
        return this.commandName;
    }
}

