/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import mpi.eudico.client.annotator.commands.AddTierCommand;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class AddParticipantCommand
implements UndoableCommand {
    private String commandName;
    private TranscriptionImpl transcription;
    private List names;
    private Tier parentTier = null;
    private String participantName;
    private ArrayList newTiersCommand;
    private String oldValue;
    private String newValue;
    private boolean changePrefix;
    private boolean tierStrucSelected;

    public AddParticipantCommand(String name) {
        this.commandName = name;
        this.newTiersCommand = new ArrayList();
    }

    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        this.names = (List)arguments[0];
        this.participantName = (String)arguments[1];
        this.oldValue = (String)arguments[2];
        this.newValue = (String)arguments[3];
        this.changePrefix = (Boolean)arguments[4];
        this.tierStrucSelected = (Boolean)arguments[5];
        this.newValue = this.newValue.trim();
        if (this.names == null || this.names.size() == 0) {
            ClientLogger.LOG.warning("No tier/participant selected.");
            this.transcription.setNotifying(true);
            return;
        }
        this.setWaitCursor(true);
        if (this.tierStrucSelected) {
            for (int i = 0; i < this.names.size(); ++i) {
                TierImpl tier = (TierImpl)this.transcription.getTierWithId((String)this.names.get(i));
                if (tier == null) continue;
                this.parentTier = null;
                this.addTier(tier, true);
                Vector childTiers = tier.getDependentTiers();
                if (childTiers == null) continue;
                for (int c = 0; c < childTiers.size(); ++c) {
                    this.addTier((TierImpl)childTiers.get(c), false);
                }
            }
        } else {
            Vector tiers = this.transcription.getTiers();
            ArrayList<TierImpl> parentTiers = new ArrayList<TierImpl>();
            for (int i = 0; i < tiers.size(); ++i) {
                TierImpl tier = (TierImpl)tiers.get(i);
                if (tier == null || !this.names.contains(tier.getParticipant())) continue;
                if (!tier.hasParentTier()) {
                    if (parentTiers.contains(tier)) {
                        continue;
                    }
                } else {
                    if (parentTiers.contains(tier.getParentTier())) continue;
                    tier = (TierImpl)tier.getParentTier();
                }
                this.parentTier = null;
                parentTiers.add(tier);
                this.addTier(tier, true);
                Vector childTiers = tier.getDependentTiers();
                if (childTiers == null) continue;
                for (int c = 0; c < childTiers.size(); ++c) {
                    this.addTier((TierImpl)childTiers.get(c), false);
                }
            }
        }
        this.setWaitCursor(false);
    }

    private void addTier(TierImpl tier, boolean parent) {
        String tierName = tier.getName();
        String lingType = tier.getLinguisticType().getLinguisticTypeName();
        String annotator = tier.getAnnotator();
        Locale locale = tier.getDefaultLocale();
        tierName = this.oldValue != null && this.oldValue.trim().length() > 0 ? (this.changePrefix ? (tierName.startsWith(this.oldValue) ? tierName.replaceFirst(this.oldValue, this.newValue) : this.newValue + "-" + tierName) : (tierName.endsWith(this.oldValue) ? tierName.substring(0, tierName.lastIndexOf(this.oldValue)) + this.newValue : tierName + "-" + this.newValue)) : (this.changePrefix ? this.newValue + "-" + tierName : tierName + "-" + this.newValue);
        Object[] args = new Object[]{tierName, this.parentTier, lingType, this.participantName, annotator, locale};
        AddTierCommand c = new AddTierCommand("Menu.Tier.AddNewTier");
        c.execute(this.transcription, args);
        this.newTiersCommand.add(c);
        if (parent) {
            this.parentTier = this.transcription.getTierWithId(tierName);
        }
    }

    private void setWaitCursor(boolean showWaitCursor) {
        if (showWaitCursor) {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }

    public String getName() {
        return this.commandName;
    }

    public void undo() {
        if (this.transcription != null && this.newTiersCommand != null) {
            this.setWaitCursor(true);
            for (int i = 0; i < this.newTiersCommand.size(); ++i) {
                ((UndoableCommand)this.newTiersCommand.get(i)).undo();
            }
            this.setWaitCursor(false);
        }
    }

    public void redo() {
        if (this.transcription != null && this.newTiersCommand != null) {
            this.setWaitCursor(true);
            for (int i = 0; i < this.newTiersCommand.size(); ++i) {
                ((UndoableCommand)this.newTiersCommand.get(i)).redo();
            }
            this.setWaitCursor(false);
        }
    }
}

