/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.TimeInterval;

public class AddSegmentationCommand
implements UndoableCommand {
    private String commandName;
    private TranscriptionImpl transcription;
    private String tierName;
    private TierImpl tier;
    private ArrayList segments;
    ArrayList changedAnnotations;
    ArrayList removedAnnotations;

    public AddSegmentationCommand(String name) {
        this.commandName = name;
    }

    public void undo() {
        if (this.transcription != null) {
            this.restoreAnnotations();
        }
    }

    public void redo() {
        if (this.transcription != null) {
            this.createNewAnnotations();
        }
    }

    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        this.tierName = (String)arguments[0];
        this.segments = (ArrayList)arguments[1];
        if (this.transcription != null) {
            this.tier = (TierImpl)this.transcription.getTierWithId(this.tierName);
        }
        if (this.tier != null) {
            this.setWaitCursor(true);
            this.preProcessIntervals();
            this.changedAnnotations = new ArrayList();
            this.removedAnnotations = new ArrayList();
            this.storeAnnotations();
            this.createNewAnnotations();
            this.setWaitCursor(false);
        }
    }

    private void preProcessIntervals() {
        if (this.segments != null) {
            Collections.sort(this.segments, new IntervalComparator());
            TimeInterval t1 = null;
            TimeInterval t2 = null;
            for (int i = this.segments.size() - 1; i > 0; --i) {
                t1 = (TimeInterval)this.segments.get(i - 1);
                t2 = (TimeInterval)this.segments.get(i);
                if (t2.getBeginTime() >= t1.getEndTime()) continue;
                if (t1 instanceof AnnotationDataRecord) {
                    ((AnnotationDataRecord)t1).setEndTime(t2.getBeginTime());
                    if (((AnnotationDataRecord)t1).getDuration() > 0L) continue;
                    this.segments.remove(t1);
                    continue;
                }
                TimeInterval ti = new TimeInterval(t1.getBeginTime(), t2.getBeginTime());
                this.segments.remove(t1);
                if (ti.getDuration() <= 0L) continue;
                this.segments.add(i - 1, ti);
            }
        }
    }

    private void storeAnnotations() {
        if (this.segments != null && this.segments.size() > 0) {
            ArrayList<AbstractAnnotation> changedTemp = new ArrayList<AbstractAnnotation>();
            TimeInterval curInterval = null;
            AbstractAnnotation aa = null;
            for (int i = 0; i < this.segments.size(); ++i) {
                curInterval = (TimeInterval)this.segments.get(i);
                Vector effectedAnn = this.tier.getOverlappingAnnotations(curInterval.getBeginTime(), curInterval.getEndTime());
                for (int j = 0; j < effectedAnn.size(); ++j) {
                    aa = (AbstractAnnotation)effectedAnn.get(j);
                    if (aa.getBeginTimeBoundary() < curInterval.getBeginTime()) {
                        if (changedTemp.contains(aa)) continue;
                        changedTemp.add(aa);
                        this.changedAnnotations.add(AnnotationRecreator.createTreeForAnnotation(aa));
                        continue;
                    }
                    if (aa.getEndTimeBoundary() > curInterval.getEndTime()) {
                        if (changedTemp.contains(aa)) continue;
                        changedTemp.add(aa);
                        this.changedAnnotations.add(AnnotationRecreator.createTreeForAnnotation(aa));
                        continue;
                    }
                    this.removedAnnotations.add(AnnotationRecreator.createTreeForAnnotation(aa));
                }
            }
        }
    }

    private void createNewAnnotations() {
        if (this.segments == null || this.tier == null) {
            return;
        }
        if (!this.tier.isTimeAlignable()) {
            return;
        }
        int curPropMode = 0;
        curPropMode = this.transcription.getTimeChangePropagationMode();
        if (curPropMode != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        this.transcription.setNotifying(false);
        this.setWaitCursor(true);
        TimeInterval ti = null;
        AnnotationDataRecord adr = null;
        for (int i = 0; i < this.segments.size(); ++i) {
            Object segment = this.segments.get(i);
            if (segment instanceof AnnotationDataRecord) {
                adr = (AnnotationDataRecord)segment;
                AbstractAnnotation aa = (AbstractAnnotation)this.tier.createAnnotation(adr.getBeginTime(), adr.getEndTime());
                if (aa == null) continue;
                aa.setValue(adr.getValue());
                if (adr.getExtRef() == null) continue;
                aa.setExtRef(adr.getExtRef());
                continue;
            }
            if (!(segment instanceof TimeInterval)) continue;
            ti = (TimeInterval)segment;
            this.tier.createAnnotation(ti.getBeginTime(), ti.getEndTime());
        }
        this.transcription.setNotifying(true);
        this.setWaitCursor(false);
        this.transcription.setTimeChangePropagationMode(curPropMode);
    }

    private void restoreAnnotations() {
        int i;
        if (this.tier == null || this.segments == null || this.segments.size() == 0) {
            return;
        }
        this.setWaitCursor(true);
        this.transcription.setNotifying(false);
        int curPropMode = 0;
        curPropMode = this.transcription.getTimeChangePropagationMode();
        if (curPropMode != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        TimeInterval ti = null;
        Object adr = null;
        AbstractAnnotation aa = null;
        DefaultMutableTreeNode node = null;
        AnnotationDataRecord annRecord = null;
        for (i = 0; i < this.segments.size(); ++i) {
            ti = (TimeInterval)this.segments.get(i);
            aa = (AbstractAnnotation)this.tier.getAnnotationAtTime(ti.getBeginTime());
            if (aa != null) {
                this.tier.removeAnnotation(aa);
                continue;
            }
            System.out.println("Could not delete a previously created annotation");
        }
        for (i = 0; i < this.changedAnnotations.size(); ++i) {
            node = (DefaultMutableTreeNode)this.changedAnnotations.get(i);
            annRecord = (AnnotationDataRecord)node.getUserObject();
            Vector v = this.tier.getOverlappingAnnotations(annRecord.getBeginTime(), annRecord.getEndTime());
            if (v.size() > 1) {
                System.out.println("Found more than one annotation in interval");
            }
            for (int j = 0; j < v.size(); ++j) {
                aa = (AbstractAnnotation)v.get(j);
                this.tier.removeAnnotation(aa);
            }
        }
        if (this.changedAnnotations.size() > 0) {
            for (i = 0; i < this.changedAnnotations.size(); ++i) {
                node = (DefaultMutableTreeNode)this.changedAnnotations.get(i);
                AnnotationRecreator.createAnnotationFromTree(this.transcription, node, true);
            }
        }
        if (this.removedAnnotations.size() > 0) {
            for (i = 0; i < this.removedAnnotations.size(); ++i) {
                node = (DefaultMutableTreeNode)this.removedAnnotations.get(i);
                AnnotationRecreator.createAnnotationFromTree(this.transcription, node, true);
            }
        }
        this.transcription.setTimeChangePropagationMode(curPropMode);
        this.transcription.setNotifying(true);
        this.setWaitCursor(false);
    }

    public String getName() {
        return this.commandName;
    }

    private void setWaitCursor(boolean showWaitCursor) {
        if (showWaitCursor) {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }

    private void printSegments() {
        if (this.segments == null) {
            return;
        }
        if (this.segments.size() > 0) {
            for (int i = 0; i < this.segments.size(); ++i) {
                TimeInterval ti = (TimeInterval)this.segments.get(i);
                System.out.println("Segment: " + ti.getBeginTime() + " - " + ti.getEndTime());
            }
        }
    }

    class IntervalComparator
    implements Comparator {
        IntervalComparator() {
        }

        public int compare(Object o1, Object o2) throws ClassCastException {
            if (!(o1 instanceof TimeInterval) || !(o2 instanceof TimeInterval)) {
                throw new ClassCastException("Objects should be of type TimeInterval");
            }
            if (((TimeInterval)o1).getBeginTime() < ((TimeInterval)o2).getBeginTime()) {
                return -1;
            }
            if (((TimeInterval)o1).getBeginTime() == ((TimeInterval)o2).getBeginTime() && ((TimeInterval)o1).getEndTime() < ((TimeInterval)o2).getEndTime()) {
                return -1;
            }
            if (((TimeInterval)o1).getBeginTime() == ((TimeInterval)o2).getBeginTime() && ((TimeInterval)o1).getEndTime() == ((TimeInterval)o2).getEndTime()) {
                return 0;
            }
            return 1;
        }
    }
}

