/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.CommandAction;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.server.corpora.clom.TranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;

public class BackupCA
extends CommandAction {
    private static final Logger LOG = Logger.getLogger(BackupCA.class.getName());
    private int delay = 0;
    private boolean promptedOnce = false;
    private String filePath = "";
    private Timer timer;
    protected TranscriptionStore transcriptionStore = ACMTranscriptionStore.getCurrentTranscriptionStore();
    private int numBuFiles = 1;
    private int curIndex = 1;

    public BackupCA(ViewerManager2 viewerManager) {
        super(viewerManager, "CommandActions.Backup");
        if (this.vm.getTranscription() instanceof TranscriptionImpl) {
            this.filePath = ((TranscriptionImpl)this.vm.getTranscription()).getPathName();
        }
    }

    protected void newCommand() {
        this.command = null;
    }

    protected Object getReceiver() {
        return null;
    }

    protected Object[] getArguments() {
        return null;
    }

    public int getDelay() {
        return this.delay;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setDelay(int delayTime) {
        if (this.delay != delayTime) {
            this.delay = delayTime;
            Preferences.set("BackUpDelay", this.delay, null);
            if (delayTime == 0) {
                if (this.timer != null) {
                    this.timer.stop();
                }
            } else {
                if (this.timer != null) {
                    this.timer.stop();
                }
                this.createTimer();
            }
        }
    }

    public int getNumBuFiles() {
        return this.numBuFiles;
    }

    public void setNumBuFiles(int numBuFiles) {
        this.numBuFiles = numBuFiles;
        if (this.curIndex > this.numBuFiles) {
            this.curIndex = 1;
        }
    }

    public void setFilePath(String path) {
        if (!path.equals(this.filePath)) {
            this.filePath = path;
            if (this.timer != null) {
                this.timer.stop();
                if (this.delay != 0) {
                    this.createTimer();
                }
            }
        }
    }

    public void stopBackUp() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    private void createTimer() {
        this.timer = new Timer(this.delay, new BackupActionListener());
        this.timer.start();
    }

    class BackupActionListener
    implements ActionListener {
        BackupActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!(BackupCA.this.vm.getTranscription() instanceof TranscriptionImpl)) {
                return;
            }
            if (BackupCA.this.transcriptionStore != null) {
                List visibleTiers = null;
                if (BackupCA.this.vm.getMultiTierControlPanel() != null) {
                    BackupCA.this.vm.getMultiTierControlPanel().getVisibleTiers();
                }
                try {
                    String path = null;
                    String suffix = ".00" + BackupCA.this.curIndex;
                    if (BackupCA.this.getFilePath().length() == 0) {
                        path = ((TranscriptionImpl)BackupCA.this.vm.getTranscription()).getPathName() + suffix;
                    } else if (BackupCA.this.getFilePath().equals("aishug294879ryshfda9763afo8947a5gf")) {
                        if (!BackupCA.this.promptedOnce) {
                            JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(BackupCA.this.vm.getTranscription()), ElanLocale.getString("Message.Backup"), ElanLocale.getString("Message.Warning"), 2);
                            BackupCA.this.promptedOnce = true;
                        }
                        path = BackupCA.this.getFilePath() + ".eaf" + suffix;
                    } else {
                        path = BackupCA.this.getFilePath() + suffix;
                    }
                    try {
                        BackupCA.this.transcriptionStore.storeTranscriptionIn(BackupCA.this.vm.getTranscription(), null, visibleTiers, path, 0);
                        BackupCA.this.curIndex++;
                        if (BackupCA.this.curIndex > BackupCA.this.numBuFiles) {
                            BackupCA.this.curIndex = 1;
                        }
                    }
                    catch (IOException ioe) {
                        LOG.severe("Cannot save a backup file: " + ioe.getMessage());
                    }
                }
                catch (SecurityException sex) {
                    LOG.severe("Cannot save a backup file - no write permission");
                }
            }
        }
    }
}

