/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.List;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationValuesRecord;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class ChangeCaseCommand
implements UndoableCommand {
    private String name;
    private Transcription transcription;
    private List<String> tierNames;
    private boolean uppercase;
    private boolean beginCapital;
    private List<AnnotationValuesRecord> records;

    public ChangeCaseCommand(String name) {
        this.name = name;
    }

    public void redo() {
        this.setWaitCursor(true);
        ((TranscriptionImpl)this.transcription).setNotifying(false);
        String name = null;
        TierImpl tier = null;
        if (this.tierNames != null) {
            if (this.records != null) {
                Annotation ann = null;
                AnnotationValuesRecord record = null;
                for (int i = 0; i < this.records.size(); ++i) {
                    record = this.records.get(i);
                    name = record.getTierName();
                    if (tier == null || !tier.getName().equals(name)) {
                        tier = (TierImpl)this.transcription.getTierWithId(name);
                    }
                    if (tier != null) {
                        ann = tier.getAnnotationAtTime(record.getBeginTime());
                        if (ann != null && ann.getEndTimeBoundary() == record.getEndTime()) {
                            ann.setValue(record.getNewLabelValue());
                            continue;
                        }
                        ClientLogger.LOG.warning("The annotation could not be found for undo");
                        continue;
                    }
                    ClientLogger.LOG.warning("The tier could not be found: " + name);
                }
            } else {
                ClientLogger.LOG.info("No annotation records have been stored for undo.");
            }
        } else {
            ClientLogger.LOG.warning("No tier names have been stored.");
        }
        ((TranscriptionImpl)this.transcription).setNotifying(true);
        this.setWaitCursor(false);
    }

    public void undo() {
        this.setWaitCursor(true);
        ((TranscriptionImpl)this.transcription).setNotifying(false);
        String name = null;
        TierImpl tier = null;
        if (this.tierNames != null) {
            if (this.records != null) {
                Annotation ann = null;
                AnnotationValuesRecord record = null;
                for (int i = 0; i < this.records.size(); ++i) {
                    record = this.records.get(i);
                    name = record.getTierName();
                    if (tier == null || !tier.getName().equals(name)) {
                        tier = (TierImpl)this.transcription.getTierWithId(name);
                    }
                    if (tier != null) {
                        ann = tier.getAnnotationAtTime(record.getBeginTime());
                        if (ann != null && ann.getEndTimeBoundary() == record.getEndTime()) {
                            ann.setValue(record.getValue());
                            continue;
                        }
                        ClientLogger.LOG.warning("The annotation could not be found for undo");
                        continue;
                    }
                    ClientLogger.LOG.warning("The tier could not be found: " + name);
                }
            } else {
                ClientLogger.LOG.info("No annotation records have been stored for undo.");
            }
        } else {
            ClientLogger.LOG.warning("No tier names have been stored.");
        }
        ((TranscriptionImpl)this.transcription).setNotifying(true);
        this.setWaitCursor(false);
    }

    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (Transcription)receiver;
        this.tierNames = (List)arguments[0];
        if (this.tierNames == null | this.tierNames.size() == 0) {
            return;
        }
        this.uppercase = (Boolean)arguments[1];
        this.beginCapital = (Boolean)arguments[2];
        this.records = new ArrayList<AnnotationValuesRecord>();
        this.changeCase();
    }

    public String getName() {
        return this.name;
    }

    private void setWaitCursor(boolean showWaitCursor) {
        if (showWaitCursor) {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }

    private void changeCase() {
        this.setWaitCursor(true);
        ((TranscriptionImpl)this.transcription).setNotifying(false);
        for (String name : this.tierNames) {
            TierImpl t = (TierImpl)this.transcription.getTierWithId(name);
            if (t == null) continue;
            int size = t.getAnnotations().size();
            for (int i = 0; i < size; ++i) {
                AbstractAnnotation aa = (AbstractAnnotation)t.getAnnotations().get(i);
                if (aa.getValue() == null || aa.getValue().length() <= 0) continue;
                AnnotationValuesRecord avr = new AnnotationValuesRecord(aa);
                this.records.add(avr);
                if (this.uppercase) {
                    aa.setValue(aa.getValue().toUpperCase());
                } else if (this.beginCapital) {
                    aa.setValue(aa.getValue().substring(0, 1).toUpperCase() + aa.getValue().substring(1).toLowerCase());
                } else {
                    aa.setValue(aa.getValue().toLowerCase());
                }
                avr.setNewLabelValue(aa.getValue());
            }
        }
        ((TranscriptionImpl)this.transcription).setNotifying(true);
        this.setWaitCursor(false);
    }
}

