/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.SystemReporting;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.util.TimeFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClipMediaCommand
implements Command {
    public static final String IN_FILE = "$in_file";
    public static final String OUT_FILE = "$out_file";
    public static final String BEGIN_TIME = "$begin";
    public static final String END_TIME = "$end";
    public static final String DUR = "$duration";
    public static final String HH = "hour:min:sec.ms";
    public static final String HHFF = "hour:min:sec:fr";
    public static final String HHFF_NTSC = "hour:min:sec:fr_NTSC";
    public static final String SEC = "sec.ms";
    public static final String MS = "ms";
    public static final String FR = "fr";
    public static final String FR_NTSC = "fr_NTSC";
    private static final String[] FORMATS = new String[]{"sec.ms", "ms", "hour:min:sec.ms", "fr", "hour:min:sec:fr", "hour:min:sec:fr_NTSC", "fr_NTSC"};
    private String commandName;

    public ClipMediaCommand(String theName) {
        this.commandName = theName;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        String executable = null;
        String command = "";
        long timeBegin = -1L;
        long timeEnd = -1L;
        String sourceFileName = null;
        if (arguments[0] instanceof ViewerManager2) {
            ViewerManager2 viewerManager = (ViewerManager2)arguments[0];
            if (arguments.length > 1 && arguments[1] instanceof Exception) {
                JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(viewerManager.getTranscription()), ((Exception)arguments[1]).getMessage(), ElanLocale.getString("Message.Warning"), 2);
                return;
            }
            if (arguments.length > 1) {
                Selection selection;
                executable = (String)arguments[1];
                if (arguments.length <= 2) {
                    ClientLogger.LOG.warning("Error running script: no executable or no parameters.");
                    return;
                }
                command = (String)arguments[2];
                if (arguments.length > 3 && arguments[3] instanceof Long) {
                    timeBegin = (Long)arguments[3];
                }
                if (arguments.length > 4 && arguments[4] instanceof Long) {
                    timeEnd = (Long)arguments[4];
                }
                if ((selection = viewerManager.getSelection()) != null && timeBegin == -1L) {
                    timeBegin = selection.getBeginTime();
                    timeEnd = selection.getEndTime();
                }
                Vector players = viewerManager.getTranscription().getMediaDescriptors();
                int numPl = players.size();
                ArrayList<MediaClipper> clipThreads = new ArrayList<MediaClipper>(numPl);
                for (int i = 0; i < numPl; ++i) {
                    MediaDescriptor md = (MediaDescriptor)players.get(i);
                    sourceFileName = md.mediaURL.substring(5);
                    long offset = md.timeOrigin;
                    if (sourceFileName.startsWith("///") && SystemReporting.isWindows()) {
                        sourceFileName = sourceFileName.substring(3);
                    }
                    sourceFileName = File.separatorChar == '/' ? sourceFileName.replace('\\', File.separatorChar) : sourceFileName.replace('/', File.separatorChar);
                    String destFileName = this.createDestinationName(sourceFileName, timeBegin + offset, timeEnd + offset);
                    List<String> defCommand = this.processCommand(command, sourceFileName, destFileName, timeBegin + offset, timeEnd + offset);
                    defCommand.add(0, executable);
                    clipThreads.add(new MediaClipper(defCommand));
                }
                new ClipRunner(clipThreads).start();
            }
        } else if (arguments[0] instanceof String) {
            sourceFileName = (String)arguments[0];
            long offset = 0L;
            if (arguments.length > 1 && arguments[1] instanceof Exception) {
                ClientLogger.LOG.warning("Error running script: " + ((Exception)arguments[1]).getMessage());
                return;
            }
            if (arguments.length > 1) {
                executable = (String)arguments[1];
                if (arguments.length <= 2) {
                    ClientLogger.LOG.warning("Error running script: no executable or no parameters.");
                    return;
                }
                command = (String)arguments[2];
                if (arguments.length > 3 && arguments[3] instanceof Long) {
                    timeBegin = (Long)arguments[3];
                }
                if (arguments.length > 4 && arguments[4] instanceof Long) {
                    timeEnd = (Long)arguments[4];
                }
                if (arguments.length > 5 && arguments[5] instanceof Long) {
                    offset = (Long)arguments[5];
                }
                if (sourceFileName.startsWith("file:")) {
                    sourceFileName = sourceFileName.substring(5);
                }
                if (sourceFileName.startsWith("///")) {
                    sourceFileName = sourceFileName.substring(3);
                }
                sourceFileName = File.separatorChar == '/' ? sourceFileName.replace('\\', File.separatorChar) : sourceFileName.replace('/', File.separatorChar);
                String destFileName = this.createDestinationName(sourceFileName, timeBegin + offset, timeEnd + offset);
                List<String> defCommand = this.processCommand(command, sourceFileName, destFileName, timeBegin + offset, timeEnd + offset);
                defCommand.add(0, executable);
                new MediaClipper(defCommand).start();
            }
        }
    }

    private List<String> processCommand(String command, String inFile, String outFile, long timeBegin, long timeEnd) {
        int i;
        if (inFile == null || outFile == null) {
            return null;
        }
        Pattern pat = Pattern.compile(" ");
        String[] parts = pat.split(command);
        ArrayList<String> partList = new ArrayList<String>(parts.length);
        for (String s : parts) {
            partList.add(s);
        }
        int from = 0;
        int to = 0;
        for (i = 0; i < partList.size(); ++i) {
            String replSub;
            String sub = (String)partList.get(i);
            if (sub.length() == 0) continue;
            if (sub.indexOf(BEGIN_TIME) > -1) {
                partList.set(i, this.replaceTime(sub, BEGIN_TIME, timeBegin));
                continue;
            }
            if (sub.indexOf(END_TIME) > -1) {
                partList.set(i, this.replaceTime(sub, END_TIME, timeEnd));
                continue;
            }
            if (sub.indexOf(DUR) > -1) {
                partList.set(i, this.replaceTime(sub, DUR, timeEnd - timeBegin));
                continue;
            }
            from = sub.indexOf(IN_FILE);
            if (from > -1) {
                to = from + IN_FILE.length();
                replSub = sub.substring(0, from) + inFile + sub.substring(to);
                partList.set(i, replSub);
                continue;
            }
            from = sub.indexOf(OUT_FILE);
            if (from <= -1) continue;
            to = from + OUT_FILE.length();
            replSub = sub.substring(0, from) + outFile + sub.substring(to);
            partList.set(i, replSub);
        }
        for (i = partList.size() - 1; i >= 0; --i) {
            String sub = (String)partList.get(i);
            if (sub != null && sub.length() != 0) continue;
            partList.remove(i);
        }
        return partList;
    }

    private String replaceTime(String part, String key, long time) {
        int from = part.indexOf(key);
        int from2 = part.indexOf("(", from) + 1;
        int to = part.indexOf(")", from2);
        String format = part.substring(from2, to);
        for (String f : FORMATS) {
            if (!format.equals(f)) continue;
            String repl = part.substring(0, from) + this.toTimeString(f, time);
            if (to + 1 < part.length()) {
                repl = repl + part.substring(to + 1);
            }
            return repl;
        }
        return "";
    }

    private String toTimeString(String format, long time) {
        if (format == SEC) {
            return TimeFormatter.toSSMSString(time);
        }
        if (format == MS) {
            return String.valueOf(time);
        }
        if (format == HH) {
            return TimeFormatter.toString(time);
        }
        if (format == HHFF) {
            return TimeFormatter.toTimecodePAL(time);
        }
        if (format == HHFF_NTSC) {
            return TimeFormatter.toTimecodeNTSC(time);
        }
        if (format == FR) {
            return TimeFormatter.toFrameNumberPAL(time);
        }
        if (format == FR_NTSC) {
            return TimeFormatter.toFrameNumberNTSC(time);
        }
        return String.valueOf(time);
    }

    private String createDestinationName(String sourceFileName, long begin, long end) {
        int si = sourceFileName.lastIndexOf(".");
        if (si > -1) {
            return sourceFileName.substring(0, si) + "_" + begin + "_" + end + sourceFileName.substring(si);
        }
        return sourceFileName + "_" + begin + "_" + end;
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClipRunner
    extends Thread {
        List<MediaClipper> clips;

        public ClipRunner(List<MediaClipper> clips) {
            this.clips = clips;
        }

        @Override
        public void run() {
            if (this.clips != null && this.clips.size() != 0) {
                for (MediaClipper mc : this.clips) {
                    mc.start();
                    while (mc.isAlive()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
    }

    private class ReaderThread
    extends Thread {
        private BufferedReader reader;
        private long startTime;
        private final int MAX_READ_TIME = 120000;

        ReaderThread(BufferedReader reader) {
            this.reader = reader;
        }

        public void run() {
            this.startTime = System.currentTimeMillis();
            while (this.reader != null && !this.isInterrupted()) {
                try {
                    if (this.reader.ready()) {
                        ClientLogger.LOG.info(this.reader.readLine());
                    } else if (System.currentTimeMillis() - this.startTime > 120000L) {
                        break;
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                try {
                    Thread.sleep(40L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                    break;
                }
            }
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MediaClipper
    extends Thread {
        private List<String> command;
        private BufferedReader reader;

        public MediaClipper(List<String> command) {
            this.command = command;
        }

        @Override
        public void run() {
            if (this.command == null) {
                return;
            }
            try {
                ProcessBuilder pb = new ProcessBuilder(this.command);
                pb.redirectErrorStream(true);
                Process process = pb.start();
                this.reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                ReaderThread rt = new ReaderThread(this.reader);
                rt.start();
            }
            catch (IOException ioe) {
                ClientLogger.LOG.warning("Error running script: " + ioe.getMessage());
            }
            catch (SecurityException se) {
                ClientLogger.LOG.warning("Security error running script: " + se.getMessage());
            }
        }
    }
}

